<?php
$lineWidth=19.5;
$lineHeight=0.4;

$pdf->AddPage();

// Para anular factura
if ($tot == 0) {
    $pdf->SetFont('Arial','B',100);
    $pdf->SetTextColor(255, 144, 144);
    $pdf->SetY(12);
    $pdf->Cell($lineWidth, 1, "ANULADO",0,0,"C");
}

$pdf->SetFont("Arial","B",7);
$pdf->SetTextColor(0,0,0);

$lineHeight7 = .3;
$img = '../img/LOGO-GREEN-PRINT.jpg';
//$img2 = '../img/marcadeaguamegared.JPG';
$pdf->Image($img,1,1,6.2);
//$pdf->Image($img2,3,11.3,15);

$pdf->SetMargins(1, 1, 1);
$pdf->SetY(1);
$pdf->Cell(0, 0, "", 0, 1);
$pdf->Cell($lineWidth/3, $lineHeight7, "");
$pdf->SetFont("Arial","B",10);
$pdf->Cell($lineWidth/3, $lineHeight7, $empNom,0,1,"C");
$pdf->SetFont("Arial","B",7);
$pdf->Cell($lineWidth/3, $lineHeight7, "");
$pdf->Cell($lineWidth/3, $lineHeight7, 'NIT: '.$empNit,0,1,"C");
$pdf->Cell($lineWidth/3, $lineHeight7, "");
$pdf->Cell($lineWidth/3, $lineHeight7, $empNomc,0,1,"C");
$pdf->Cell($lineWidth/3, $lineHeight7, "");
$pdf->MultiAlignCell($lineWidth/3, .3, $empDir,0,1,"C");
$pdf->Cell($lineWidth/3, $lineHeight7, "");
$pdf->Cell($lineWidth/3, $lineHeight7, "GUATEMALA, GUATEMALA",0,1,"C");

$pdf->SetFont("Arial","B",8);
// Derecha
$y = 1.3;
$x = 14;
$pdf->SetY($y);
$pdf->SetX($x);
$pdf->Cell($lineWidth/3,1, $tipoNomFEL,0,1,"C");

if (isset($DocumentGUID)) {
    if ($totgen<0) {
      $pdf->SetY($y+=$lineHeight);
      $pdf->SetX($x);
      $pdf->Cell($lineWidth/3,1, "NOTA DE CREDITO",0,1,"C");
    }
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "NUMERO DE AUTORIZACION:",0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, $DocumentGUID,0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "SERIE: ".$tipo,0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "NO. ".$num,0,1,"C");
} else {
   // if ($totgen<0) {
//      $pdf->SetY($y+=$lineHeight);
//      $pdf->SetX($x);
//      $pdf->Cell($lineWidth/3,1, "NOTA DE CREDITO",0,1,"C");
 // }
    $pdf->SetY($y+=$lineHeight*2);
    $pdf->SetX($x);
    $pdf->SetFont("Arial","B",28);
    $pdf->MultiAlignCell($lineWidth/3,.8, "VISTA PREVIA",0,1,"C");
    $pdf->SetFont("Arial","B",8); 
}
$pdf->SetY(5);

$pdf->line($pdf->GetX(), $pdf->GetY(), $lineWidth+1, $pdf->GetY());

$pdf->SetY($pdf->GetY()+.25);

$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NOMBRE:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/1.5, $lineHeight, $nom,0,0,"L");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("FECHA:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, date('d-m-Y', strtotime($fec)),0,1,"L");
$pdf->Ln();
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("DIRECCIÓN:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/1.5, .3, utf8_decode($dir),0,0,"L");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NIT:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode(str_replace('-','',$nit)),0,1,"L");

$pdf->SetY($pdf->GetY()+.75);

$header = array("CANTIDAD","CODIGO",utf8_decode("DESCRIPCIÓN"),"PRECIO UNITARIO","VALOR ".$tcam);
$widths = array(1.75,1.5,11,2.75,2.5);
$pdf->SetWidths($widths);
$pdf->SetAligns(array("C","C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetAligns(array("C","C","L","R","R"));

// Lineas separadoras del detalle
$detX = 0;
$detY = $pdf->GetY()+13.1;
$pdf->line($pdf->GetX(), $pdf->GetY(), $pdf->GetX(), $detY);
foreach ($widths as $x) {
    $detX+=$x;
    $pdf->line($pdf->GetX()+$detX, $pdf->GetY(), $pdf->GetX()+$detX, $detY);
}

$pdf->Ln();
foreach ($detalle as $recDet) {
    $body = array(
        ($recDet["cant"] > 0) ? $recDet["cant"] : "",
        $recDet["cod"],
        $recDet["descrip"],
        ($recDet["preu"] > 0) ? number_format($recDet["preu"],2) : "",
        ($recDet["sub"] > 0) ? number_format($recDet["sub"],2) : ""
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->SetY(20.3);

$moneda = ($tcam=='Q') ? "QUETZALES" : utf8_decode("DÓLARES");
$pdf->Cell($lineWidth, $lineHeight, "HACEMOS PAGOS DEL 5% NO EFECTUAR RETENCION",1,1,"C");
$pdf->SetFont("","",6);
$pdf->MultiAlignCell(15.7, $lineHeight, "TOTAL EN LETRAS: $totLetras $moneda",'TLB',0,"L");
$pdf->SetFont("","",8);
$pdf->Cell(1.3, $lineHeight, "TOTAL:",'TBR',0,"R");
$pdf->Cell(2.5, $lineHeight, number_format($tot, 2),1,1,"R");

$pdf->Ln();

$pdf->MultiAlignCell($lineWidth/2, $lineHeight, "AUTORIZADO\n\n________________________\n".utf8_decode($empNomc),1,0,"C");
$pdf->MultiAlignCell($lineWidth/2, $lineHeight, "CLIENTE\n\n________________________\nRECIBI CONFORME",1,0,"C");

$pdf->Ln(2);

$FechaHoraCertificacion = "";
$NombreCertificador = "";

if (isset($DocumentGUID) || isset($DocumentGUIDAnulacion)) {
    $DocumentGUID = (isset($DocumentGUID)) ? $DocumentGUID : $DocumentGUIDAnulacion;
    $wsCOFIDI = new wsCOFIDIExec();
    foreach ($wsCOFIDI->sExDocumentGUID($DocumentGUID) as $Body) {
        $ResponseData1 = $Body->RequestTransactionResponse->RequestTransactionResult->ResponseData->ResponseData1;
        $xml = base64_decode($ResponseData1);

        $sxe = new SimpleXMLElement($xml);
        $FechaHoraCertificacion = $sxe->xpath('//dte:FechaHoraCertificacion')[0];
        $NombreCertificador = $sxe->xpath('//dte:NombreCertificador')[0];
    }
}



$pdf->Cell($lineWidth, .1, "",1,1);
$pdf->Cell($lineWidth, $lineHeight, "DATOS FISCALES",1,1,"C");
$pdf->SetFont("Arial","B");
$pdf->Cell($lineWidth, $lineHeight, utf8_decode("Fecha de certificación: ").$FechaHoraCertificacion,1,1);
$pdf->Cell($lineWidth, $lineHeight, utf8_decode("CERTIFICADOR: ").$NombreCertificador."- NIT:62469045",1,1);
?>