<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

include_once('../ws/fel/clases.php');

$bitForm = "pov1010FEL";
$bitMod = "pov";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$empNom = $_SESSION['empNom'];
$empNomc = $_SESSION['empNomc'];
$empNit = $_SESSION['empNit'];
$empDir = $_SESSION['empDir'];

$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);
$pCaja = utf8_decode($_SESSION['pCaja']);
$establecimiento = utf8_decode($_SESSION['establecimiento']);

$tipoPol='010';

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarDoc':
		echo consultarDoc();
		break;

	case 'consultarArtic':
		echo consultarArtic();
		break;

	case 'consultarExist':
		echo consultarExist();
		break;

	case 'consultarLisExispeps':
		echo consultarLisExispeps();
		break;

	case 'consultarExistpeps':
		echo consultarExistpeps();
		break;

	case 'consultarLisPed':
		echo consultarLisPed();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarCorrtipov':
		echo consultarCorrtipov();
		break;

	case 'consultarCliencc':
		echo consultarCliencc();
		break;

	case 'consultarClienIva':
		echo consultarClienIva();
		break;

	case 'consultarClienPed':
		echo consultarClienPed();
		break;

	case 'consultarAuto':
		echo consultarAuto();
		break;

	case 'consultarCiemes':
		echo consultarCiemes();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'guardarEnvio':
		echo guardarEnvio();
		break;

	case 'imprimir':
		echo imprimir();
		break;
}

function consultar() {
	global $empCod, $pCaja, $usuCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	# QUERYS
	$sCaja = "SELECT c.*, 
				TRIM(c.caj_nomt) AS caj_nomt, 
				TRIM(c.caj_dirt) AS caj_dirt,
				TRIM(c.caj_telt) AS caj_telt,
				TRIM(c.caj_mailt) AS caj_mailt,
				TRIM(c.caj_leyen1) AS caj_leyen1,
				TRIM(c.caj_leyen2) AS caj_leyen2
				FROM caja c
				WHERE caj_emp='$empCod' AND caj_cod='$pCaja'";

	$sUsu = "SELECT TRIM(u.usu_vend) AS usu_vend
				FROM usuarios u
				WHERE usu_cod='$usuCod'";

	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCaja, "caja");
	//$resp = $db->sEx($sUsu, "usuarios");
	$resp["usuarios"] = $db->sFetchAssoc($sUsu);

	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "caja");
}


function consultarArtic() {
	global $empCod, $dtFec, $selBod;

	$func = new functions();

	$txtCodd=utf8_decode($_POST['txtCodd']);
	$dtFec=$_POST['dtFec'];
	$selBod=$_POST['selBod'];

	# QUERYS
	$sArtic = "SELECT a.*, 
				TRIM(a.art_cod) AS art_cod, 
				TRIM(a.art_desc) AS art_desc, 
				TRIM(a.art_desd) AS art_desd,
				TRIM(ctaCos.cta_nom) AS art_ctaCosnom,
				TRIM(ctaInv.cta_nom) AS art_ctaInvnom,
				TRIM(ctaVen.cta_nom) AS art_ctaVennom,
				TRIM(p.pro_nom) AS art_provnom,
				TRIM(um.um_nom) AS um_nom
				FROM artic a
				LEFT JOIN cuentas ctaCos ON a.art_emp = ctaCos.cta_emp AND a.art_ctaCos=ctaCos.cta
				LEFT JOIN cuentas ctaInv ON a.art_emp = ctaInv.cta_emp AND a.art_ctaInv=ctaInv.cta
				LEFT JOIN cuentas ctaVen ON a.art_emp = ctaVen.cta_emp AND a.art_ctaven=ctaVen.cta
				LEFT JOIN provcp p ON a.art_emp = p.pro_emp AND a.art_prov=p.pro_cod
				LEFT JOIN unimed um ON a.art_medi=um.um_cod
				WHERE a.art_emp='$empCod' AND a.art_cod='$txtCodd'";

	$sArticbarr = "SELECT a.*, 
				TRIM(a.art_cod) AS art_cod, 
				TRIM(a.art_desc) AS art_desc, 
				TRIM(a.art_desd) AS art_desd,
				TRIM(ctaCos.cta_nom) AS art_ctaCosnom,
				TRIM(ctaInv.cta_nom) AS art_ctaInvnom,
				TRIM(ctaVen.cta_nom) AS art_ctaVennom,
				TRIM(p.pro_nom) AS art_provnom,
				TRIM(um.um_nom) AS um_nom,
				TRIM(cb.cb_cod) AS cb_cod,
				TRIM(cb.cb_barr) AS cb_barr 
				FROM artic a
				LEFT JOIN cuentas ctaCos ON a.art_emp = ctaCos.cta_emp AND a.art_ctaCos=ctaCos.cta
				LEFT JOIN cuentas ctaInv ON a.art_emp = ctaInv.cta_emp AND a.art_ctaInv=ctaInv.cta
				LEFT JOIN cuentas ctaVen ON a.art_emp = ctaVen.cta_emp AND a.art_ctaven=ctaVen.cta
				LEFT JOIN provcp p ON a.art_emp = p.pro_emp AND a.art_prov=p.pro_cod
				LEFT JOIN unimed um ON a.art_medi=um.um_cod
				LEFT JOIN cod_barr cb ON a.art_emp=cb.cb_emp AND a.art_cod=cb.cb_cod 
				WHERE a.art_emp='$empCod' AND cb.cb_barr='$txtCodd'";


	function sExiart($codigo) { 
		global $empCod;
		return "SELECT e.*, TRIM(b.bod_nom) AS bod_nom
				FROM exiart e 
				LEFT JOIN bodegas b ON e.ea_emp=b.bod_emp AND e.ea_bod=b.bod_cod
				WHERE e.ea_emp='$empCod' AND e.ea_cod='$codigo'";
	}

	function sExiart_peps($codigo) { 
		global $empCod, $selBod;
		return "SELECT *
				FROM exiart_peps  
				WHERE ea_emp='$empCod' AND ea_bod='$selBod' AND ea_cod='$codigo' AND ea_exist>0 GROUP BY ea_cod ORDER BY ea_fvence";
	}

	function sDescu($depto,$subdepto) { 
		global $empCod, $dtFec;
		return "SELECT *
				FROM ofertas  
				WHERE of_emp='$empCod' AND of_dep='$depto' AND of_subdep='$subdepto' AND '$dtFec'>=of_del AND '$dtFec'<=of_al";
	}

	//$sCod_barr = "SELECT * FROM cod_barr WHERE cb_emp='$empCod' AND cb_cod='$txtCodd'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$codigo=$txtCodd;
	$resp = $db->sEx($sArtic, "artic");
	$select["artic"] = $db->query($sArtic);
	if ($db->numRows($select["artic"]) == 0) {
		$resp = $db->sEx($sArticbarr, "artic");
		$codigo=$resp["artic"]["art_cod"];
	}
	$resp["exiart"] = $db->sFetchAll(sExiart($codigo));
	$resp["imgArtic"] = "imgArticulos/$empCod"."_".$func->imgCharacters($codigo).".jpeg?".rand(1,9999);

	$dep=$resp["artic"]["art_dep"];
	$subdep=$resp["artic"]["art_subdep"];

	$resp["descuento"] = $db->sFetchAssoc(sDescu($dep,$subdep));

	$resp["exiart_peps"] = $db->sFetchAssoc(sExiart_peps($codigo));

	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "artic");
}

function consultarExist() {
	global $empCod;

	$func = new functions();

	$txtCod=utf8_decode($_POST['txtCod']);
	$selBod=utf8_decode($_POST['selBod']);

	# QUERYS
	$sExiart = "SELECT ea_exist, ea_exicon FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$txtCod' AND ea_bod='$selBod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sExiart, "exiart");
	$db->close();

	return json_encode($resp);
}

function consultarLisExispeps() {
	global $empCod;
	$txtCodd=utf8_decode($_POST['txtCodd']);
	$selBodega=utf8_decode($_POST['selBodega']);

	# QUERYS
	$sExiartpeps = "SELECT * FROM exiart_peps WHERE ea_emp='$empCod' AND ea_cod='$txtCodd' AND ea_bod='$selBodega' AND ea_exist>0 ORDER BY ea_emp,ea_cod,ea_fvence";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["exiart_peps"] = $db->sFetchAll($sExiartpeps);
	$db->close();

	$func = new functions();

	return $func->jsonEncodeArray($resp, "exiart_peps");
}

function consultarLisPed() {
	global $empCod, $pCaja;

	$dtFec=$_POST['dtFec'];

	# QUERYS
	$sLisped = "SELECT *,TRIM(fact_nomped) AS fact_nomped, TRIM(fact_dirped) AS fact_dirped, SUBSTR(fact_guardado,12,8) AS fact_guardado FROM facturas WHERE fact_emp='$empCod' AND fact_caja='$pCaja' AND fact_fec='$dtFec' AND fact_adomicilio='S' ORDER BY fact_guardado DESC";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["facturas"] = $db->sFetchAll($sLisped);
	$db->close();

	$func = new functions();

	return $func->jsonEncodeArray($resp, "facturas");
}

function consultarExistpeps() {
	global $empCod;

	$func = new functions();

	$txtCodd=utf8_decode($_POST['txtCodd']);
	$selBodega=utf8_decode($_POST['selBodega']);
	$dtFvenced=$_POST['dtFvenced'];

	# QUERYS
	$sExiartpeps = "SELECT * FROM exiart_peps WHERE ea_emp='$empCod' AND ea_cod='$txtCodd' AND ea_bod='$selBodega' AND ea_fvence='$dtFvenced' ORDER BY ea_fvence";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sExiartpeps, "exiart_peps");
	$db->close();

	return json_encode($resp);
}

function consultarCorrtipov() {
	global $empCod;

	$func = new functions();

	$selTipoCod=utf8_decode($_POST['selTipoCod']);

	# QUERYS
	$sCorrtipov = "SELECT ctv_num FROM corrtipov WHERE ctv_emp='$empCod' AND ctv_tipo='$selTipoCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();

	$select["corrtipov"] = $db->query($sCorrtipov);
	if ($db->numRows($select["corrtipov"])>0) {
		$numFac = ($db->fetchAssoc($select["corrtipov"])["ctv_num"]);
	} else {
		$numFac = 1;
		$r["corrtipov"] = $db->query("INSERT INTO corrtipov (ctv_emp, ctv_tipo, ctv_num) VALUES('$empCod', '$selTipoCod', $numFac);");
	}

	$resp["corrtipov"]["ctv_num"] = $numFac;
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrtipov");
}

function consultarCta() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarCliencc() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$txtCliCod = $_POST["txtCliCod"];

	# QUERYS
	$sCliencc = "SELECT *, 
					TRIM(cli_cod) AS cli_cod, 
					TRIM(cli_nom) AS cli_nom,
					TRIM(cli_nomfac) AS cli_nomfac,
					TRIM(cli_nit) AS cli_nit,
					TRIM(cli_dir) AS cli_dir,
					TRIM(cli_ven) AS cli_ven,
					TRIM(cli_cta) AS cli_cta,
					TRIM(cli_tel) AS cli_tel
				FROM cliencc WHERE cli_emp='$empCod' AND cli_cod='$txtCliCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["cliencc"] = $db->sFetchAssoc($sCliencc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc");
}

function consultarClienIva() {
	global $empCod;
	$txtNit=utf8_decode($_POST['txtNit']);

	# QUERYS
	$sClien = "SELECT *, TRIM(cli_nom) AS cli_nom, TRIM(cli_dir) AS cli_dir, TRIM(cli_tel) AS cli_tel 
			   FROM clien cli
			   LEFT JOIN clien_ped clip ON cli.cli_idped=clip.Id 
			   WHERE cli_nit='$txtNit'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClien, "clien");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "clien");
}

function consultarClienPed() {
	global $empCod;
	$numIdPed=(empty($_POST['numIdPed'])) ? 0 : $_POST['numIdPed'];

	# QUERYS
	$sClienPed = "SELECT *, TRIM(clip_nom) AS clip_nom, TRIM(clip_dir) AS cli_dir, TRIM(clip_tel) AS clip_tel, TRIM(clip_nomfac) AS clip_nomfac, TRIM(clip_dirfac) AS clip_dirfac FROM clien_ped WHERE id='$numIdPed'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClienPed, "clien_ped");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "clien_ped");
}

function consultarCiemes() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();
	$numAno=$_POST["numAno"];
	$selMesCod=$_POST["selMesCod"];

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$selMesCod";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCiemes, "ciemes");
	$db->close();

	return json_encode($resp);
}

function consultarAuto() {
	global $empCod, $usuNom;
	$txtPassdescu=$_POST['txtPassdescu'];
	$dtHoy = date("Y-m-d");
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$Descrip = "  Autorizacion utilizada por: ".$usuNom." ".$dtGrabado;

	# QUERYS
	$sPassauto = "SELECT * FROM autoriza WHERE aut_num='$txtPassdescu' and aut_stat!='B'";

	$uPassauto = "UPDATE autoriza SET aut_stat='B',aut_fecutil='$dtHoy',aut_desc=CONCAT(aut_desc, '$Descrip') WHERE aut_num='$txtPassdescu'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sPassauto, "autoriza");

	$select["autoriza1"] = $db->query($sPassauto);
	if ($db->numRows($select["autoriza1"]) > 0) {
		$db->uEx($uPassauto);
	}	
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "autoriza");
}

function guardar() {
	// Importante, se cambio la variable $totales por $totaleslocal porque esta reservada para una de las clases
	// que vienen de infile
	global $empCod, $usuNom, $pCaja, $empConso, $bitMod, $bitForm, $numTcam, $dtFec, $numAno, $numMes, $selTipoCod, $selTipoAbrev, $selCodasiste, $tipoPol, $tipoInv, $db, $func, $totaleslocal, $dtGrabado, $numInv, $numTotfp, $numEfectotfp, $numExenvalfp, $txtChnumfp, $numChvalfp, $numTarjfp, $numValefp, $numCredfp, $numDolaresfp, $numTcdolarfp, $numEfecfp, $txtNit,$numdoc,$seriedoc, $empDir, $empNit, $empNom, $empNomc, $txtDir, $txtLentrega, $establecimiento, $ctainv, $ctaven, $txtObs, $txtNomFac, $txtNomPed, $txtDirPed, $txtDirPed, $txtNomPed2, $txtDirPed2, $txtNomPed3, $txtDirPed3, $numZonaPed, $cbCheckped, $cbCheckped2, $cbCheckped3, $txtCelPed, $txtTelPed, $crDomi, $txtEmail, $numEnv, $txtObsPed, $numIdPed;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$DocumentGUID = '';
	$numEnv = $_POST["numEnv"];
	$selTipoCod = $_POST["selTipoCod"];
	$selTipoAbrev = $_POST["selTipoAbrev"];
	$selTipoLibrosn = $_POST["selTipoLibrosn"];
	$selTipoImpues = $_POST["selTipoImpues"];
	$selCodasiste = $_POST["selCodasiste"];
	$dtFec = $_POST["dtFec"];
	$numAno=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$selBodSalCod = $_POST["selBodSalCod"];
	$numTcam = $_POST["numTcam"];
	$txtCliCod = utf8_decode($_POST["txtCliCod"]);
	$txtNomFac = $_POST["txtNomFac"];
	$txtNit = utf8_decode($_POST["txtNit"]);
	$txtDir = $_POST["txtDir"];
	$txtNomPed = empty($_POST["txtNomPed"]) ? "" : utf8_decode($_POST["txtNomPed"]);
	$txtDirPed = empty($_POST["txtDirPed"]) ? "" : utf8_decode($_POST["txtDirPed"]);
	$txtNomPed2 = empty($_POST["txtNomPed2"]) ? "" : utf8_decode($_POST["txtNomPed2"]);
	$txtDirPed2 = empty($_POST["txtDirPed2"]) ? "" : utf8_decode($_POST["txtDirPed2"]);
	$txtNomPed3 = empty($_POST["txtNomPed3"]) ? "" : utf8_decode($_POST["txtNomPed3"]);
	$txtDirPed3 = empty($_POST["txtDirPed3"]) ? "" : utf8_decode($_POST["txtDirPed3"]);
	$cbCheckped = $_POST["cbCheckped"];
	$cbCheckped2 = $_POST["cbCheckped2"];
	$cbCheckped3 = $_POST["cbCheckped3"];
	$txtObsPed = utf8_decode($_POST["txtObsPed"]);
	$numIdPed=(empty($_POST['numIdPed'])) ? 0 : $_POST['numIdPed'];
	$numZonaPed=(empty($_POST['numZonaPed'])) ? 0 : $_POST['numZonaPed'];
	$txtTelPed = utf8_decode($_POST["txtTelPed"]);
	$txtCelPed = utf8_decode($_POST["txtCelPed"]);
	$txtEmail = $_POST["txtEmail"];
	$txtLentrega = "";
	$numDcre = $_POST["numDcre"];
	$selVendCod = $_POST["selVendCod"];
	$crFpag = $_POST["crFpag"];
	$crExp = $_POST["crExp"];
	$crRet = $_POST["crRet"];
	$crReti = $_POST["crReti"];
	$crDomi = $_POST["crDomi"];
	$tot=$_POST["tot"];
	$numTotfp=(empty($_POST['numTotfp'])) ? 0 : $_POST['numTotfp'];
	$numEfectotfp=(empty($_POST['numEfectotfp'])) ? 0 : $_POST['numEfectotfp'];
	$numExenvalfp=(empty($_POST['numExenvalfp'])) ? 0 : $_POST['numExenvalfp'];
	$txtChnumfp=$_POST["txtChnumfp"]; 
	$numChvalfp=(empty($_POST['numChvalfp'])) ? 0 : $_POST['numChvalfp'];
	$numTarjfp=(empty($_POST['numTarjfp'])) ? 0 : $_POST['numTarjfp'];
	$numValefp=(empty($_POST['numValefp'])) ? 0 : $_POST['numValefp'];
	$numCredfp=(empty($_POST['numCredfp'])) ? 0 : $_POST['numCredfp'];
	$numDolaresfp=(empty($_POST['numDolaresfp'])) ? 0 : $_POST['numDolaresfp'];
	$numTcdolarfp=(empty($_POST['numTcdolarfp'])) ? 0 : $_POST['numTcdolarfp'];
	$numVueltofp=(empty($_POST['numVueltofp'])) ? 0 : $_POST['numVueltofp'];
	$valq=(empty($_POST['valq'])) ? 0 : $_POST['valq'];
	$ctainv = $_POST["ctainv"];
	$ctaven = $_POST["ctaven"];
	if ($numEfectotfp>0.00) {
	   $numEfecfp=$numTotfp-($numExenvalfp+$numChvalfp+$numTarjfp+$numValefp+$numCredfp+$valq);
	} else {
	   $numEfecfp=0;	
	}
	$txtObs = "";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	$jsonDet=json_decode($_POST['tblDet']);
	$crTcam="L";

	$tipoInv=$_POST["selTipoRelatd"];


	$arrayError = array();

	# QUERYS PARA UN REGISTRO
	$sCaja = "SELECT c.caj_emp, c.caj_cod,  
				TRIM(c.caj_resolu) AS caj_resolu, TRIM(c.caj_llavews) AS caj_llavews, TRIM(c.caj_tokensigner) AS caj_tokensigner, TRIM(c.caj_prefij) AS caj_prefij,
				TRIM(c.caj_nitemi) AS caj_nitemi, TRIM(c.caj_prefijows) AS caj_prefijows  
				FROM caja c
				WHERE caj_emp='$empCod' AND caj_cod='$pCaja'";

	$sCorrTipov = "SELECT ctv_num FROM corrtipov WHERE ctv_emp='$empCod' AND ctv_tipo='$selTipoCod'";

	$sCliIva = "SELECT * FROM clien WHERE cli_nit='$txtNit'";


	$sCliPed = "SELECT * FROM clien_ped WHERE id='$numIdPed'";

	$uCliPed = "UPDATE clien_ped SET clip_nom='$txtNomPed', clip_dir='$txtDirPed', clip_nom2='$txtNomPed2', clip_dir2='$txtDirPed2', clip_nom3='$txtNomPed3', clip_dir3='$txtDirPed3', clip_nomfac='$txtNomFac', clip_dirfac='$txtDir', clip_tel='$txtTelPed', clip_zona='$numZonaPed', clip_nit='$txtNit', clip_email='$txtEmail', clip_obs='$txtObsPed', clip_cel='$txtCelPed' WHERE id='$numIdPed'";

	$iCliPed = "INSERT INTO clien_ped (clip_cel, clip_nom, clip_dir, clip_nom2, clip_dir2, clip_nom3, clip_dir3, clip_tel, clip_zona, clip_nit, clip_nomfac, clip_dirfac, clip_email, clip_obs) VALUES('$txtCelPed','$txtNomPed','$txtDirPed','$txtNomPed2','$txtDirPed2','$txtNomPed3','$txtDirPed3','$txtTelPed','$numZonaPed','$txtNit','$txtNomFac','$txtDir','$txtEmail','$txtObsPed')";

	$sTABLES = "SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_NAME='facturas' AND TABLE_SCHEMA='{$_SESSION['nombredb']}'";

	$sTABLESPed = "SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_NAME='clien_ped' AND TABLE_SCHEMA='{$_SESSION['nombredb']}'";

	$sFacmax = "SELECT MAX(fact_idinterno) AS maximo FROM facturas ORDER BY fact_idinterno";

/*	$sFacturas = "SELECT f.fact_idinterno, d.ds_num, f.fact_fec FROM facturas f
				  LEFT JOIN doctoss d ON d.ds_emp=f.fact_emp AND d.ds_ftipo=f.fact_tipo AND d.ds_fserie=f.fact_serie AND d.ds_fnum=f.fact_num
				  WHERE fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";  */
	function uCliIva($idnumped){
		global $empCod,$txtNit,$txtNomFac,$txtDir,$txtTelPed,$txtCelPed,$numZonaPed,$txtEmail,$txtObsPed;
		return "UPDATE clien SET cli_nom='$txtNomFac', cli_dir='$txtDir', cli_tel='$txtTelPed', cli_cel='$txtCelPed', cli_zona='$numZonaPed', cli_email='$txtEmail',cli_obsped='$txtObsPed', cli_idped='$idnumped' WHERE cli_nit='$txtNit'";
	}

	function iCliIva($idnumped){
		global $empCod,$txtNit,$txtNomFac,$txtDir,$txtTelPed,$txtCelPed,$numZonaPed,$txtEmail,$txtObsPed;
		return "INSERT INTO clien (cli_nit, cli_nom, cli_dir, cli_tel, cli_cel, cli_zona, cli_email, cli_obsped, cli_idped) VALUES('$txtNit','$txtNomFac','$txtDir','$txtTelPed', '$txtCelPed','$numZonaPed','$txtEmail','$txtObsPed','$idnumped')";
	}


	function sCliencc($cod){
		global $empCod;
		return "SELECT 
					*,
					TRIM(cli_codpos) AS cli_codpos,
					TRIM(cli_tel) AS cli_tel,
					TRIM(cli_muni) AS cli_muni,
					TRIM(cli_depto) AS cli_depto
				FROM cliencc WHERE cli_emp='$empCod' AND cli_cod='$cod'";
	}

	function sFacturas($Idinterno){
		global $empCod;
		return "SELECT fact_emp,fact_tipo,fact_serie,fact_num 
				FROM facturas WHERE fact_emp='$empCod' AND fact_idinterno='$Idinterno'";
	}

	function iFacturas($Batch, $Serial, $DocumentGUID, $transac, $tot, $codp, $nit, $nom, $dir, $tel, $dcre, $tcam, $fpag, $obs, $retsn, $retisn, $stat, $vencod, $lugare, $envio, $pedido, $orden, $bodsal, $pcomi, $contrato, $expsn, $FechaHoraEmision){
		global $empCod, $usuNom, $dtFec, $selTipoCod, $numTotfp, $numEfectotfp, $numExenvalfp, $txtChnumfp, $numChvalfp, $numTarjfp, $numValefp, $numCredfp, $numDolaresfp, $numTcdolarfp, $numEfecfp, $dtGrabado, $func, $pCaja, $numZonaPed, $txtCelPed, $txtNomPed, $txtDirPed, $crDomi, $txtEmail, $numEnv;
//		if ($func->stringToBool($_POST['nuevo'])) {
			return "INSERT INTO facturas(fact_documentguid,fact_emp,fact_tipo,fact_serie,fact_num,fact_transac,fact_fec,fact_tot,fact_codp,fact_nit,fact_nom,fact_dir,fact_tel,fact_dcre,fact_tcam,fact_fpag,fact_obs,fact_retsn,fact_retisn,fact_stat,fact_vend,fact_ulcam,fact_lugare,fact_envio,fact_pedido,fact_orden,fact_bodsal,fact_pcomi,fact_contrato, fact_exensn,fact_vencod,fact_tipoanu,fact_numanu,fact_serieped,fact_numped,fact_fel,fact_motanu,fact_expsn, fact_asigenvio,fact_tipoenv,fact_serieenv,fact_numenv, fact_efectot,fact_efec,fact_exenval,fact_chnum,fact_chval,fact_tarj,fact_vale,fact_cred,fact_dolares,fact_tcdolar,fact_guardado,fact_caja,fact_zona,fact_cel,fact_adomicilio,fact_nomped,fact_dirped,fact_email) VALUES ('$DocumentGUID','$empCod','$selTipoCod','$Batch',$Serial,$transac,'$dtFec','$tot','$codp','$nit','$nom','$dir','$tel',$dcre,'$tcam','$fpag','$obs','$retsn','$retisn','$stat','$vencod','$usuNom','$lugare','$envio','$pedido','$orden','$bodsal','$pcomi','$contrato','','','',0,'',0,'','','$expsn','','','','$numEnv','$numEfectotfp','$numEfecfp','$numExenvalfp','$txtChnumfp','$numChvalfp','$numTarjfp','$numValefp','$numCredfp','$numDolaresfp','$numTcdolarfp','$FechaHoraEmision','$pCaja','$numZonaPed','$txtCelPed','$crDomi','$txtNomPed','$txtDirPed','$txtEmail')";
/*		} else {
			return "UPDATE facturas SET fact_fec='$dtFec',fact_tot='$tot',fact_codp='$codp',fact_nit='$nit',fact_nom='$nom',fact_dir='$dir',fact_tel='$tel',fact_dcre=$dcre,fact_tcam='$tcam',fact_fpag='$fpag',fact_obs='$obs',fact_retsn='$retsn',fact_retisn='$retisn',fact_stat='$stat',fact_vend='$vencod',fact_ulcam='$usuNom',fact_lugare='$lugare',fact_envio='$envio',fact_pedido='$pedido',fact_orden='$orden',fact_bodsal='$bodsal',fact_pcomi='$pcomi',fact_contrato='$contrato',fact_expsn='$expsn' WHERE fact_documentguid='$DocumentGUID' AND fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$Batch' AND fact_num=$Serial";
		}   */
	}

	function uFacturas($Batch, $Serial, $DocumentGUID, $transac, $tot, $codp, $nit, $nom, $dir, $tel, $dcre, $tcam, $fpag, $obs, $retsn, $retisn, $stat, $vencod, $lugare, $envio, $pedido, $orden, $bodsal, $pcomi, $contrato, $expsn, $FechaHoraEmision){
		global $empCod, $usuNom, $dtFec, $selTipoCod, $numTotfp, $numEfectotfp, $numExenvalfp, $txtChnumfp, $numChvalfp, $numTarjfp, $numValefp, $numCredfp, $numDolaresfp, $numTcdolarfp, $numEfecfp, $dtGrabado, $func, $pCaja, $numZonaPed, $txtCelPed, $txtNomPed, $txtDirPed, $crDomi, $txtEmail;
		return "UPDATE facturas SET fact_documentguid='$DocumentGUID',fact_serie='$Batch',fact_num=$Serial, fact_transac='$transac' WHERE fact_emp='$empCod' AND fact_idinterno='$transac'";
	}

	function dFacturas($transac){
		global $empCod, $usuNom;
		return "DELETE FROM facturas WHERE fact_emp='$empCod' AND fact_idinterno='$transac' AND fact_num=0";
	}

	function uEnvio($Batch,$Serial) {
		global $empCod, $numEnv;
		return "UPDATE facturas SET fact_fserie='$Batch',fact_fnum='$Serial' WHERE fact_emp='$empCod' AND fact_idinterno='$numEnv'";
	}

	function sMeses($mes) {
		return "SELECT mes_nom FROM meses WHERE mes_cod=$mes";
	}

	function sPaises($pais) {
		return "SELECT pa_alfa2 FROM paises WHERE id=$pais";
	}
	
	function iuIva_ven($num, $Batch, $nit, $nom, $retsn, $retisn, $bien, $serv, $exen, $exp, $obs, $subb, $subs, $sube, $ret, $reti, $sub, $iva, $tot, $tcam) {
		global $empCod, $usuNom, $dtFec, $selTipoCod, $empConso, $bitMod, $func;
//		if ($func->stringToBool($_POST['nuevo'])) {
			return "INSERT INTO iva_ven (ivav_emp, ivav_serie, ivav_num, ivav_nit, ivav_tipo, ivav_clin, ivav_fec, ivav_retsn, ivav_retisn, ivav_afe, ivav_bien, ivav_serv, ivav_exen, ivav_exp, ivav_expre, ivav_medi, ivav_noafe, ivav_vehi, ivav_vehia, ivav_tvehi, ivav_tfaco, ivav_galos, ivav_galor, ivav_galod, ivav_comb, ivav_con, ivav_subb, ivav_subs, ivav_subco, ivav_subve, ivav_sube, ivav_suber, ivav_subna, ivav_subme, ivav_ret, ivav_reti, ivav_sub, ivav_iva, ivav_tot, ivav_dedu, ivav_ulcam, ivav_conso, ivav_mod) VALUES ('$empCod', '$Batch', '$num', '$nit', '$selTipoCod', '$nom', '$dtFec', '$retsn', '$retisn', 'S', '$bien', '$serv', '$exen', '$exp', 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '$obs', '$subb', '$subs', 0, 0, '$sube', 0, 0, 0, $ret, $reti, '$sub', '$iva', '$tot', 0,'$usuNom', '$empConso', '$bitMod')";
/*		} else {
			return "UPDATE iva_ven SET ivav_nit='$nit', ivav_clin='$nom', ivav_fec='$dtFec', ivav_retsn='$retsn', ivav_retisn='$retisn', ivav_bien='$bien', ivav_serv='$serv', ivav_exen='$exen', ivav_exp='$exp', ivav_con='$obs', ivav_subb='$subb', ivav_subs='$subs', ivav_sube='$sube', ivav_ret='$ret', ivav_reti='$reti', ivav_sub='$sub', ivav_iva='$iva', ivav_tot='$tot', ivav_ulcam='$usuNom', ivav_conso='$empConso', ivav_mod='$bitMod' WHERE ivav_emp='$empCod' AND ivav_serie='$Batch' AND ivav_num=$num AND ivav_tipo='$selTipoCod'";
		}   */
	}

	function sDoctoscc($num, $Batch) {
		global $empCod, $selTipoCod;
		return "SELECT dc_num FROM doctoscc WHERE dc_emp='$empCod' AND dc_serie='$Batch' AND dc_num=$num AND dc_tipo='$selTipoCod'";
	}

	function iuDoctoscc($num, $Batch, $nit, $nom, $retsn, $retisn, $bien, $serv, $exen, $exp, $obs, $subb, $subs, $sube, $ret, $reti, $sub, $iva, $tot, $tcam, $cod) {
		global $empCod, $usuNom, $dtFec, $selTipoCod, $empConso, $bitMod, $func, $db;
		if ($db->numRows($db->query(sDoctoscc($num, $Batch)))==0) {
			return "INSERT INTO doctoscc (dc_emp, dc_serie, dc_num, dc_codp, dc_nit, dc_tipo, dc_clien, dc_fec, dc_fecp, dc_retsn, dc_retisn, dc_afe, dc_bien, dc_serv, dc_exen, dc_exp, dc_expre, dc_medi, dc_noafe, dc_tfaco, dc_galos, dc_galor, dc_galod, dc_comb, dc_con, dc_subb, dc_subs, dc_subco, dc_sube, dc_suber, dc_subna, dc_subme, dc_ret, dc_reti, dc_sub, dc_iva, dc_tot, dc_dedu, dc_tcam, dc_ulcam, dc_conso, dc_mod) VALUES ('$empCod', '$Batch', '$num','$cod', '$nit', '$selTipoCod', '$nom', '$dtFec', '$dtFec', '$retsn', '$retisn', 'S', '$bien', '$serv', '$exen', '$exp', 0, 0, 0, 0, 0, 0, 0, 0, '$obs', '$subb', '$subs', 0, '$sube', 0, 0, 0, $ret, $reti, '$sub', '$iva', '$tot', 0, '$tcam', '$usuNom', '$empConso','$bitMod')";
		} else {
			return "UPDATE doctoscc SET dc_codp='$cod', dc_nit='$nit', dc_clien='$nom', dc_fec='$dtFec', dc_fecp='$dtFec', dc_retsn='$retsn', dc_retisn='$retisn', dc_bien='$bien', dc_serv='$serv', dc_exen='$exen', dc_exp='$exp', dc_con='$obs', dc_subb='$subb', dc_subs='$subs', dc_sube='$sube', dc_ret='$ret', dc_reti='$reti', dc_sub='$sub', dc_iva='$iva', dc_tot='$tot', dc_tcam='$tcam', dc_ulcam='$usuNom', dc_conso='$empConso', dc_mod='$bitMod' WHERE dc_emp='$empCod' AND dc_serie='$Batch' AND dc_num=$num AND dc_tipo='$selTipoCod'";
		}
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCuentasarray($cta,$debe,$haber) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom, $debe AS cta_debe, $haber AS cta_haber
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function sExiart($cod, $bod) {
		global $empCod;
		return "SELECT ea_exist FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}
	function uExiart($cod, $bod, $existact) {
		global $empCod;
		return "UPDATE exiart SET ea_exist=$existact WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}

	function iExiart($cod, $bod) {
		global $empCod;
		return "INSERT INTO exiart(ea_emp,ea_cod,ea_bod,ea_exist) VALUES('$empCod','$cod','$bod',0)";
	}

	function sExiartpeps($codd,$bodega,$fvence) { 
		global $empCod, $usuNom;
		return "SELECT * FROM exiart_peps WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$bodega' AND ea_fvence='$fvence'";
	}

	function uExiartpeps($codd,$nexist,$bodega,$lote,$fvence) { 
		global $empCod, $usuNom;
		return "UPDATE exiart_peps SET ea_exist='$nexist' WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$bodega' AND ea_fvence='$fvence'";
	}
	function iExiartpeps($codd,$nexist,$bodega,$lote,$fvence,$cosu) { 
		global $empCod, $usuNom;
		return "INSERT INTO exiart_peps(ea_emp,ea_cod,ea_bod,ea_exist,ea_lote,ea_fvence,ea_cosu) VALUES('$empCod','$codd','$bodega','$nexist','$lote','$fvence',$cosu)";
	}

	function iFact_det($IDInterno,$transac,$Batch,$Serial,$autoriza,$codp,$nit,$vend,$bodsal,$tcam,$obs,$nom,$dir,$expsn,$tot,$cosp,$codd,$descd,$medid,$unimed,$cantd,$preud,$subd,$descud,$descuvd,$totd,$exensnd,$bienserd,$loted,$fvenced) { 
		global $empCod, $tipoInv, $dtFec, $usuNom, $selTipoCod, $func, $totaleslocal, $numInv;
			return "INSERT INTO fact_det(factd_idinterno,factd_emp,factd_transac,factd_tipo,factd_serie,factd_num,factd_fec,factd_cod,factd_desc,factd_desci,factd_med,factd_unimed,factd_cant,factd_preu,factd_cosu,factd_sub,factd_descu,factd_descuv,factd_tot,factd_autoriza,factd_codp,factd_nit,factd_vend,factd_bodsal,factd_exensn,factd_bienser,factd_lote,factd_fvence) VALUES ('$IDInterno','$empCod','$transac','$selTipoCod','$Batch','$Serial','$dtFec','$codd','$descd','$descd','$medid','$unimed','$cantd','$preud','$cosp','$subd','$descud','$descuvd','$totd',0,'$codp','$nit','$vend','$bodsal','$exensnd','$bienserd','$loted','$fvenced')";
	}

	function sArtic($cod) {
		global $empCod;
		return "SELECT art.art_cosp, art.art_dep, art.art_subdep, TRIM(dep.dep_ctaven) AS dep_ctaven
		FROM artic art LEFT JOIN deptosi dep ON art.art_dep=dep.dep_cod 
		WHERE art_cod='$cod' AND art_emp='$empCod'";
	}

	function uArtic($cod,$exensn) {
		global $empCod;
		return "UPDATE artic SET art_exen='$exensn' WHERE art_cod='$cod' AND art_emp='$empCod'";
	}

	function sPolizas($num, $serie) {
		global $empCod, $tipoPol;
		return "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie'";
	}

	function iPolizas($fecha,$serie,$num,$nit,$obs) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$obs','$usuNom','$dtGrabado')";
	}

	function uPolizas($num, $serie, $con, $nit) {
		global $empCod, $tipoPol, $usuNom, $dtFec, $dtGrabado;
		return "UPDATE polizas SET pol_con='$con', pol_fec='$dtFec', pol_nit='$nit', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie'";
	}

	# QUERYS PARA VARIOS REGISTROS
	function iPoli_det($fecha,$serie,$num,$nit,$cta,$ctan,$debe,$haber) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$cta','$ctan','$debe','$haber')";
	}

	function dPoli_det($num, $serie) {
		global $empCod, $tipoPol;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie'";
	}

	# PARA REVISION DE EXISTENCIAS
	function sMoviie0($codd, $bodega) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_entra) AS mov_sentra
	            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$bodega' GROUP BY '$empCod','$bodega','$codd'";
	}

	function sMoviis0($codd, $bodega) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_sale) AS mov_ssale
	            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$bodega' GROUP BY '$empCod','$bodega','$codd'";
	}
	function sMoviie0peps($codd, $bodega, $fvence) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_entra) AS mov_sentrapeps
	            FROM movii_peps WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$bodega' AND mov_fvence='$fvence' GROUP BY '$empCod','$bodega','$codd','$fvence'";
	}

	function sMoviis0peps($codd, $bodega, $fvence) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_sale) AS mov_ssalepeps
	            FROM movii_peps WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$bodega' AND mov_fvence='$fvence' GROUP BY '$empCod','$bodega','$codd','$fvence'";
	}
	///

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$faCliencc = $db->sFetchAssoc(sCliencc($txtCliCod));

    // Revisa datos para el Web Service
	$select["caja"] = $db->query($sCaja);
	$fetchAssoc["caja"] = $db->fetchAssoc($select["caja"]);
	$llaveWS=$fetchAssoc["caja"]["caj_llavews"];
	$tokenSigner=$fetchAssoc["caja"]["caj_tokensigner"];
	$prefij=$fetchAssoc["caja"]["caj_prefij"];
	$nitemi=$fetchAssoc["caja"]["caj_nitemi"];
	$prefijows=$fetchAssoc["caja"]["caj_prefijows"];

/*	$sub = round(($tot/(($_SESSION['pIva']/100)+1)), 2);
	$iva = round((($tot/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 2);

	$haber = ($sub+$iva);
	if ($tot != $haber) {
		$sub += ($tot < $haber) ? ($tot-$haber) : ($haber-$tot);
	}

	if ($crTcam=="L") {
		$totIva=$tot;
		$subIva=$sub;
		$ivaIva=$iva;
	} else {
		$totIva=round($tot*$numTcam, 2);
		$subIva=round(($totIva/(($_SESSION['pIva']/100)+1)), 2);
		$ivaIva=round((($totIva/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 2);

		$haberIva = ($subIva+$ivaIva);
		if ($totIva != $haberIva) {
			$subIva += ($totIva < $haberIva) ? ($totIva-$haberIva) : ($haberIva-$totIva);
		}
	}                         */

	//$codpos = $faCliencc["cli_codpos"];
	$pais = $db->sFetchAssoc(sPaises($faCliencc['cli_pais']))['pa_alfa2'];
	$dcre = $faCliencc["cli_dcre"];

//	$wsFormatsXML = new wsFormatsXML();

	// Para quitar comillas porque nos da error y no deja guardar en WS
	$nomWS = str_replace('"', '', $txtNomFac);
	$nomWS = str_replace('&', '&amp;', $nomWS);
	$nomWS = str_replace('Ñ', '&Ntilde;', $nomWS);
	$nomWS = str_replace('ñ', '&ntilde;', $nomWS);
	$nomWS = str_replace('Á', '&Atilde;', $nomWS);
	$nomWS = str_replace('É', '&Etilde;', $nomWS);
	$nomWS = str_replace('Í', '&Itilde;', $nomWS);
	$nomWS = str_replace('Ó', '&Otilde;', $nomWS);
	$nomWS = str_replace('Ú', '&Utilde;', $nomWS);
	$nomWS = str_replace('á', '&aacute;', $nomWS);
	$nomWS = str_replace('é', '&eacute;', $nomWS);
	$nomWS = str_replace('í', '&iacute;', $nomWS);
	$nomWS = str_replace('ó', '&oacute;', $nomWS);
	$nomWS = str_replace('ú', '&uacute;', $nomWS);

	$txtNomFac = str_replace('"', '', $txtNomFac);
	$txtNomFac = str_replace("'", "", $txtNomFac);
	$txtNomFac = str_replace('&', '&amp;', $txtNomFac);

	$txtDir = str_replace('&', '&amp;', $txtDir);
	$txtDir = str_replace('"', '', $txtDir);
	$txtDir = str_replace("'", "", $txtDir);

	$dirWS = str_replace('"', '', utf8_decode($txtDir));
	$dirWS = str_replace('&', '&amp;', $dirWS);
	$dirWS = str_replace('Ñ', '&Ntilde;', $dirWS);
	$dirWS = str_replace('ñ', '&ntilde;', $dirWS);
	$dirWS = str_replace('Á', '&Atilde;', $dirWS);
	$dirWS = str_replace('É', '&Etilde;', $dirWS);
	$dirWS = str_replace('Í', '&Itilde;', $dirWS);
	$dirWS = str_replace('Ó', '&Otilde;', $dirWS);
	$dirWS = str_replace('Ú', '&Utilde;', $dirWS);
	$dirWS = str_replace('á', '&aacute;', $dirWS);
	$dirWS = str_replace('é', '&eacute;', $dirWS);
	$dirWS = str_replace('í', '&iacute;', $dirWS);
	$dirWS = str_replace('ó', '&oacute;', $dirWS);

	$txtNomPed = str_replace('"', '', $txtNomPed);
	$txtNomPed = str_replace("'", "", $txtNomPed);
	$txtNomPed = str_replace('&', '&amp;', $txtNomPed);
	$txtDirPed = str_replace('"', '', $txtDirPed);
	$txtDirPed = str_replace("'", "", $txtDirPed);
	$txtDirPed = str_replace('&', '&amp;', $txtDirPed);

	// Datos Generales
	$Tipo=$selCodasiste;
	$FechaHoraEmision = $dtFec.'T'.date("H:i:s", STRTOTIME(date('h:i:sa'))).'-06:00';
	$CodigoMoneda = ($crTcam=='L') ? 'GTQ' : 'USD';

	// Frases
	$arrayFrases = array(
		array('TipoFrase'=>1, 'CodigoEscenario'=>1)
	);

    // Infile
 $documento_fel = new DocumentoFel();

 $datos_emisor = new DatosEmisor();

    $datos_emisor->setAfiliacionIVA("GEN");
    $datos_emisor->setCodigoEstablecimiento($establecimiento);
    $datos_emisor->setCodigoPostal("01001");
    $datos_emisor->setCorreoEmisor("facturacionarcoiris@jireh.com");
    $datos_emisor->setDepartamento("Guatemala");
    $datos_emisor->setMunicipio("Guatemala");
    $datos_emisor->setDireccion($empDir);
    $datos_emisor->setNITEmisor($nitemi);
    $datos_emisor->setNombreComercial($empNomc);
    $datos_emisor->setNombreEmisor($empNom);
    $datos_emisor->setPais("GT");
    $documento_fel->setDatosEmisor($datos_emisor);

    $datos_generales = new DatosGenerales();
    $datos_generales->setCodigoMoneda($CodigoMoneda); //"GTQ");  
    
    $datos_generales->setFechaHoraEmision($FechaHoraEmision);   //"2021-07-21T10:42:00-06:00");
    //$datos_generales->setNumeroAcceso(11111);
    $datos_generales->setTipo($Tipo);  // "FACT");  
    $documento_fel->setDatosGenerales($datos_generales);

	$nitWS = str_replace('-', '', utf8_decode($txtNit));

    $datos_receptor = new DatosReceptor();
    $datos_receptor->setCodigoPostal($faCliencc['cli_codpos']);
    $datos_receptor->setCorreoReceptor("");
    $datos_receptor->setDepartamento($faCliencc['cli_depto']);
    $datos_receptor->setDireccion($dirWS);
    $datos_receptor->setIDReceptor($nitWS);
    $datos_receptor->setMunicipio($faCliencc['cli_muni']);
    $datos_receptor->setNombreReceptor($nomWS);
    $datos_receptor->setPais($pais);
    // $datos_receptor->setTipoEspecial("CUI");
    $documento_fel->setDatosReceptor( $datos_receptor);

    $frases = new Frases();
    $frases->setTipoFrase(1);
    $frases->setCodigoEscenario(1);
    $frases->setResolucion("");
    $frases->setFecha("");
    $documento_fel->setFrases($frases);

    $frases2 = new Frases();
    $frases2->setTipoFrase(4);
    $frases2->setCodigoEscenario(9);
    $documento_fel->setFrases($frases2);

	$sub=0;
	$iva=0;
	$totIva=0;
	$subIva=0;
	$ivaIva=0;
	$haberIva=0;
	// Items


	$arrayItems = array();
	$i = 1;
	foreach ($jsonDet as $obj) {
		$descd = $obj->descd;
		$descd = str_replace('&', '&amp;', $descd);
		$descd = str_replace('Ñ', '&Ntilde;', $descd);
		$descd = str_replace('ñ', '&ntilde;', $descd);
		$descd = str_replace('Á', '&Atilde;', $descd);
		$descd = str_replace('É', '&Etilde;', $descd);
		$descd = str_replace('Í', '&Itilde;', $descd);
		$descd = str_replace('Ó', '&Otilde;', $descd);
		$descd = str_replace('Ú', '&Utilde;', $descd);
		$descd = str_replace('á', '&aacute;', $descd);
		$descd = str_replace('é', '&eacute;', $descd);
		$descd = str_replace('í', '&iacute;', $descd);
		$descd = str_replace('ó', '&oacute;', $descd);
		$descd = str_replace('ú', '&uacute;', $descd);

		$totItem = $obj->totd;
		if ($obj->exensnd=='N') {
			$subItem = round(($totItem/(($_SESSION['pIva']/100)+1)), 5);
			$ivaItem = round((($totItem/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 5);
			$codunigrav=1;
		} else {
			$subItem = $totItem;
			$ivaItem = 0;
			$codunigrav=2;
		}
		$haberItem = ($subItem+$ivaItem);
		if ($totItem != $haberItem && $obj->exensnd=='N') {
			$subItem += ($totItem < $haberItem) ? ($haberItem-$totItem) : 0;
		}

		$sub += $subItem;
		$iva += $ivaItem;
		$totIva += $totItem;
		$subIva += $subItem;
		$ivaIva += $ivaItem;

		if ($obj->totd>0) {
			$ttpreud=round(($obj->totd/$obj->cantd),4);
		} else {
			$ttpreud=0;
		}
//		array_push($arrayItems, array('NumeroLinea'=>$i, 'BienOServicio'=>'B', 'Cantidad'=>$obj->cantd, 'UnidadMedida'=>'UND', 'Descripcion'=>$obj->descd, 'PrecioUnitario'=>$ttpreud, 'Precio'=>$obj->totd, 'Descuento'=>0, 'NombreCorto'=>'IVA', 'CodigoUnidadGravable'=>1, 'MontoGravable'=>$subItem, 'MontoImpuesto'=>$ivaItem, 'Total'=>$obj->totd));

		/// Items Infile
            $items = new Items();
            $items->setNumeroLinea($i);
            $items->setBienOServicio("B");
            $items->setCantidad($obj->cantd);
            $items->setDescripcion($descd);
            $items->setDescuento(0);
            $items->setPrecio($obj->totd);
            $items->setPrecioUnitario($ttpreud);
            $items->setUnidadMedida("UND");
            $items->setTotal($obj->totd);

            for ($j = 1; $j <= 1; $j++) {
                $impuestos_detalle = new ImpuestosDetalle();
                $impuestos_detalle->setNombreCorto("IVA");
                $impuestos_detalle->setCodigoUnidadGravable($codunigrav);
                $impuestos_detalle->setMontoGravable($subItem);
                $impuestos_detalle->setMontoImpuesto($ivaItem);
                $items->setImpuestosDetalle($impuestos_detalle);
            }

            $documento_fel->setItems($items);
        ///

		$i++;
/*		
		// Revisa si hay registro de existencia, si no hay lo inicia
		$select["exiartr"] = $db->query(sExiart($obj->codd, $selBodSalCod));
		if ($db->numRows($select["exiartr"]) == 0) {
	    	$db->iEx(iExiart($obj->codd, $selBodSalCod));
		}  
*/
	}  


     $total_impuestos = new TotalImpuestos();
     $total_impuestos->setNombreCorto("IVA");
     $total_impuestos->setTotalMontoImpuesto($iva);
     $documento_fel->setImpuestosResumen($total_impuestos);

     $totales = new Totales();
     $totales->setGranTotal($tot);
     $documento_fel->setTotales($totales);

	
	$adendax=new Adenda2();
	$adendax->setNombre("Adendita1");
	$adendax->setValor("Valorcito1");
	
    $adendax2=new Adenda2();
	$adendax2->setNombre("Adendita2");
	$adendax2->setValor("Valorcito2");

    $adendax3=new Adenda2();
    $adendax3->setNombre("Adendita3");
    $adendax3->setValor("Valorcito3");
	
	$documento_fel->setAdendaX($adendax);
	$documento_fel->setAdendaX($adendax2);
    $documento_fel->setAdendaX($adendax3);
	
	
	$arreglito=Array($adendax,$adendax2);
	/*

	$adendas2= Array();	
	$adendas2[0]="Nombre,valor";
	$adendas2[1]="Nombre,valor";
	$adendas2[3]="Nombre,valor";
	//$adendas2="Nombre2,valor2";
	//$adendas2="Nombre3,valor3";*/
	
	/*

		//------------------------------	
     $adendas = new Adendas();
     $adendas->setAdenda("Cajero", "Luis Morales");
     $adendas->setAdenda("Lote", "45121");
     $adendas->setAdenda("OrdenCompra", "1041-85");

     $documento_fel->setAdenda($adendas);*/
	 //----------------------

     //var_dump($documento_fel);
	 	
//	$IDInterno = $db->sFetchAssoc($sTABLES)['AUTO_INCREMENT'];
//	$Identificador=$prefij.str_pad($IDInterno,9,"0",STR_PAD_LEFT);

	$Batch = "";
	$Serial = 0;
	$DocumentGUID = "";

	$txtObs="Venta realizada a: ".$txtNomFac;

	$resp = $db->iEx(iFacturas($Batch, $Serial, $DocumentGUID, 0, $tot, $txtCliCod, $txtNit, $txtNomFac, $txtDir, $txtTelPed, $numDcre, $numTcam, $crFpag, $txtObs, $crRet, $crReti, '', $selVendCod, '', '', '', '', $selBodSalCod, "0.00", 0, $crExp, $FechaHoraEmision));
	$IDInterno = $db->sFetchAssoc($sFacmax)['maximo'];
	$Identificador=$prefij.str_pad($IDInterno,9,"0",STR_PAD_LEFT);


	 // Objeto para enviar los datos para generacion del XML
     $generar_xml = new GenerarXml();
        // Para el caso de la certificacion
     $respuesta = $generar_xml->ToXml($documento_fel);

     

     $conexion = new ConexionServicioFel();

     $conexion->setUrl("https://certificador.feel.com.gt/fel/certificacion/v2/dte");
     $conexion->setMetodo("POST");
     $conexion->setContentType("application/json");
     $conexion->setUsuario($prefijows);
     $conexion->setLlave($llaveWS);
     $conexion->setIdentificador($Identificador); //"Correlativo_00010");


     $firma = new FirmaEmisor();

     $xml_firmado = $firma->firmar($respuesta->getXml(),$prefijows,$tokenSigner);

    
     $servicio = new ServicioFel();
     $respuesta_servicio = $servicio->Certificar($conexion,$xml_firmado);


	$sub=0;
	$iva=0;
	$totIva=0;
	$subIva=0;
	$ivaIva=0;
	$haberIva=0;

	$mserror = $respuesta_servicio->getDescripcionErrores();
	$msDescrip = $respuesta_servicio->getDescripcion();

    // Condicion Infile solo si no hay errores asigna valores y graba informacion
//    $paso=1;
	$Batch = "";
	$Serial = "";
	$DocumentGUID = "";

    if ($respuesta_servicio->getCantidadErrores() == 0) {
//    if ($paso == 2) {	
		$Batch = $respuesta_servicio->getSerie();
		$Serial = $respuesta_servicio->getNumero();
		$DocumentGUID = $respuesta_servicio->getUuid();
	
		if ($Serial>0) {
			$select["corrtipov"] = $db->query($sCorrTipov);
			$fetchAssoc["corrtipov"] = $db->fetchAssoc($select["corrtipov"]);
		    $numNum=$Serial;


		    $idnumped=$numIdPed;
			if ($numIdPed==0) {
			   $idnumped = $db->sFetchAssoc($sTABLESPed)['AUTO_INCREMENT'];
			}

			$select["clien"] = $db->query($sCliIva);
			if ($db->numRows($select["clien"]) == 0) {
		    	$db->iEx(iCliIva($idnumped));
			} else {
				if ($numIdPed==0) {
				   $idnumped=($db->fetchAssoc($select["clien"])["cli_idped"]);			
				}
		    	$db->uEx(uCliIva($idnumped));
			}	

			$select["clien_ped"] = $db->query($sCliPed);
			if ($db->numRows($select["clien_ped"]) == 0 || $numIdPed==0) {
				if ($txtNomPed!="" || $txtNomPed2!="" || $txtNomPed3!="" || $txtDirPed!="" || $txtDirPed2!="" || $txtDirPed3!="") {
		    	   $db->iEx($iCliPed);
				}
			} else {
		    	$db->uEx($uCliPed);
			}	

			$numInv	= $numNum;



			// VARIABLES PARA SEPARAR BIENES, SERVICIOS Y EXPORTACION
			$hayBienes=false;
			$totaleslocal["bienes"]["exentoS"]=0;
			$totaleslocal["bienes"]["exentoN"]=0;
			$totaleslocal["servicios"]["exentoS"]=0;
			$totaleslocal["servicios"]["exentoN"]=0;
			$totaleslocal["exportacion"]=0;


			$txtObs="Venta realizada a: ".$txtNomFac;

			// SI EL DOCUMENTO ESTA EXENTO DE IMPUESTOS, ENTONCES GUARDAR POLIZA
		/*	if ($selTipoImpues=='N' && sizeof($jsonPol)>0) {
				$select["polizas"] = $db->query(sPolizas($numNum, $selTipoAbrev));
				$queryAcum .= ($db->numRows($select["polizas"]) > 0) ? uPolizas($numNum, $selTipoAbrev, $txtObs, $txtNit).";\n" : iPolizas($numNum, $selTipoAbrev, $txtObs, $txtNit).";\n";
				$queryAcum .= dPoli_det($numNum, $selTipoAbrev).";\n";
				$queryAcum .= iPoli_det($numNum, $selTipoAbrev, $txtNit, $jsonPol).";\n";
			}  */

//        	$IDInterno = $db->sFetchAssoc($sTABLES)['AUTO_INCREMENT'];

			// Encabezado Factura
			if ($db->numRows($db->query(sFacturas($IDInterno)))>0) {
				$db->uEx(uFacturas($Batch, $Serial, $DocumentGUID, $IDInterno, $tot, $txtCliCod, $txtNit, $txtNomFac, $txtDir, $txtTelPed, $numDcre, $numTcam, $crFpag, $txtObs, $crRet, $crReti, '', $selVendCod, '', '', '', '', $selBodSalCod, "0.00", 0, $crExp, $FechaHoraEmision));
			}

			$db->uEx(uEnvio($Batch, $Serial));

			// PARA REVERTIR EXISTENCIAS
	/*		foreach ($jsonDetAnt as $obj) {
				if ($obj->factd_bienser!='S') {
					$r["exiart"] .= uExiart($obj->factd_cod, $obj->factd_cant, $obj->factd_bodsal, "+").";\n";
				}
			}  */

			// RECORRER DETALLE PARA ACUMULAR QUERYS
			$i=0;
			$iUltimoBien=0;
			$arrayCosto=array();
			$arrayVen=array();
			$sumcosto=0;
			$cero=0;
			foreach ($jsonDet as $obj) {
				$i++;
				$codd = utf8_decode($obj->codd);
				$descd = $obj->descd;
				$descd = str_replace('"', '', $descd);
				$descd = str_replace("'", "", $descd);
				
				$medid = utf8_decode($obj->medid);
				$unimed = utf8_decode($obj->unimed);
				$loted = $obj->loted;
				$fvenced = $obj->fvenced;
				$cantd = $obj->cantd;
				$preud = $obj->preud;
				$subd = $obj->subd;
				$descud = $obj->descud;
				$descuvd = $obj->descuvd;
				$totd = $obj->totd;
				$exensnd = $obj->exensnd;
				$bienserd = $obj->bienserd;
				$ctacos = $obj->ctacos;
				$cosp = $obj->cosud;
				$sumcosto+= $cosp;

				$db->uEx(uArtic($codd,$exensnd));

				$hayBienes = true;
				$iUltimoBien = $i;
				($obj->exensnd=='N') ? $totaleslocal["bienes"]["exentoN"]+=$obj->totd : $totaleslocal["bienes"]["exentoS"]+=$obj->totd;

                // Detalle de la factura
				$resp = $db->iEx(iFact_det($IDInterno, $IDInterno, $Batch, $Serial, 0, $txtCliCod, $txtNit, $selVendCod, $selBodSalCod, $numTcam, $txtObs, $txtNomFac, $txtDir, $crExp, $tot,$cosp,$codd,$descd,$medid,$unimed,$cantd,$preud,$subd,$descud,$descuvd,$totd,$exensnd,$bienserd,$loted,$fvenced));

	            # Aqui se recalculan existencias
	            # Para revisar las existencias normales
				$select["moviie0"] = $db->query(sMoviie0($codd,$selBodSalCod));
				$fetchAssoc["moviie0"] = $db->fetchAssoc($select["moviie0"]);
				if ($db->numRows($select["moviie0"]) == 0) {
				   $sumentro=0;
	            } else {
	              $sumentro=$fetchAssoc["moviie0"]["mov_sentra"];
                }
				$select["moviis0"] = $db->query(sMoviis0($codd,$selBodSalCod));
				$fetchAssoc["moviis0"] = $db->fetchAssoc($select["moviis0"]);
				if ($db->numRows($select["moviis0"]) == 0) {
				   $sumsalio=0;
	            } else {
	               $sumsalio=$fetchAssoc["moviis0"]["mov_ssale"];
				}	               
	            $exisactu=$sumentro-$sumsalio;
				$db->uEx(uExiart($codd,$selBodSalCod,$exisactu));

	            # Para revisar las existencias normales peps
				$select["moviie0peps"] = $db->query(sMoviie0peps($codd,$selBodSalCod,$fvenced));
				$fetchAssoc["moviie0peps"] = $db->fetchAssoc($select["moviie0peps"]);
				if ($db->numRows($select["moviie0peps"]) == 0) {
				   $sumentropeps=0;
	            } else {
	               $sumentropeps=$fetchAssoc["moviie0peps"]["mov_sentrapeps"];
	            }
				$select["moviis0peps"] = $db->query(sMoviis0peps($codd,$selBodSalCod,$fvenced));
				$fetchAssoc["moviis0peps"] = $db->fetchAssoc($select["moviis0peps"]);
				if ($db->numRows($select["moviis0peps"]) == 0) {
				   $sumsaliopeps=0;
	            } else {
	               $sumsaliopeps=$fetchAssoc["moviis0peps"]["mov_ssalepeps"];
	            }
	            $exisactupeps=$sumentropeps-$sumsaliopeps;
				$db->uEx(uExiartpeps($codd,$exisactupeps,$selBodSalCod,$loted,$fvenced));
				//

				$ctaven="4110105";
				$select["artic"] = $db->query(sArtic($codd));
				if ($db->numRows($select["artic"])>0) {
					$ctaven=($db->fetchAssoc($select["artic"])["dep_ctaven"]);
				}

				if ($obj->exensnd=='S') {
					$ctaven="4110107";
				}

				if ($obj->exensnd=='N') {
					$subVen = round(($totd/(($_SESSION['pIva']/100)+1)), 5);
					$ivaVen = round((($totd/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 5);
					$tottemp =round(($subVen+$ivaVen),2);
					if ($totd>$tottemp) {
						$subVen += (round(($totd-$tottemp),2));
					}
				} else {
					$subVen = $totd;
					$ivaVen = 0;
				}

				// Para agrupar las cuentas de ventas que se utilizaron
				$cuentaven = TRIM($ctaven);
				$p = $func->multiSearch($arrayVen, array('cta' => (string)$cuentaven));
				if ($p >= 0) {
					$arrayVen[$p]["cta_haber"] += $subVen;
				} else {
					$fa["ctaVen"] = $db->sFetchAssoc(sCuentasarray((string)$cuentaven,0,$subVen));
				    array_push($arrayVen, array("cta"=>$cuentaven,"cta_nom"=>$fa["ctaVen"]["cta_nom"],"cta_debe"=>$cero,"cta_haber"=>$subVen));
				}

				// Para agrupar las cuentas de costos que se utilizaron
				$cuentacos = TRIM($ctacos);
// Ya no se uso, segun indicacion de la contadora
/*				
				$p = $func->multiSearch($arrayCosto, array('cta' => (string)$cuentacos));
				if ($p >= 0) {
					$arrayCosto[$p]["cta_debe"] += $cosp;
				} else {
					$fa["ctaCos"] = $db->sFetchAssoc(sCuentasarray((string)$cuentacos,$cosp,0));
				    array_push($arrayCosto, array("cta"=>$cuentacos,"cta_nom"=>$fa["ctaCos"]["cta_nom"],"cta_debe"=>$cosp,"cta_haber"=>$cero));
				}
*/

			}

			// Iva ventas
			$val = calculos($tot, $crRet, $crReti, $crExp, $selTipoImpues, $numTcam, 1);
			$db->iEx(iuIva_ven($Serial, $Batch, $txtNit, $txtNomFac, $crRet, $crReti, $val["bien"], $val["serv"], $val["exen"], $val["exp"], $txtObs, $val["subb"], $val["subs"], $val["sube"], $val["ret"], $val["reti"], $val["sub"], $val["iva"], $val["tot"], 1));

			// SI LA FORMA DE PAGO ES AL CREDITO, ENTONCES GUARDAR EN EL MODULO DE CUENTAS POR COBRAR
			if ($crFpag==2) {
				$resp = $db->iEx(iuDoctoscc($Serial, $Batch, $txtNit, $txtNomFac, $crRet, $crReti, $val["bien"], $val["serv"], $val["exen"], $val["exp"], $txtObs, $val["subb"], $val["subs"], $val["sube"], $val["ret"], $val["reti"], $val["sub"], $val["iva"], $val["tot"], $numTcam, $txtCliCod));
			}

			// De aqui en adelante se registra la parte de la partida contable

			$db->query(iPolizas($dtFec,$Batch,$Serial,$txtNit,$txtObs));

			// CUENTA DE CARGO SE USA LA CUENTA DE CAJA GENERAL
			//$cta = '1110101';
			// Se manda la venta a Clientes Locales, segun se platico con la contadora
			$cta = '1120101';
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$tot-($numExenvalfp);  
			$haber=0;
			$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
			if ($numExenvalfp>0) {
				// CUENTA PARA EXENCIONES
				$cta = "1120203";
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$numExenvalfp;  
				$haber=0;
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}
/*			if ($numCredfp>0) {
				// CUENTA PARA VENTAS AL CREDITO
				$cta = "1120101";
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$numCredfp;  
				$haber=0;
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}   */
			if ($val["iva"]>0) {
				// CUENTA PARA IVA
				$cta = $_SESSION['empCtaiv'];
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=0;  
				$haber=$val["iva"];
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}
			// CUENTA PARA VENTAS
/*			$cta = $ctaven;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;  
			$haber=$val["sub"];
			$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/
			$longitud = count($arrayVen);
// Para las la cuenta de Ventas
			//Recorro todos los elementos
			for($i=0; $i<$longitud; $i++) {
				$cta=$arrayVen[$i]["cta"];
				$ctaNom=$arrayVen[$i]["cta_nom"];
				$debe=0;
				$haber=$arrayVen[$i]["cta_haber"];
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}

			//saco el numero de elementos
			$longitud = count($arrayCosto);
// No se tocaran cuentas de inventario y costos segun se converso con el contador
/*
			//Recorro todos los elementos
			for($i=0; $i<$longitud; $i++) {
				$cta=$arrayCosto[$i]["cta"];
				$ctaNom=$arrayCosto[$i]["cta_nom"];
				$debe=$arrayCosto[$i]["cta_debe"];
				$haber=0;
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}

			// CUENTA DE INVENTARIO
			$cta = $ctainv;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;  
			$haber=$sumcosto;
			$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

*/
			//PARA BITACORA
			$db->iEx($func->iBitacora(utf8_decode("Se creó factura IDInterno: {$IDInterno} DocumentGUID: {$DocumentGUID} No.: {$Serial} Serie: {$Batch} NIT: {$txtNit} Usuario: ").$usuNom, $bitMod, $bitForm));

			/*if ($db->multiQuery($queryAcum) === TRUE) {
				$resp = $db->rSuccessPublic('Se guardó correctamente', 'Serie: '.$Batch.'<br> Número: '.$Serial);
			} else {
				array_push($arrayError, array("Code"=>'MySQL', "cod"=>$db->errno(), "Description"=>$db->error()));
			}   */
		}

	} else {
		$db->dEx(dFacturas($IDInterno));
	}
	if ($Serial==0) {
		$db->dEx(dFacturas($IDInterno));
	}

/*
	else {
			// En caso encuentre Errores
			$Code = $respuesta_servicio->getDescripcionAlertasInfile();
			$Description = $respuesta_servicio->getDescripcionErrores();

			array_push($arrayError, array("Code"=>''.$Code, "cod"=>$txtCliCod, "Description"=>''.$Description));
	}  */

//	}


/*
	// Por si no se pudo guardar la factura de algún cliente
	$sizeError = sizeof($arrayError);
	if ($sizeError != 0) {
		$title = $arrayError[0]["Code"]." - ".$arrayError[0]["cod"];
		$text = $arrayError[0]["Description"];
		$resp = $db->rErrorPublic($title, $text);
	}

*/
	$db->close();



	$resp["seriedoc"]=$Batch;
	$resp["numdoc"]=$Serial;
	$resp["nit"]=$txtNit;
	$resp["idinterno"]=$IDInterno;
	$resp["Identificador"]=$Identificador;
	$resp["documentGuid"]=$DocumentGUID;
	$resp["mserror"]=$mserror;
	$resp["msDescrip"]=$msDescrip;

	return json_encode($resp);
}


function guardarEnvio() {
	// Importante, se cambio la variable $totales por $totaleslocal porque esta reservada para una de las clases
	// que vienen de infile
	global $empCod, $usuNom, $pCaja, $empConso, $bitMod, $bitForm, $numTcam, $dtFec, $numAno, $numMes, $selTipoCod, $selTipoAbrev, $selCodasiste, $tipoPol, $tipoInv, $db, $func, $totaleslocal, $dtGrabado, $numInv, $numTotfp, $numEfectotfp, $numExenvalfp, $txtChnumfp, $numChvalfp, $numTarjfp, $numValefp, $numCredfp, $numDolaresfp, $numTcdolarfp, $numEfecfp, $txtNit,$numdoc,$seriedoc, $empDir, $empNit, $empNom, $empNomc, $txtDir, $txtLentrega, $establecimiento, $ctainv, $ctaven, $txtObs, $txtNomFac, $txtNomPed, $txtDirPed, $numZonaPed, $txtCelPed, $txtTelPed, $crDomi, $txtEmail;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$DocumentGUID = '';
	$selTipoCod = $_POST["selTipoCod"];
	$selTipoAbrev = $_POST["selTipoAbrev"];
	$selTipoLibrosn = $_POST["selTipoLibrosn"];
	$selTipoImpues = $_POST["selTipoImpues"];
	$selCodasiste = $_POST["selCodasiste"];
	$dtFec = $_POST["dtFec"];
	$numAno=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));

	$selBodSalCod = $_POST["selBodSalCod"];
	$numTcam = $_POST["numTcam"];
	$txtCliCod = utf8_decode($_POST["txtCliCod"]);
	$txtNomFac = utf8_decode($_POST["txtNomFac"]);
	$txtNit = utf8_decode($_POST["txtNit"]);
	$txtDir = utf8_decode($_POST["txtDir"]);
	$txtNomPed = utf8_decode($_POST["txtNomPed"]);
	$txtDirPed = utf8_decode($_POST["txtDirPed"]);
	$numZonaPed=(empty($_POST['numZonaPed'])) ? 0 : $_POST['numZonaPed'];
	$txtTelPed = utf8_decode($_POST["txtTelPed"]);
	$txtCelPed = utf8_decode($_POST["txtCelPed"]);
	$txtEmail = utf8_decode($_POST["txtEmail"]);
	$txtLentrega = "";
	$numDcre = $_POST["numDcre"];
	$selVendCod = $_POST["selVendCod"];
	$crFpag = $_POST["crFpag"];
	$crExp = $_POST["crExp"];
	$crRet = $_POST["crRet"];
	$crReti = $_POST["crReti"];
	$crDomi = $_POST["crDomi"];
	$tot=$_POST["tot"];
	$numTotfp=(empty($_POST['numTotfp'])) ? 0 : $_POST['numTotfp'];
	$numEfectotfp=(empty($_POST['numEfectotfp'])) ? 0 : $_POST['numEfectotfp'];
	$numExenvalfp=(empty($_POST['numExenvalfp'])) ? 0 : $_POST['numExenvalfp'];
	$txtChnumfp=$_POST["txtChnumfp"]; 
	$numChvalfp=(empty($_POST['numChvalfp'])) ? 0 : $_POST['numChvalfp'];
	$numTarjfp=(empty($_POST['numTarjfp'])) ? 0 : $_POST['numTarjfp'];
	$numValefp=(empty($_POST['numValefp'])) ? 0 : $_POST['numValefp'];
	$numCredfp=(empty($_POST['numCredfp'])) ? 0 : $_POST['numCredfp'];
	$numDolaresfp=(empty($_POST['numDolaresfp'])) ? 0 : $_POST['numDolaresfp'];
	$numTcdolarfp=(empty($_POST['numTcdolarfp'])) ? 0 : $_POST['numTcdolarfp'];
	$numVueltofp=(empty($_POST['numVueltofp'])) ? 0 : $_POST['numVueltofp'];
	$valq=(empty($_POST['valq'])) ? 0 : $_POST['valq'];
	$ctainv = $_POST["ctainv"];
	$ctaven = $_POST["ctaven"];
	if ($numEfectotfp>0.00) {
	   $numEfecfp=$numTotfp-($numExenvalfp+$numChvalfp+$numTarjfp+$numValefp+$numCredfp+$valq);
	} else {
	   $numEfecfp=0;	
	}
	$txtObs = "";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	$jsonDet=json_decode($_POST['tblDet']);
	$crTcam="L";

	$tipoInv=$_POST["selTipoRelatd"];


	$arrayError = array();

	# QUERYS PARA UN REGISTRO
	$sCaja = "SELECT c.caj_emp, c.caj_cod, c.caj_codenvio,  
				TRIM(c.caj_resolu) AS caj_resolu
				FROM caja c
				WHERE caj_emp='$empCod' AND caj_cod='$pCaja'";

	$sCorrTipov = "SELECT ctv_num FROM corrtipov WHERE ctv_emp='$empCod' AND ctv_tipo='$selTipoCod'";

	$sCliIva = "SELECT * FROM clien WHERE cli_nit='$txtNit'";

	$uCliIva = "UPDATE clien SET cli_nom='$txtNomFac', cli_dir='$txtDir', cli_tel='$txtTelPed', cli_cel='$txtCelPed', cli_zona='$numZonaPed', cli_email='$txtEmail' WHERE cli_nit='$txtNit'";

	$iCliIva = "INSERT INTO clien (cli_nit, cli_nom, cli_dir, cli_tel, cli_cel, cli_zona, cli_email) VALUES('$txtNit','$txtNomFac','$txtDir','$txtTelPed', '$txtCelPed','$numZonaPed','$txtEmail')";

	$sCliPed = "SELECT * FROM clien_ped WHERE clip_cel='$txtCelPed'";

	$uCliPed = "UPDATE clien_ped SET clip_nom='$txtNomPed', clip_dir='$txtDirPed', clip_nomfac='$txtNomFac', clip_dirfac='$txtDir', clip_tel='$txtTelPed', clip_zona='$numZonaPed', clip_nit='$txtNit', clip_email='$txtEmail' WHERE clip_cel='$txtCelPed'";

	$iCliPed = "INSERT INTO clien_ped (clip_cel,clip_nom,clip_dir,clip_tel,clip_zona,clip_nit,clip_nomfac,clip_dirfac,clip_email) VALUES('$txtCelPed','$txtNomPed','$txtDirPed','$txtTelPed','$numZonaPed','$txtNit','$txtNomFac','$txtDir','$txtEmail')";

	$sTABLES = "SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_NAME='facturas' AND TABLE_SCHEMA='{$_SESSION['nombredb']}'";

	function sCorrtdoci($codenvio){
		global $empCod;
		return "SELECT * FROM corrtdoci WHERE ctdi_emp='$empCod' AND ctdi_tipo='$codenvio'";
	}

	function iCorrTdoci($codenvio,$nuevocorr) { 
		global $empCod, $usuNom, $selTdoci;
		return "INSERT INTO corrtdoci(ctdi_emp, ctdi_tipo, ctdi_corr) VALUES ('$empCod','$codenvio',$nuevocorr)";
	}
	function uCorrTdoci($codenvio,$nuevocorr) { 
		global $empCod, $usuNom, $selTdoci;
		return "UPDATE corrtdoci SET ctdi_corr=$nuevocorr WHERE ctdi_emp='$empCod' and ctdi_tipo='$codenvio'";
	}

	function sTdoci($codenvio){
		global $empCod;
		return "SELECT * FROM tipodoci WHERE td_cod='$codenvio'";
	}

	function sTipov($tvcodenvio){
		global $empCod;
		return "SELECT * FROM tipov WHERE tv_cod='$tvcodenvio'";
	}

/*	$sFacturas = "SELECT f.fact_idinterno, d.ds_num, f.fact_fec FROM facturas f
				  LEFT JOIN doctoss d ON d.ds_emp=f.fact_emp AND d.ds_ftipo=f.fact_tipo AND d.ds_fserie=f.fact_serie AND d.ds_fnum=f.fact_num
				  WHERE fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";  */

	function sCliencc($cod){
		global $empCod;
		return "SELECT 
					*,
					TRIM(cli_codpos) AS cli_codpos,
					TRIM(cli_tel) AS cli_tel,
					TRIM(cli_muni) AS cli_muni,
					TRIM(cli_depto) AS cli_depto
				FROM cliencc WHERE cli_emp='$empCod' AND cli_cod='$cod'";
	}

	function iuFacturas($tvcodenvio,$Batch, $Serial, $DocumentGUID, $transac, $tot, $codp, $nit, $nom, $dir, $tel, $dcre, $tcam, $fpag, $obs, $retsn, $retisn, $stat, $vencod, $lugare, $envio, $pedido, $orden, $bodsal, $pcomi, $contrato, $expsn, $FechaHoraEmision){
		global $empCod, $usuNom, $dtFec, $selTipoCod, $numTotfp, $numEfectotfp, $numExenvalfp, $txtChnumfp, $numChnumfp, $numTarjfp, $numValefp, $numCredfp, $numDolaresfp, $numTcdolarfp, $numEfecfp, $dtGrabado, $func, $pCaja, $numZonaPed, $txtCelPed, $txtNomPed, $txtDirPed, $crDomi, $txtEmail;
//		if ($func->stringToBool($_POST['nuevo'])) {
			return "INSERT INTO facturas(fact_documentguid,fact_emp,fact_tipo,fact_serie,fact_num,fact_transac,fact_fec,fact_tot,fact_codp,fact_nit,fact_nom,fact_dir,fact_tel,fact_dcre,fact_tcam,fact_fpag,fact_obs,fact_retsn,fact_retisn,fact_stat,fact_vend,fact_ulcam,fact_lugare,fact_envio,fact_pedido,fact_orden,fact_bodsal,fact_pcomi,fact_contrato, fact_exensn,fact_vencod,fact_tipoanu,fact_numanu,fact_serieped,fact_numped,fact_fel,fact_motanu,fact_expsn, fact_asigenvio,fact_tipoenv,fact_serieenv,fact_numenv, fact_efectot,fact_efec,fact_exenval,fact_chnum,fact_chval,fact_tarj,fact_vale,fact_cred,fact_dolares,fact_tcdolar,fact_guardado,fact_caja,fact_zona,fact_cel,fact_adomicilio,fact_nomped,fact_dirped,fact_email) VALUES ('$DocumentGUID','$empCod','$tvcodenvio','$Batch',$Serial,$transac,'$dtFec','$tot','$codp','$nit','$nom','$dir','$tel',$dcre,'$tcam','$fpag','$obs','$retsn','$retisn','$stat','$vencod','$usuNom','$lugare','$envio','$pedido','$orden','$bodsal','$pcomi','$contrato','','','',0,'',0,'','','$expsn','','','',0,'$numEfectotfp','$numEfecfp','$numExenvalfp','$txtChnumfp','$numChvalfp','$numTarjfp','$numValefp','$numCredfp','$numDolaresfp','$numTcdolarfp','$FechaHoraEmision','$pCaja','$numZonaPed','$txtCelPed','$crDomi','$txtNomPed','$txtDirPed','$txtEmail')";
/*		} else {
			return "UPDATE facturas SET fact_fec='$dtFec',fact_tot='$tot',fact_codp='$codp',fact_nit='$nit',fact_nom='$nom',fact_dir='$dir',fact_tel='$tel',fact_dcre=$dcre,fact_tcam='$tcam',fact_fpag='$fpag',fact_obs='$obs',fact_retsn='$retsn',fact_retisn='$retisn',fact_stat='$stat',fact_vend='$vencod',fact_ulcam='$usuNom',fact_lugare='$lugare',fact_envio='$envio',fact_pedido='$pedido',fact_orden='$orden',fact_bodsal='$bodsal',fact_pcomi='$pcomi',fact_contrato='$contrato',fact_expsn='$expsn' WHERE fact_documentguid='$DocumentGUID' AND fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$Batch' AND fact_num=$Serial";
		}   */
	}

	function sMeses($mes) {
		return "SELECT mes_nom FROM meses WHERE mes_cod=$mes";
	}

	function sPaises($pais) {
		return "SELECT pa_alfa2 FROM paises WHERE id=$pais";
	}
	

	function sDoctoscc($tvcodenvio,$num, $Batch) {
		global $empCod, $selTipoCod;
		return "SELECT dc_num FROM doctoscc WHERE dc_emp='$empCod' AND dc_serie='$Batch' AND dc_num=$num AND dc_tipo='$tvcodenvio'";
	}

	function iuDoctoscc($tvcodenvio,$num, $Batch, $nit, $nom, $retsn, $retisn, $bien, $serv, $exen, $exp, $obs, $subb, $subs, $sube, $ret, $reti, $sub, $iva, $tot, $tcam, $cod) {
		global $empCod, $usuNom, $dtFec, $selTipoCod, $empConso, $bitMod, $func, $db;
		if ($db->numRows($db->query(sDoctoscc($num, $Batch)))==0) {
			return "INSERT INTO doctoscc (dc_emp, dc_serie, dc_num, dc_codp, dc_nit, dc_tipo, dc_clien, dc_fec, dc_fecp, dc_retsn, dc_retisn, dc_afe, dc_bien, dc_serv, dc_exen, dc_exp, dc_expre, dc_medi, dc_noafe, dc_tfaco, dc_galos, dc_galor, dc_galod, dc_comb, dc_con, dc_subb, dc_subs, dc_subco, dc_sube, dc_suber, dc_subna, dc_subme, dc_ret, dc_reti, dc_sub, dc_iva, dc_tot, dc_dedu, dc_tcam, dc_ulcam, dc_conso, dc_mod) VALUES ('$empCod', '$Batch', '$num','$cod', '$nit', '$tvcodenvio', '$nom', '$dtFec', '$dtFec', '$retsn', '$retisn', 'S', '$bien', '$serv', '$exen', '$exp', 0, 0, 0, 0, 0, 0, 0, 0, '$obs', '$subb', '$subs', 0, '$sube', 0, 0, 0, $ret, $reti, '$sub', '$iva', '$tot', 0, '$tcam', '$usuNom', '$empConso','$bitMod')";
		} else {
			return "UPDATE doctoscc SET dc_codp='$cod', dc_nit='$nit', dc_clien='$nom', dc_fec='$dtFec', dc_fecp='$dtFec', dc_retsn='$retsn', dc_retisn='$retisn', dc_bien='$bien', dc_serv='$serv', dc_exen='$exen', dc_exp='$exp', dc_con='$obs', dc_subb='$subb', dc_subs='$subs', dc_sube='$sube', dc_ret='$ret', dc_reti='$reti', dc_sub='$sub', dc_iva='$iva', dc_tot='$tot', dc_tcam='$tcam', dc_ulcam='$usuNom', dc_conso='$empConso', dc_mod='$bitMod' WHERE dc_emp='$empCod' AND dc_serie='$Batch' AND dc_num=$num AND dc_tipo='$tvcodenvio'";
		}
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCuentasarray($cta,$debe,$haber) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom, $debe AS cta_debe, $haber AS cta_haber
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function sExiart($cod, $bod) {
		global $empCod;
		return "SELECT ea_exist FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}

	function uExiart($cod, $bod, $existact) {
		global $empCod;
		return "UPDATE exiart SET ea_exist=$existact WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}

	function iExiart($cod, $bod) {
		global $empCod;
		return "INSERT INTO exiart(ea_emp,ea_cod,ea_bod,ea_exist) VALUES('$empCod','$cod','$bod',0)";
	}

	function sExiartpeps($codd,$bodega,$fvence) { 
		global $empCod, $usuNom;
		return "SELECT * FROM exiart_peps WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$bodega' AND ea_fvence='$fvence'";
	}

	function uExiartpeps($codd,$nexist,$bodega,$lote,$fvence) { 
		global $empCod, $usuNom;
		return "UPDATE exiart_peps SET ea_exist='$nexist' WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$bodega' AND ea_fvence='$fvence'";
	}
	function iExiartpeps($codd,$nexist,$bodega,$lote,$fvence,$cosu) { 
		global $empCod, $usuNom;
		return "INSERT INTO exiart_peps(ea_emp,ea_cod,ea_bod,ea_exist,ea_lote,ea_fvence,ea_cosu) VALUES('$empCod','$codd','$bodega','$nexist','$lote','$fvence',$cosu)";
	}

	function iuDoctoss($codenvio,$tvcodenvio,$num, $bodsal, $tcam, $obs, $tot, $codp, $nit, $nom, $dir, $vend, $Batch, $Serial, $hora) { 
		global $empCod, $tipoInv, $dtFec, $usuNom, $selTipoCod, $func, $txtLentrega;
//		if ($func->stringToBool($_POST['nuevo'])) {
			return "INSERT INTO doctoss(ds_emp,ds_tipo,ds_num,ds_fec,ds_fecapli,ds_bodsal,ds_tcam,ds_clicod,ds_clinit,ds_clinom,ds_clidir,ds_vencod,ds_ftipo,ds_fserie,ds_fnum,ds_hora,ds_obs,ds_obsfac,ds_total,ds_ulcam,ds_lentrega) VALUES ('$empCod','$codenvio','$num','$dtFec','$dtFec','$bodsal','$tcam','$codp','$nit','$nom','$dir','$vend','$tvcodenvio','$Batch',$Serial,'$hora','$obs','$obs','$tot','$usuNom','$txtLentrega')";
/*		} else {
			return "UPDATE doctoss SET ds_fec='$dtFec',ds_fecapli='$dtFec',ds_bodsal='$bodsal',ds_tcam='$tcam',ds_clicod='$codp',ds_clinit='$nit',ds_clinom='$nom',ds_clidir='$dir',ds_vencod='$vend',ds_ftipo='$selTipoCod',ds_fserie='$Batch',ds_fnum=$Serial,ds_hora='$hora',ds_obs='$obs',ds_total='$tot',ds_ulcam='$usuNom' WHERE ds_emp='$empCod' AND ds_tipo='$tipoInv' AND ds_num='$num'";
		}   */
	}

	function iFact_det($tvcodenvio,$IDInterno,$transac,$Batch,$Serial,$autoriza,$codp,$nit,$vend,$bodsal,$tcam,$obs,$nom,$dir,$expsn,$tot,$cosp,$codd,$descd,$medid,$unimed,$cantd,$preud,$subd,$descud,$descuvd,$totd,$exensnd,$bienserd,$loted,$fvenced) { 
		global $empCod, $tipoInv, $dtFec, $usuNom, $selTipoCod, $func, $totaleslocal, $numInv;
			return "INSERT INTO fact_det(factd_idinterno,factd_emp,factd_transac,factd_tipo,factd_serie,factd_num,factd_fec,factd_cod,factd_desc,factd_desci,factd_med,factd_unimed,factd_cant,factd_preu,factd_cosu,factd_sub,factd_descu,factd_descuv,factd_tot,factd_autoriza,factd_codp,factd_nit,factd_vend,factd_bodsal,factd_exensn,factd_bienser,factd_lote,factd_fvence) VALUES ('$IDInterno','$empCod','$transac','$tvcodenvio','$Batch','$Serial','$dtFec','$codd','$descd','$descd','$medid','$unimed','$cantd','$preud','$cosp','$subd','$descud','$descuvd','$totd',0,'$codp','$nit','$vend','$bodsal','$exensnd','$bienserd','$loted','$fvenced')";
	}

	function iDocs_det($codenvio,$IDInterno, $transac, $Batch, $Serial, $autoriza, $codp, $nit, $vend, $bodsal, $tcam, $obs, $nom, $dir, $expsn, $tot, $existant, $existact,$cosp,$i,$codd,$descd,$medid,$unimed,$cantd,$preud,$subd,$descud,$descuvd,$totd,$exensnd,$bienserd,$loted,$fvenced) { 
		global $empCod, $tipoInv, $dtFec, $usuNom, $selTipoCod, $func, $totaleslocal, $numInv;
			return "INSERT INTO docs_det(dsd_emp,dsd_tipo,dsd_num,dsd_fec,dsd_fecapli,dsd_linea,dsd_cod,dsd_cant,dsd_cantcon,dsd_desc,dsd_descfac,dsd_med,dsd_unimed,dsd_unit,dsd_descu,dsd_descuv,dsd_monto,dsd_cosu,dsd_exiant,dsd_exipos,dsd_consig,dsd_autoriza,dsd_exensn,dsd_lote,dsd_fvence) VALUES ('$empCod','$codenvio','$Serial','$dtFec','$dtFec',$i,'$codd','$cantd',0,'$descd','$descd','$medid','$unimed','$preud','$descud','$descuvd','$totd','$cosp',$existant,$existact,'',0,'$exensnd','$loted','$fvenced')";
	}

	function iMovii($codenvio,$tvcodenvio,$IDInterno, $transac, $Batch, $Serial, $autoriza, $codp, $nit, $vend, $bodsal, $tcam, $obs, $nom, $dir, $expsn, $tot, $cosp, $i, $codd, $descd, $medid, $unimed, $cantd, $preud, $subd, $descud, $descuvd, $totd, $exensnd, $bienserd) { 
		global $empCod, $tipoInv, $dtFec, $usuNom, $selTipoCod, $func, $totaleslocal, $numInv;
			return "INSERT INTO movii(mov_emp,mov_tipo,mov_num,mov_ftipo,mov_fserie,mov_fnum,mov_fec,mov_fecapli,mov_linea,mov_cod,mov_bodent,mov_bodsal,mov_entra,mov_sale,mov_entracon,mov_salecon,mov_cosu,mov_preu) VALUES ('$empCod','$codenvio','$Serial','$tvcodenvio','$Batch','$Serial','$dtFec','$dtFec',$i,'$codd','','$bodsal',0,'$cantd',0,0,'$cosp','$preud')";
	}

	function iMoviipeps($codenvio,$tvcodenvio,$IDInterno, $transac, $Batch, $Serial, $autoriza, $codp, $nit, $vend, $bodsal, $tcam, $obs, $nom, $dir, $expsn, $tot, $cosp, $i, $codd, $descd, $medid, $unimed, $cantd, $preud, $subd, $descud, $descuvd, $totd, $exensnd, $bienserd, $lote, $fvence) { 
		global $empCod, $tipoInv, $dtFec, $usuNom, $selTipoCod, $func, $totaleslocal, $numInv;
		return "INSERT INTO movii_peps (mov_emp, mov_tipo, mov_num, mov_fec, mov_fecapli, mov_cod, mov_bodent, mov_bodsal, mov_entra, mov_sale, mov_cosu, mov_preu, mov_lote, mov_fvence, mov_fserie, mov_fnum) VALUES ('$empCod','$codenvio','$Serial','$dtFec','$dtFec','$codd','','$bodsal', 0, '$cantd','$cosp','$preud','$lote','$fvence','$tvcodenvio','$Batch')";
	}

	function sArtic($cod) {
		global $empCod;
		return "SELECT art_cosp FROM artic WHERE art_cod='$cod' AND art_emp='$empCod'";
	}

	function uArtic($cod,$exensn,$cosp) {
		global $empCod;
		return "UPDATE artic SET art_exen='$exensn', art_cosp='$cosp' WHERE art_cod='$cod' AND art_emp='$empCod'";
	}

	function sPolizas($num, $serie) {
		global $empCod, $tipoPol;
		return "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie'";
	}

	function iPolizas($fecha,$serie,$num,$nit,$obs) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$obs','$usuNom','$dtGrabado')";
	}

	function uPolizas($num, $serie, $con, $nit) {
		global $empCod, $tipoPol, $usuNom, $dtFec, $dtGrabado;
		return "UPDATE polizas SET pol_con='$con', pol_fec='$dtFec', pol_nit='$nit', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie'";
	}

	# QUERYS PARA VARIOS REGISTROS
	function iPoli_det($fecha,$serie,$num,$nit,$cta,$ctan,$debe,$haber) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$cta','$ctan','$debe','$haber')";
	}

	function dPoli_det($num, $serie) {
		global $empCod, $tipoPol;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie'";
	}

	# PARA REVISION DE EXISTENCIAS
	function sMoviie0($codd, $bodega) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_entra) AS mov_sentra
	            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$bodega' GROUP BY '$empCod','$bodega','$codd'";
	}

	function sMoviis0($codd, $bodega) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_sale) AS mov_ssale
	            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$bodega' GROUP BY '$empCod','$bodega','$codd'";
	}
	function sMoviie0peps($codd, $bodega, $fvence) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_entra) AS mov_sentrapeps
	            FROM movii_peps WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$bodega' AND mov_fvence='$fvence' GROUP BY '$empCod','$bodega','$codd','$fvence'";
	}

	function sMoviis0peps($codd, $bodega, $fvence) { 
	    global $empCod, $usuNom;
	    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
	            SUM(mov_sale) AS mov_ssalepeps
	            FROM movii_peps WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$bodega' AND mov_fvence='$fvence' GROUP BY '$empCod','$bodega','$codd','$fvence'";
	}
	///

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$faCliencc = $db->sFetchAssoc(sCliencc($txtCliCod));

	// Para ver correlativo de envios y relacionado con tipov
	$fetchAssoc["caja"] = $db->sFetchAssoc($sCaja);
	$codenvio = trim($fetchAssoc["caja"]["caj_codenvio"]);
	$select["corrtdoci"] = $db->query(sCorrTdoci($codenvio));
	$fetchAssoc["corrtdoci"] = $db->fetchAssoc($select["corrtdoci"]);
	if ($db->numRows($select["corrtdoci"]) == 0) {
	  $nuevocorr=1;
	  $numdoc=1;
	  $db->iEx(iCorrTdoci($codenvio,$nuevocorr));
	} else {
      $numdoc=$fetchAssoc["corrtdoci"]["ctdi_corr"];
  	  $nuevocorr=$numdoc+1;
  	  $db->uEx(uCorrTdoci($codenvio,$nuevocorr));
	}
	// Tipo documento inventario
	$select["tipodoci"] = $db->query(sTdoci($codenvio));
	$fetchAssoc["tipodoci"] = $db->fetchAssoc($select["tipodoci"]);
	$tvcodenvio = trim($fetchAssoc["tipodoci"]["td_relatv"]);
	// Tipo documento venta
	$select["tipov"] = $db->query(sTipov($tvcodenvio));
	$fetchAssoc["tipov"] = $db->fetchAssoc($select["tipov"]);
	$abrev = trim($fetchAssoc["tipov"]["tv_abrev"]);

    // 
	$pais = $db->sFetchAssoc(sPaises($faCliencc['cli_pais']))['pa_alfa2'];
	$dcre = $faCliencc["cli_dcre"];


	// Para quitar comillas porque nos da error y no deja guardar en WS
	$nomWS = str_replace('"', '', utf8_decode($txtNomFac));
	$nomWS = str_replace('&', '&amp;', $nomWS);

	// Datos Generales
	$Tipo=$selCodasiste;
	$FechaHoraEmision = $dtFec.'T'.date("H:i:s", STRTOTIME(date('h:i:sa'))).'-06:00';
	$CodigoMoneda = ($crTcam=='L') ? 'GTQ' : 'USD';

	// Frases
	$arrayFrases = array(
		array('TipoFrase'=>1, 'CodigoEscenario'=>1)
	);

	$sub=0;
	$iva=0;
	$totIva=0;
	$subIva=0;
	$ivaIva=0;
	$haberIva=0;
	// Items


	$arrayItems = array();
	$i = 1;
	foreach ($jsonDet as $obj) {
		$i++;
		// Revisa si hay registro de existencia, si no hay lo inicia
		$select["exiartr"] = $db->query(sExiart($obj->codd, $selBodSalCod));
		if ($db->numRows($select["exiartr"]) == 0) {
	    	$db->iEx(iExiart($obj->codd, $selBodSalCod));
		}  
	}  

	$IDInterno = $db->sFetchAssoc($sTABLES)['AUTO_INCREMENT'];
	$Identificador="PARCOIRIS_".str_pad($IDInterno,9,"0",STR_PAD_LEFT);

//    $paso=1;
	$Batch = $abrev;
	$Serial = $numdoc;
	$DocumentGUID = "";


    $numNum=$Serial;

	$select["clien"] = $db->query($sCliIva);
	if ($db->numRows($select["clien"]) == 0) {
	   	$db->iEx($iCliIva);
	} else {
	   	$db->uEx($uCliIva);
	}

	$select["clien_ped"] = $db->query($sCliPed);
	if ($db->numRows($select["clien_ped"]) == 0) {
    	$db->iEx($iCliPed);
	} else {
    	$db->uEx($uCliPed);
	}	

	$numInv	= $numNum;


	// VARIABLES PARA SEPARAR BIENES, SERVICIOS Y EXPORTACION
	$hayBienes=false;
	$totaleslocal["bienes"]["exentoS"]=0;
	$totaleslocal["bienes"]["exentoN"]=0;
	$totaleslocal["servicios"]["exentoS"]=0;
	$totaleslocal["servicios"]["exentoN"]=0;
	$totaleslocal["exportacion"]=0;

	$txtObs="Envio realizado a: ".$txtNomFac;
	// Iva ventas
	$val = calculos($tot, $crRet, $crReti, $crExp, $selTipoImpues, $numTcam, 1);

	$db->iEx(iuDoctoss($codenvio,$tvcodenvio,$Serial,$selBodSalCod, $numTcam, $txtObs, $tot, $txtCliCod, $txtNit, $txtNomFac, $txtDir, $selVendCod, $Batch, $Serial, ''));

	// SI LA FORMA DE PAGO ES AL CREDITO, ENTONCES GUARDAR EN EL MODULO DE CUENTAS POR COBRAR
	if ($crFpag==2) {
		$resp = $db->iEx(iuDoctoscc($tvcodenvio,$Serial, $Batch, $txtNit, $txtNomFac, $crRet, $crReti, $val["bien"], $val["serv"], $val["exen"], $val["exp"], $txtObs, $val["subb"], $val["subs"], $val["sube"], $val["ret"], $val["reti"], $val["sub"], $val["iva"], $val["tot"], $numTcam, $txtCliCod));
	}


	// Encabezado Factura
	$db->iEx(iuFacturas($tvcodenvio,$Batch, $Serial, $DocumentGUID, $IDInterno, $tot, $txtCliCod, $txtNit, $txtNomFac, $txtDir, $txtTelPed, $numDcre, $numTcam, $crFpag, $txtObs, $crRet, $crReti, '', $selVendCod, '', '', '', '', $selBodSalCod, "0.00", 0, $crExp, $FechaHoraEmision));

	// RECORRER DETALLE PARA ACUMULAR QUERYS
	$i=0;
	$iUltimoBien=0;
	$arrayCosto=array();
	$sumcosto=0;
	$cero=0;
	foreach ($jsonDet as $obj) {
		$i++;
		$codd = utf8_decode($obj->codd);
		$descd = utf8_decode($obj->descd);
		$medid = utf8_decode($obj->medid);
		$unimed = utf8_decode($obj->unimed);
		$loted = $obj->loted;
		$fvenced = $obj->fvenced;
		$cantd = $obj->cantd;
		$preud = $obj->preud;
		$subd = $obj->subd;
		$descud = $obj->descud;
		$descuvd = $obj->descuvd;
		$totd = $obj->totd;
		$exensnd = $obj->exensnd;
		$bienserd = $obj->bienserd;
		$ctacos = $obj->ctacos;
		$cosp = $obj->cosud;
		$sumcosto+= $cosp;

		$db->uEx(uArtic($codd,$exensnd,$cosp));

		// Hay que jalar la existencia actual
		$select["exiart"] = $db->query(sExiart($codd,$selBodSalCod));
		if ($db->numRows($select["exiart"])>0) {
			$existant=($db->fetchAssoc($select["exiart"])["ea_exist"]);
		} else {
			$existant=0;
			$db->iEx(iExiart($codd,$selBodSalCod));
		}
		$existact = $existant-$cantd;
		$db->uEx(uExiart($codd, $selBodSalCod, $existact));

		// Para existencia Peps
		$select["exiarts_peps"] = $db->query(sExiartpeps($codd,$selBodSalCod,$fvenced));
		$fetchAssoc["exiarts_peps"] = $db->fetchAssoc($select["exiarts_peps"]);
		if ($db->numRows($select["exiarts_peps"]) == 0) {
			$exiantspeps=0;
        } else {
          $exiantspeps=$fetchAssoc["exiarts_peps"]["ea_exist"];
        }
        $nuevaexistspeps=$exiantspeps-$cantd;
		$db->uEx(uExiartpeps($codd,$nuevaexistspeps,$selBodSalCod,$loted,$fvenced));

		$hayBienes = true;
		$iUltimoBien = $i;
		($obj->exensnd=='N') ? $totaleslocal["bienes"]["exentoN"]+=$obj->totd : $totaleslocal["bienes"]["exentoS"]+=$obj->totd;

        // Detalle de la factura
		$resp = $db->iEx(iFact_det($tvcodenvio,$IDInterno, $IDInterno, $Batch, $Serial, 0, $txtCliCod, $txtNit, $selVendCod, $selBodSalCod, $numTcam, $txtObs, $txtNomFac, $txtDir, $crExp, $tot,$cosp,$codd,$descd,$medid,$unimed,$cantd,$preud,$subd,$descud,$descuvd,$totd,$exensnd,$bienserd,$loted,$fvenced));

		// Detalle de documentos inventario
		$db->iEx(iDocs_det($codenvio,$IDInterno, $IDInterno, $Batch, $Serial, 0, $txtCliCod, $txtNit, $selVendCod, $selBodSalCod, $numTcam, $txtObs, $txtNomFac, $txtDir, $crExp, $tot,$existant,$existact, $cosp, $i, $codd, $descd, $medid, $unimed, $cantd, $preud, $subd, $descud, $descuvd, $totd, $exensnd,$bienserd,$loted,$fvenced));

		// Movimiento en el inventario
		$db->iEx(iMovii($codenvio,$tvcodenvio,$IDInterno, $IDInterno, $Batch, $Serial, 0, $txtCliCod, $txtNit, $selVendCod, $selBodSalCod, $numTcam, $txtObs, $txtNomFac, $txtDir, $crExp, $tot, $cosp, $i, $codd, $descd, $medid, $unimed, $cantd, $preud, $subd, $descud, $descuvd, $totd, $exensnd, $bienserd));

		$db->query(iMoviipeps($codenvio,$tvcodenvio,$IDInterno, $IDInterno, $Batch, $Serial, 0, $txtCliCod, $txtNit, $selVendCod, $selBodSalCod, $numTcam, $txtObs, $txtNomFac, $txtDir, $crExp, $tot, $cosp, $i, $codd, $descd, $medid, $unimed, $cantd, $preud, $subd, $descud, $descuvd, $totd, $exensnd, $bienserd, $loted, $fvenced));

        # Aqui se recalculan existencias
        # Para revisar las existencias normales
		$select["moviie0"] = $db->query(sMoviie0($codd,$selBodSalCod));
		$fetchAssoc["moviie0"] = $db->fetchAssoc($select["moviie0"]);
		if ($db->numRows($select["moviie0"]) == 0) {
		   $sumentro=0;
        } else {
          $sumentro=$fetchAssoc["moviie0"]["mov_sentra"];
        }
		$select["moviis0"] = $db->query(sMoviis0($codd,$selBodSalCod));
		$fetchAssoc["moviis0"] = $db->fetchAssoc($select["moviis0"]);
		if ($db->numRows($select["moviis0"]) == 0) {
		   $sumsalio=0;
        } else {
           $sumsalio=$fetchAssoc["moviis0"]["mov_ssale"];
		}	               
        $exisactu=$sumentro-$sumsalio;
		$db->uEx(uExiart($codd,$selBodSalCod,$exisactu));

        # Para revisar las existencias normales peps
		$select["moviie0peps"] = $db->query(sMoviie0peps($codd,$selBodSalCod,$fvenced));
		$fetchAssoc["moviie0peps"] = $db->fetchAssoc($select["moviie0peps"]);
		if ($db->numRows($select["moviie0peps"]) == 0) {
		   $sumentropeps=0;
        } else {
           $sumentropeps=$fetchAssoc["moviie0peps"]["mov_sentrapeps"];
        }
		$select["moviis0peps"] = $db->query(sMoviis0peps($codd,$selBodSalCod,$fvenced));
		$fetchAssoc["moviis0peps"] = $db->fetchAssoc($select["moviis0peps"]);
		if ($db->numRows($select["moviis0peps"]) == 0) {
		   $sumsaliopeps=0;
        } else {
           $sumsaliopeps=$fetchAssoc["moviis0peps"]["mov_ssalepeps"];
        }
        $exisactupeps=$sumentropeps-$sumsaliopeps;
		$db->uEx(uExiartpeps($codd,$exisactupeps,$selBodSalCod,$loted,$fvenced));
		//

		// Para agrupar las cuentas de costos que se utilizaron
/// Ya no se uso por indicacion de la contadora, no se incluiran costos aqui		
/*		
		$cuentacos = TRIM($ctacos);
		$p = $func->multiSearch($arrayCosto, array('cta' => (string)$cuentacos));
		if ($p >= 0) {
			$arrayCosto[$p]["cta_debe"] += $cosp;
		} else {
			$fa["ctaCos"] = $db->sFetchAssoc(sCuentasarray((string)$cuentacos,$cosp,0));
		    array_push($arrayCosto, array("cta"=>$cuentacos,"cta_nom"=>$fa["ctaCos"]["cta_nom"],"cta_debe"=>$cosp,"cta_haber"=>$cero));
		}
*/		
	}

			// De aqui en adelante se registra la parte de la partida contable

/*  Se bloqueo mientras se define si el envio lleva patida o no

			$db->query(iPolizas($dtFec,$Batch,$Serial,$txtNit,$txtObs));

			// CUENTA DE CARGO SE USA LA CUENTA DE CAJA GENERAL
			$cta = '1110101';
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$tot-($numExenvalfp+$numCredfp);  
			$haber=0;
			$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
			if ($numExenvalfp>0) {
				// CUENTA PARA EXENCIONES
				$cta = "1120203";
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$numExenvalfp;  
				$haber=0;
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}
			if ($numCredfp>0) {
				// CUENTA PARA VENTAS AL CREDITO
				$cta = "1120101";
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$numCredfp;  
				$haber=0;
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}
			if ($val["iva"]>0) {
				// CUENTA PARA IVA
				$cta = $_SESSION['empCtaiv'];
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=0;  
				$haber=$val["iva"];
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}
			// CUENTA PARA VENTAS
			$cta = $ctaven;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;  
			$haber=$val["sub"];
			$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

			//saco el numero de elementos
			$longitud = count($arrayCosto);
			//Recorro todos los elementos
			for($i=0; $i<$longitud; $i++) {
				$cta=$arrayCosto[$i]["cta"];
				$ctaNom=$arrayCosto[$i]["cta_nom"];
				$debe=$arrayCosto[$i]["cta_debe"];
				$haber=0;
				$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
				// PARA APLICAR LOS CIERRES
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
			}

			// CUENTA DE INVENTARIO
			$cta = $ctainv;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;  
			$haber=$sumcosto;
			$db->query(iPoli_det($dtFec,$Batch,$Serial,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/
			
	//PARA BITACORA
	$db->iEx($func->iBitacora(utf8_decode("Se creó Envio IDInterno: {$IDInterno} DocumentGUID: {$DocumentGUID} No.: {$Serial} Serie: {$Batch} NIT: {$txtNit} Usuario: ").$usuNom, $bitMod, $bitForm));



/*
	// Por si no se pudo guardar la factura de algún cliente
	$sizeError = sizeof($arrayError);
	if ($sizeError != 0) {
		$title = $arrayError[0]["Code"]." - ".$arrayError[0]["cod"];
		$text = $arrayError[0]["Description"];
		$resp = $db->rErrorPublic($title, $text);
	}

*/
	$db->close();
	$mserror="";

	$resp["seriedoc"]=$Batch;
	$resp["numdoc"]=$Serial;
	$resp["nit"]=$txtNit;
	$resp["idinterno"]=$IDInterno;
	$resp["Identificador"]=$Identificador;
	$resp["documentGuid"]=$DocumentGUID;
	$resp["mserror"]=$mserror;

	return json_encode($resp);
}


function imprimir() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}
	
	# QUERYS
	$sTipov = "SELECT TRIM(tv_nom) AS tv_nom FROM tipov WHERE tv_cod='{$_POST["selTipoCod"]}'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$fa["tipov"] = $db->sFetchAssoc($sTipov);

	$_SESSION["printFacturas"] = array(
		'tipoNomFEL'=>$fa["tipov"]["tv_nom"],
		'tipoFEL'	=>$_POST["selTipoCod"],
		'nom'		=>$_POST["txtNomFac"],
		'nit'		=>$_POST["txtNit"],
		'dir'		=>$_POST["txtDir"],
		'fec'		=>$_POST["dtFec"],
		'tcam'		=>$_POST["tcam"],
		'tot'		=>$_POST["dataTot"],
		'totLetras'	=>$_POST["totLetras"],
		'det' 		=>$_POST["tblDet"]
	);
	return "";
}

function calculos($tot, $retsn, $retisn, $expsn, $impues, $tcam, $tcamRet) {
	global $totaleslocal;

	$val["ret"] = 0;
	$val["reti"] = 0;

	$val["bien"] = round($totaleslocal["bienes"]["exentoN"]*$tcam, 2);
	$val["serv"] = round($totaleslocal["servicios"]["exentoN"]*$tcam, 2);
	$val["exen"] = round(($totaleslocal["bienes"]["exentoS"]+$totaleslocal["servicios"]["exentoS"])*$tcam, 2);
	$val["exp"] = round($totaleslocal["exportacion"]*$tcam, 2);

	// SUBTOTALES
	$val["subb"] = $val["bien"];
	$val["subs"] = $val["serv"];
	$val["sube"] = $val["exp"];

    // IVA, SUBTOTAL Y TOTAL
	$val["tot"] = round($tot*$tcam, 2);
	$val["sub"] = $val["subb"]+$val["subs"]+$val["exen"]+$val["sube"];
	$val["iva"] = 0;
	if ($impues=="N") {
		$val["subb"] = ($val["bien"]/(($_SESSION['pIva']/100)+1));
		$val["subs"] = ($val["serv"]/(($_SESSION['pIva']/100)+1));
		$val["sube"] = $val["exp"];

		$val["sub"] = $val["subb"]+$val["subs"]+$val["exen"]+$val["sube"];
		$val["iva"] = $val["tot"]-$val["sub"];

		// RETENCION ISR
		$val["ret"]=0;
		$pBaseisrQ = $_SESSION["pBaseisr"]/$tcamRet;
		if ($retsn=='S' && $val["sub"]>=(2500/$tcamRet) && $expsn=='N') {
			if ($val["sub"] > $pBaseisrQ) {
				$sub1 = $pBaseisrQ;
				$sub2 = $val["sub"]-$pBaseisrQ;
			} else {
				$sub1 = $val["sub"];
				$sub2 = 0;
			}
			$ret1=($sub1*$_SESSION["pIsr"])/100;
			$ret2=($sub2*$_SESSION["pIsr2"])/100;
			$val["ret"]=round($ret1+$ret2, 2);
		}
		
		// RETENCION IVA
		$val["reti"] = ($retisn=='S' && $expsn=='N') ? round(($val["iva"]*$_SESSION["pRiva"])/100, 2) : 0;
	}

	return $val;
}
function consultarDoc() {
	global $empCod, $usuNom, $tipoPol;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$tipoPol="010";
	$numInterno=$_POST['numInterno'];

	# QUERYS
	$sFacturas = "SELECT
					f.*,
					c.ciem_stat,
					TRIM(f.fact_documentguid) AS fact_documentguid,
					TRIM(f.fact_guardado) AS fact_guardado,
					TRIM(cli.cli_nom) AS cli_nom,
					TRIM(cli.cli_cta) AS cli_cta
				  FROM facturas f 
				  LEFT JOIN ciemes c ON c.ciem_mes=MONTH(f.fact_fec) AND c.ciem_ano=YEAR(f.fact_fec) AND c.ciem_emp='$empCod'
				  LEFT JOIN cliencc cli ON cli.cli_emp='$empCod' AND cli.cli_cod=f.fact_codp
				  WHERE fact_emp='$empCod' AND fact_idinterno='$numInterno'";

	function sFact_det($IDInterno) {
		return "SELECT * FROM fact_det WHERE factd_idinterno='$IDInterno'";
	}

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sFacturas, "facturas");
	$resp["fact_det"] = ($resp["facturas"]!=null) ? $db->sFetchAll(sFact_det($resp["facturas"]["fact_idinterno"])) : array();
	$serie=$resp["facturas"]["fact_serie"];
	$num=$resp["facturas"]["fact_num"];

	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "facturas");
}

?>