<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selBodega=$_GET["selBodega"];
$BodegaNom=$_GET["BodegaNom"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$lineWidth=19;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $BodegaNom;
        $this->SetMargins(1, 1, 1);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",14);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell($lineWidth,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Resumen de entradas y salidas Para toma fisica del ".strftime("%d/%m/%Y", strtotime($dtFeci))." al ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        //$this->Ln();
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Bodega ".$BodegaNom),0,1,"L");
        $this->SetFont("","",8);
        $header = array("Codigo","Descripcion","Medida","Entradas","Salidas","Existencia Fisica");
        $this->SetFont("","B");
        $this->SetWidths(array(1.8,7.5,2,2,2,4));
        $this->SetAligns(array("C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("");
        $this->SetAligns(array("L","L","C","R","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS

$sMovii = "SELECT *, TRIM(art.art_cod) AS art_cod,
            TRIM(art.art_desc) AS art_desc,
            SUM(mov_entra) AS mov_sentra,
            SUM(mov_sale) AS mov_ssale
            FROM movii mi
            LEFT JOIN artic art ON art.art_emp=mi.mov_emp AND art.art_cod=mi.mov_cod
            LEFT JOIN exiart ea ON ea.ea_emp=mi.mov_emp AND ea.ea_cod=mi.mov_cod AND ea.ea_bod='$selBodega'
            LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
            LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
            LEFT JOIN unimed um ON art.art_medi=um.um_cod            
            WHERE (mov_emp='$empCod' AND mov_entra>0 AND mov_bodent='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf') or (mov_emp='$empCod' AND mov_sale>0 AND mov_bodsal='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf') 
            GROUP BY mov_emp,mov_cod ORDER BY art.art_emp,CAST(art.art_cod AS UNSIGNED)";

function sMoviied($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$selBodega' AND mov_fec>'$dtFecf' GROUP BY '$empCod','$codd'";
}
function sMoviisd($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$selBodega' AND mov_fec>'$dtFecf' GROUP BY '$empCod','$codd'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["movii"] = $db->query($sMovii);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$ti_Depto="XXXX";
$ti_sDepto="XXXX";
$sumcos=0;
$sument=0;
$sumsal=0;
while ($rec = $db->fetchAssoc($select["movii"])) {
/*    if ($ti_Depto.$ti_sDepto!=$rec["art_dep"].$rec["art_subdep"]) {
       $pdf->SetFont("","B");
       $pdf->Cell($lineWidth,.7,trim($rec["dep_nom"]).", ".rtrim($rec["sdep_nom"]),0,0,"L");
       $ti_Depto=$rec["art_dep"];
       $ti_sDepto=$rec["art_subdep"];
       $pdf->SetFont("","");
       $pdf->ln();
    }  */
    $codd=$rec["art_cod"];
    $cosp=$rec["art_cosp"];
    $exist=$rec["ea_exist"];
    $salidas=$rec["mov_ssale"];
    $entradas=$rec["mov_sentra"];
    $sument+=$entradas;
    $sumsal+=$salidas;
    // Para revisar lo posterior entradas
    $select["moviie"] = $db->query(sMoviied($codd));
    $recme0 = $db->fetchAssoc($select['moviie']);
    $sEntramov=$recme0["mov_sentra"];
    // Para revisar lo posterior salidas
    $select["moviis"] = $db->query(sMoviisd($codd));
    $recms0 = $db->fetchAssoc($select['moviis']);
    $sSalemov=$recms0["mov_ssale"];

    $exisact=($exist+$sSalemov)-$sEntramov;
    $exiini=($exisact+$salidas)-$entradas;

    if ($salidas==0 && $entradas==0) {
        continue;
    }
    $costot=round($exisact*$cosp,5);
    $sumcos+=$costot;
    $body = array(
        $rec["art_cod"],
        trim($rec["art_desc"]),
        trim($rec["um_nom"]),
//        number_format($exiini, 2, '.', ','),
        number_format($entradas, 2, '.', ','),
        number_format($salidas, 2, '.', ','),
//        number_format($exisact, 2, '.', ','),
        "__________________",
    );
    $pdf->RowBorderHidden($body, $lineHeight+.7);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 20.25, $pdf->GetY());
$body = array(
    "",
    "  TOTALES  ",
    "",
//        number_format($exiini, 2, '.', ','),
    number_format($sument, 2, '.', ','),
    number_format($sumsal, 2, '.', ','),
//        number_format($exisact, 2, '.', ','),
    "",
);
$pdf->RowBorderHidden($body, $lineHeight+.2);
$pdf->line($pdf->GetX(), $pdf->GetY(), 20.25, $pdf->GetY());
$pdf->line($pdf->GetX(), $pdf->GetY()+.075, 20.25, $pdf->GetY()+.075);

$db->close();
$pdf->Output(utf8_decode("ResumenMovi").".pdf","I");
?>