<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

//$func = new functions();

$lineWidth=25.2;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $selTipodoci;
        $this->SetMargins(1.1, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE PRORRATEOS REGISTRADOS DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");

        $this->Ln();
        $this->SetFont("","",7);
        $this->SetFont("","B");
        $this->SetWidths(array(1.7,2.3,1.8,2,6,7,1.6,2.2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","C","L","L","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sProrrat = "SELECT * FROM prt_det1 pd1 LEFT JOIN prorrat prt ON pd1.pd1_emp=prt.prt_emp and pd1.pd1_num=prt.prt_num 
   LEFT JOIN tipodoci td ON prt.prt_tipod=td.td_cod 
   WHERE pd1_emp='$empCod' and prt_fec>='$dtFeci' and prt_fec<='$dtFecf' ORDER BY pd1_emp,pd1_num";
# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["prt_det1"] = $db->query($sProrrat);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "letter");
$pdf->AddPage();
$func = new functions();

$ti_tipo="XXXZZZ999";
$ti_num=9999999;
$subcant=0;
$subtfobq=0;
$subpord=0;
$subgastq=0;
$subdai=0;
$subvtotal=0;
$totcant=0;
$tottfobq=0;
$totpord=0;
$totgastq=0;
$totdai=0;
$totvtotal=0;

$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["prt_det1"])) {
    if ($t_lini == 1) {
        $pdf->SetFont("","B",7);        
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "NUMERO:  ".$rec["prt_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["prt_fec"])),0,1,"L");
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/7, $lineHeight, utf8_decode("TIPO DE DOCUMENTO:"),0,0,"L");
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode($rec["td_nom"]),0,0,"L");
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("NUMERO DOCUMENTO:"),0,0,"L");
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode($rec["prt_numd"]),0,0,"L");
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("TASA DE CAMBIO:"),0,0,"L");
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, $rec["prt_tcam"],0,1,"L");
        $pdf->SetFont("","B");
        if ($rec["prt_stat"]=='P') {
          $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("YA PROCESADO"),0,1,"L");
        } else {
          $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("PENDIENTE DE PROCESAR"),0,1,"L");
        }   
        $pdf->SetFont("","",7);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"CANTIDAD","UNIT/FOB Q","TOTAL/FOB Q","% DISTRIB.","OTROS/GASTOS","DAI","COSTO TOTAL Q","UNITARIO Q");
        $widths = array(3,7,2,2,2,2,2,2,2,2);
        $pdf->SetWidths($widths);
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","R","R","R","R","R","R","R","R"));
    }
    if ($ti_num!=$rec["prt_num"]) {
        if ($t_lini > 1) {
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 27.1, $pdf->GetY());
            //$pdf->Cell(.04,.4,"          TOTAL ESTE DOCUMENTO",0,0,"L");
            $body = array(
                "",
                "             TOTALES DEL DOCUMENTO: ",
                ($subcant > 0) ? number_format($subcant,2) : "",
                "",
                ($subtfobq > 0) ? number_format($subtfobq,6) : "",
                ($subpord > 0) ? number_format($subpord,6) : "",
                ($subgastq > 0) ? number_format($subgastq,6) : "",
                ($subdai > 0) ? number_format($subdai,6) : "",
                ($subvtotal > 0) ? number_format($subvtotal,6) : "",
            ); 

            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 27.1, $pdf->GetY());
            $pdf->ln();
            $pdf->MultiAlignCell($lineWidth, $lineHeight, "NUMERO:  ".$rec["prt_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["prt_fec"])),0,1,"L");
            $pdf->SetFont("","B");
            $pdf->MultiAlignCell($lineWidth/7, $lineHeight, utf8_decode("TIPO DE DOCUMENTO:"),0,0,"L");
            $pdf->SetFont("","");
            $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode($rec["td_nom"]),0,0,"L");
            $pdf->SetFont("","B");
            $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("NUMERO DOCUMENTO:"),0,0,"L");
            $pdf->SetFont("","");
            $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode($rec["prt_numd"]),0,0,"L");
            $pdf->SetFont("","B");
            $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("TASA DE CAMBIO:"),0,0,"L");
            $pdf->SetFont("","");
            $pdf->MultiAlignCell($lineWidth/8, $lineHeight, $rec["prt_tcam"],0,1,"L");
            $pdf->SetFont("","B");
            if ($rec["prt_stat"]=='P') {
              $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("YA PROCESADO"),0,1,"L");
            } else {
              $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("PENDIENTE DE PROCESAR"),0,1,"L");
            }   
            $pdf->SetFont("","",7);   
            $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"CANTIDAD","UNIT/FOB Q","TOTAL/FOB Q","% DISTRIB.","OTROS/GASTOS","DAI","COSTO TOTAL Q","UNITARIO Q");
            $widths = array(3,7,2,2,2,2,2,2,2,2);
            $pdf->SetWidths($widths);
            $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
            $pdf->Row($header, $lineHeight);
            $pdf->SetAligns(array("L","L","R","R","R","R","R","R","R","R"));
        }             
        $subcant=0;
        $subtfobq=0;
        $subpord=0;
        $subgastq=0;
        $subdai=0;
        $subvtotal=0;
        $ti_num=$rec["pd1_num"];
        $t_lini=2;
    } 
    $subcant+=$rec["pd1_cant"];
    $subtfobq+=$rec["pd1_tfobq"];
    $subpord+=$rec["pd1_pord"];
    $subgastq+=$rec["pd1_gastq"];
    $subdai+=$rec["pd1_dai"];
    $subvtotal+=$rec["pd1_vtotal"];

    $totcant+=$rec["pd1_cant"];
    $tottfobq+=$rec["pd1_tfobq"];
    $totpord+=$rec["pd1_pord"];
    $totgastq+=$rec["pd1_gastq"];
    $totdai+=$rec["pd1_dai"];
    $totvtotal+=$rec["pd1_vtotal"];

    $body = array(
        $rec["pd1_codpro"],
        $rec["pd1_desc"],
        ($rec["pd1_cant"] > 0) ? number_format($rec["pd1_cant"],2) : "",
        ($rec["pd1_cosu"] > 0) ? number_format($rec["pd1_cosu"],6) : "",
        ($rec["pd1_tfobq"] > 0) ? number_format($rec["pd1_tfobq"],6) : "",
        ($rec["pd1_pord"] > 0) ? number_format($rec["pd1_pord"],6) : "",
        ($rec["pd1_gastq"] > 0) ? number_format($rec["pd1_gastq"],6) : "",
        ($rec["pd1_dai"] > 0) ? number_format($rec["pd1_dai"],6) : "",
        ($rec["pd1_vtotal"] > 0) ? number_format($rec["pd1_vtotal"],6) : "",
        ($rec["pd1_costuq"] > 0) ? number_format($rec["pd1_costuq"],5) : "",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
    if (($pdf->GetY()+$lineHeight) > 27) {
        $pdf->AddPage();
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "NUMERO:  ".$rec["prt_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["prt_fec"])),0,1,"L");
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/7, $lineHeight, utf8_decode("TIPO DE DOCUMENTO:"),0,0,"L");
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode($rec["td_nom"]),0,0,"L");
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("NUMERO DOCUMENTO:"),0,0,"L");
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode($rec["prt_numd"]),0,0,"L");
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("TASA DE CAMBIO:"),0,0,"L");
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, $rec["prt_tcam"],0,1,"L");
        $pdf->SetFont("","B");
        if ($rec["prt_stat"]=='P') {
          $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("YA PROCESADO"),0,1,"L");
        } else {
          $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("PENDIENTE DE PROCESAR"),0,1,"L");
        }   
        $pdf->SetFont("","",7);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"CANTIDAD","UNIT/FOB Q","TOTAL/FOB Q","% DISTRIB.","OTROS/GASTOS","DAI","COSTO TOTAL Q","UNITARIO Q");
        $widths = array(3,7,2,2,2,2,2,2,2,2);
        $pdf->SetWidths($widths);
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","R","R","R","R","R","R","R","R"));
    }    
}

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 27.1, $pdf->GetY());
$body = array(
    "",
    "             TOTALES DEL DOCUMENTO: ",
    ($subcant > 0) ? number_format($subcant,2) : "",
    "",
    ($subtfobq > 0) ? number_format($subtfobq,6) : "",
    ($subpord > 0) ? number_format($subpord,6) : "",
    ($subgastq > 0) ? number_format($subgastq,6) : "",
    ($subdai > 0) ? number_format($subdai,6) : "",
    ($subvtotal > 0) ? number_format($subvtotal,6) : "",
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 27.1, $pdf->GetY());
$pdf->ln();

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 27.1, $pdf->GetY());
$body = array(
    "",
    "             TOTALES GENERAL: ",
    ($totcant > 0) ? number_format($totcant,2) : "",
    "",
    ($tottfobq > 0) ? number_format($tottfobq,6) : "",
    "",
    ($totgastq > 0) ? number_format($totgastq,6) : "",
    ($totdai > 0) ? number_format($totdai,6) : "",
    ($totvtotal > 0) ? number_format($totvtotal,6) : "",
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 27.1, $pdf->GetY());

$pdf->Output(utf8_decode("Reporte Prorrateos" ).".pdf","I");

$db->close();

?>