<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selUsu=$_GET["selUsu"];
$Usunom=$_GET["Usunom"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

# QUERYS
$sDoctoss = "SELECT ds.*, TRIM(ds.ds_clinom) AS ds_clinom, TRIM(td.td_nom) AS td_nom, 
       TRIM(bod.bod_nom) AS bod_nom, fact_idinterno 
       FROM doctoss ds  
       LEFT JOIN tipodoci td ON  ds.ds_tipo=td.td_cod 
       LEFT JOIN bodegas bod ON  ds.ds_bodsal=bod.bod_cod 
       LEFT JOIN facturas fac ON  ds.ds_emp=fac.fact_emp and ds.ds_num=fac.fact_num and ds.ds_fec=fac.fact_fec 
       WHERE ds_emp='$empCod' and ds_ulcam='$Usunom' and ds_fec>='$dtFeci' and ds_fec<='$dtFecf' GROUP BY ds_emp,ds_tipo,ds_num ORDER BY ds_fec,ds_tipo,ds_num";
$sDoctose = "SELECT *, TRIM(bode.bod_nom) AS bode_nom, TRIM(td.td_nom) AS td_nom, 
       TRIM(bod.bod_nom) AS bod_nom
       FROM doctose de  
       LEFT JOIN tipodoci td ON  de.de_tipo=td.td_cod 
       LEFT JOIN bodegas bod ON  de.de_bodsal=bod.bod_cod 
       LEFT JOIN bodegas bode ON  de.de_bodent=bode.bod_cod 
       WHERE de_emp='$empCod' and de_ulcam='$Usunom' and de_fec>='$dtFeci' and de_fec<='$dtFecf' and de_bodsal!='' GROUP BY de_emp,de_tipo,de_num ORDER BY de_fec,de_tipo,de_num";
# EJECUCION DE QUERYS
$db = new dbExec();
$select["doctoss"] = $db->query($sDoctoss);
$select["doctose"] = $db->query($sDoctose);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['salidas']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['salidas'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "REPORTE DE SALIDAS DEL: ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf)))
            ->setCellValueByColumnAndRow($i, 3, "USUARIO: ".$Usunom);

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}
$j=5;
$i=$iIni;
$objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($i++, $j, 'TIPO DOCUMENTO')
            ->setCellValueByColumnAndRow($i++, $j, 'ID')
            ->setCellValueByColumnAndRow($i++, $j, 'NUMERO')
            ->setCellValueByColumnAndRow($i++, $j, 'FECHA')
            ->setCellValueByColumnAndRow($i++, $j, 'BODEGA SALIO')
            ->setCellValueByColumnAndRow($i++, $j, 'CLIENTE')
            ->setCellValueByColumnAndRow($i++, $j, 'VALOR');
$objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styEncabezado); 

$objPHPExcel->getActiveSheet()->mergeCells('A1:G1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:G2')->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A3:G3')->getStyle('A3')->applyFromArray($styEmp);
//$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($styEncabezado);

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$j=6;
$inidoc=6;
$iniprov=6;
while ($rec = $db->fetchAssoc($select["doctoss"])) {
    $tottot += $rec["ds_total"];
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["td_nom"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["fact_idinterno"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["ds_num"])
                ->setCellValueByColumnAndRow($i++, $j, strftime("%d/%m/%Y", strtotime($rec["ds_fec"])))
                ->setCellValueByColumnAndRow($i++, $j, $rec["bod_nom"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["ds_clinom"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["ds_total"]);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styLineas);
    $j+=1;
}
while ($rece = $db->fetchAssoc($select["doctose"])) {
    $tottot += $rece["de_total"];
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, trim($rece["td_nom"]))
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, $rece["de_num"])
                ->setCellValueByColumnAndRow($i++, $j, strftime("%d/%m/%Y", strtotime($rece["de_fec"])))
                ->setCellValueByColumnAndRow($i++, $j, $rece["bod_nom"])
                ->setCellValueByColumnAndRow($i++, $j, "Bodega Entro: ".$rece["bode_nom"])
                ->setCellValueByColumnAndRow($i++, $j, $rece["de_total"]);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styLineas);
    $j+=1;
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL GENERAL")
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(G6:G'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('G'.$j.':G'.$j)->applyFromArray($styEncabezado); 
$j+=2;
$i=$iIni;

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(17);

$objPHPExcel->getActiveSheet()->getStyle('G6'.':G'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':F'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['salidas'])->setTitle('Salidas');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ReporteSaludosUsu.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>