<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selUsu=$_GET["selUsu"];
$Usunom=$_GET["Usunom"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $selUsu, $Usunom;
        $this->SetMargins(.9, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("REPORTE DE DOCUMENTOS DE SALIDA DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("USUARIO: ".$Usunom),0,1,"L");
        $this->Ln();
        $this->SetFont("","",8);   
        $header = array("TIPO DOCUMENTO","ID","NUMERO","FECHA","BODEGA SALIO","CLIENTE","VALOR");
        $this->SetWidths(array(3.3,1.7,2.2,1.8,3.5,5,2.5));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetAligns(array("L","L","L","C","C","L","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sDoctoss = "SELECT ds.*, TRIM(ds.ds_clinom) AS ds_clinom, TRIM(td.td_nom) AS td_nom, 
       TRIM(bod.bod_nom) AS bod_nom, fact_idinterno 
       FROM doctoss ds  
       LEFT JOIN tipodoci td ON  ds.ds_tipo=td.td_cod 
       LEFT JOIN bodegas bod ON  ds.ds_bodsal=bod.bod_cod 
       LEFT JOIN facturas fac ON  ds.ds_emp=fac.fact_emp and ds.ds_num=fac.fact_num and ds.ds_fec=fac.fact_fec 
       WHERE ds_emp='$empCod' and ds_ulcam='$Usunom' and ds_fec>='$dtFeci' and ds_fec<='$dtFecf' GROUP BY ds_emp,ds_tipo,ds_num ORDER BY ds_fec,ds_tipo,ds_num";
$sDoctose = "SELECT *, TRIM(bode.bod_nom) AS bode_nom, TRIM(td.td_nom) AS td_nom, 
       TRIM(bod.bod_nom) AS bod_nom
       FROM doctose de  
       LEFT JOIN tipodoci td ON  de.de_tipo=td.td_cod 
       LEFT JOIN bodegas bod ON  de.de_bodsal=bod.bod_cod 
       LEFT JOIN bodegas bode ON  de.de_bodent=bode.bod_cod 
       WHERE de_emp='$empCod' and de_ulcam='$Usunom' and de_fec>='$dtFeci' and de_fec<='$dtFecf' and de_bodsal!='' GROUP BY de_emp,de_tipo,de_num ORDER BY de_fec,de_tipo,de_num";

# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["doctoss"] = $db->query($sDoctoss);
$select["doctose"] = $db->query($sDoctose);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "letter");
$pdf->AddPage();
$func = new functions();

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$subcant=0;
$totcant=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["doctoss"])) {
    $tottot += $rec["ds_total"];
    $body = array(
        $rec["td_nom"],
        $rec["fact_idinterno"],
        $rec["ds_num"],
        strftime("%d/%m/%Y", strtotime($rec["ds_fec"])),
        $rec["bod_nom"],
        $rec["ds_clinom"],
        ($rec["ds_total"] > 0) ? number_format($rec["ds_total"],2) : "",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
}
while ($rece = $db->fetchAssoc($select["doctose"])) {
    $tottot += $rece["de_total"];
    $body = array(
        $rece["td_nom"],
        "",
        $rece["de_num"],
        strftime("%d/%m/%Y", strtotime($rece["de_fec"])),
        $rece["bod_nom"],
        "Bodega Entro: ".$rece["bode_nom"],
        ($rece["de_total"] > 0) ? number_format($rece["de_total"],2) : "",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.9, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL GENERAL",0,0,"L");
$body = array(
    "",
    "",
    "",
    "",
    "",
    "",
    number_format($tottot, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.9, $pdf->GetY());

$pdf->Output(utf8_decode("Salidas Segun Usuario" ).".pdf","I");

$db->close();

?>