<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selDepto=$_GET["selDepto"];
$selsubDepto=$_GET["selSubDepto"];
$selBodega=$_GET["selBodega"];
$BodegaNom=$_GET["BodegaNom"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$lineWidth=38;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $BodegaNom;
        $this->SetMargins(1.5, 1, 1);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",14);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Resumen de entradas y salidas del ".strftime("%d/%m/%Y", strtotime($dtFeci))." al ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        //$this->Ln();
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Bodega ".$BodegaNom),0,1,"L");
        $this->SetFont("","",8);
        $header = array("Codigo","Descripcion","Medida","Existencia Inicial","Compras","Otras Entradas","Ventas","Otras Salidas","Existencia Final","Costo Total");
        $this->SetFont("","B");
        $this->SetWidths(array(3,6,1.8,2,2,2,2,2,2,2.7));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("");
        $this->SetAligns(array("L","L","C","R","R","R","R","R","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selDepto=='0000') {
    if ($selsubDepto=='0000') {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    WHERE art_emp='$empCod' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    } else {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    WHERE art_emp='$empCod' AND art_subdep='$selsubDepto' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    }
} else {
    if ($selsubDepto=='0000') {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    } else {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_subdep='$selsubDepto' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    }
}

function sExiart($codd) { 
    global $empCod, $usuNom, $selBodega;
    return "SELECT * FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$selBodega'";
}

function sExiartTodas($codd) { 
    global $empCod, $usuNom, $selBodega;
    return "SELECT *, SUM(ea_exist) AS ea_existtot FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$codd' GROUP BY '$empCod','$codd'";
}

function sMoviie0($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$selBodega' AND mov_fec>='$dtFeci' GROUP BY '$empCod','$codd'";
}
function sMoviis0($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$selBodega' AND mov_fec>='$dtFeci' GROUP BY '$empCod','$codd'";
}

function sMoviie0Todas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>='$dtFeci' GROUP BY '$empCod','$codd'";
}
function sMoviis0Todas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>='$dtFeci' GROUP BY '$empCod','$codd'";
}

function sCierrei($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFecf ;
    return "SELECT * FROM cierresi WHERE ci_emp='$empCod' AND ci_cod='$codd' AND ci_fec='$dtFecf'";
}

function sCierreiTodas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFecf;
    return "SELECT * FROM cierresi WHERE ci_emp='$empCod' AND ci_cod='$codd' AND ci_fec='$dtFecf'";
}

function sMoviie0c($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_afecos,td_inveini, 
            SUM(mov_entra) AS mov_sentra
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND td_afecos='S' AND td_inveini='N' GROUP BY '$empCod','$codd'";
}
function sMoviie0cTodas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_afecos,td_inveini,
            SUM(mov_entra) AS mov_sentra
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND td_afecos='S' AND td_inveini='N' GROUP BY '$empCod','$codd'";
}
function sMoviie0o($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_afecos,td_inveini,
            SUM(mov_entra) AS mov_sentra
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND (td_afecos!='S' OR td_inveini='S' OR td_inveini='P')  GROUP BY '$empCod','$codd'";
}
function sMoviie0oTodas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_afecos,td_inveini,
            SUM(mov_entra) AS mov_sentra
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND (td_afecos!='S' OR td_inveini='S' OR td_inveini='P') GROUP BY '$empCod','$codd'";
}

function sMoviis0v($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_repven,
            SUM(mov_sale) AS mov_ssale
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND td_repven='S' GROUP BY '$empCod','$codd'";
}
function sMoviis0vTodas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_repven,
            SUM(mov_sale) AS mov_ssale
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND td_repven='S' GROUP BY '$empCod','$codd'";
}
function sMoviis0o($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_repven,
            SUM(mov_sale) AS mov_ssale
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND td_repven!='S' GROUP BY '$empCod','$codd'";
}
function sMoviis0oTodas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,td_repven,
            SUM(mov_sale) AS mov_ssale
            FROM movii LEFT JOIN tipodoci ON movii.mov_tipo=tipodoci.td_cod WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' AND td_repven!='S' GROUP BY '$empCod','$codd'";
}


# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["artic"] = $db->query($sArtic);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Letter");
$pdf->AddPage();
$ti_Depto="XXXX";
$ti_sDepto="XXXX";
$sumcos=0;
while ($rec = $db->fetchAssoc($select["artic"])) {
    if ($ti_Depto.$ti_sDepto!=$rec["art_dep"].$rec["art_subdep"]) {
       $pdf->SetFont("","B");
       $pdf->Cell($lineWidth,.7,trim($rec["dep_nom"]).", ".rtrim($rec["sdep_nom"]),0,0,"L");
       $ti_Depto=$rec["art_dep"];
       $ti_sDepto=$rec["art_subdep"];
       $pdf->SetFont("","");
       $pdf->ln();
    }
    $codd=$rec["art_cod"];
    $cosp=$rec["art_cosp"];

    if ($selBodega=='0000') {
        $select["exiart"] = $db->query(sExiartTodas($codd));
        $fetchAssoc["exiart"] = $db->fetchAssoc($select["exiart"]);
        $Exist = $fetchAssoc["exiart"]["ea_existtot"];

        $select["cierresi"] = $db->query(sCierreiTodas($codd));
        $fetchAssoc["cierresi"] = $db->fetchAssoc($select["cierresi"]);
        if ($db->numRows($select["cierresi"]) > 0) {
            $cosp = $fetchAssoc["cierresi"]["ci_cosp"];
        }
        $select["movii"] = $db->query(sMoviie0Todas($codd));
        $recme0 = $db->fetchAssoc($select['movii']);
        $sEntramov=$recme0["mov_sentra"];

        $select["movii"] = $db->query(sMoviis0Todas($codd));
        $recms0 = $db->fetchAssoc($select['movii']);
        $sSalemov=$recms0["mov_ssale"];

        $Exiini=($Exist-$sEntramov)+$sSalemov;

        $select["movii"] = $db->query(sMoviie0cTodas($codd));
        $recme0c = $db->fetchAssoc($select['movii']);
        $sEntramovcom=$recme0c["mov_sentra"];

        $select["movii"] = $db->query(sMoviie0oTodas($codd));
        $recme0o = $db->fetchAssoc($select['movii']);
        $sEntramovotr=$recme0o["mov_sentra"];

        $select["movii"] = $db->query(sMoviis0vTodas($codd));
        $recms0v = $db->fetchAssoc($select['movii']);
        $sSalemovven=$recms0v["mov_ssale"];

        $select["movii"] = $db->query(sMoviis0oTodas($codd));
        $recms0o = $db->fetchAssoc($select['movii']);
        $sSalemovotr=$recms0o["mov_ssale"];

    } else {
        $select["exiart"] = $db->query(sExiart($codd));
        $fetchAssoc["exiart"] = $db->fetchAssoc($select["exiart"]);
        $Exist = $fetchAssoc["exiart"]["ea_exist"];

        $select["cierresi"] = $db->query(sCierrei($codd));
        $fetchAssoc["cierresi"] = $db->fetchAssoc($select["cierresi"]);
        if ($db->numRows($select["cierresi"]) > 0) {
            $cosp = $fetchAssoc["cierresi"]["ci_cosp"];
        }
        $select["movii"] = $db->query(sMoviie0($codd));
        $recme0 = $db->fetchAssoc($select['movii']);
        $sEntramov=$recme0["mov_sentra"];

        $select["movii"] = $db->query(sMoviis0($codd));
        $recms0 = $db->fetchAssoc($select['movii']);
        $sSalemov=$recms0["mov_ssale"];

        $Exiini=($Exist-$sEntramov)+$sSalemov;

        $select["movii"] = $db->query(sMoviie0c($codd));
        $recme0c = $db->fetchAssoc($select['movii']);
        $sEntramovcom=$recme0c["mov_sentra"];

        $select["movii"] = $db->query(sMoviie0o($codd));
        $recme0o = $db->fetchAssoc($select['movii']);
        $sEntramovotr=$recme0o["mov_sentra"];

        $select["movii"] = $db->query(sMoviis0v($codd));
        $recms0v = $db->fetchAssoc($select['movii']);
        $sSalemovven=$recms0v["mov_ssale"];

        $select["movii"] = $db->query(sMoviis0o($codd));
        $recms0o = $db->fetchAssoc($select['movii']);
        $sSalemovotr=$recms0o["mov_ssale"];

    }
    $Exifin=$Exiini+($sEntramovcom+$sEntramovotr)-($sSalemovven+$sSalemovotr);

    if ($Exiini==0 && $sEntramovcom==0 && $sEntramovotr==0 && $sSalemovven==0 && $sSalemovotr==0) {
        continue;
    }
    $costot=round($Exifin*$cosp,5);
    $sumcos+=$costot;
    $body = array(
        $rec["art_cod"],
        trim($rec["art_desc"]),
        trim($rec["um_nom"]),
        number_format($Exiini, 2, '.', ','),
        number_format($sEntramovcom, 2, '.', ','),
        number_format($sEntramovotr, 2, '.', ','),
        number_format($sSalemovven, 2, '.', ','),
        number_format($sSalemovotr, 2, '.', ','),
        number_format($Exifin, 2, '.', ','),
        number_format($costot, 5, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX()+18, $pdf->GetY(), 27, $pdf->GetY());

$pdf->SetAligns(array("","","C","R","R","R","R","R","R","R"));
$body = array("","","","","","","","Total: ","",
    number_format($sumcos,5, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+18, $pdf->GetY(), 27, $pdf->GetY());
$pdf->line($pdf->GetX()+18, $pdf->GetY()+.075, 27, $pdf->GetY()+.075);

$db->close();
$pdf->Output(utf8_decode("ResumenMovi").".pdf","I");
?>