<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

# QUERYS
$sFact_det = "SELECT *, TRIM(fac.fact_nit) AS fact_nit, TRIM(fac.fact_nom) AS fact_nom, TRIM(fd.factd_desc) AS factd_desc
   FROM fact_det fd LEFT JOIN facturas fac ON fd.factd_emp=fac.fact_emp AND fd.factd_tipo=fac.fact_tipo AND fd.factd_serie=fac.fact_serie AND fd.factd_num=fac.fact_num LEFT JOIN tipov tv ON fd.factd_tipo=tv.tv_cod
   WHERE factd_emp='$empCod' and factd_fec>='$dtFeci' and factd_fec<='$dtFecf' and tv_librosn='S' AND fact_tot!=0 AND factd_bienser!='S' ORDER BY factd_fec,factd_tipo,factd_serie,factd_num";
# EJECUCION DE QUERYS
$db = new dbExec();
$select["fact_det"] = $db->query($sFact_det);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['comparativoven']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['comparativoven'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "COMPARATIVO VENTAS DEL  ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf)));

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->mergeCells('A1:D1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:D2')->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A3:D3')->getStyle('A3')->applyFromArray($styEmp);
//$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($styEncabezado);

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$j=6;
$inidoc=6;
$iniprov=6;
while ($rec = $db->fetchAssoc($select["fact_det"])) {
    if ($t_lini == 1) {
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, "SERIE: ".$rec["factd_serie"]."         NUMERO:  ".$rec["factd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["factd_fec"])));
        $j+=1;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_decode("NOMBRE:  ".trim($rec["fact_nom"])));
        $j+=1;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_decode("NIT:  ".trim($rec["fact_nit"])));
        $j+=1;

        $i=$iIni;
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
                    ->setCellValueByColumnAndRow($i++, $j, 'DESCRIPCION')
                    ->setCellValueByColumnAndRow($i++, $j, 'CANTIDAD')
                    ->setCellValueByColumnAndRow($i++, $j, 'COSTO TOTAL')
                    ->setCellValueByColumnAndRow($i++, $j, 'PRECIO TOTAL')
                    ->setCellValueByColumnAndRow($i++, $j, 'GANANCIA')
                    ->setCellValueByColumnAndRow($i++, $j, '  %');
        $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styEncabezado); 
        $j+=1;
        $inidoc=6;
    }
    if ($ti_tipo!=$rec["factd_serie"]  || $ti_num!=$rec["factd_num"]) {
        if ($t_lini > 1) {
            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE DOCUMENTO")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidoc.':D'.($j-1).')')
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidoc.':E'.($j-1).')')
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidoc.':F'.($j-1).')')
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$j.'*100/E'.$j.')');
            $objPHPExcel->getActiveSheet()->getStyle('D'.$j.':G'.$j)->applyFromArray($styEncabezado); 
            $j+=2;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, "SERIE: ".$rec["factd_serie"]."         NUMERO:  ".$rec["factd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["factd_fec"])));
            $j+=1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, utf8_decode("NOMBRE:  ".trim($rec["fact_nom"])));
            $j+=1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, utf8_decode("NIT:  ".trim($rec["fact_nit"])));
            $j+=1;

            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
                        ->setCellValueByColumnAndRow($i++, $j, 'DESCRIPCION')
                        ->setCellValueByColumnAndRow($i++, $j, 'CANTIDAD')
                        ->setCellValueByColumnAndRow($i++, $j, 'COSTO TOTAL')
                        ->setCellValueByColumnAndRow($i++, $j, 'PRECIO TOTAL')
                        ->setCellValueByColumnAndRow($i++, $j, 'GANANCIA')
                        ->setCellValueByColumnAndRow($i++, $j, '  %');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styEncabezado); 
            $j+=1;
            $inidoc=$j;
        }             
        $subtot=0;
        $ti_tipo=$rec["factd_serie"];
        $ti_num=$rec["factd_num"];
        $t_lini=2;
    } 

    $costot = ($rec["factd_cosu"]*$rec["factd_cant"]);
    $ganancia = ($rec["factd_tot"]-$costot);
    if ($ganancia!=0 && $rec["factd_tot"]!=0) {
      $porgan = ($ganancia*100/$rec["factd_tot"]);
    } else {
      $porgan=0;
    }   
 
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["factd_cod"]))
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["factd_desc"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["factd_cant"])
                ->setCellValueByColumnAndRow($i++, $j, $costot)
                ->setCellValueByColumnAndRow($i++, $j, $rec["factd_tot"])
                ->setCellValueByColumnAndRow($i++, $j, $ganancia)
                ->setCellValueByColumnAndRow($i++, $j, $porgan);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styLineas);
    $j+=1;
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE DOCUMENTO")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidoc.':D'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidoc.':E'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidoc.':F'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$j.'*100/E'.$j.')');
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':G'.$j)->applyFromArray($styEncabezado); 
$j+=2;
$i=$iIni;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL GENERAL") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    TOTAL ESTE DOCUMENTO",D6:D'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    TOTAL ESTE DOCUMENTO",E6:E'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    TOTAL ESTE DOCUMENTO",F6:F'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$j.'*100/E'.$j.')');
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':G'.$j)->applyFromArray($styEncabezado);


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(8);

$objPHPExcel->getActiveSheet()->getStyle('C6'.':C'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('D6'.':D'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00000');
$objPHPExcel->getActiveSheet()->getStyle('E6'.':E'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00000');
$objPHPExcel->getActiveSheet()->getStyle('F6'.':F'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00000');
$objPHPExcel->getActiveSheet()->getStyle('G6'.':G'.$j)->getNumberFormat()->setFormatCode('#,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':B'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['comparativoven'])->setTitle('ComparativoVen');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ComparativoVentas.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>