<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

$lineWidth=17;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf;
        $this->SetMargins(2, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, .4, utf8_decode("Articulos sin movimiento del  ".strftime("%d/%m/%Y", strtotime($dtFeci))." al ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        //$this->Ln();
        $this->SetFont("","",9);
        $header = array("Codigo","Descripcion","Medida");
        $this->SetFont("","B");
        $this->SetWidths(array(3,9,2.5));
        $this->SetAligns(array("C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("");
        $this->SetAligns(array("L","L","C"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
            TRIM(art_desc) AS art_desc,
            TRIM(art_desd) AS art_desd,
            TRIM(art_marca) AS art_marca,
            TRIM(art_prov) AS art_prov,
            TRIM(art_codf) AS art_codf,
            TRIM(art_codbarr) AS art_codbarr
            FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
            LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
            LEFT JOIN unimed um ON art.art_medi=um.um_cod
            WHERE art_emp='$empCod' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";

function sMovii0($codd) { 
    global $empCod, $usuNom, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra, SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf' GROUP BY '$empCod','$codd'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["artic"] = $db->query($sArtic);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$ti_Depto="XXXX";
$ti_sDepto="XXXX";
while ($rec = $db->fetchAssoc($select["artic"])) {
    $codd=$rec["art_cod"];
   
    $select["movii"] = $db->query(sMovii0($codd));
    $fetchAssoc["movii"] = $db->fetchAssoc($select["movii"]);
    if ($db->numRows($select["movii"]) > 0) {
        continue;
    }

    if ($ti_Depto.$ti_sDepto!=$rec["art_dep"].$rec["art_subdep"]) {
       $pdf->SetFont("","B");
       $pdf->Cell($lineWidth,.7,trim($rec["dep_nom"]).", ".rtrim($rec["sdep_nom"]),0,0,"L");
       $ti_Depto=$rec["art_dep"];
       $ti_sDepto=$rec["art_subdep"];
       $pdf->ln();
       $pdf->SetFont("","");
    }
    $codd=$rec["art_cod"];
   
    $body = array(
        $rec["art_cod"],
        trim($rec["art_desc"]),
        trim($rec["um_nom"]),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$db->close();
$pdf->Output(utf8_decode("SinMovi").".pdf","I");
?>