<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selBodega=$_GET["selBodega"];
$BodegaNom=$_GET["BodegaNom"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$lineWidth=38;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $BodegaNom;
        $this->SetMargins(1.5, 1, 1);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",14);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"C");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Reporte de Movimientos Segun Cliente".strftime("%d/%m/%Y", strtotime($dtFeci))." al ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        //$this->Ln();
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Bodega ".$BodegaNom),0,1,"L");
        $this->SetFont("","",8);
        $header = array("Nit","Cliente","Valor");
        $this->SetFont("","B");
        $this->SetWidths(array(3,8,3));
        $this->SetAligns(array("C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("");
        $this->SetAligns(array("L","L","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selBodega=='0000') {
    $sArtic = "SELECT fd.*, TRIM(fac.fact_nom) AS fact_nom, TRIM(cli.cli_nom) AS cli_nom, 
                SUM(factd_cant) AS factd_scant, SUM(factd_tot) AS factd_stot,
                TRIM(fd.factd_desc) AS art_desc,
                TRIM(fd.factd_nit) AS factd_nit
                FROM fact_det fd 
                LEFT JOIN facturas fac ON fd.factd_emp=fac.fact_emp AND fd.factd_transac=fac.fact_transac
                LEFT JOIN clien cli ON fd.factd_nit=cli.cli_nit 
                WHERE factd_emp='$empCod' AND factd_nit!='CF' AND factd_fec>='$dtFeci' AND factd_fec<='$dtFecf' 
                GROUP BY factd_emp,factd_nit
                ORDER BY factd_emp,SUM(factd_tot) DESC";
} else {
    $sArtic = "SELECT fd.*, TRIM(fac.fact_nom) AS fact_nom, TRIM(cli.cli_nom) AS cli_nom, 
                SUM(factd_cant) AS factd_scant, SUM(factd_tot) AS factd_stot,
                TRIM(fd.factd_desc) AS art_desc,
                TRIM(fd.factd_nit) AS factd_nit
                FROM fact_det fd 
                LEFT JOIN facturas fac ON fd.factd_emp=fac.fact_emp AND fd.factd_transac=fac.fact_transac
                LEFT JOIN clien cli ON fd.factd_nit=cli.cli_nit 
                WHERE factd_emp='$empCod' AND factd_nit!='CF' AND factd_fec>='$dtFeci' AND factd_fec<='$dtFecf' AND factd_bodsal='$selBodega' 
                GROUP BY factd_emp,factd_nit
                ORDER BY factd_emp,SUM(factd_tot) DESC";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["fact_det"] = $db->query($sArtic);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Letter");
$pdf->AddPage();
$ti_Depto="XXXX";
$ti_sDepto="XXXX";
$sumcos=0;
while ($rec = $db->fetchAssoc($select["fact_det"])) {
    if ($rec["factd_stot"]<=0) {
        continue;
    }
    $body = array(
        $rec["factd_nit"],
        trim($rec["cli_nom"]),
        number_format($rec["factd_stot"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 18, $pdf->GetY());


$db->close();
$pdf->Output(utf8_decode("ReporteCant").".pdf","I");
?>