<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selDepto=$_GET["selDepto"];
$selsubDepto=$_GET["selSubDepto"];

$lineWidth=17;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec;
        $this->SetMargins(2, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Articulos al ".strftime("%d/%m/%Y")),0,1,"L");

        $this->Ln();
        $this->SetFont("","",7);
        $header = array("Codigo","Descripcion","Medida","Marca","Generico","Bloqueado");
        $this->SetFont("","B");
        $this->SetWidths(array(2.5,8.5,2.5,2.5,5.5,2));
        $this->SetAligns(array("C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","L","L","C"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selDepto=='0000') {
    if ($selsubDepto=='0000') {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN provcp pcp ON art.art_emp=pcp.pro_emp AND art.art_prov=pcp.pro_cod 
                    WHERE art_emp='$empCod' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    } else {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN provcp pcp ON art.art_emp=pcp.pro_emp AND art.art_prov=pcp.pro_cod 
                    WHERE art_emp='$empCod' AND art_subdep='$selsubDepto' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    }
} else {
    if ($selsubDepto=='0000') {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN provcp pcp ON art.art_emp=pcp.pro_emp AND art.art_prov=pcp.pro_cod 
                    WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    } else {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN provcp pcp ON art.art_emp=pcp.pro_emp AND art.art_prov=pcp.pro_cod 
                    WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_subdep='$selsubDepto' AND art_bienser='B' ORDER BY art_emp,art_dep,art_subdep,art_desc";
    }
}
# EJECUCION DE QUERYS
$db = new dbExec();
$select["artic"] = $db->query($sArtic);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Letter");
$pdf->AddPage();
$ti_Depto="XXXX";
$ti_sDepto="XXXX";
while ($rec = $db->fetchAssoc($select["artic"])) {
    if ($ti_Depto.$ti_sDepto!=$rec["art_dep"].$rec["art_subdep"]) {
       $pdf->Cell($lineWidth,.7,utf8_decode(trim($rec["dep_nom"])).", ".utf8_decode(rtrim($rec["sdep_nom"])),0,0,"L");
       $ti_Depto=$rec["art_dep"];
       $ti_sDepto=$rec["art_subdep"];
       $pdf->ln();
    }
    if ($rec["art_bloqueado"] == 1) {
       $txtblo='Si';
    } else {
       $txtblo='';
    }   
    $body = array(
        $rec["art_cod"],
        utf8_decode(trim($rec["art_desc"])),
        trim($rec["um_nom"]),
        trim($rec["art_marca"]),
        trim($rec["art_prov"]),
        trim($txtblo),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Articulos").".pdf","I");
?>