<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sSubFamii = "SELECT *, TRIM(sdep_dep) AS sdep_dep, TRIM(sdep_cod) AS sdep_cod, TRIM(sdep_nom) AS sdep_nom 
                FROM subdeptosi sdi LEFT JOIN deptosi di ON sdi.sdep_dep=di.dep_cod ORDER BY sdep_dep,sdep_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["subdeptosi"] = $db->query($sSubFamii);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",12);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.5;

$pdf->SetFont("","",9);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Sub-Familias en Inventario"));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight*2);

$header = array("Familia","Codigo","Nombre de la Sub-Familia");
$pdf->SetFont("","B");
$pdf->SetWidths(array(6,3,8));
$pdf->SetAligns(array("C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","L"));

while ($rec = $db->fetchAssoc($select["subdeptosi"])) {
    $body = array(
        trim($rec["dep_nom"]),
        $rec["sdep_cod"],
        trim($rec["sdep_nom"]),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Listado de Sub-Familias Inventario").".pdf","I");
?>