<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "iva2010";
$bitMod = "iva";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarClien':
		echo consultarClien();
		break;

	case 'consultarCiemes':
		echo consultarCiemes();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	global $empCod, $usuNom;

	$tipoPol='010';

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$selTipoCod=$_POST['selTipoCod'];
	$txtSerie=$_POST['txtSerie'];
	$numNum=$_POST['numNum'];

	# QUERYS
	$sIva_ven = "SELECT
					i.*,
					c.ciem_stat 
				  FROM iva_ven i 
				  LEFT JOIN ciemes c ON c.ciem_mes=MONTH(i.ivav_fec) AND c.ciem_ano=YEAR(i.ivav_fec) AND c.ciem_emp='$empCod'
				  WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum' AND ivav_tipo='$selTipoCod'";

	$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_tipoi='$txtSerie' AND pold_num='$numNum'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sIva_ven, "iva_ven");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "iva_ven");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarClien() {
	global $empCod;
	$txtNit=utf8_decode($_POST['txtNit']);

	# QUERYS
	$sClien = "SELECT *, TRIM(cli_nom) AS cli_nom FROM clien WHERE cli_nit='$txtNit'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClien, "clien");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "clien");
}

function consultarCiemes() {
	global $empCod;

	$func = new functions();
	$numAno=$_POST["numAno"];
	$selMesCod=$_POST["selMesCod"];

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$selMesCod";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCiemes, "ciemes");
	$db->close();

	return json_encode($resp);
}

function generarPartida() {
	global $empCod;
	$numIva=$_POST['numIva'];
	$deduTot=$_POST['deduTot'];
	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numVen=$_POST['numVen'];
	$numServ=$_POST['numServ'];
	$numExport=$_POST['numExport'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaIva"] = ($numIva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaiv"]));
	$resp["ctaComb"] = ($deduTot==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacomb"]));
	$resp["ctaRet"] = ($numRet==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtarisr"]));
	$resp["ctaReti"] = ($numReti==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtariva"]));
	$resp["ctaVen"] = ($numVen==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaven"]));
	$resp["ctaServ"] = ($numServ==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaserv"]));
	$resp["ctaExport"] = ($numExport==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaexport"]));
	$resp["ctaCaj"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacaj"]));
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'ctaIva');
}

function guardar() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm;

	$func = new functions();

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv']) && !$func->stringToBool($_POST['nuevo'])) {
		return json_encode($priv->rErrorModify());
	}

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$numNumf=$_POST['numNumf'];
	$crVenRango=$_POST['crVenRango'];
	$txtNit=utf8_decode($_POST['txtNit']);
	$selTipoCod=$_POST['selTipoCod'];
	$txtClin=utf8_decode($_POST['txtClin']);
	$dtFec=$_POST['dtFec'];
	$numAno=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));

	$fecAnt=$_POST['fecAnt'];
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	$crRet=$_POST['crRet'];
	$crReti=$_POST['crReti'];
	$crAfe=$_POST['crAfe'];

	$numBien=(empty($_POST['numBien'])) ? 0 : $_POST['numBien'];
	$numServ=(empty($_POST['numServ'])) ? 0 : $_POST['numServ'];
	$numExen=(empty($_POST['numExen'])) ? 0 : $_POST['numExen'];
	$numExp=(empty($_POST['numExp'])) ? 0 : $_POST['numExp'];
	$numExpre=(empty($_POST['numExpre'])) ? 0 : $_POST['numExpre'];
	$numMedi=(empty($_POST['numMedi'])) ? 0 : $_POST['numMedi'];
	$numNoafe=(empty($_POST['numNoafe'])) ? 0 : $_POST['numNoafe'];
	$numVehi=(empty($_POST['numVehi'])) ? 0 : $_POST['numVehi'];
	$numVehia=(empty($_POST['numVehia'])) ? 0 : $_POST['numVehia'];
	$crTvehi=(empty($_POST['crTvehi'])) ? "0" : $_POST['crTvehi'];
	$numTfaco=(empty($_POST['numTfaco'])) ? 0 : $_POST['numTfaco'];
	$numGalos=(empty($_POST['numGalos'])) ? 0 : $_POST['numGalos'];
	$numGalor=(empty($_POST['numGalor'])) ? 0 : $_POST['numGalor'];
	$numGalod=(empty($_POST['numGalod'])) ? 0 : $_POST['numGalod'];
	$numComb=(empty($_POST['numComb'])) ? 0 : $_POST['numComb'];
	$txtCon=utf8_decode($_POST['txtCon']);

	$subb=$_POST['subb'];
	$subs=$_POST['subs'];
	$subco=$_POST['subco'];
	$subve=$_POST['subve'];
	$sube=$_POST['sube'];
	$suber=$_POST['suber'];
	$subna=$_POST['subna'];
	$subme=$_POST['subme'];

	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numSub=$_POST['numSub'];
	$numIva=$_POST['numIva'];
	$numTot=$_POST['numTot'];
	$deduTot=$_POST['deduTot'];

	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol='010';
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	# QUERYS PARA UN REGISTRO
	$iIva_ven = "INSERT INTO iva_ven (ivav_emp, ivav_serie, ivav_num, ivav_nit, ivav_tipo, ivav_clin, ivav_fec, ivav_retsn, ivav_retisn, ivav_afe, ivav_bien, ivav_serv, ivav_exen, ivav_exp, ivav_expre, ivav_medi, ivav_noafe, ivav_vehi, ivav_vehia, ivav_tvehi, ivav_tfaco, ivav_galos, ivav_galor, ivav_galod, ivav_comb, ivav_con, ivav_subb, ivav_subs, ivav_subco, ivav_subve, ivav_sube, ivav_suber, ivav_subna, ivav_subme, ivav_ret, ivav_reti, ivav_sub, ivav_iva, ivav_tot, ivav_dedu, ivav_ulcam, ivav_conso, ivav_numf, ivav_venrango) VALUES ('$empCod', '$txtSerie', '$numNum', '$txtNit', '$selTipoCod', '$txtClin', '$dtFec', '$crRet', '$crReti', '$crAfe', '$numBien', '$numServ', '$numExen', '$numExp', '$numExpre', '$numMedi', '$numNoafe', '$numVehi', '$numVehia', '$crTvehi', '$numTfaco', '$numGalos', '$numGalor', '$numGalod', '$numComb', '$txtCon', '$subb', '$subs', '$subco', '$subve', '$sube', '$suber', '$subna', '$subme', '$numRet', '$numReti', '$numSub', '$numIva', '$numTot', '$deduTot','$usuNom', '$empConso', '$numNumf', '$crVenRango')";

	$uIva_ven = "UPDATE iva_ven SET ivav_tipo='$selTipoCod', ivav_clin='$txtClin', ivav_fec='$dtFec', ivav_retsn='$crRet', ivav_retisn='$crReti', ivav_afe='$crAfe', ivav_bien='$numBien', ivav_serv='$numServ', ivav_exen='$numExen', ivav_exp='$numExp', ivav_expre='$numExpre', ivav_medi='$numMedi', ivav_noafe='$numNoafe', ivav_vehi='$numVehi', ivav_vehia='$numVehia', ivav_tvehi='$crTvehi', ivav_tfaco='$numTfaco', ivav_galos='$numGalos', ivav_galor='$numGalor', ivav_galod='$numGalod', ivav_comb='$numComb', ivav_con='$txtCon', ivav_subb='$subb', ivav_subs='$subs', ivav_subco='$subco', ivav_subve='$subve', ivav_sube='$sube', ivav_suber='$suber', ivav_subna='$subna', ivav_subme='$subme', ivav_ret='$numRet', ivav_reti='$numReti', ivav_sub='$numSub', ivav_iva='$numIva', ivav_tot='$numTot', ivav_dedu='$deduTot', ivav_ulcam='$usuNom', ivav_conso='$empConso', ivav_numf='$numNumf', ivav_venrango='$crVenRango' WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum'";

	$sPolizas = "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$tipoPol','$numNum','$txtSerie','$txtNit','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$iClien = "INSERT INTO clien(cli_nit, cli_nom) VALUES ('$txtNit','$txtClin')";

	$uClien = "UPDATE clien SET cli_nom='$txtClin' WHERE cli_nit='$txtNit'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$tipoPol','$numNum','$txtSerie','$txtNit','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	if ($func->stringToBool($_POST['nuevo'])) {
		$resp = $db->iEx($iIva_ven);
		$db->query($func->iBitacora(utf8_decode("Se creó venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));

		$db->query($iPolizas);
	} else {
		$resp = $db->uEx($uIva_ven);
		$db->query($func->iBitacora(utf8_decode("Se modificó venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));

		$select["polizas"] = $db->query($sPolizas);
		($db->numRows($select["polizas"]) > 0) ? $db->query($uPolizas) : $db->query($iPolizas);
	}
	($func->stringToBool($_POST['nuevoClien'])) ? $db->query($iClien) : $db->query($uClien);

	$db->dEx($dPoli_det);
	if (!$func->jsonEmpty($jsonPol)) {
		$db->iEx($iPoli_det);
	}

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}

	// PARA APLICAR LOS CIERRES
	foreach ($jsonPol as $obj) {
		$cta = $obj->cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
			if ($db->numRows($select["cierres"]) > 0) {
				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

				$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			} else {
				$mdebe=$obj->debe;
				$mhaber=$obj->haber;

				$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
	}
	$db->close();

	return json_encode($resp);
	//return $func->jsonEncodeArray($resp, "msg");
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];

	$fecAnt=$_POST['fecAnt'];
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol = "010";

	# QUERYS
	$dIva_ven = "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum'";

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp = $db->dEx($dIva_ven);
	$db->dEx($dPolizas);
	$db->dEx($dPoli_det);

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}


	$db->iEx($func->iBitacora(utf8_decode("Se borró venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	return json_encode($resp);
}
?>