<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sTipov = "SELECT * FROM tipov";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["tipov"] = $db->query($sTipov);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",17);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.5;

$pdf->SetFont("","",9);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Tipos de Documentos de Ventas "));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight*2);

$header = array("Codigo","Nombre del Tipo","Abreviatura","Impuesto","Tipo Valor","Afecta Libro","Pedir Serie");
$pdf->SetFont("","B");
$pdf->SetWidths(array(1.5,6,2,2,2,2,2));
$pdf->SetAligns(array("C","C","C","C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("","","","","","",""));

while ($rec = $db->fetchAssoc($select["tipov"])) {
    $body = array(
        $rec["tv_cod"],
        trim($rec["tv_nom"]),
        trim($rec["tv_abrev"]),
        trim($rec["tv_impues"]),
        trim($rec["tv_pone"]),
        trim($rec["tv_librosn"]),
        trim($rec["tv_seriesn"]),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Listado de Tipos de Ventas").".pdf","I");
?>