<?php
include_once('../../../php/db/dbExec.php');

# QUERYS
$sEmpresas = "SELECT * FROM empresas where emp_cod='zzz' ORDER BY emp_nom ASC";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["empresas"] = $db->query($sEmpresas);
$db->close();
?>
<!DOCTYPE html>
<!--
* CoreUI - Free Bootstrap Admin Template
* @version v2.1.10
* @link https://coreui.io
* Copyright (c) 2018 creativeLabs Łukasz Holeczek
* Licensed under MIT (https://coreui.io/license)
-->

<html lang="es">
  <?php include('../../../php/includes/headLocal.php'); ?>
  <body class="app flex-row align-items-center" style="background-image: url(img/login.jpg); background-size: cover;">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-8">
          <div class="card-group">
            <div class="card p-4">
              <div class="card-body">
                <form action="menu/" method="post" autocomplete="off" name="formLogin">
                  <h1>Iniciar Sesión</h1>
                  <p class="text-muted">Ingresa tu cuenta</p>
                  <div class="input-group mb-3">
                    <input class="form-control" name="txtUsuCod" type="text" placeholder="Usuario" id="txtUsuCod" value="" >
                  </div>
                  <div class="input-group mb-3">
                    <input class="form-control" name="txtUsuCla" type="password" placeholder="Contraseña" value="" >
                  </div>
                  <div class="input-group mb-4">
                    <select class="form-control round-circle" id="selectEmp" name="selEmpCod" value="">
<!--                      <option value="0">Seleccionar Empresa</option>
                      <?php
                        while ($rec = $db->fetchAssoc($select['empresas'])) {
                          echo  '<option value="'.$rec['emp_cod'].'">'.utf8_encode($rec['emp_nom']).'</option>';
                        }
                      ?>    --->
                    </select>
                  </div>

                  <div class="row">
                    <div class="col-12">
                      <button class="btn btn-success btn-block px-4" type="button" onclick="entrar();return false;">Entrar</button>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12 text-right">
                      <button class="btn btn-link text-success btn-block px-0" type="button">¿Olvidaste tu contraseña?</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div class="card text-white bg-dark py-5 d-md-down-none" style="width:44%">
              <div class="card-body text-center">
                <div>
                  <h2>Contacto</h2>
                  <p><a class="text-white" href="mailto:implementaciones@asesoriaensis.com" target="_blank">implementaciones@asesoriaensis.com</a></p>
                  <p><a class="text-white" href="tel:+50254015022" target="_blank">(502) 5401-5022</a></p>
                  <p><a class="text-white" href="tel:+50255625322" target="_blank">(502) 5562-5322</a></p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </body>
  <!-- alert y ajax -->
  <script type="text/javascript" src="../../js/alerts.js"></script>
  <script>
    const txtUsuCod = document.formLogin.txtUsuCod;

    var sel = document.formLogin.selectEmp;

    function entrar(){
      var parametros = {
        "txtUsuCod" : document.formLogin.txtUsuCod.value,
        "txtUsuCla" : document.formLogin.txtUsuCla.value,
        "selEmpCod" : document.formLogin.selEmpCod.value
      };
      $.ajax({
        data:  parametros,
        url:   window.location+"/validacion.php", 
        type:  "post",
        beforeSend: function () {
            alLoad("Cargando...")
        },
        success: function (jsonPhp) {
          console.log(jsonPhp);
          var jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error==false){
            console.log(jsonJS.diasretraso,jsonJS.bloqueo,jsonJS.fhoy,jsonJS.fven);
            if (jsonJS.bloqueo=='P') {
              alert("Favor tomar en cuenta que en los proximos días el sistema se estara bloqueando por no estar al dia en los pagos en el servicio en la nube");
            }     
            if (jsonJS.bloqueo=='S') {
              document.formLogin.txtUsuCod.value="";
              document.formLogin.txtUsuCla.value="";
              document.formLogin.selEmpCod.value="";
              document.formLogin.txtUsuCod.focus();
              alError({"msg":{"type":"error","title":"SISTEMA BLOQUEADO","text":"Lo sentimos el sistema ha sido bloqueado por retraso en los pagos, para que se lo habiliten, debe enviar las boletas de pago.", "ok":"Aceptar"}});
              return;
            }     
            location.href = "menu/?opcNom=Inicio"
          } else {
            alError(jsonJS);
          }
        }
      });
    }

    $(document).ready(function() {
      document.formLogin.txtUsuCod.focus();

      // Bloqueamos el SELECT de las empresas
//      $("#selectEmp").prop('disabled', true);

      // Guardamos el select de empresas en variable emprecur
      var emprecur = $("#selectEmp");

      txtUsuCod.value="";

      // SUBMIT FORM
      $('form').submit(function() {
        return false;
      });

      // VALID usuCod
      $("#txtUsuCod").change(function (){

          // Limpiamos el select
          emprecur.find('option').remove();

          const parametros = new FormData();
          parametros.append("action", "consultar");

          parametros.append("txtUsuCod", txtUsuCod.value);

          $.ajax({
            data:  parametros,
            url:   window.location.origin+window.location.pathname+"actions.php",
            type:  "post",
            contentType: false,
            processData: false,
            success: function (jsonPhp) {
              //console.log(jsonPhp);
              const jsonJS = JSON.parse(jsonPhp);

              if(jsonJS.error == true){
                alError(jsonJS);
              } else {
                jsonJS.empresas.forEach(function(i){
                    $cod=i.emp_cod;
                    $nom=i.emp_nom;
                    emprecur.append('<option value="'+$cod+'">'+$nom+'</option>');
                });
              }
            }
          });
      });

      $("#selectEmp").click(function (){
          if (txtUsuCod.value=='888') {
            //console.log("sipaso");
          } 
      });
    });
  </script>
</html>