<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

$numAno=$_GET["numAno"];
$selMes=$_GET["selMes"];
$Mesnom=$_GET["Mesnom"];

$lineWidth=17;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $selMes, $Mesnom, $numAno;
        $this->SetMargins(1, 1, 2);
        $img = '../img/LogoOsher.png';
        $this->Image($img,23,.5,2.9,2);
        $this->Cell(0, 0, "", 0, 1);
        $this->SetFont("Arial","B",10);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell($lineWidth/1,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight,  utf8_decode("RESUMEN DE PLANILLAS DEL MES"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight,  utf8_decode("CORRESPONDIENTE A  ".$Mesnom." DEL ".$numAno),0,1,"L");
        //$this->Ln();
        $this->SetFont("","",6);
        $header = array("PROYECTO/DEPARTAMENTO","SUELDO ORDINARIO","SUELDO EXTRA","BONIFICA. LEY","OTRAS BONIF.","OTROS INGRESOS","TOTAL DEVENGADO","IGSS","ISR","PRESTAMO BANCO","PRESTAMO EMPRESA","DESC. JUDICIAL","ANTICIPO","OTROS DECUEN","TOTAL DESCUEN","LIQUIDO A RECIBIR");
        $this->SetFont("","B");
        $this->SetWidths(array(5.7,1.5,1.2,1.3,1.5,1.4,1.6,1.1,1.1,1.4,1.4,1.3,1.3,1.3,1.3,1.5));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("");
        $this->SetAligns(array("L","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R"));
    }
    
    function Footer() {
        $func = new functions();

        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# QUERYS
$sNomper = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, 
            SUM(np_sord) AS np_ssord, SUM(np_sext) AS np_ssext, SUM(np_boni) AS np_sboni, SUM(np_bonii+np_bonoe+np_depre+np_viati) AS np_sbonii,
            SUM(np_otrp+np_comi) AS np_sotrp, SUM(np_totdev) AS np_stotdev, SUM(np_igss) AS np_sigss,
            SUM(np_isr) AS np_sisr, SUM(np_preb) AS np_spreb, SUM(np_pree) AS np_spree, SUM(np_desj) AS np_sdesj,
            SUM(np_anti) AS np_santi, SUM(np_otrd+np_unif+np_lent) AS np_sotrd, SUM(np_totdes) AS np_stotdes, SUM(np_liqrec) AS np_sliqrec,
            TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom,
            mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                WHERE np_emp='$empCod' AND year(np_ffin)='$numAno' AND month(np_ffin)='$selMes' GROUP BY np_emp,np_gru,np_dep ORDER BY np_emp,np_gru,np_dep";

# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["nomper"] = $db->query($sNomper);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Letter");
$pdf->AddPage();
$ti_Depto="XXXX";
$subsord=0;
$subsext=0;
$subboni=0;
$subbonii=0;
$subotrp=0;
$subtotdev=0;
$subigss=0;
$subisr=0;
$subpreb=0;
$subpree=0;
$subdesj=0;
$subanti=0;
$subotrd=0;
$subtotdes=0;
$subliqrec=0;
$totsord=0;
$totsext=0;
$totboni=0;
$totbonii=0;
$tototrp=0;
$tottotdev=0;
$totigss=0;
$totisr=0;
$totpreb=0;
$totpree=0;
$totdesj=0;
$totanti=0;
$tototrd=0;
$tottotdes=0;
$totliqrec=0;

$t_lini=1;
$itemdep=0;
$items=0;
$grupop=99999;
$depp=99999;
while ($rec = $db->fetchAssoc($select["nomper"])) {
    $body = array(
        $rec["gru_nom"].",".$rec["dep_nom"],
        number_format($rec["np_ssord"], 2, '.', ','),
        number_format($rec["np_ssext"], 2, '.', ','),
        number_format($rec["np_sboni"], 2, '.', ','),
        number_format(($rec["np_sbonii"]), 2, '.', ','),
        number_format($rec["np_sotrp"], 2, '.', ','),
        number_format($rec["np_stotdev"], 2, '.', ','),
        number_format($rec["np_sigss"], 2, '.', ','),
        number_format($rec["np_sisr"], 2, '.', ','),
        number_format($rec["np_spreb"], 2, '.', ','),
        number_format($rec["np_spree"], 2, '.', ','),
        number_format($rec["np_sdesj"], 2, '.', ','),
        number_format($rec["np_santi"], 2, '.', ','),
        number_format($rec["np_sotrd"], 2, '.', ','),
        number_format($rec["np_stotdes"], 2, '.', ','),
        number_format($rec["np_sliqrec"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);

    $totsord+=$rec["np_ssord"];
    $totsext+=$rec["np_ssext"];
    $totboni+=$rec["np_sboni"];
    $totbonii+=($rec["np_sbonii"]);
    $tototrp+=($rec["np_sotrp"]);
    $tottotdev+=$rec["np_stotdev"];
    $totigss+=$rec["np_sigss"];
    $totisr+=$rec["np_sisr"];
    $totpreb+=$rec["np_spreb"];
    $totpree+=$rec["np_spree"];
    $totdesj+=$rec["np_sdesj"];
    $totanti+=$rec["np_santi"];
    $tototrd+=$rec["np_sotrd"];
    $tottotdes+=$rec["np_stotdes"];
    $totliqrec+=$rec["np_sliqrec"];
    $itemdep+=1;
    $items+=1;
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 26.8, $pdf->GetY());
$pdf->MultiAlignCell($lineWidth/2,.4, "TOTALES ",0,0,"L");
$pdf->SetX(1);
$body = array(
    "",
    number_format($totsord, 2, '.', ','),
    number_format($totsext, 2, '.', ','),
    number_format($totboni, 2, '.', ','),
    number_format($totbonii, 2, '.', ','),
    number_format($tototrp, 2, '.', ','),
    number_format($tottotdev, 2, '.', ','),
    number_format($totigss, 2, '.', ','),
    number_format($totisr, 2, '.', ','),
    number_format($totpreb, 2, '.', ','),
    number_format($totpree, 2, '.', ','),
    number_format($totdesj, 2, '.', ','),
    number_format($totanti, 2, '.', ','),
    number_format($tototrd, 2, '.', ','),
    number_format($tottotdes, 2, '.', ','),
    number_format($totliqrec, 2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY()+.075, 26.8, $pdf->GetY()+.075);

$db->close();
$pdf->Output(utf8_decode("Resumen_".$Mesnom."_".$numAno).".pdf","I");
?>