<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$numAno=$_GET["numAno"];

# QUERYS
$sNomper = "SELECT np_cod, np_ano, np_mes, SUM(np_sord+np_sexts+np_sextd) AS np_base, 
            SUM(np_boni+np_bonii+np_bonoe+np_depre+np_viati+np_comi+np_otrp) AS np_boniley, 
            SUM(np_isr) AS np_isr, SUM(np_igss) AS np_igss, 
            TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, TRIM(mae_nit) AS mae_nit 
            FROM nomper np
            INNER JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
            WHERE np_emp='$empCod' AND year(np_fini)='$numAno' GROUP BY np_emp,np_cod,np_ano,np_mes 
            ORDER BY np_emp,np_gru,np_dep,np_cod,np_mes";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['planilla']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=3;
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "Sueldos Anuales ".$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'NIT')
            ->setCellValueByColumnAndRow($i++, $j, 'EMPLEADO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'ENERO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'FEBRERO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'MARZO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'ABRIL')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'MAYO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'JUNIO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'JULIO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'AGOSTO')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'SEPTIEMBRE')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'OCTUBRE')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'NOVIEMBRE')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'DICIEMBRE');

        $i=$iIni;
        $j=$j+1;
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'RETENCION')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, '')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL BASE')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL BONI')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL RETEN')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL IGSS');

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    )
 /*,   'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    ) */
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        'wrap' => true,
        )    
);

$styEncabezado1 = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '31869B') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        'wrap' => true,
        )    
);

$styTotales = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') )
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A3:AX3')->applyFromArray($styEncabezado);
$objPHPExcel->getActiveSheet()->getStyle('C4:AX4')->applyFromArray($styEncabezado);
$objPHPExcel->getActiveSheet()->getStyle('C3:F3')->applyFromArray($styEncabezado1);
$objPHPExcel->getActiveSheet()->getStyle('K3:N3')->applyFromArray($styEncabezado1);
$objPHPExcel->getActiveSheet()->getStyle('S3:V3')->applyFromArray($styEncabezado1);
$objPHPExcel->getActiveSheet()->getStyle('AA3:AD3')->applyFromArray($styEncabezado1);
$objPHPExcel->getActiveSheet()->getStyle('AI3:AL3')->applyFromArray($styEncabezado1);
$objPHPExcel->getActiveSheet()->getStyle('AQ3:AT3')->applyFromArray($styEncabezado1);
$objPHPExcel->getActiveSheet()->getStyle('AZ4:BC4')->applyFromArray($styEncabezado);

$totdepo=0;
$totch=0;
$tcod=9999998;
$tlini=1;
$j=4;
$inidep=5;
while ($rec = $db->fetchAssoc($select["nomper"])) {
    if ($rec["np_cod"] != $tcod) {
        $j+=1;
        $i=$iIni;
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, $rec["mae_nit"])
                    ->setCellValueByColumnAndRow($i++, $j, utf8_encode($rec["mae_nom"].", ".$rec["mae_ape"]));
        $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':AX'.$j)->applyFromArray($styLineas);
        $objPHPExcel->getActiveSheet()->getStyle('AZ'.$j.':BC'.$j)->applyFromArray($styLineas);
        $tcod=$rec["np_cod"];
    }
    if ($rec["np_mes"]==1) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(2, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(3, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(4, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(5, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==2) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(6, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(7, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(8, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(9, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==3) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(10, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(11, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(12, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(13, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==4) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(14, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(15, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(16, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(17, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==5) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(18, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(19, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(20, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(21, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==6) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(22, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(23, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(24, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(25, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==7) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(26, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(27, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(28, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(29, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==8) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(30, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(31, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(32, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(33, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==9) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(34, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(35, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(36, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(37, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==10) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(38, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(39, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(40, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(41, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==11) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(42, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(43, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(44, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(45, $j, $rec["np_igss"]);
    }
    if ($rec["np_mes"]==12) {
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow(46, $j, $rec["np_base"])
                    ->setCellValueByColumnAndRow(47, $j, $rec["np_boniley"])
                    ->setCellValueByColumnAndRow(48, $j, $rec["np_isr"])
                    ->setCellValueByColumnAndRow(49, $j, $rec["np_igss"]);
    }
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(51, $j, '=+C'.$j.'+G'.$j.'+K'.$j.'+O'.$j.'+S'.$j.'+W'.$j.'+AA'.$j.'+AE'.$j.'+AI'.$j.'+AQ'.$j.'+AU'.$j.'+AM'.$j)
                ->setCellValueByColumnAndRow(52, $j, '=+D'.$j.'+H'.$j.'+L'.$j.'+P'.$j.'+T'.$j.'+X'.$j.'+AB'.$j.'+AF'.$j.'+AJ'.$j.'+AR'.$j.'+AV'.$j.'+AN'.$j)
                ->setCellValueByColumnAndRow(53, $j, '=+E'.$j.'+I'.$j.'+M'.$j.'+Q'.$j.'+U'.$j.'+Y'.$j.'+AC'.$j.'+AG'.$j.'+AK'.$j.'+AS'.$j.'+AW'.$j.'+AO'.$j)
                ->setCellValueByColumnAndRow(54, $j, '=+F'.$j.'+J'.$j.'+N'.$j.'+R'.$j.'+V'.$j.'+Z'.$j.'+AD'.$j.'+AH'.$j.'+AL'.$j.'+AT'.$j.'+AX'.$j.'+AP'.$j);
}
$i=$iIni;
$j+=1;
$objPHPExcel->getActiveSheet()
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "TOTALES")
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(C5:C'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(D5:D'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(E5:E'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(F5:F'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(G5:G'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(H5:H'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(I5:I'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(J5:J'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(K5:K'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(L5:L'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(M5:M'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(N5:N'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(O5:O'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(P5:P'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Q5:Q'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(R5:R'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(S5:S'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(T5:T'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(U5:U'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(V5:V'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(W5:W'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(X5:X'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Y5:Y'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Z5:Z'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AA5:AA'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AB5:AB'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AC5:AC'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AD5:AD'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AE5:AE'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AF5:AF'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AG5:AG'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AH5:AH'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AI5:AI'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AJ5:AJ'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AK5:AK'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AL5:AL'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AM5:AM'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AN5:AN'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AO5:AO'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AP5:AP'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AQ5:AQ'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AR5:AR'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AS5:AS'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AT5:AT'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AU5:AU'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AV5:AV'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AW5:AW'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AX5:AX'.($j-1).')');
        $i+=1;
$objPHPExcel->getActiveSheet()
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AZ5:AZ'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(BA5:BA'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(BB5:BB'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(BC5:BC'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('C'.$j.':AX'.$j)->applyFromArray($styTotales);
$objPHPExcel->getActiveSheet()->getStyle('AZ'.$j.':BC'.$j)->applyFromArray($styTotales);

$j+=1;
$inidep=$j;

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AH')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AI')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AJ')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AK')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AL')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AM')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AN')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AO')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AP')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AQ')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AR')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AS')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AT')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AU')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AV')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AW')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AX')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('AZ')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('BA')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('BB')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('BC')->setWidth(12);

$objPHPExcel->getActiveSheet()->getStyle('C5'.':AX'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('AZ5'.':BC'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A5'.':B'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])->setTitle('Reporte Anual');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Reporte_Anual.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>