<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */
	/** Error reporting */
	 error_reporting(E_ALL);
	ini_set('display_errors', TRUE);
	ini_set('display_startup_errors', TRUE);
	date_default_timezone_set('Europe/London');

	if (PHP_SAPI == 'cli')
		die('This example should only be run from a Web Browser');

	require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';
	require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel/IOFactory.php';

include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$objPHPExcel = new PHPExcel();

// Esto es para abrir y leer el Excel
$archivo = $_FILES['file']['tmp_name'];
$inputFileType = PHPExcel_IOFactory::identify($archivo);
$objReader = PHPExcel_IOFactory::createReader($inputFileType);
$objPHPExcel = $objReader->load($archivo);

$bitForm = "ban1120";
$bitMod = "ban";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultarCtac':
		echo consultarCtac();
		break;
	case 'guardarCarga':
		echo guardarCarga();
		break;
	case 'borrarCarga':
		echo borrarCarga();
		break;
}

function consultarCtac() {
	global $empCod;
	$txtCtac=utf8_decode($_POST['txtCtac']);

	# QUERYS
	$sCuentas = "SELECT *, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas  WHERE cta='$txtCtac' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}


function guardarCarga() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $tipoPol, $selTipoCod, $mod, $dtGrabado, $objPHPExcel;;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

//	$txtCtac=utf8_decode($_POST['txtCtac']);
//	$crTipov=$_POST['crTipov'];
	$tipoPol='010';
	$selTipoCod="010";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$tbla='';
	$t0=0;
	$mod='ban';
	$empTasa = utf8_decode($_SESSION["empTasa"]);

	# QUERYS PARA UN REGISTRO
	function sTipopol($tipo) { 
		global $empCod,$usuNom,$empConso,$tbla,$t0;
	    return "SELECT * FROM tipopol WHERE tp_cod='$tipo' AND tp_bansn='S'";
	}
	function iCheques($tipo,$banco,$num,$fec,$bene,$concepto,$tcam,$total) { 
		global $empCod,$usuNom,$empConso,$tbla,$t0;
	    return "INSERT INTO cheques(ch_emp, ch_tipo, ch_ban, ch_num, ch_fec, ch_tot, ch_tcam, ch_bene, ch_con, ch_nego, ch_stat, ch_ulcam) VALUES ('$empCod','$tipo','$banco','$num','$fec','$total','$tcam','$bene','$concepto','N','C','$usuNom')";
	}

	function iMovAcu($tipo,$banco,$num,$fec,$bene,$concepto,$debe,$haber,$stat) { 
		global $empCod,$usuNom,$empConso,$tbla,$t0;
	    return "INSERT INTO mov_acu(ma_emp, ma_tipo, ma_ban, ma_num, ma_fec, ma_debe, ma_haber, ma_bene, ma_con, ma_stat) VALUES ('$empCod','$tipo','$banco','$num','$fec','$debe','$haber','$bene','$concepto','$stat')";
	}
	function sMovAcu($tipo,$banco,$num) { 
		global $empCod,$usuNom,$empConso,$tbla,$t0;
	    return "SELECT * FROM mov_acu WHERE ma_emp='$empCod' AND ma_ban='$banco' AND ma_tipo='$tipo' AND ma_num='$num'";
	}

	function iMovi($tipo,$banco,$bancoa,$num,$fec,$concepto,$tcam,$total,$crDH) { 
		global $empCod,$usuNom,$empConso,$tbla,$t0;
	    return "INSERT INTO movi(mov_emp, mov_tipo, mov_ban, mov_bana, mov_num, mov_fec, mov_tot, mov_tcam,  mov_con, mov_debacr, mov_ulcam) VALUES ('$empCod','$tipo','$banco','$bancoa','$num','$fec','$total','$tcam','$concepto','$crDH','$usuNom')";
	}

	function sBanco($banco) { 
		global $empCod;
	    return "SELECT * FROM bancos WHERE ban_emp='$empCod' AND ban_num='$banco'";
	}

	function sSaldo($banco) { 
		global $empCod;
	    return "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$banco'";
	}

	function uSaldob($banco,$nvalor) { 
		global $empCod, $usuNom;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$banco'";
	}

	function iSaldob($banco,$nvalor) { 
		global $empCod, $usuNom;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$banco',$nvalor)";
	}

	function sPoli_det($tipoPol,$banco,$num) { 
		global $empCod;
	    return "SELECT * FROM poli_det 
	    WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_ban='$banco' AND pold_num='$num'";
	}

	function dPoli_det($tipoPol, $banco, $num) { 
		global $empCod;
	    return "DELETE FROM poli_det 
	    		 WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_ban='$banco' AND pold_num='$num'";
	}

	function dPolizas($tipoPol,$serie,$num,$nit,$banco) { 
		global $empCod;
	    return "DELETE FROM polizas 
	    		 WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_ban='$banco'";
	}

	function iPolizas($tipoPol,$fecha,$serie,$num,$nit,$obs,$banco) { 
		global $empCod,$usuNom,$dtGrabado;
	    return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) 
	    		  VALUES ('$empCod','$fecha','$banco','$tipoPol','$num','$serie','$nit','$obs','$usuNom','$dtGrabado')";
	}

	function iPoli_det($tipoPol,$fecha,$serie,$num,$nit,$cta,$ctan,$debe,$haber,$banco) { 
		global $empCod,$usuNom,$dtGrabado;
	    return "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) 
	    		  VALUES ('$empCod','$fecha','$banco','$tipoPol','$num','$serie','$nit','$cta','$ctan','$debe','$haber')";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 
	$pIva = $_SESSION["pIva"];

	$ctaIva = $_SESSION["empCtaiv"];
	$ctaRet = $_SESSION["empCtarisr"];
	$ctaReti = $_SESSION["empCtariva"];

	// Para cargar el archivo desde excel
	// Indicamos que usaremos la primera hoja del excel
	$objPHPExcel->setActiveSheetIndex(0);

	// Revisa cual es la ultima fila y columna trabajada
	$highestRow = $objPHPExcel->getActiveSheet()->getHighestRow(); 
	$highestColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();   
/*
	echo $highestRow;   
	$nom="prueba";
	$resp["fileCompras"]=array();  */
	$resp["fileVentas"]=array();
	$nom="prueba";
	$tipo="XXXX999";
	$arrayErrores = array();
	$j=0;
	// Aqui se obtienen los valores de cada celda, hasta el ultimo valor
	for ($row = 2; $tipo!=''; $row++){   
		$db = new dbExec();
	//	echo $objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue(); 

		$tipo= trim($objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue());
		$num= $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue();
		$fec1 = $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue()+1;
		$fec = date("Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($fec1)); 
		$bene= utf8_decode($objPHPExcel->getActiveSheet()->getCell("D".$row)->getValue());
		$concepto= $objPHPExcel->getActiveSheet()->getCell("E".$row)->getValue();
		$tcam= $objPHPExcel->getActiveSheet()->getCell("F".$row)->getValue();
		$total= $objPHPExcel->getActiveSheet()->getCell("G".$row)->getValue();
		$banco= $objPHPExcel->getActiveSheet()->getCell("H".$row)->getValue();
		$bancoa= $objPHPExcel->getActiveSheet()->getCell("I".$row)->getValue();
		$cta1= $objPHPExcel->getActiveSheet()->getCell("J".$row)->getValue();
		$val1= $objPHPExcel->getActiveSheet()->getCell("K".$row)->getValue();
		$cta2= $objPHPExcel->getActiveSheet()->getCell("L".$row)->getValue();
		$val2= $objPHPExcel->getActiveSheet()->getCell("M".$row)->getValue();
		$cta3= $objPHPExcel->getActiveSheet()->getCell("N".$row)->getValue();
		$val3= $objPHPExcel->getActiveSheet()->getCell("O".$row)->getValue();

		$numMes=date("n", strtotime($fec));
		$numAno=date("Y", strtotime($fec));

		if (is_null($tipo)) {
			$tipo="";
			continue;
	    }
		if (is_null($bene)) {
			$bene="";
	    }
		if (is_null($concepto)) {
			$concepto="";
	    }
		if (is_null($tcam)) {
			$tcam=1.0000;
	    }
		if (is_null($total)) {
			$total=0;
	    }

		if (is_null($banco)) {
			$banco=0;
	    }
		if (is_null($bancoa)) {
			$bancoa=0;
	    }
		if (is_null($cta1)) {
			$cta1='';
	    }
		if (is_null($cta2)) {
			$cta2='';
	    }
		if (is_null($cta3)) {
			$cta3='';
	    }
		if (is_null($val1)) {
			$val1=0;
	    }
		if (is_null($val2)) {
			$val2=0;
	    }
		if (is_null($val3)) {
			$val3=0;
	    }

	    $val1=round($val1,2);
	    $val2=round($val2,2);
	    $val3=round($val3,2);

	    if ($tcam>1) {
	       $montoq=round(($total*$tcam),2);
		} else {
		   $montoq=round($total,2);
		}
/*		
	    if ($tcam>1) {
	       $val1q=round(($val1*$tcam),2);
		} else {
		   $val1q=$val1;
		}
	    if ($tcam>1) {
	       $val2q=round(($val2*$tcam),2);
		} else {
		   $val2q=$val2;
		}
	    if ($tcam>1) {
	       $val3q=round(($val3*$tcam),2);
		} else {
		   $val3q=$val3;
		}
*/

		$fetchAssoc["tipopol"] = $db->sFetchAssoc(sTipopol($tipo));
		$select["tipopol"] = $db->query(sTipopol($tipo));
		// Verifica si existe el tipo de documento que esta cargando
		if ($db->numRows($select["tipopol"]) == 0) {
			if ($tipo!="") {
			  array_push($arrayErrores, array('Linea'=>$row, 'Tipo'=>$tipo, 'NumDoc'=>$num, 'Mensaje'=>'El tipo de Documento no existe en la lista'));
			}
			continue;
		}
		$debacr = $fetchAssoc["tipopol"]["tp_deha"];

		$fetchAssoc["bancos"] = $db->sFetchAssoc(sBanco($banco));
		$select["bancos"] = $db->query(sBanco($banco));
		// Verifica si existe el banco
		if ($db->numRows($select["bancos"]) == 0) {
			array_push($arrayErrores, array('Linea'=>$row, 'Tipo'=>$tipo, 'NumDoc'=>$num, 'Mensaje'=>'El codigo que ingreso para el banco primario no esta registrado'));
			continue;
		}
		$banmon = $fetchAssoc["bancos"]["ban_mon"];
		$banctac = $fetchAssoc["bancos"]["ban_ctac"];
		$banctadif = $fetchAssoc["bancos"]["ban_ctadif"];
		// Verifica si la cuenta que esta usando es moneda local y le pusieron tipo de cambio
		if ($banmon==1 && $tcam>1) {
			array_push($arrayErrores, array('Linea'=>$row, 'Tipo'=>$tipo, 'NumDoc'=>$num, 'Mensaje'=>'Coloco tasa de cambio mayor a 1.00 y el tipo de moneda del banco primario esta como moneda local'));
			continue;
		}
		// Verifica si la cuenta que esta usando es de dolares y no le pusieron tipo de cambio
		if ($banmon==2 && $tcam==1) {
			array_push($arrayErrores, array('Linea'=>$row, 'Tipo'=>$tipo, 'NumDoc'=>$num, 'Mensaje'=>'Coloco tasa de cambio 1.00 y el tipo de moneda del banco primario esta como moneda extranjera'));
			continue;
		}
		
		if ($bancoa>0) {
			$fetchAssoc["bancosa"] = $db->sFetchAssoc(sBanco($bancoa));
			$select["bancosa"] = $db->query(sBanco($bancoa));
			/// Verifica si existe el segundo banco
			if ($db->numRows($select["bancosa"]) == 0) {
				array_push($arrayErrores, array('Linea'=>$row, 'Tipo'=>$tipo, 'NumDoc'=>$num, 'Mensaje'=>'El codigo del banco segundario que ingreso, no existe'));
				continue;
			}
			$banmona = $fetchAssoc["bancosa"]["ban_mon"];
			$banctaca = $fetchAssoc["bancosa"]["ban_ctac"];
			$banctadifa = $fetchAssoc["bancosa"]["ban_ctadif"];
		} else {
			$banmona = 0;
			$banctaca = "";
			$banctadifa = "";
		}
		$totdif=0;
		if ($tcam>1 && $banmon==2) {
		   $totdif=$montoq-$total;
		}
		$suma=round(($val1+$val2+$val3),2);
		/// Verifica si el total del haber va a ser igual que el debe en la partida
		if ($montoq!=$suma && $tipo!="003") {
			array_push($arrayErrores, array('Linea'=>$row, 'Tipo'=>$tipo, 'NumDoc'=>$num, 'Mensaje'=>'El monto total no cuadra con el valor de las cuentas de detalle'.$montoq."  ".$suma));
			continue;
		}
		/// Verifica si el detalle de la poliza ya existe
		$existepol="N";
		$select["poli_det"] = $db->query(sPoli_det($tipo,$banco,$num));
		if ($db->numRows($select["poli_det"])>0) {
			$existepol="S";
		}
		// Se registra cuando el tipo de movimiento se debe restar del banco primario
		if ($debacr=="A") {
			if ($tipo=="004") {
			  $resp =	$db->query(iCheques($tipo,$banco,$num,$fec,$bene,$concepto,$tcam,$total));
			  $resp =	$db->query(iMovAcu($tipo,$banco,$num,$fec,$bene,$concepto,0,$total,"C"));
			} else {
			  $resp =	$db->query(iMovi($tipo,$banco,$bancoa,$num,$fec,$concepto,$tcam,$total,$debacr));
			  $resp =	$db->query(iMovAcu($tipo,$banco,$num,$fec,$bene,$concepto,0,$total,"P"));
			  if ($tipo=="003") {
			  	if ($banmon==1 && $banmona==1) {
			  		$resp =	$db->query(iMovAcu($tipo,$bancoa,$num,$fec,$bene,$concepto,$total,0,"P"));
			  	}
			  	if ($banmon==2 && $banmona==1) {
			  		$totala=round(($total*$tcam),2);
			  		$resp =	$db->query(iMovAcu($tipo,$bancoa,$num,$fec,$bene,$concepto,$totala,0,"P"));
			  	}
			  	if ($banmon==1 && $banmona==2) {
			  		$totala=round(($total/$empTasa),2);
			  		$resp =	$db->query(iMovAcu($tipo,$bancoa,$num,$fec,$bene,$concepto,$totala,0,"P"));
			  	}
			  }
			}
			$resp =	$db->query(iMovAcu($tipo,$banco,$num,$fec,$bene,$concepto,0,$total,'C'));
			if ($cta1!="" && $val1>0 && $existepol=="N") {
				$cta=$cta1;
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$val1;
				$haber=0;
				$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
				// PARA APLICAR LOS CIERRES
/*				
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
*/				
			}
			if ($cta2!="" && $val2>0 && $existepol=="N") {
				$cta=$cta2;
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$val2;
				$haber=0;
				$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
				// PARA APLICAR LOS CIERRES
/*				
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
*/				
			}
			if ($cta3!="" && $val3>0 && $existepol=="N") {
				$cta=$cta3;
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$val3;
				$haber=0;
				$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
				// PARA APLICAR LOS CIERRES
/*				
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
*/				
			}
		    if ($tipo=="003" && $existepol=="N") {
		       if ($banmon==1 && $banmona==1) {
		  		 $totala=$total;
		  	   }
		  	   if ($banmon==2 && $banmona==1) {
		  		 $totala=round(($total*$tcam),2);
		  	   }
		  	   if ($banmon==1 && $banmona==2) {
		  		 $totala=round(($total/$empTasa),2);
		  	   }
				// Para registrar la cuenta de banco a donde entrara en la transferencia
				$cta=$banctaca;
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$totala;
				$haber=0;
				$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
				// PARA APLICAR LOS CIERRES
/*				
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
*/				
				if ($banmona==2) {
					$totalaq=round(($totala*$empTasa),6);
				    $totdifa=round((($total+$totdif)-$totala),2);
					// Para registrar la cuenta de bancos diferencial
					$cta=$banctadifa;
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
					if ($banmon==1 && $banmona==2) {
					  $debe=$totdifa;
					  $haber=0;
					} else {
					  $debe=0;
					  $haber=$totdifa;
					}
					$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
					// PARA APLICAR LOS CIERRES
/*					
					while (!empty($cta)) {
						$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
						$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

						$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
						if ($db->numRows($select["cierres"]) > 0) {
							$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
							$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
							$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
							$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						} else {
							$mdebe=$debe;
							$mhaber=$haber;
							$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						}
						$cta = $ctaActa;
					}
*/					
				}
		    }
			// Para registrar la cuenta de bancos
			if ($existepol=="N") {
				$cta=$banctac;
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=0;
				$haber=$total;
				$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
				// PARA APLICAR LOS CIERRES
/*				
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
*/				
				if ($banmon==2) {
					// Para registrar la cuenta de bancos diferencial
					$cta=$banctadif;
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
					$debe=0;
					$haber=$totdif;
					$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
					// PARA APLICAR LOS CIERRES
/*					
					while (!empty($cta)) {
						$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
						$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

						$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
						if ($db->numRows($select["cierres"]) > 0) {
							$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
							$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
							$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
							$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						} else {
							$mdebe=$debe;
							$mhaber=$haber;
							$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						}
						$cta = $ctaActa;
					}
*/					
				}
			}
		}


		// Se registra cuando el tipo de movimiento se debe sumar del banco primario
		if ($debacr=="D") {
		    $resp =	$db->query(iMovi($tipo,$banco,$banco,$num,$fec,$concepto,$tcam,$total,$debacr));
		    $resp =	$db->query(iMovAcu($tipo,$banco,$num,$fec,$bene,$concepto,$total,0,"P"));
			// Para registrar la cuenta de bancos
			if ($existepol=="N") {
				$cta=$banctac;
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
				$debe=$total;
				$haber=0;
				$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
				// PARA APLICAR LOS CIERRES
/*				
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
						$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$debe;
						$mhaber=$haber;
						$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}
*/				
				if ($banmon==2) {
					// Para registrar la cuenta de bancos diferencial
					$cta=$banctadif;
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
					$debe=$totdif;
					$haber=0;
					$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
					// PARA APLICAR LOS CIERRES
/*					
					while (!empty($cta)) {
						$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
						$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

						$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
						if ($db->numRows($select["cierres"]) > 0) {
							$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
							$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
							$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
							$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						} else {
							$mdebe=$debe;
							$mhaber=$haber;
							$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						}
						$cta = $ctaActa;
					}
*/					
				}
				if ($cta1!="" && $val1>0) {
					$cta=$cta1;
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
					$debe=0;
					$haber=$val1;
					$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
					// PARA APLICAR LOS CIERRES
/*					
					while (!empty($cta)) {
						$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
						$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

						$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
						if ($db->numRows($select["cierres"]) > 0) {
							$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
							$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
							$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
							$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						} else {
							$mdebe=$debe;
							$mhaber=$haber;
							$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						}
						$cta = $ctaActa;
					}
*/					
				}
				if ($cta2!="" && $val2>0) {
					$cta=$cta2;
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
					$debe=0;
					$haber=$val2;
					$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
					// PARA APLICAR LOS CIERRES
/*					
					while (!empty($cta)) {
						$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
						$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

						$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
						if ($db->numRows($select["cierres"]) > 0) {
							$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
							$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
							$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
							$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						} else {
							$mdebe=$debe;
							$mhaber=$haber;
							$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						}
						$cta = $ctaActa;
					}
*/					
				}
				if ($cta3!="" && $val3>0) {
					$cta=$cta3;
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
					$debe=0;
					$haber=$val3;
					$db->query(iPoli_det($tipo,$fec,'',$num,'',$cta,$ctaNom,$debe,$haber,$banco));
					// PARA APLICAR LOS CIERRES
/*					
					while (!empty($cta)) {
						$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
						$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

						$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
						if ($db->numRows($select["cierres"]) > 0) {
							$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
							$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
							$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
							$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						} else {
							$mdebe=$debe;
							$mhaber=$haber;
							$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
						}
						$cta = $ctaActa;
					}
*/					
				}
			}
		}
		// Registar el encabezado de la poliza
		$db->query(iPolizas($tipo,$fec,'',$num,'',$concepto,$banco));

		$db->close();
	}

	$db = new dbExec();
	$db->query($func->iBitacora(utf8_decode("Se Regristaron Documentos Se habia Cargado desde archivo Excel Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

//	$cta="1";
//	$resp = $db->sFetchAssoc(sCuentas($cta));
/*
	class generatePDF extends PDF_MC_Table {
	    function Header() {
	        global $empNom, $empNomc, $lineHeight;
	        $this->SetMargins(2, 1, 2);

	        $func = new functions();
	        $this->SetFont("Arial","",9);
	        $this->Cell(0, 0, "", 0, 1);

	        $this->SetFont("","",8);
	        $this->SetWidths(array(3,3,3,7));
	        $this->SetAligns(array("C","L","L","L"));
	    }
	    
	    function Footer() {
	        // Posición: a 1,5 cm del final
	        $func = new functions();
	        $this->SetY(-2);
	        $this->SetFont("Arial","I",8);
	    }
	}
	$pdf = new generatePDF("P","cm", "Letter");
	$pdf->AddPage();
	$lineHeight=0.35;
	$func = new functions();
	foreach ($arrayErrores as $rec) {
		$Linea=$rec["Linea"];
		$Tipo=$rec["Linea"];
        $body = array(
            $rec["Linea"],
            $rec["Tipo"],
            $rec["NumDoc"],
            $rec["Mensaje"],
        );
        $pdf->RowBorderHidden($body, $lineHeight);
	}
	ob_end_clean();
	ob_start();
	$pdf->Output(utf8_decode("Lista de Errores").".pdf","I");
*/
	$resp["Errores"]=$arrayErrores;
//	return $func->jsonEncodeArray($resp, 'cuentas');
	return json_encode($resp);
}

function borrarCarga() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $tipoPol, $selTipoCod, $mod, $objPHPExcel;;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$tipoPol='010';
	$selTipoCod="010";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$mod='ban';


	# QUERYS PARA UN REGISTRO
	function dCheques($tipo,$ban,$num) { 
		global $empCod;
	    return "DELETE FROM cheques WHERE ch_emp='$empCod' AND ch_ban='$ban' AND ch_num='$num'";
	}

	function dMovi($tipo,$ban,$num) { 
		global $empCod;
	    return "DELETE FROM movi WHERE mov_emp='$empCod' AND mov_tipo='$tipo' AND mov_ban='$ban' AND mov_num='$num'";
	}

	function dMovAcu($tipo,$ban,$num) { 
		global $empCod;
	    return "DELETE FROM mov_acu WHERE ma_emp='$empCod' AND ma_tipo='$tipo' AND ma_ban='$ban' AND ma_num='$num'";
	}

	function dPoli_det($tipo,$ban,$num) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM poli_det 
	    		 WHERE pold_emp='$empCod' AND pold_tipo='$tipo' AND pold_num='$num' AND pold_ban='$ban'";
	}

	function dPolizas($tipo,$ban,$num) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM polizas 
	    		 WHERE pol_emp='$empCod' AND pol_tipo='$tipo' AND pol_num='$num' AND pol_ban='$ban'";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 

	// Para cargar el archivo desde excel
	// Indicamos que usaremos la primera hoja del excel
	$objPHPExcel->setActiveSheetIndex(0);

	// Revisa cual es la ultima fila y columna trabajada
	$highestRow = $objPHPExcel->getActiveSheet()->getHighestRow(); 
	$highestColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();   
/*
	echo $highestRow;   
	$nom="prueba";
	$resp["fileCompras"]=array();  */
	$resp["fileVentas"]=array();
	$nom="prueba";
	$tipo="XXXX999";
	$j=0;
	// Aqui se obtienen los valores de cada celda, hasta el ultimo valor
	for ($row = 2; $tipo!=''; $row++){   
		$db = new dbExec();
	//	echo $objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue(); 

		$tipo= trim($objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue());
		$num= $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue();
		$fec1 = $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue()+1;
		$fec = date("Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($fec1)); 
		$bene= utf8_decode($objPHPExcel->getActiveSheet()->getCell("D".$row)->getValue());
		$concepto= $objPHPExcel->getActiveSheet()->getCell("E".$row)->getValue();
		$tcam= $objPHPExcel->getActiveSheet()->getCell("F".$row)->getValue();
		$total= $objPHPExcel->getActiveSheet()->getCell("G".$row)->getValue();
		$banco= $objPHPExcel->getActiveSheet()->getCell("H".$row)->getValue();
		$bancoa= $objPHPExcel->getActiveSheet()->getCell("I".$row)->getValue();

	    // Revisa si ya fue grabado este documento con anterioridad, si es asi, revierte poliza y borra documento
		    // Borra el registro de compras y las polizas que le afecten
		$resp = $db->query(dCheques($tipo,$banco,$num));
		$resp = $db->query(dMovi($tipo,$banco,$num));
		$db->query(dMovAcu($tipo,$banco,$num));
		if ($tipo=="003") {
  		  $db->query(dMovAcu($tipo,$bancoa,$num));
		}
		$db->query(dPolizas($tipo,$banco,$num));
		$db->query(dPoli_det($tipo,$banco,$num));

		$db->close();
	}
	$db = new dbExec();
	$db->query($func->iBitacora(utf8_decode("Se borro Documentos Se habia Cargado desde archivo Excel Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

?>