<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$dtFec=$_GET["dtFec"];

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec;
        $this->SetMargins(2.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"C");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de cuentas al ".strftime("%d/%m/%Y", strtotime($dtFec))),0,1,"C");
        $this->Ln();

        $header = array("Cuenta","Nombre de Cuenta","Acum.","Nivel","Cta Acumula", "Presu");
        $this->SetFont("","B");
        $this->SetWidths(array(3,7.9,1.3,1.2,2.4,1.2));
        $this->SetAligns(array("C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("","","C","C","","C"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sCuentas = "SELECT * FROM cuentas WHERE cta_emp='$empCod'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["cuentas"] = $db->query($sCuentas);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

while ($rec = $db->fetchAssoc($select["cuentas"])) {
    $body = array(
        $rec["cta"],
        trim($rec["cta_nom"]),
        $rec["cta_con"],
        $rec["cta_niv"],
        $rec["cta_acta"],
        $rec["cta_presu"],
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Catálogo de Cuentas").".pdf","I");
?>