<?php 
include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$pTcam=$_SESSION["pTcam"];
$empNit=utf8_decode($_SESSION['empNit']);

$selMes=$_GET["selMes"];
$selMesNom=$_GET["selMesNom"];
$numAno=$_GET["numAno"];
$selMesf=$_GET["selMesf"];
$selMesNomf=$_GET["selMesNomf"];
$numAnof=$_GET["numAnof"];
$cbFecsn=$_GET["cbFecsn"];
$cbNoIva=$_GET["cbNoIva"];
$txtNit=$_GET["txtNit"];
$txtCli=$_GET["txtCli"];
$Uldia=$_GET["Uldia"];
$Fecfin = (strval($numAnof)."-".strval($selMesf)."-".strval($Uldia));
$numDiai = 1;
$Fecini = (strval($numAno)."-".strval($selMes)."-".strval($numDiai));

$lineWidth=20;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $empNomc, $empNit, $selMes, $selMesNom, $numAno, $selMesf, $selMesNomf, $numAnof, $txtNit, $txtCli, $Fecini, $Fecfin, $cbFecsn, $cbNoIva, $lineWidth, $lineHeight;
        $this->SetMargins(1.6, 1, 2);

        $func = new functions();
        $this->SetFont("Arial","",9);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");
        //$this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNomc),0,1,"C");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1, utf8_decode("Folio: ".(string)($this->PageNo())),0,1,"R");

        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("VENTAS REGISTRADAS A UN CLIENTE"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Mes Inicial  ".trim($selMesNom)."  Año ".$numAno."  Mes Final  ".trim($selMesNomf)."  Año ".$numAnof."                    Nit: ".$empNit),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cliente: ".trim($txtNit)."     ".trim($txtCli)),0,1,"L");
        $this->Ln();

        $this->SetFont("","",7);
        $header = array("FECHA","SERIE","NUMERO","VENTAS", "EXENTO", "SERVICIOS", "EXPORTACION", "IVA", "TOTAL");
        $this->SetWidths(array(1.5,2.5,2.5,2,2,2,2,2,2,2,2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetAligns(array("C","L","L","R","R","R","R","R","R"));
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();
        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}
# QUERYS
if ($cbNoIva) {
    $sIva_ven = "SELECT *,
                TRIM(iv.ivav_serie) AS ivav_serie,
                TRIM(iv.ivav_nit) AS ivav_nit,
                TRIM(iv.ivav_clin) AS ivav_clin
            FROM iva_ven iv LEFT JOIN tipov tv ON tv.tv_cod=iv.ivav_tipo
            WHERE iv.ivav_emp='$empCod' AND iv.ivav_fec>='$Fecini' AND iv.ivav_fec<='$Fecfin' AND iv.ivav_nit='$txtNit'
            ORDER BY iv.ivav_emp,iv.ivav_fec";
} else {
    $sIva_ven = "SELECT *,
                TRIM(iv.ivav_serie) AS ivav_serie,
                TRIM(iv.ivav_nit) AS ivav_nit,
                TRIM(iv.ivav_clin) AS ivav_clin
            FROM iva_ven iv 
            WHERE iv.ivav_emp='$empCod' AND iv.ivav_fec>='$Fecini' AND iv.ivav_fec<='$Fecfin' AND iv.ivav_afe='S' AND iv.ivav_nit='$txtNit'
            ORDER BY iv.ivav_emp,iv.ivav_fec";
}

# EJECUCION DE QUERYS
$db = new dbExec();
# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$func = new functions();
$linea=1;
$cantdoc=0;
$select["iva_ven"] = $db->query($sIva_ven);
while ($rec = $db->fetchAssoc($select['iva_ven'])) {
    // TASA DE CAMBIO
    $cantdoc += 1;
    $tsubna = $tsubna+($rec["ivav_subna"]+$rec["ivav_exen"]);
    $tsubb = ($tsubb+$rec["ivav_subb"]+$rec["ivav_subme"]+$rec["ivav_subve"]+$rec["ivav_subco"]);
    $tsubs += $rec["ivav_subs"];
    $tsube = $tsube+$rec["ivav_sube"]+$rec["ivav_suber"];
    $tiva += $rec["ivav_iva"];
    $ttot += $rec["ivav_tot"];

    $rsubna += ($rec["ivav_subna"]+$rec["ivav_exen"]);
    $rsubb  += ($rec["ivav_subb"]+$rec["ivav_subme"]+$rec["ivav_subve"]+$rec["ivav_subco"]);
    $rsubs  +=  $rec["ivav_subs"];
    $rsube +=  ($rec["ivav_sube"]+$rec["ivav_suber"]);
    $riva += $rec["ivav_iva"];
    $rtot += $rec["ivav_tot"];

    $body = array(
        strftime("%d/%m/%Y", strtotime($rec["ivav_fec"])),
        $rec["tv_nom"],
        $rec["ivav_num"],
        (round($rec["ivav_subb"]+$rec["ivav_subme"]+$rec["ivav_subve"]+$rec["ivav_subco"], 2) != 0) ? number_format($rec["ivav_subb"]+$rec["ivav_subme"]+$rec["ivav_subve"]+$rec["ivav_subco"], 2, '.', ',') : "",
        (round($rec["ivav_subna"]+$rec["ivav_exen"], 2) != 0) ? number_format($rec["ivav_subna"]+$rec["ivav_exen"], 2, '.', ',') : "",
        (round($rec["ivav_subs"], 2) != 0) ? number_format($rec["ivav_subs"], 2, '.', ',') : "",
        (round($rec["ivav_sube"]+$rec["ivav_suber"], 2) != 0) ? number_format($rec["ivav_sube"]+$rec["ivav_suber"], 2, '.', ',') : "",
        (round($rec["ivav_iva"], 2) != 0) ? number_format($rec["ivav_iva"], 2, '.', ',') : "",
        number_format($rec["ivav_tot"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    //  (round($totSalIni, 2) != 0) ? number_format($totSalIni, 2, '.', ',') : "",

    $linea=2;
}

// TOTALES DEL MOVIMIENTO
//$pdf->Ln();
$pdf->line($pdf->GetX()+4, $pdf->GetY(), 20.2, $pdf->GetY());
$body = array(
    "",
    "",
    "TOTALES",
    number_format($tsubb, 2, '.', ','),
    number_format($tsubna, 2, '.', ','),
    number_format($tsubs, 2, '.', ','),
    number_format($tsube, 2, '.', ','),
    number_format($tiva, 2, '.', ','),
    number_format($ttot, 2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+4, $pdf->GetY(), 20.2, $pdf->GetY());

$db->close();
ob_end_clean();
ob_start();
$pdf->Output(utf8_decode("LIBRO DE VENTAS").".pdf","I"); 

?>