<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$numChi=$_GET["numChi"];
$numChf=$_GET["numChf"];
$selBanCod=$_GET["selBanCod"];

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $numPoli, $numPolf;
    }
    
    function Footer() {
    }
}

# QUERYS
$sCheques = "SELECT *, TRIM(m.mes_nom) AS mes_nom 
        FROM cheques ch LEFT JOIN bancos ban ON ban.ban_emp=ch.ch_emp AND ban.ban_num=ch.ch_ban 
        LEFT JOIN meses m ON month(ch.ch_fec)=m.mes_cod 
        WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_num>='$numChi' AND ch_num<='$numChf'";

function sPoli_det($selBanCod, $numNum) {
    global $empCod;
    return "SELECT *,
                TRIM(pold_cta) AS pold_cta,
                TRIM(pold_ctan) AS pold_ctan
            FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='004' AND pold_num='$numNum'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["cheques"] = $db->query($sCheques);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 27.94));
$pdf->AddPage();

$totDebe = 0;
$totHaber = 0;
while ($rec = $db->fetchAssoc($select['cheques'])) {
    $anoch=date("Y", strtotime($rec["ch_fec"]));
    $diach=date("d", strtotime($rec["ch_fec"]));
    $pdf->SetMargins(2.5, 1, 2.5);
    $pdf->SetFont("Arial","B",20);

    $lineWidth=17;
    $lineHeight=0.6;

    $pdf->SetFont("","B",14);
    $pdf->SetX(2.5);
    $pdf->MultiAlignCell($lineWidth/1, $lineHeight, "HOJA ADJUNTA",0,1,"C");
    $pdf->SetFont("","",10);
    $pdf->Ln($lineHeight*1);    
    $pdf->MultiAlignCell($lineWidth/1, $lineHeight, "Numero de Cheque:     ".$rec["ch_num"]);
    $pdf->Ln($lineHeight*1);
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, utf8_decode("Fecha:   "));
    $pdf->MultiAlignCell($lineWidth/2, $lineHeight, $diach." de ".$rec["mes_nom"]." del ".$anoch);
    $pdf->MultiAlignCell($lineWidth/6, $lineHeight, "Valor:   ***".number_format($rec["ch_tot"],2),0,1,"R");
    $pdf->MultiAlignCell($lineWidth/1, $lineHeight, "Beneneficiario: ".utf8_decode($rec["ch_bene"]),0,1);
    //$pdf->MultiAlignCell($lineWidth/1.1, $lineHeight,utf8_decode($func->numLetras((float)$rec["ch_tot"])));
    if ($rec["ch_nego"] == "N") {
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/1, $lineHeight, "NO NEGOCIABLE");
    } else {
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, " ");
    }

    $lineHeight=0.4;

    $pdf->Ln($lineHeight*2);

    $header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
    $pdf->SetFont("","B");
    $pdf->SetWidths(array(3,8,3,3));
    $pdf->SetAligns(array("C","C","C","C"));
    $pdf->Row($header, $lineHeight);

    $pdf->SetFont("");
    $pdf->SetAligns(array("L","L","R","R"));
    $debe = 0;
    $haber = 0;

    $select["poli_det"] = $db->query(sPoli_det($rec["ch_ban"], $rec["ch_num"]));
    
    while ($recTbl = $db->fetchAssoc($select['poli_det'])) {
        $debe += $recTbl["pold_debe"];
        $haber += $recTbl["pold_haber"];
        $body = array(
            $recTbl["pold_cta"],
            $recTbl["pold_ctan"],
            ($recTbl["pold_debe"] != 0) ? $recTbl["pold_debe"] : "",
            ($recTbl["pold_haber"] != 0) ? $recTbl["pold_haber"] : "",
        );
        $pdf->RowBorderHidden($body, $lineHeight);
    }
    $pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

    $pdf->SetAligns(array("","R","R","R"));
    $body = array(
        "",
        "Totales: ",
        number_format($debe,2),
        number_format($haber,2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
    $pdf->SetFont("","");
    $pdf->MultiAlignCell($lineWidth/1, $lineHeight, "Concepto: ".$rec["ch_con"]);
    $pdf->Ln($lineHeight*3);
    $pdf->MultiAlignCell($lineWidth/1.2, $lineHeight, "Banco: ".$rec["ban_nom"]);
    $pdf->Ln();
    $pdf->MultiAlignCell($lineWidth/1.2, $lineHeight, "Cuenta: ".$rec["ban_ctab"]);

    $pdf->Ln($lineHeight*2);
    $pdf->Cell($lineWidth/6);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Hecho por", "T", 0, "C");
    $pdf->Cell($lineWidth/6);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Revisado por", "T", 0, "C");

    if ($rec["ch_num"] < $numChf) { $pdf->AddPage(); }        
}

$db->close();

$pdf->Output(utf8_decode("Cheques").".pdf","I");

?>