<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];

$lineWidth=19.3;
$lineHeight=0.50;

# QUERYS
function sMovAcu0($selBan) {
    global $empCod,$dtFecI,$dtFecF;
    return "SELECT ma_emp,ma_ban,
            SUM(ma_debe) AS ma_sdebe, 
            SUM(ma_haber) AS ma_shaber 
            FROM mov_acu WHERE ma_emp='$empCod' AND ma_ban='$selBan' AND ma_fec>='$dtFecI' GROUP BY '$empCod','$selBan'";
}            
function sMovAcu($selBan) {
    global $empCod,$dtFecI,$dtFecF;
    return "SELECT ma_emp,ma_ban,
            SUM(ma_debe) AS ma_sdebe, 
            SUM(ma_haber) AS ma_shaber 
            FROM mov_acu WHERE ma_emp='$empCod' AND ma_ban='$selBan' AND ma_fec>='$dtFecI' AND ma_fec<='$dtFecF' GROUP BY '$empCod','$selBan'";
}            

    
function sSaldob($selBan) {
    global $empCod,$dtFecI,$dtFecF;
    return "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num=$selBan";
}

$sBancos = "SELECT *,
            TRIM(ban_nom) AS ban_nom,
            TRIM(ban_ctab) AS ban_ctab 
            FROM bancos WHERE ban_emp='$empCod'";

# EJECUCION DE QUERYS
$db = new dbExec();

$Saldo=0;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth,$dtFecI, $dtFecF, $selBan,$salIni,$Saldo,$banNom,$banCtab;
        $func = new functions();
        $this->SetMargins(1.35, 1, 1.35);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, $empNom,0,1,"L");
        $this->SetFont("","I",8);
        $this->SetY(.6);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","B",10);
        $this->Cell($lineWidth, $lineHeight, utf8_decode("CONSOLIDADO DE SALDOS DEL ".strftime("%d/%m/%Y", strtotime($dtFecI))." AL ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"L");

        $this->SetFont("","B",10);        
        $header = array("Codigo","Descripcion","Saldo Inicial","Ingresos","Egresos","Saldo Actual");
        $this->SetFont("","B");
        $this->SetWidths(array(1.5,6.5,2.8,2.8,2.8,2.8));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("", "", 10);
        $this->SetAligns(array("L","L","R","R","R","R"));

    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$totsini = 0;
$totdebe = 0;
$tothaber = 0;
$totsact = 0;


$select["bancos"] = $db->query($sBancos);
while ($rec = $db->fetchAssoc($select['bancos'])) {
    $selBan = $rec["ban_num"];
    $banNom = $rec["ban_nom"];

    $select["mov_acu"] = $db->query(sMovAcu0($selBan));
    $recma0 = $db->fetchAssoc($select['mov_acu']);
    $sDebemov=$recma0["ma_sdebe"];
    $sHabermov=$recma0["ma_shaber"];

    $select["mov_acu"] = $db->query(sMovAcu($selBan));
    $recma = $db->fetchAssoc($select['mov_acu']);
    $sDebemova=$recma["ma_sdebe"];
    $sHabermova=$recma["ma_shaber"];

    $select["saldob"]=$db->query(sSaldob($selBan));
    $recsal = $db->fetchAssoc($select['saldob']);
    $Saldo=$recsal["salb_saldo"];
    $salIni=($Saldo-$sDebemov)+$sHabermov;
    $salAct=($salIni+$sDebemova)-$sHabermova;

    $totsini += $salIni;
    $totdebe += $sDebemova;
    $tothaber += $sHabermova;
    $totsact += $salAct;

    $body = array(
        $selBan,
        TRIM($banNom),
        (round($salIni,2) != 0) ? number_format($salIni, 2, '.', ',') : "",
        (round($sDebemova,2) != 0) ? number_format($sDebemova, 2, '.', ',') : "",
        (round($sHabermova,2) != 0) ? number_format($sHabermova, 2, '.', ',') : "",
        number_format($salAct, 2, '.', ','),
        );
     $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->Ln($lineHeight);

$pdf->line($pdf->GetX()+7.5, $pdf->GetY(), 20.5, $pdf->GetY());

$pdf->SetAligns(array("","C","R","R","R","R"));
$body = array("","Totales: ",
    number_format($totsini,2, '.', ','),
    number_format($totdebe,2, '.', ','),
    number_format($tothaber,2, '.', ','),
    number_format($totsact,2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+7.5, $pdf->GetY(), 20.5, $pdf->GetY());
$pdf->line($pdf->GetX()+7.5, $pdf->GetY()+.075, 20.5, $pdf->GetY()+.075);

$db->close();

$pdf->Output(utf8_decode("Consolidado de Saldos").".pdf","I");
?>