<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];
$txtBene=$_GET["txtBene"];

$lineWidth=19.3;
$lineHeight=0.50;

# QUERYS
$sMovAcu= "SELECT *,
           TRIM(ma.ma_bene) AS ma_bene,
           TRIM(ma.ma_con) AS ma_con,
           TRIM(ban.ban_nom) AS ban_nom,
           TRIM(tp.tp_nom) AS tp_nom,
           TRIM(tp.tp_abrev) AS tp_abrev 
           FROM mov_acu AS ma 
           LEFT JOIN bancos AS ban ON ma.ma_emp=ban.ban_emp AND ma.ma_ban=ban.ban_num
           LEFT JOIN tipopol AS tp ON ma.ma_tipo=tp.tp_cod 
           WHERE ma_emp='$empCod' AND ma_tipo='004' AND ma_bene LIKE '%$txtBene%' AND ma_fec>='$dtFecI' AND ma_fec<='$dtFecF' ORDER BY ma_emp,ma_ban,ma_fec,ma_tipo";

# EJECUCION DE QUERYS
$db = new dbExec();

$Saldo=0;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth,$dtFecI, $dtFecF, $txtBene;
        $func = new functions();
        $this->SetMargins(1.35, 1, 1.35);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, $empNom,0,1,"L");
        $this->SetFont("","I",8);
        $this->SetY(.6);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","B",10);
        $this->Cell($lineWidth, $lineHeight, utf8_decode("LISTADO DE DOCUMENTOS DEL ".strftime("%d/%m/%Y", strtotime($dtFecI))." AL ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"L");
        $this->Cell($lineWidth, $lineHeight, utf8_decode("CRITERIO DE BUSQUEDA: ".$txtBene),0,1,"L");
        $this->SetFont("","B",8);        
        $header = array("Cuenta","Tipo","Numero","Fecha","Beneficiario","Concepto","Monto");
        $this->SetFont("","B");
        $this->SetWidths(array(3,.8,2,1.8,6.5,8.5,2.5));
        $this->SetAligns(array("C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("", "", 8);
        $this->SetAligns(array("L","L","L","L","L","L","R"));

    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# GENERAR PDF
$pdf = new generatePDF("L","cm", array(22, 28));
$pdf->AddPage();

$totMonto = 0;

$select["mov_acu"] = $db->query($sMovAcu);
while ($rec = $db->fetchAssoc($select['mov_acu'])) {
    $totMonto=$totMonto+($rec["ma_debe"]+$rec["ma_haber"]);
    $body = array(
        TRIM($rec["ban_nom"]),
        $rec["tp_abrev"],
        $rec["ma_num"],
        strftime("%d/%m/%Y", strtotime($rec["ma_fec"])),
        TRIM($rec["ma_bene"]),
        TRIM($rec["ma_con"]),
        number_format($rec["ma_debe"]+$rec["ma_haber"],2, '.', ','),
        );
     $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->Ln($lineHeight);

$pdf->line($pdf->GetX()+20, $pdf->GetY(), 26.5, $pdf->GetY());

$pdf->SetAligns(array("","","","","","R","R"));
$body = array("","","","","","Total: ",
    number_format($totMonto,2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+20, $pdf->GetY(), 26.5, $pdf->GetY());
$pdf->line($pdf->GetX()+20, $pdf->GetY()+.075, 26.5, $pdf->GetY()+.075);

$db->close();

$pdf->Output(utf8_decode("Reporte segun Beneficiario").".pdf","I");
?>