<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];
$txtTitulo=$_GET["txtTitulo"];
$numHoja=$_GET["numHoja"];
$cbFecsn=$_GET["cbFecsn"];
$cbNoFol=$_GET["cbNoFol"];

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecI, $dtFecF,$txtTitulo,$numHoja,$cbFecsn,$cbNoFol;
        $func = new functions();
        $this->SetMargins(2.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, $empNom,0,1,"C");
        $this->SetFont("Arial","B",9);        
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($txtTitulo." Del ".strftime("%d/%m/%Y", strtotime($dtFecI))." Al ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"C");
        if ($func->stringToBool($cbNoFol)) {
            $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Folio: ".((string)($this->PageNo())+$numHoja)),0,1,"R");
        }
        $this->Ln();
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}

# QUERYS
$sPoliDet = "SELECT *,
                TRIM(pd.pold_cta) AS pold_cta,
                TRIM(pd.pold_ctan) AS pold_ctan,
                TRIM(p.pol_con) AS pol_con,
                trim(tp.tp_nom) AS tp_nom,
                SUM(pold_debe) AS pold_sdebe,
                SUM(pold_haber) AS pold_shaber
            FROM poli_det pd LEFT JOIN polizas p ON pd.pold_emp=p.pol_emp AND pd.pold_ban=p.pol_ban AND pd.pold_tipo=p.pol_tipo AND pd.pold_fec=p.pol_fec AND pd.pold_num=p.pol_num AND pd.pold_tipoi=p.pol_tipoi AND pd.pold_nit=p.pol_nit LEFT JOIN tipopol tp ON pd.pold_tipo=tp.tp_cod WHERE pd.pold_emp='$empCod' AND pd.pold_fec>='$dtFecI' AND pd.pold_fec<='$dtFecF' GROUP BY pd.pold_tipo, pd.pold_cta";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["poli_det"]=$db->query($sPoliDet);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$totDebe = 0;
$totHaber = 0;

$tipot="";
$debe = 0;
$haber = 0;
$linea=1;
while ($recTbl = $db->fetchAssoc($select['poli_det'])) {
    if ($recTbl["pold_tipo"]!=$tipot) {

        if ($linea!=1) {
            $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->SetAligns(array("","R","R","R"));
            $body = array(
                "",
                "Total Este Documento: ",
                number_format($debe,2),
                number_format($haber,2),
            );
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
            $debe = 0;
            $haber = 0;
            $pdf->Ln();
        }

        $pdf->SetFont("","B",8);
        $pdf->Cell($lineWidth/8, $lineHeight, utf8_decode("Tipo Poliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/5, $lineHeight, $recTbl["tp_nom"]);

        $pdf->SetFont("","B",8);
        $pdf->Cell($lineWidth/3, $lineHeight, utf8_decode("Número de Póliza: 99999999"));

        $pdf->SetFont("","B");
        $pdf->Cell($lineWidth/6, $lineHeight, utf8_decode("Fecha de Póliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($dtFecF)),0,1);

        $pdf->SetFont("","B");
        $pdf->Cell($lineWidth/8, $lineHeight, "Concepto: RESUMEN DEL MOVIMIENTO");
        $pdf->SetFont("");
        $pdf->Ln();

        $header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
        $pdf->SetFont("","B");
        $pdf->SetWidths(array(3,8,3,3));
        $pdf->SetAligns(array("C","C","C","C"));
        $pdf->Row($header, $lineHeight);

        $pdf->SetFont("");
        $pdf->SetAligns(array("L","L","R","R"));
        $tipot=$recTbl["pold_tipo"];
        $linea=2;
    }

    $debe += $recTbl["pold_sdebe"];
    $haber += $recTbl["pold_shaber"];
    $totDebe += $recTbl["pold_sdebe"];
    $totHaber += $recTbl["pold_shaber"];
    $body = array(
        $recTbl["pold_cta"],
        $recTbl["pold_ctan"],
        ($recTbl["pold_sdebe"] != 0) ? number_format($recTbl["pold_sdebe"],2) : "",
        ($recTbl["pold_shaber"] != 0) ? number_format($recTbl["pold_shaber"],2) : "",
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->SetAligns(array("","R","R","R"));
$body = array(
        "",
        "Total Este Documento: ",
        number_format($debe,2),
        number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
$pdf->Ln();


$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales Generales: ",
    number_format($totDebe,2),
    number_format($totHaber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

$db->close();

$pdf->Output(utf8_decode("Libro Diario Resumido").".pdf","I");
?>