<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

# Para jalar año de la variable que sea tipo fecha
$AnoTrab=date("Y", strtotime($_SESSION['empFtrab']));
$TipoPol="099";

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecI, $dtFecF,$txtTitulo,$numHoja,$cbFecsn,$cbNoFol,$AnoTrab;
        $func = new functions();
        $this->SetMargins(2.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, $empNom,0,1,"C");
        $this->SetFont("Arial","B",9);        
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("POLIZAS DE CIERRE CORRESPONDIENTES A ").((string)($AnoTrab)),0,1,"C");

        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Hoja: ".((string)($this->PageNo()))),0,1,"R");
        $this->Ln();
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}

# QUERYS
$sPoliFin = "SELECT *,
            TRIM(pf.polf_cta) AS polf_cta,
            TRIM(pf.polf_ctan) AS polf_ctan,
            TRIM(pf.polf_con) AS polf_con,
            trim(tp.tp_nom) AS tp_nom
            FROM polifin pf LEFT JOIN tipopol tp ON pf.polf_tipo=tp.tp_cod WHERE polf_emp='$empCod' AND polf_ano='$AnoTrab'";

$uPoliFin = "UPDATE polifin SET polf_stat='I' WHERE polf_emp='$empCod' AND polf_ano='$AnoTrab'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["polifin"]=$db->query($sPoliFin);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$totDebe = 0;
$totHaber = 0;

$tipot="";
$numt=0;
$debe = 0;
$haber = 0;
$linea=1;
while ($rec = $db->fetchAssoc($select['polifin'])) {
    if (($rec["polf_tipo"]!=$tipot) || ($rec["polf_num"]!=$numt)) {

        if ($linea!=1) {
            $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->SetAligns(array("","R","R","R"));
            $body = array(
                "",
                "Total Este Documento: ",
                number_format($debe,2),
                number_format($haber,2),
            );
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
            $debe = 0;
            $haber = 0;
            $pdf->Ln();
        }

        $pdf->SetFont("","B",8);
        $pdf->Cell($lineWidth/8, $lineHeight, utf8_decode("Tipo Poliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/6, $lineHeight, $rec["tp_nom"]);

        $pdf->SetFont("","B",8);
        $pdf->Cell($lineWidth/6, $lineHeight, utf8_decode("Número de Póliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/6, $lineHeight, $rec["polf_tipo"]."-".$rec["polf_num"]);

        $pdf->SetFont("","B");
        $pdf->Cell($lineWidth/6, $lineHeight, utf8_decode("Fecha de Póliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/5, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["polf_fec"])),0,1);

        $pdf->SetFont("","B");
        $pdf->Cell($lineWidth/8, $lineHeight, "Concepto: ");
        $pdf->SetFont("");
        $pdf->MultiCell($lineWidth/1.35, $lineHeight, $rec["polf_con"]);
        $pdf->Ln($lineHeight*3);

        $header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
        $pdf->SetFont("","B");
        $pdf->SetWidths(array(3,8,3,3));
        $pdf->SetAligns(array("C","C","C","C"));
        $pdf->Row($header, $lineHeight);

        $pdf->SetFont("");
        $pdf->SetAligns(array("L","L","R","R"));
        $debe = 0;
        $haber = 0;

        $tipot=$rec["polf_tipo"];
        $numt=$rec["polf_num"];
        $linea=2;
    }

    $debe += $rec["polf_debe"];
    $haber += $rec["polf_haber"];
    $totDebe += $rec["polf_debe"];
    $totHaber += $rec["polf_haber"];
    $body = array(
        $rec["polf_cta"],
        $rec["polf_ctan"],
        ($rec["polf_debe"] != 0) ? number_format($rec["polf_debe"],2) : "",
        ($rec["polf_haber"] != 0) ? number_format($rec["polf_haber"],2) : "",
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->SetAligns(array("","R","R","R"));
$body = array(
        "",
        "Total Este Documento: ",
        number_format($debe,2),
        number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
$pdf->Ln();


$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales Generales: ",
    number_format($totDebe,2),
    number_format($totHaber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

# Para poner status de impreso en la poliza de cierre
$db->query($uPoliFin);

$db->close();

$pdf->Output(utf8_decode("Polizas de Cierre").".pdf","I");
?>