<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$numNum=$_GET["numNum"];
$selTipoCod=$_GET["selTipoCod"];
$selBanCod=$_GET["selBanCod"];
$dtFec=$_GET["dtFec"];
$txtCon=$_GET["txtCon"];
$jsonPol=json_decode($_GET['tblPol']);
$dtGrabado=(empty($_GET["dtGrabado"])) ? strftime("%d/%m/%Y %T") : $_GET["dtGrabado"];
$btn=utf8_decode($_GET["btn"]);

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineWidth, $lineHeight, $selTipoCod, $numNum,$dtFec,$txtCon;
        $this->SetMargins(2.5, 1, 2.5);

        $this->SetFont("Arial","",20);
        $this->Cell(0, 0, "", 0, 1);

        $this->Cell(20,.7,$empNom,0,1,"L");
        $this->Ln();
        $this->SetFont("","B",10);
        $this->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Número de Póliza: "));
        $this->SetFont("");
        $this->MultiAlignCell($lineWidth/2, $lineHeight, $selTipoCod."-".$numNum);

        $this->SetFont("","B");
        $this->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Fecha de Póliza: "));
        $this->SetFont("");
        $this->MultiAlignCell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($dtFec)));
        $this->Ln($lineHeight*2);

        $this->SetFont("","B");
        $this->MultiAlignCell($lineWidth/8, $lineHeight, "Concepto: ");
        $this->SetFont("");
        $this->MultiAlignCell($lineWidth/1.35, $lineHeight, utf8_decode($txtCon));
        $this->Ln($lineHeight*3);


        $header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
        $this->SetFont("","B");
        $this->SetWidths(array(3,8,3,3));
        $this->SetAligns(array("C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","R","R"));


    }
    
    function Footer() {
        global $btn, $dtGrabado;
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,0,"C");
        $this->Ln(.5);
        $this->Cell(0,1,$btn." ".$dtGrabado,0,0,"C");
    }
}

# QUERYS
$sPolizas = "SELECT * FROM polizas WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";
$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_fec='$dtFec' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["polizas"] = $db->query($sPolizas);
$select["poli_det"] = $db->query($sPoli_det);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();



$debe = 0;
$haber = 0;
while ($recd = $db->fetchAssoc($select["poli_det"])) {
    $debe += $recd["pold_debe"];
    $haber += $recd["pold_haber"];
    $body = array(
        $recd["pold_cta"],
        $recd["pold_ctan"],
        ($recd["pold_debe"] != 0) ? number_format($recd["pold_debe"],2) : "",
        ($recd["pold_haber"] != 0) ? number_format($recd["pold_haber"],2) : "",
    );
    $pdf->RowBorderLR($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales: ",
    number_format($debe,2),
    number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->Ln($lineHeight*6);
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Hecho por", "T", 0, "C");
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Revisado por", "T", 0, "C");

$pdf->Output(utf8_decode("Póliza ").$selTipoCod."-".$numNum.".pdf","I");
?>