<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selClasi=$_GET["selClasi"];
$dtFec=$_GET["dtFec"];
$crTmone=$_GET["crTmone"];
if ($crTmone == 'L') {
    $tipomon=$empMoneda;
} else {
    $tipomon='DOLARES';
}   

# QUERYS
if ($selClasi=='000') {
    $sDoctoscc = "SELECT *, TRIM(dc_clien) AS dc_clien, TRIM(dc_codp) AS dc_codp, TRIM(dc_nit) AS dc_nit, (dc_tot-(dc_abo+dc_ret+dc_reti)) AS dc_saldod, TRIM(cl.cli_clas) AS dc_clas, TRIM(cla.cla_nom) AS cla_nom FROM doctoscc dc 
        LEFT JOIN cliencc cl ON dc.dc_emp=cl.cli_emp and dc.dc_codp=cl.cli_cod 
        LEFT JOIN clasic cla ON cl.cli_clas=cla.cla_cod
        WHERE dc_emp='$empCod' and dc_fecp<='$dtFec' and (dc_tot-(dc_abo+dc_ret+dc_reti))>0 ORDER BY cli_clas,cli_nom,dc_fec";
} else {
    $sDoctoscc = "SELECT *, TRIM(dc_clien) AS dc_clien, TRIM(dc_codp) AS dc_codp, TRIM(dc_nit) AS dc_nit, (dc_tot-(dc_abo+dc_ret+dc_reti)) AS dc_saldod, TRIM(cl.cli_clas) AS dc_clas, TRIM(cla.cla_nom) AS cla_nom FROM doctoscc dc 
        LEFT JOIN cliencc cl ON dc.dc_emp=cl.cli_emp and dc.dc_codp=cl.cli_cod 
        LEFT JOIN clasic cla ON cl.cli_clas=cla.cla_cod
        WHERE dc_emp='$empCod' and dc_fecp<='$dtFec' and (dc_tot-(dc_abo+dc_ret+dc_reti))>0 and cli_clas='$selClasi' ORDER BY cli_clas,cli_nom,dc_fec";
}    
# EJECUCION DE QUERYS
$db = new dbExec();
$select["doctoscc"] = $db->query($sDoctoscc);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['vencidoscc']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['vencidoscc'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "LISTADO DE DOCUMENTOS VENCIDOS CxC AL ".strftime("%d/%m/%Y", strtotime($dtFec)))
            ->setCellValueByColumnAndRow($i, 3, "CIFRAS EXPRESADAS EN ".$tipomon)
            ->setCellValueByColumnAndRow($i++, $j, 'SERIE')
            ->setCellValueByColumnAndRow($i++, $j, 'NUMERO')
            ->setCellValueByColumnAndRow($i++, $j, 'FECHA/DOC.')
            ->setCellValueByColumnAndRow($i++, $j, 'FECHA/VENCE')
            ->setCellValueByColumnAndRow($i++, $j, '   TOTAL')
            ->setCellValueByColumnAndRow($i++, $j, '     ABONOS')
            ->setCellValueByColumnAndRow($i++, $j, '     SALDO');

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->mergeCells('A1:G1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:G2')->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A3:G3')->getStyle('A3')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A5:G5')->applyFromArray($styEncabezado);

$ti_clasi="XXXZZZ999";
$subtot=0;
$subabo=0;
$subsal=0;
$subtotg=0;
$subabog=0;
$subsalg=0;
$tottot=0;
$totabo=0;
$totsal=0;
$t_lini=1;
$codp="";
$ti_codp="XXZZZ999";
$nomp="";
$clas="";
$clasnom="";

$j=6;
$inigru=6;
$iniprov=6;
while ($rec = $db->fetchAssoc($select["doctoscc"])) {
    if ($t_lini == 1) {
        $codp=$rec["dc_codp"];
        $nomp=$rec["cli_nom"];
        $clas=$rec["cli_clas"];
        $clasnom=$rec["cla_nom"];
        $iniprov=6;
        $inigru=6;
        //$t_lini=2;
    }
    if ($ti_codp!=$rec["dc_codp"]) {
        if ($t_lini > 1) {
            $i=$iIni;
           $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "    SUBTOTAL DE ESTE CLIENTE")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "") 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$iniprov.':E'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$iniprov.':F'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$iniprov.':G'.($j-1).')');
            $objPHPExcel->getActiveSheet()->getStyle('E'.$j.':G'.$j)->applyFromArray($styEncabezado);
            $j+=1;
        }             
        $subtot=0;
        $subabo=0;
        $subsal=0;
        $codp=$rec["dc_codp"];
        $ti_codp=$rec["dc_codp"];
        $nomp=$rec["cli_nom"];
        if ($ti_clasi!=$rec["cli_clas"]) {
            if ($t_lini > 1) {
                $i=$iIni;
                $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "    SUBTOTAL DE ESTE GRUPO")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "") 
                ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B'.$inigru.':B'.($j-1).',"    SUBTOTAL DE ESTE CLIENTE",E'.$inigru.':E'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B'.$inigru.':B'.($j-1).',"    SUBTOTAL DE ESTE CLIENTE",F'.$inigru.':F'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B'.$inigru.':B'.($j-1).',"    SUBTOTAL DE ESTE CLIENTE",G'.$inigru.':G'.($j-1).')');
                $objPHPExcel->getActiveSheet()->getStyle('E'.$j.':G'.$j)->applyFromArray($styEncabezado);
                $j+=2;
                $subtotg=0;
                $subabog=0;
                $subsalg=0;
            }
            $clas=$rec["cli_clas"];
            $clasnom=$rec["cla_nom"];
            $ti_clasi=$rec["cli_clas"];
            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "GRUPO: ".$clasnom); 
            $inigru=$j;
            $j+=1;
        }

        $i=$iIni;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($i++, $j, $codp."-".utf8_encode($nomp));
        $j+=1;
        $t_lini=2;
        $iniprov=$j;
    } 

    $codp=$rec["dc_codp"];
    $clas=$rec["cli_clas"];
    $seried=$rec["dc_serie"];
    $numd=$rec["dc_num"];
    $fec=$rec["dc_fec"];
    $fecp=$rec["dc_fecp"];
    $tcam=$rec["dc_tcam"];
    $tot=$rec["dc_tot"];
    $abo=$rec["dc_abo"]+$rec["dc_ret"]+$rec["dc_reti"];
    $saldod=$rec["dc_saldod"];
    if ($saldod>0) {
        if ($crTmone == 'L' && $tcam>1) {
            $saldod=round($saldod*$tcam,2);
        }
        if ($crTmone == 'E' && $tcam == 1) {
            $saldod=round($saldod/$empTcam,2);
        }
    }
    // Para saber cuantos dias
    $diff=$func->dateDiff($dtFec, $fecp);
    $dias=($diff->invert == 1) ? '-'.$diff->days : $diff->days;

    $subtot += $tot;
    $subabo += $abo;
    $subsal += $saldod;

    $subtotg += $tot;
    $subabog += $abo;
    $subsalg += $saldod;

    $tottot += $tot;
    $totabo += $abo;
    $totsal += $saldod;
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, $rec["dc_serie"])
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["dc_num"]))
                ->setCellValueByColumnAndRow($i++, $j, strftime("%d/%m/%Y", strtotime($fec)))
                ->setCellValueByColumnAndRow($i++, $j, strftime("%d/%m/%Y", strtotime($fecp)))
                ->setCellValueByColumnAndRow($i++, $j, $tot)
                ->setCellValueByColumnAndRow($i++, $j, $abo)
                ->setCellValueByColumnAndRow($i++, $j, $saldod);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styLineas);
    $j+=1;
}


$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    SUBTOTAL DE ESTE CLIENTE")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$iniprov.':E'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$iniprov.':F'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$iniprov.':G'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('E'.$j.':G'.$j)->applyFromArray($styEncabezado);
$j+=1;

$i=$iIni;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($i++, $j, "")
	->setCellValueByColumnAndRow($i++, $j, "    SUBTOTAL DE ESTE GRUPO")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B'.$inigru.':B'.($j-1).',"    SUBTOTAL DE ESTE CLIENTE",E'.$inigru.':E'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B'.$inigru.':B'.($j-1).',"    SUBTOTAL DE ESTE CLIENTE",F'.$inigru.':F'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B'.$inigru.':B'.($j-1).',"    SUBTOTAL DE ESTE CLIENTE",G'.$inigru.':G'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('E'.$j.':G'.$j)->applyFromArray($styEncabezado); 

$i=$iIni;
$j+=1;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($i++, $j, "")
	->setCellValueByColumnAndRow($i++, $j, "    TOTAL GENERAL")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    SUBTOTAL DE ESTE GRUPO",E6:E'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    SUBTOTAL DE ESTE GRUPO",F6:F'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    SUBTOTAL DE ESTE GRUPO",G6:G'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('E'.$j.':G'.$j)->applyFromArray($styEncabezado);


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);

$objPHPExcel->getActiveSheet()->getStyle('E6'.':G'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':B'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['vencidoscc'])->setTitle('vencidoscc');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="vencidoscc.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>