<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selTipoa=$_GET["selTipoa"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$crTmone=$_GET["crTmone"];
if ($crTmone == 'L') {
    $tipomon=$empMoneda;
} else {
    $tipomon='DOLARES';
}   

# QUERYS
if ($crTmone=='L') {
    if ($selTipoa=='000') {
        $sAbonosc = "SELECT *, TRIM(cl.cli_nom) AS cli_nom, TRIM(abo.abo_codp) AS abo_codp, TRIM(abo.abo_con) AS abo_con, TRIM(ta.ta_nom) AS ta_nom
           FROM abo_detc abd LEFT JOIN cliencc cl ON abd.abd_emp=cl.cli_emp and abd.abd_codp=cl.cli_cod 
           LEFT JOIN abonosc abo ON abd.abd_emp=abo.abo_emp and abd.abd_tipo=abo.abo_tipo and abd.abd_num=abo.abo_num 
           LEFT JOIN tipoaboc ta ON  abd.abd_tipo=ta.ta_cod 
           WHERE abd_emp='$empCod' and abd_fec>='$dtFeci' and abd_fec<='$dtFecf' and abo_tcam=1 and abd_abop>0 ORDER BY abd_fec,abd_tipo,abd_num";
    } else {
        $sAbonosc = "SELECT *, TRIM(cl.cli_nom) AS cli_nom, TRIM(abo.abo_codp) AS abo_codp, TRIM(abo.abo_con) AS abo_con, TRIM(ta.ta_nom) AS ta_nom
           FROM abo_detc abd LEFT JOIN cliencc cl ON abd.abd_emp=cl.cli_emp and abd.abd_codp=cl.cli_cod 
           LEFT JOIN abonosc abo ON abd.abd_emp=abo.abo_emp and abd.abd_tipo=abo.abo_tipo and abd.abd_num=abo.abo_num 
           LEFT JOIN tipoaboc ta ON  abd.abd_tipo=ta.ta_cod 
           WHERE abd_emp='$empCod' and abd_tipo='$selTipoa' and abd_fec>='$dtFeci' and abd_fec<='$dtFecf' and abo_tcam=1 and abd_abop>0 ORDER BY abd_fec,abd_tipo,abd_num";
    }           
} else {
    if ($selTipoa=='000') {
        $sAbonosc = "SELECT *, TRIM(cl.cli_nom) AS cli_nom, TRIM(abo.abo_codp) AS abo_codp, TRIM(abo.abo_con) AS abo_con, TRIM(ta.ta_nom) AS ta_nom
           FROM abo_detc abd LEFT JOIN cliencc cl ON abd.abd_emp=cl.cli_emp and abd.abd_codp=cl.cli_cod 
           LEFT JOIN abonosc abo ON abd.abd_emp=abo.abo_emp and abd.abd_tipo=abo.abo_tipo and abd.abd_num=abo.abo_num 
           LEFT JOIN tipoaboc ta ON  abd.abd_tipo=ta.ta_cod 
           WHERE abd_emp='$empCod' and abd_fec>='$dtFeci' and abd_fec<='$dtFecf' and abo_tcam>1 and abd_abop>0 ORDER BY abd_fec,abd_tipo,abd_num";
    } else {
        $sAbonosc = "SELECT *, TRIM(cl.cli_nom) AS cli_nom, TRIM(abo.abo_codp) AS abo_codp, TRIM(abo.abo_con) AS abo_con, TRIM(ta.ta_nom) AS ta_nom
           FROM abo_detc abd LEFT JOIN cliencc cl ON abd.abd_emp=cl.cli_emp and abd.abd_codp=cl.cli_cod 
           LEFT JOIN abonosc abo ON abd.abd_emp=abo.abo_emp and abd.abd_tipo=abo.abo_tipo and abd.abd_num=abo.abo_num 
           LEFT JOIN tipoaboc ta ON  abd.abd_tipo=ta.ta_cod 
           WHERE abd_emp='$empCod' and abd_tipo='$selTipoa' and abd_fec>='$dtFeci' and abd_fec<='$dtFecf' and abo_tcam>1 and abd_abop>0 ORDER BY abd_fec,abd_tipo,abd_num";
    }           
}    
# EJECUCION DE QUERYS
$db = new dbExec();
$select["abo_detc"] = $db->query($sAbonosc);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['abonos']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['abonos'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "LISTADO DE OTROS DOCUMENTOS DE ABONO CxC DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf)))
            ->setCellValueByColumnAndRow($i, 3, "DOCUMENTOS REGISTRADOS EN ".$tipomon);

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->mergeCells('A1:D1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:D2')->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A3:D3')->getStyle('A3')->applyFromArray($styEmp);
//$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($styEncabezado);

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$j=6;
$inidoc=6;
$iniprov=6;
while ($rec = $db->fetchAssoc($select["abo_detc"])) {
    if ($t_lini == 1) {
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, "TIPO DE DOCUMENTO: ".utf8_encode($rec["ta_nom"])."         NUMERO:  ".$rec["abd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["abd_fec"])));
        $j+=1;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_encode("CLIENTE:   ".$rec["abd_codp"]." - ".$rec["cli_nom"]));
        $j+=1;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, "TASA DE CAMBIO : ".$rec["abo_tcam"]);
        $j+=1;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_encode("CONCEPTO: ".$rec["abo_con"]));
        $j+=1;

        $i=$iIni;
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, 'SERIE CARGO')
                    ->setCellValueByColumnAndRow($i++, $j, 'NUMERO CARGO')
                    ->setCellValueByColumnAndRow($i++, $j, 'FECHA/CARGO')
                    ->setCellValueByColumnAndRow($i++, $j, '  ABONO APLICADO');
        $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':D'.$j)->applyFromArray($styEncabezado); 
        $j+=1;
        $inidoc=6;
    }
    if ($ti_tipo!=$rec["abd_tipo"]  || $ti_num!=$rec["abd_num"]) {
        if ($t_lini > 1) {
            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE DOCUMENTO")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidoc.':D'.($j-1).')');
            $objPHPExcel->getActiveSheet()->getStyle('D'.$j.':D'.$j)->applyFromArray($styEncabezado); 
            $j+=2;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, "TIPO DE DOCUMENTO: ".utf8_encode($rec["ta_nom"])."         NUMERO:  ".$rec["abd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["abd_fec"])));
            $j+=1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, utf8_encode("CLIENTE:   ".$rec["abd_codp"]." - ".$rec["cli_nom"]));
            $j+=1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, "TASA DE CAMBIO : ".$rec["abo_tcam"]);
            $j+=1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, utf8_encode("CONCEPTO: ".$rec["abo_con"]));
            $j+=1;

            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($i++, $j, 'SERIE CARGO')
                        ->setCellValueByColumnAndRow($i++, $j, 'NUMERO CARGO')
                        ->setCellValueByColumnAndRow($i++, $j, 'FECHA/CARGO')
                        ->setCellValueByColumnAndRow($i++, $j, '  ABONO APLICADO');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':D'.$j)->applyFromArray($styEncabezado);
            $j+=1;
            $inidoc=$j;
        }             
        $subtot=0;
        $ti_tipo=$rec["abd_tipo"];
        $ti_num=$rec["abd_num"];
        $t_lini=2;
    } 
    $subtot += $rec["abd_abop"];
    $tottot += $rec["abd_abop"];

    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, $rec["abd_seriec"])
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["abd_numc"]))
                ->setCellValueByColumnAndRow($i++, $j, strftime("%d/%m/%Y", strtotime($rec["abd_feccd"])))
                ->setCellValueByColumnAndRow($i++, $j, $rec["abd_abop"]);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':D'.$j)->applyFromArray($styLineas);
    $j+=1;
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE DOCUMENTO")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidoc.':D'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':D'.$j)->applyFromArray($styEncabezado); 
$j+=2;
$i=$iIni;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL GENERAL") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    TOTAL ESTE DOCUMENTO",D6:D'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':D'.$j)->applyFromArray($styEncabezado);


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);

$objPHPExcel->getActiveSheet()->getStyle('D6'.':D'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':B'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['abonos'])->setTitle('Otros Abonos');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ListaOabonoscc.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>