<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sTipoaboc = "SELECT ta.*, TRIM(ta.ta_nom) AS ta_nom,
            TRIM(ta.ta_trela) AS ta_trela,
            TRIM(tv.tv_nom) AS ta_trelanom
            FROM tipoaboc as ta
            LEFT JOIN tipov tv ON ta.ta_trela = tv.tv_cod ORDER BY ta_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["tipoaboc"] = $db->query($sTipoaboc);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",12);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.5;

$pdf->SetFont("","",9);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Tipos de Documentos de Abono CxC"));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight*2);

$header = array("Codigo","Nombre del Tipo","Relacionado","Afe/Comp","Partida","Otros/Doc.");
$pdf->SetFont("","B");
$pdf->SetWidths(array(2,6,3,2,2,2));
$pdf->SetAligns(array("C","C","C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","L","C","C","C"));

while ($rec = $db->fetchAssoc($select["tipoaboc"])) {
    $body = array(
        $rec["ta_cod"],
        trim($rec["ta_nom"]),
        trim($rec["ta_trelanom"]),
        trim($rec["ta_afe"]),
        trim($rec["ta_partsn"]),
        trim($rec["ta_otros"]),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Listado de Tipos de Abonos CxC").".pdf","I");
?>