<?php 
include_once('../../../php/sessionStart.php'); 
include_once('../../../php/db/dbExec.php');
include_once('../ws/BANGUAT/wsExec.php');

# QUERYS
$sTipov = "SELECT * FROM tipov WHERE tv_fel='S' AND tv_cod LIKE 'F%'";
$sMeses = "SELECT * FROM meses";
$sBancos = "SELECT * FROM bancos WHERE ban_emp='".$_SESSION['empCod']."'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["tipov"] = $db->query($sTipov);
$select["meses"] = $db->query($sMeses);
$select["bancos"] = $db->query($sBancos);
$db->close();

$anoTrab=date("Y", strtotime($_SESSION['empFtrab']));
$mesTrab=date("m", strtotime($_SESSION['empFtrab']));

$wsBANGUAT = new wsBANGUATExec();
$tcam = 0;
foreach ($wsBANGUAT->sEx() as $Body) {
  $tcam = $Body->TipoCambioDiaResponse->TipoCambioDiaResult->CambioDolar->VarDolar->referencia;
}
?>
<?php include_once('../includes/htmlOpen.php'); ?>
    <style type="text/css">
      /* TAMAÑO PERSONALIZADO PARA TABLA DE ESTE FORMULARIO */
      .table th,
      .table td {
        padding: 0 .3em 0 .3em;
        font-size: 12px;
      }
    </style>
    <main class="main" style="">
      <?php 
        $li[0] = '<i class="fas fa-file-invoice"></i>';
        $li[1] = $_GET["opcNom"];
        include_once('../../../php/includes/ol.php');
      ?>

      <div class="container-as">
        <div class="row">
          <div class="col">
            <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" id="pills-0-tab" data-toggle="pill" href="#pills-0" role="tab" aria-controls="pills-0" aria-selected="true">Mantenimiento</a>
              </li>
            </ul>
            <div class="tab-content bg-transparent border-0" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-0" role="tabpanel" aria-labelledby="pills-0-tab">

                <form action="" name="thisform" autocomplete="off" enctype="multipart/form-data">
                  <div class="form-row">
                    <div class="col-12 col-sm-9">
                      <div class="form-group">

                        <div class="form-row align-items-end">
                          <div class="col-12 col-md-6">
                            <label for="selMes">Mes a Reportar</label>
                            <select class="form-control form-control-sm form-control-as" name="selMes" id="selMes">
                              <?php
                                while ($rec = $db->fetchAssoc($select['meses'])) {
                                  $mesNom = utf8_encode($rec['mes_nom']);
                                  echo  "<option value={$rec['mes_cod']}>{$mesNom}</option>";
                                }
                              ?>
                            </select>
                          </div>
                          <div class="col-6 col-md-3">
                            <label for="numAno">Año a Reportar</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="numAno" placeholder="AAAA">
                          </div>
                          <div class="col-6 col-md-3">
                            <label for="selTipo">Tipo</label>
                            <select class="form-control form-control-sm form-control-as" name="selTipo" id="selTipo">
                              <?php
                                while ($rec = $db->fetchAssoc($select['tipov'])) {
                                  echo  "<option value={$rec['tv_cod']} data-impues={$rec['tv_impues']} data-pone={$rec['tv_pone']}>".utf8_encode($rec['tv_abrev']).'</option>';
                                }
                              ?>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="form-group">
                        <div class="form-row align-items-center">
                          <div class="col-6">
                            <button type="button" class="btn btn-secondary" id="btnGenerar">
                              <i class="fas fa-tasks"></i> Generar Facturas
                            </button>
                          </div>
                          <div class="col-6 text-right">
                            <label class="custom-checkbox-container pr-4">Seleccionar Todos
                              <input type="checkbox" id="cbTodos" name="cb" checked="checked">
                              <span class="checkmark"></span>
                            </label>
                          </div>
                          <div class="col-12 col-md-3"></div>
                          <div class="col-12 col-md-6">
                            <label for="txtFiltrar"></label>
                            <div class="input-group input-group-sm mb-3">
                              <div class="input-group-prepend">
                                <span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-search" aria-label="small"></i></span>
                              </div>
                              <input type="text" class="form-control" aria-label="small" aria-describedby="inputGroup-sizing-sm" placeholder="Filtrar.." id="txtFiltrar">
                            </div>
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-md-12">
                            <div class="table-responsive">
                              <table class="table table-hover table-bordered table-dark" id="tblFac">
                                <thead>
                                  <tr>
                                    <th scope="col" class="text-center" width="90">Código</th>
                                    <th scope="col" class="text-center">Nombre para la factura</th>
                                    <th scope="col" class="text-center" width="50">Quetzales</th>
                                    <th scope="col" class="text-center" width="50">Dólares</th>
                                    <th scope="col" class="text-center" width="50">Seleccionar</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                                <tfoot>
                                  <tr>
                                    <th scope="col"></th>
                                    <th scope="col" class="text-right">Total General<br>Total Mercado</th>
                                    <th scope="col" class="text-right">
                                      <span id="dataTtotQ">0.00</span><br>
                                      <span id="dataTtotQM">0.00</span>
                                    </th>
                                    <th scope="col" class="text-right">
                                      <span id="dataTtotD">0.00</span><br>
                                      <span id="dataTtotDM">0.00</span>
                                    </th>
                                    <th scope="col"></th>
                                  </tr>
                                </tfoot>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-12 col-sm-3">
                      <div class="form-group position-fixed-md m-md-10">

                        <div class="form-row align-items-end">
                          <div class="col-6 col-sm-12">
                            <label for="dtFec">Fecha del Documento</label>
                            <input type="date" class="form-control form-control-sm form-control-as form-info" id="dtFec" placeholder="" disabled>
                          </div>
                          <div class="col-6 col-sm-12">
                            <label for="numTcam">Tipo de Cambio <span style="font-size: 12px">(Banco de Guatemala)</span></label>
                            <input type="number" class="form-control form-control-sm form-control-as form-info dec-5 pl-3" id="numTcam" placeholder="0.00000" disabled>
                          </div>
                        </div>

                        <div class="form-row">
                          <div class="col-12 mt-2">
                            <button class="btn btn-success btn-block" id="btnGuardar" type="button">Guardar</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-info btn-block" id="btnVistaPrevia" type="button">Vista Previa</button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>

              </div>

              <div class="tab-pane fade" id="pills-1" role="tabpanel" aria-labelledby="pills-1-tab">
                <?php
                  $a='0';
                  $b='1';
                  include('../busClien/index.html')
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
<?php include_once('../../../php/includes/htmlClose.php'); ?>

<script>
  var pressEnter = false;
  var nuevo = true;
  var fecAnt = "0000-00-00";

  colFac = ["cod", "nom", "totQ", "totD", "stat", "tipo", "totLetras"];

  const txtSerie = document.thisform.txtSerie;
  const dtFec = document.thisform.dtFec;

  function restriccion(consultar = false, mes = true){
    if (!consultar) {
      if ((selTipo.value=="FESP")) {
        alWarning({"msg":{"title":"FESP","text":"Esta opción no fue diseñada para emitir Facturas Especiales"}});
        return true;
      }
    } else {
      if (isNullPer(txtSerie.value) || isNullPer(numNum.value)) {
        return true;
      }
    }
    return false;
  }

  function restriccionCamposVacios() {
    if (isNullPer(selTipo.value)) {
      selTipo.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el TIPO"}});
      return true;
    }
    if (isNullPer(txtSerie.value)) {
      txtSerie.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar la SERIE"}});
      return true;
    }
    if (isNullPer(numNum.value)) {
      numNum.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NÚMERO"}});
      return true;
    }
    return false;
  }

  function restriccionMesCerrado() {
    if (mesCerrado) {
      alError({"msg":{"type":"error","title":"Mes Cerrado","text":"No puede trabajar con este mes porque ya fue cerrado", "ok":"Aceptar"}});
      return true;
    }
    return false;
  }

  function addRowFac(cod, nom, totQ, totD, i, tipo){
    var totLetras = "";
    if (tipo == 'Q') {
      totLetras = numeroALetras(totQ, 2, {
                    plural: 'quetzales',
                    singular: 'quetzal',
                    centPlural: 'centavos',
                    centSingular: 'centavo'
                  }).toUpperCase()
    } else {
      totLetras = numeroALetras(totD, 2, {
                    plural: 'dólares',
                    singular: 'dólar',
                    centPlural: 'centavos',
                    centSingular: 'centavo'
                  }).toUpperCase()
    }
    const row = "<tr>"
                  +"<td id='dataCod'>"+cod+"</td>"
                  +"<td id='dataNom'>"+nom+"</td>"
                  +"<td id='dataTotQ' class='text-right'>"+totQ+"</td>"
                  +"<td id='dataTotD' class='text-right'>"+totD+"</td>"
                  +'<td class="text-center">'
                    +'<div class="btn-group btn-checkbox" data-toggle="buttons">'
                      +'<label class="btn btn-secondary cbFac">'
                        +'<input type="checkbox" id="dataCheck'+i+'" name="cb">'
                        +'<span class="fas fa-check fa-sm"></span>'
                      +'</label>'
                    +'</div>'
                  +'</td>'
                  +"<td id='dataTipo' class='d-none'>"+tipo+"</td>"
                  +"<td id='dataTotLetras' class='d-none'>"+totLetras+"</td>"
                +"</tr>";
    $("#tblFac tbody").append(row);
  }

  function limpiar() {
    tblClear("tblFac");
    sumFac();
  }

  function sumFacMar(){
    var acumQ = 0;
    var acumD = 0;
    $("#tblFac").find('tbody tr').each(function () {
      if ($(this).find('td input[name="cb"]').is(":checked")) {
        acumQ += parseFloat($(this).find('#dataTotQ').text());
        acumD += parseFloat($(this).find('#dataTotD').text());
      }
    });
    $("#tblFac #dataTtotQM").text(acumQ.toFixed(2));
    $("#tblFac #dataTtotDM").text(acumD.toFixed(2));
  }

  function sumFac(){
    $("#tblFac #dataTtotQ").text(tblSumCol("tblFac", "dataTotQ").toFixed(2));
    $("#tblFac #dataTtotD").text(tblSumCol("tblFac", "dataTotD").toFixed(2));
  }

  function getElements(locationPHP) {
    const getFec = "?dtFec="+dtFec.value;
    const getTipoNom = "&selTipoNom="+$("#selTipo option:selected").text();

    return window.location.origin+window.location.pathname+locationPHP+".php"+getFec+getTipoNom;
  }

  $(document).ready(function() {
    $(this).find('select:visible:first').focus();
    selTipo.value = "FACT";
    date = new Date();
    dtFec.value = dateToday();
    selMes.value = date.getMonth()+1;
    numAno.value = date.getFullYear();
    numTcam.value = <?php echo $tcam; ?>.toFixed(5);

    // SHOW MODAL
    $('#modalPol').on('shown.bs.modal', function() {
      if (!isMobile()) {
        $(this).find('input:visible:first').focus();
      }
    });

    // SUBMIT FORM
    $('form').submit(function() {
      return false;
    });

    // VALID TASA DE CAMBIO
    $("#btnGenerar")
    .click(function (){
      const parametros = new FormData();
      parametros.append("action", "consultarCliencc");
      tblClear("tblFac");
      sumFacMar();

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
          alLoad("Generando listado de facturas...")
        },
        success: function (jsonPhp) {
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (jsonJS.cliencc === null) {
            } else {
              jsonJS.cliencc.forEach(function(i, index){
                tot=Number(i.cli_men);
                mesvencido=Number(i.cli_mesvencido);
                
                fecfin=new Date(Number(numAno.value), Number(selMes.value)-1, 0);
                diafin=fecfin.getDate();
                mesfin=fecfin.getMonth();
                anofin=fecfin.getFullYear();

                fins=YMDToDate(i.cli_fins);
                diafins=fins.getDate();
                mesfins=fins.getMonth();
                anofins=fins.getFullYear();
                valdiaa=round((i.cli_men/diafin),2);
                valmesant=0;

                if (mesvencido==0 && mesfin==mesfins && anofin==anofins) {
                  valmesant=round((((diafin-diafins)+1)*valdiaa),2);
                }
                if (mesvencido==1 && mesfin==mesfins && anofin==anofins) {
                  tot=round((((diafin-diafins)+1)*valdiaa),2);
                  valmesant=0;
                }
                if (mesvencido==0 && (mesfin!=mesfins || anofin!=anofins)) {
                  valmesant=0;
                }
                if (mesvencido==1 && (mesfin!=mesfins || anofin!=anofins)) {
                  valmesant=0;
                }

                sigmon=i.cli_sigmon
                tipo=(i.cli_tipo=="L") ? "Q" : "$";

                var totQ = 0;
                var totD = 0;
                if (sigmon==tipo) {
                  totQ = (tipo=="Q") ? (tot+valmesant) : 0;
                  totD = (tipo=="$") ? (tot+valmesant) : 0;
                } else {
                  totQ = (sigmon=="$" && tipo=="Q") ? round(((tot+valmesant)*numTcam.value),2) : 0;
                  totD = (sigmon=="Q" && tipo=="$") ? round(((tot+valmesant)/numTcam.value),2) : 0;
                }
                totQ = totQ.toFixed(2);
                totD = totD.toFixed(2);
                addRowFac(i.cli_cod, i.cli_nomfac, totQ, totD, index, tipo);
              });
              sumFac();
              tblAllChecked("tblFac", "cb", "cbTodos");
              alClose()
            }
          }
        }
      });
    });

    // CLICK GUARDAR
    $("#btnGuardar").click(function (){
      if (restriccion()) {return};

      const parametros = new FormData();
      parametros.append("action", "guardar");
      parametros.append("numAno", numAno.value);
      parametros.append("selMesCod", selMes.value);
      parametros.append("selMesNom", $("#selMes option:selected").text());
      parametros.append("numTcam", numTcam.value);
      parametros.append("dtFec", dtFec.value);
      parametros.append("selTipoCod", selTipo.value);
      parametros.append("tblFac", tblToJsonCbSkip(colFac, "tblFac", 10, 4));
      //console.log(tblToJsonCbSkip(colFac, "tblFac", 10, 4))
      
      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
          alLoad("Cargando...")
        },
        success: function (jsonPhp) {
          console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error==true){
            alError(jsonJS);
            if(jsonJS.print) {
              window.open(getElements("print"), '_blank');
            }
          } else {
            alSuccess(jsonJS);
            window.open(getElements("print"), '_blank');
          }
        }
      });
    });

    // CLICK VISTA PREVIA
    $("#btnVistaPrevia").click(function (){
      const parametros = new FormData();
      parametros.append("action", "imprimir");
      parametros.append("numAno", numAno.value);
      parametros.append("selMesCod", selMes.value);
      parametros.append("selTipoCod", selTipo.value);
      parametros.append("dtFec", dtFec.value);
      parametros.append("tblFac", tblToJsonCbSkip(colFac, "tblFac", 10, 4));
      
      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
        },
        success: function (jsonPhp) {
          window.open(window.location.origin+window.location.pathname+"preview.php", '_blank');
        }
      });
    });

    // CLICK TODOS
    $('#cbTodos').change(function () {
      (this.checked) ? $(".cbFac").addClass("active") : $(".cbFac").removeClass("active");
      cbAllChecked("tblFac", "cb", "cbTodos");
    });
  });

  // CHANGE CB TBLFAC
  $("body").on("change", "input[name=cb]", function (){
    sumFacMar();
  });

  $("#txtFiltrar").on("keyup", function() {
    var value = accent_fold($(this).val().toLowerCase());
    $("#tblFac tbody tr").filter(function() {
      $(this).toggle(accent_fold($(this).text()).toLowerCase().indexOf(value) > -1)
    });
  });
</script>