<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$facturas=$_SESSION["tempFacturas"];

$lineWidth=17.5;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineWidth, $lineHeight;
        $this->SetMargins(2, 1, 2);
        $this->SetFont("Arial","",10);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, 'LISTADO DE FACTURAS EMITIDAS',0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode('TIPO: '.$_GET["selTipoNom"]),0,1,"L");

        // Derecha
        $this->SetY(.7);
        $this->Cell(0,1, utf8_decode("PÁGINA: ".((string)($this->PageNo()))),0,1,"R");
        $this->SetY(1.5);
        $this->Cell(0,1, utf8_decode("FECHA DE FACTURAS: ".date('d/m/Y', strtotime($_GET["dtFec"]))),0,1,"R");

        $header = array("Serie","No. Factura","Nombre en la Factura","Valor","Moneda");
        $this->SetFont("","B",8);
        $this->SetWidths(array(2.5,2.5,9.1,2,1.4));
        $this->SetAligns(array("C","C","C","C","C"));
        $this->RowLHColor($header, $lineWidth, $lineHeight, array(192,192,192), array(0,0,0));

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","R","C"));
    }
    
    function Footer() { 
    }
}

# GENERAR PDF
$pdf = new generatePDF("P", "cm", "Letter");
//$pdf = new FPDF('P','mm',array(500,150));
$pdf->AddPage();
foreach ($facturas as $rec) {
    $body = array(
        $rec["serie"],
        $rec["num"],
        $rec["nom"],
        number_format($rec["tot"], 2),
        ($rec["tipo"])
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->Output(utf8_decode("Facturas Generadas ").".pdf","I");
?>