<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');
include_once('../ws/COFIDI/wsExec.php');
include_once('../ws/COFIDI/wsFormatsXML.php');

$bitForm = "fel1100";
$bitMod = "fel";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);
$tipoPol='012';

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarCliencc':
		echo consultarCliencc();
		break;

	case 'consultarCiemes':
		echo consultarCiemes();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'imprimir':
		echo imprimir();
		break;
}

function consultar() {
	global $empCod, $tipoPol;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$numNum=$_POST['numNum'];
	$txtSerie=utf8_decode($_POST['txtSerie']);

	# QUERYS
	$sFacturas="SELECT 
					f.*, 
					TRIM(c.cli_nom) AS cli_nom,
					TRIM(c.cli_cta) AS cli_cta,
					cm.ciem_stat,
					d.dc_tot,
					d.dc_abo
				FROM facturas f 
				LEFT JOIN cliencc c ON f.fact_codp=c.cli_cod
				LEFT JOIN ciemes cm ON f.fact_emp=cm.ciem_emp AND YEAR(f.fact_fec)=cm.ciem_ano AND MONTH(f.fact_fec)=cm.ciem_mes
				LEFT JOIN doctoscc d ON f.fact_emp=d.dc_emp AND f.fact_num=d.dc_num AND f.fact_serie=d.dc_serie
				WHERE fact_serie='$txtSerie' AND fact_num='$numNum' AND fact_emp='$empCod'";

	$sFact_det="SELECT 
					*,
                	REPLACE(factd_desc, '\n', '<br/>') AS factd_desc
                FROM fact_det WHERE factd_serie='$txtSerie' AND factd_num='$numNum' AND factd_emp='$empCod'";

	$sPolizas="SELECT pol_stat FROM polizas WHERE pol_tipoi='$txtSerie' AND pol_num='$numNum' AND pol_tipo='$tipoPol' AND pol_emp='$empCod'";

	$sPoli_det="SELECT * FROM poli_det WHERE pold_tipoi='$txtSerie' AND pold_num='$numNum' AND pold_tipo='$tipoPol' AND pold_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sFacturas, "facturas");
	$resp["fact_det"] = $db->sFetchAll($sFact_det);
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$resp["polizas"] = $db->sFetchAssoc($sPolizas);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "facturas");
}

function consultarCta() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarCliencc() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$txtCliCod = $_POST["txtCliCod"];

	# QUERYS
	$sCliencc = "SELECT *, 
					TRIM(cli_cod) AS cli_cod, 
					TRIM(cli_nom) AS cli_nom,
					TRIM(cli_nomfac) AS cli_nomfac,
					TRIM(cli_nit) AS cli_nit,
					TRIM(cli_dir) AS cli_dir,
					TRIM(cli_ven) AS cli_ven,
					TRIM(cli_cta) AS cli_cta
				FROM cliencc WHERE cli_emp='$empCod' AND cli_cod='$txtCliCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["cliencc"] = $db->sFetchAssoc($sCliencc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc");
}

function consultarCiemes() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();
	$numAno=$_POST["numAno"];
	$selMesCod=$_POST["selMesCod"];

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$selMesCod";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCiemes, "ciemes");
	$db->close();

	return json_encode($resp);
}

function generarPartida() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$cliCta=$_POST['cliCta'];
	$selTipoCod=$_POST['selTipoCod'];
	$numTcam=$_POST['numTcam'];
	$crTcam=$_POST['crTcam'];
	$tot=$_POST['tot'];
	
	if ($crTcam!="L") {
		$tot=round($tot*$numTcam, 2);
	}

	$sub = round(($tot/(($_SESSION['pIva']/100)+1)), 2);
	$iva = round((($tot/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 2);

	$haber = ($sub+$iva);
	if ($tot != $haber) {
		$sub += ($tot < $haber) ? ($tot-$haber) : ($haber-$tot);
	}

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaCli"] = ($tot==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$cliCta));
	$resp["ctaIva"] = ($iva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaiv"]));
	$resp["ctaServ"] = ($sub==0) ? 0 : $db->sFetchAssoc(sCuentas("41102001"));
	$db->close();

	$resp["tot"] = $tot;
	$resp["iva"] = $iva;
	$resp["sub"] = $sub;

	$func = new functions();
	return $func->jsonEncodeArrayEach($resp, array('ctaCli', 'ctaIva', 'ctaServ'));
}

function guardar() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $numTcam, $dtFec, $selTipoCod, $tipoPol, $selTdoci, $bodega;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$selTipoCod=$_POST['selTipoCod'];
	$txtCliCod=$_POST["txtCliCod"];
	$txtNomFac=utf8_decode($_POST["txtNomFac"]);
	$txtNit=$_POST["txtNit"];
	$txtDir=$_POST["txtDir"];
	$selVendCod=$_POST["selVendCod"];
	$crTcam=$_POST["crTcam"];
	//$crFpag = $_POST["crFpag"];
	$crFpag=2;
	$numTcam=$_POST['numTcam'];
	$dtFec=$_POST['dtFec'];
	$tot=$_POST["tot"];

	$jsonDet=json_decode($_POST['tblDet']);
	$jsonPol=json_decode($_POST['tblPol']);

	$arrayError = array();

	$txtMot = $_POST['txtMot'];
	$txtSerie = $_POST['txtSerie'];
	$numNum = $_POST['numNum'];
	$DocumentGUIDF=$_POST["DocumentGUIDF"];
	$totFac=$_POST["totFac"];
	$fecFac=$_POST["fecFac"];
	$bodega=$_POST["bodega"];
	$selTipoTipoabo = $_POST["selTipoTipoabo"];
	$selTipoTrela = $_POST["selTipoTrela"];
	$car = ($_POST["selTipoPone"]=='N') ? 0 : $tot;
	$abo = ($_POST["selTipoPone"]=='N') ? $tot : 0;
	$totDif = ($crTcam != 'L') ? ($tot*$numTcam)-$tot : 0;
	$selTdoci = "0080";

	# QUERYS PARA UN REGISTRO
	$sNotas = "SELECT MAX(fact_idinterno)+1 AS IDInterno FROM notas";

	$sTABLES = "SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_NAME = 'notas'";

	function sCliencc($cod){
		global $empCod;
		return "SELECT 
					*,
					TRIM(cli_tel) AS cli_tel,
					TRIM(cli_codpos) AS cli_codpos,
					TRIM(cli_muni) AS cli_muni,
					TRIM(cli_depto) AS cli_depto
				FROM cliencc WHERE cli_emp='$empCod' AND cli_cod='$cod'";
	}

	function iNotas($Batch, $Serial, $DocumentGUID, $transac, $tot, $codp, $nit, $nom, $dir, $tel, $dcre, $tcam, $fpag, $obs, $retsn, $retisn, $stat, $vencod, $lugare, $envio, $pedido, $orden, $bodsal, $pcomi, $contrato, $mot, $DocumentGUIDF, $serie, $num){
		global $empCod, $usuNom, $dtFec, $selTipoCod;
		return "INSERT INTO notas(fact_documentguid,fact_emp,fact_tipo,fact_num,fact_transac,fact_fec,fact_tot,fact_codp,fact_nit,fact_nom,fact_dir,fact_tel,fact_dcre,fact_tcam,fact_fpag,fact_obs,fact_retsn,fact_retisn,fact_stat,fact_vend,fact_ulcam,fact_lugare,fact_envio,fact_pedido,fact_orden,fact_bodsal,fact_pcomi,fact_contrato,fact_fel,fact_mot,fact_documentguidf,fact_tipof,fact_numf) VALUES ('$DocumentGUID','$empCod','$Batch',$Serial,$transac,'$dtFec','$tot','$codp','$nit','$nom','$dir','$tel',$dcre,'$tcam','$fpag','$obs','$retsn','$retisn','$stat','$vencod','$usuNom','$lugare','$envio','$pedido','$orden','$bodsal','$pcomi','$contrato','$selTipoCod','$mot','$DocumentGUIDF','$serie','$num')";
	}

	function iNotas_det($IDInterno, $transac, $Batch, $num, $codcorr, $cod, $desc, $desci, $med, $unimed, $cant, $preu, $cosu, $sub, $descu, $descuv, $tot, $autoriza, $codp, $nit, $vend, $bodsal, $exensn){
		global $empCod, $dtFec;
		return "INSERT INTO notas_det(factd_idinterno,factd_emp,factd_transac,factd_tipo,factd_num,factd_fec,factd_codcorr,factd_cod,factd_desc,factd_desci,factd_med,factd_unimed,factd_cant,factd_preu,factd_cosu,factd_sub,factd_descu,factd_descuv,factd_tot,factd_autoriza,factd_codp,factd_nit,factd_vend,factd_bodsal,factd_exensn) VALUES ('$IDInterno','$empCod','$transac','$Batch','$num','$dtFec','$codcorr','$cod','$desc','$desc','$med','$unimed','$cant','$preu','$cosu','$sub','$descu','$descuv','$tot','$autoriza','$codp','$nit','$vend','$bodsal','$exensn')";
	}

	function sPaises($pais) {
		return "SELECT pa_alfa2 FROM paises WHERE id=$pais";
	}

	function iIva_ven($num, $tipo, $nit, $tot, $sub, $iva, $nom, $tcam, $cod, $Batch) {
		global $empCod, $usuNom, $dtFec;
		if ($_POST["selTipoPone"]=='N') {
			$tot*=-1;
			$sub*=-1;
			$iva*=-1;
		}
		return "INSERT INTO iva_ven(ivav_emp,ivav_fec,ivav_num,ivav_tipo,ivav_nit,ivav_bien,ivav_serv,ivav_exp,ivav_tot,ivav_sub,ivav_exen,ivav_subb,ivav_subs,ivav_sube,ivav_iva,ivav_medi,ivav_vehi,ivav_noafe,ivav_subme,ivav_subve,ivav_subna,ivav_conso,ivav_comb,ivav_tfaco,ivav_subco,ivav_expre,ivav_suber,ivav_con,ivav_afe,ivav_vehia,ivav_ivave,ivav_ulcam,ivav_galos,ivav_galor,ivav_galod,ivav_vgals,ivav_vgalr,ivav_vgald,ivav_ret,ivav_reti,ivav_retsn,ivav_retisn,ivav_dedu,ivav_clin,ivav_stat,ivav_galon,ivav_srd,ivav_vgalo,ivav_tvehi,ivav_prens,ivav_facus,ivav_tcam,ivav_gtq,ivav_proco,ivav_serie) 
		VALUES ('$empCod','$dtFec',$num,'$tipo','$nit',0,'$tot',0,'$tot','$sub',0,0,'$sub',0,'$iva',0,0,0,0,0,0,'$empCod',0,0,0,0,0,'','S',0,0,'$usuNom',0,0,0,0,0,0,0,0,'N','N',0,'$nom','',0,0,0,0,0,0,'$tcam',0,'$cod','$Batch')";
	}

	function uDoctoscc($num, $serie, $abo) {
		global $empCod;
		return "UPDATE doctoscc SET dc_abo=dc_abo+'$abo' WHERE dc_emp='$empCod' AND dc_num=$num AND dc_serie='$serie'";
	}

	function iPolizas($num, $serie, $con, $nit) {
		global $empCod, $tipoPol, $usuNom, $dtFec;
		return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_stat, pol_tipoi, pol_nit, pol_ulcam) VALUES('$empCod','$dtFec',0,'$tipoPol',$num,'$con','','$serie','$nit','$usuNom')";
	}

	function iMovicc($codp, $nit, $tipo, $Serial, $car, $abo, $serie, $num) {
		global $empCod, $dtFec;
		return "INSERT INTO movicc(mov_emp,mov_codp,mov_nit,mov_fec,mov_tipo,mov_num,mov_car,mov_abo,mov_tipoc,mov_numc,mov_ban) VALUES('$empCod','$codp','$nit','$dtFec','$tipo','$Serial','$car','$abo','$serie',$num,0)";
	}

	function iAbonosc($tipo, $Serial, $tot, $codp, $nit, $con, $tcam, $totDif, $tipoMon) {
		global $empCod, $dtFec, $usuNom;
		return "INSERT INTO abonosc(abo_emp,abo_tipo,abo_num,abo_fec,abo_tot,abo_codp,abo_nit,abo_con,abo_stat,abo_tcam,abo_bien,abo_serv,abo_ulcam,abo_totdif,abo_tipomon,abo_efec) VALUES('$empCod','$tipo','$Serial','$dtFec','$tot','$codp','$nit','$con','','$tcam',0,'$tot','$usuNom','$totDif','$tipoMon','$tot')";
	}

	function iAbo_detc($tipo, $Serial, $codp, $nit, $serie, $num, $totFac, $tot, $fecFac, $tcam) {
		global $empCod, $dtFec, $usuNom;
		return "INSERT INTO abo_detc(abd_emp,abd_tipo,abd_num,abd_codp,abd_nit,abd_tipoc,abd_numc,abd_valor,abd_cien,abd_desc,abd_totp,abd_fec,abd_feccd,abd_feccp,abd_stat,abd_tcam) VALUES('$empCod','$tipo','$Serial','$codp','$nit','$serie','$num','$totFac',0,'0.00','$tot','$dtFec','$fecFac','$fecFac','','$tcam')";
	}
    

	# QUERYS PARA VARIOS REGISTROS
	function iPoli_det($num, $serie, $nit, $jsonPol) {
		global $empCod, $dtFec, $tipoPol;
		$func = new functions();
		$r = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber, pold_stat) VALUES ";
		foreach ($jsonPol as $obj) {
			$obj->cta = utf8_decode($obj->cta);
			$obj->ctaNom = utf8_decode($obj->ctaNom);
			$r = $r."('$empCod','$dtFec',0,'$tipoPol','$num','$serie','$nit','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber','')".$func->addValues($obj, $jsonPol);
		}
		return $r;
	}

	function dPoli_det($num, $serie) {
		global $empCod, $tipoPol;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie'";
	}

	/// De aqui en adelante esta lo correspondiente al inventario
	function iMovii($codd, $cantd, $cosud, $precio) { 
		global $empCod, $usuNom, $numNum, $selTdoci, $dtFec, $bodega, $numtcam, $selSerieo, $numOrdenc, $txtCon, $sumtot, $crPror;
		return "INSERT INTO movii (mov_emp, mov_tipo, mov_num, mov_fec, mov_fecapli, mov_cod, mov_bodent, mov_entra, mov_cosu, mov_preu) VALUES ('$empCod','$selTdoci','$numNum','$dtFec','$dtFec','$codd','$bodega','$cantd','$cosud','$precio')";
	}

	function sArtic($codd) { 
		global $empCod, $usuNom;
		return "SELECT * FROM artic WHERE art_emp='$empCod' AND art_cod='$codd'";
	}

	function sExiart($codd,$bodega) { 
		global $empCod, $usuNom;
		return "SELECT * FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$bodega'";
	}

	function uExiart($codd,$bodega, $nexist) { 
		global $empCod, $usuNom;
		return "UPDATE exiart SET ea_exist='$nexist' WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$bodega'";
	}
	function iExiart($codd,$bodega, $nexist) { 
		global $empCod, $usuNom;
		return "INSERT INTO exiart(ea_emp,ea_cod,ea_bod,ea_exist) VALUES('$empCod','$codd','$bodega','$nexist')";
	}


	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$faCliencc = $db->sFetchAssoc(sCliencc($txtCliCod));

	$sub = round(($tot/(($_SESSION['pIva']/100)+1)), 2);
	$iva = round((($tot/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 2);

	$haber = ($sub+$iva);
	if ($tot != $haber) {
		$sub += ($tot < $haber) ? ($tot-$haber) : ($haber-$tot);
	}

	if ($crTcam=="L") {
		$totIva=$tot;
		$subIva=$sub;
		$ivaIva=$iva;
	} else {
		$totIva=round($tot*$numTcam, 2);
		$subIva=round(($totIva/(($_SESSION['pIva']/100)+1)), 2);
		$ivaIva=round((($totIva/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 2);

		$haberIva = ($subIva+$ivaIva);
		if ($totIva != $haberIva) {
			$subIva += ($totIva < $haberIva) ? ($totIva-$haberIva) : ($haberIva-$totIva);
		}
	}

	$pais = $db->sFetchAssoc(sPaises($faCliencc['cli_pais']))['pa_alfa2'];

	$wsFormatsXML = new wsFormatsXML();
	// Datos Generales
	$Tipo=$selTipoCod;
	$FechaHoraEmision = $dtFec.'T'.date("H:i:s", STRTOTIME(date('h:i:sa'))).'-06:00';
	$CodigoMoneda = ($crTcam=='L') ? 'GTQ' : 'USD';

	// Items
	$arrayItems = array();
	$i = 1;
	foreach ($jsonDet as $obj) {
		$obj->descrip = utf8_decode($obj->descrip);
		$codd=trim($obj->cod);
		$cosud=$obj->cosu;
		$preud=$obj->preu;
		$cantd=$obj->cant;

		/// Para modificar existencia en el inventario y grabar el movimiento
		$select["exiart"] = $db->query(sExiart($codd,$bodega));
		$fetchAssoc["exiart"] = $db->fetchAssoc($select["exiart"]);
		if ($db->numRows($select["exiart"]) == 0) {
			$exiant=0;
        } else {
          $exiant=$fetchAssoc["exiart"]["ea_exist"];
        }
        $nuevaexist=$exiant+$cantd;

		if ($db->numRows($select["exiart"]) == 0) {
			$db->iEx(iExiart($codd,$bodega,$nuevaexist));
        } else {
			$db->uEx(uExiart($codd,$bodega,$nuevaexist));
        }
		$db->query(iMovii($codd, $cantd, $cosud, $preud));
		//

		$totItem = $obj->sub;
		$subItem = round(($totItem/(($_SESSION['pIva']/100)+1)), 5);
		$ivaItem = round((($totItem/(($_SESSION['pIva']/100)+1))*($_SESSION['pIva']/100)), 5);

		$haberItem = ($subItem+$ivaItem);
		if ($totItem != $haberItem) {
			$subItem += ($totItem < $haberItem) ? ($totItem-$haberItem) : ($haberItem-$totItem);
		}

		array_push($arrayItems, array('NumeroLinea'=>$i, 'BienOServicio'=>'S', 'Cantidad'=>$obj->cant, 'UnidadMedida'=>'UND', 'Descripcion'=>$obj->descrip, 'PrecioUnitario'=>$obj->preu, 'Precio'=>$obj->sub, 'Descuento'=>0, 'NombreCorto'=>'IVA', 'CodigoUnidadGravable'=>1, 'MontoGravable'=>$subItem, 'MontoImpuesto'=>$ivaItem, 'Total'=>$obj->sub));
		$i++;
	}
	// Frases
	$arrayFrases = array(
		array('TipoFrase'=>1, 'CodigoEscenario'=>1)
	);

	// Totales
	$arrayImpuestos = array(
		array('NombreCorto'=>'IVA', 'TotalMontoImpuesto'=>$iva)
	);

	// Complementos
	$arrayComplementos = array();
	if ($Tipo == "NCRE") {
		array_push($arrayComplementos, array('IDComplemento'=>'ReferenciasNota', 'NumeroAutorizacionDocumentoOrigen'=>$DocumentGUIDF, 'FechaEmisionDocumentoOrigen'=>$fecFac, 'MotivoAjuste'=>$txtMot, 'SerieDocumentoOrigen'=>$txtSerie, 'NumeroDocumentoOrigen'=>$numNum));
	}

	// Para quitar comillas porque nos da error y no deja guardar en WS
	$nomWS = str_replace('"', '', utf8_decode($txtNomFac));

	$FEL = $wsFormatsXML->GTDocumentoIni()
		.$wsFormatsXML->DatosGenerales($Tipo, $FechaHoraEmision, $CodigoMoneda)
		.$wsFormatsXML->Emisor()
		.$wsFormatsXML->Receptor($txtNit, $nomWS, $txtDir, $faCliencc['cli_codpos'], $faCliencc['cli_muni'], $faCliencc['cli_depto'], $pais)
		.$wsFormatsXML->Frases($arrayFrases)
		.$wsFormatsXML->Items($arrayItems)
		.$wsFormatsXML->Totales($tot, $arrayImpuestos)
		.$wsFormatsXML->Complementos($arrayComplementos)
		.$wsFormatsXML->GTDocumentoFin();
	$base64FEL = base64_encode($FEL);
	#echo $FEL." ------ base64 ---- ".$base64FEL;

	$wsCOFIDI = new wsCOFIDIExec();
	$IDInterno = $db->sFetchAssoc($sNotas)['IDInterno'] ?? $db->sFetchAssoc($sTABLES)['AUTO_INCREMENT'];
	foreach ($wsCOFIDI->iEx($base64FEL, $IDInterno) as $Body) {
		// Si se guardó en la factura en la SAT (Result = TRUE o FALSE) entonces guardar en nuestra DB
		$result = $Body->RequestTransactionResponse->RequestTransactionResult->Response->Result;
		if ($func->stringToBool((string)$result)) {
			$Batch = $Body->RequestTransactionResponse->RequestTransactionResult->Response->Identifier->Batch;
			$Serial = $Body->RequestTransactionResponse->RequestTransactionResult->Response->Identifier->Serial;
			$DocumentGUID = $Body->RequestTransactionResponse->RequestTransactionResult->Response->Identifier->DocumentGUID;

#$Batch = 'asdf';
#$Serial = 123;
#$DocumentGUID = 'asdf-123';
			$resp = $db->iEx(iNotas($Batch, $Serial, $DocumentGUID, $IDInterno, $tot, $txtCliCod, $txtNit, $txtNomFac, $txtDir, $faCliencc["cli_tel"], $faCliencc["cli_dcre"], (($crTcam=="L") ? 1 : $numTcam), $crFpag, "", "N", "N", "", $selVendCod, "", "", "", "", "", "0.00", 0, $txtMot, $DocumentGUIDF, $txtSerie, $numNum));

			foreach ($jsonDet as $obj) {
				$db->iEx(iNotas_det($IDInterno, $IDInterno, $Batch, $Serial, 0, $obj->cod, $obj->descrip, $obj->descrip, "", "", $obj->cant, $obj->preu, 0, $obj->sub, 0, 0, $obj->sub, 0, $txtCliCod, $txtNit, $selVendCod, "", "N"));
			}
			$db->iEx(iIva_ven($Serial, $selTipoTrela, $txtNit, $totIva, $subIva, $ivaIva, $txtNomFac, 1, $txtCliCod, $Batch));
			$db->iEx(iMovicc($txtCliCod, $txtNit, $selTipoTipoabo, $Serial, $car, $abo, $txtSerie, $numNum));
			$db->iEx(iAbonosc($selTipoTipoabo, $Serial, $tot, $txtCliCod, $txtNit, $txtMot, $numTcam, $totDif, $crTcam));
			$db->iEx(iAbo_detc($selTipoTipoabo, $Serial, $txtCliCod, $txtNit, $txtSerie, $numNum, $totFac, $tot, $fecFac, $numTcam));
			$db->iEx(uDoctoscc($numNum, $txtSerie, ($_POST["selTipoPone"]=='N') ? $tot : $tot*-1));
			$db->iEx(iPolizas($Serial, $selTipoTipoabo, $txtMot, $txtNit));
			$db->iEx(iPoli_det($Serial, $selTipoTipoabo, $txtNit, $jsonPol));

			$resp = $db->rSuccessPublic('Se guardó correctamente', 'Serie: '.$Batch.'<br> Número: '.$Serial);
		} else {
			$Code = $Body->RequestTransactionResponse->RequestTransactionResult->Response->Code;
			$Description = $Body->RequestTransactionResponse->RequestTransactionResult->Response->Description;

			array_push($arrayError, array("Code"=>''.$Code, "cod"=>$txtCliCod, "Description"=>''.$Description));
		}
	}

	// Por si no se pudo guardar la factura de algún cliente
	$sizeError = sizeof($arrayError);
	if ($sizeError != 0) {
		$title = $arrayError[0]["Code"]." - ".$arrayError[0]["cod"];
		$text = $arrayError[0]["Description"];
		$resp = $db->rErrorPublic($title, $text);
	}

	$db->close();

	return json_encode($resp);
}

function imprimir() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}
	
	# QUERYS
	$sTipov = "SELECT TRIM(tv_nom) AS tv_nom FROM tipov WHERE tv_cod='{$_POST["selTipoCod"]}'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$fa["tipov"] = $db->sFetchAssoc($sTipov);

	$_SESSION["printFacturas"] = array(
		'tipoNomFEL'=>$fa["tipov"]["tv_nom"],
		'tipoFEL'	=>$_POST["selTipoCod"],
		'nom'		=>$_POST["txtNomFac"],
		'nit'		=>$_POST["txtNit"],
		'dir'		=>$_POST["txtDir"],
		'fec'		=>$_POST["dtFec"],
		'tcam'		=>$_POST["tcam"],
		'tot'		=>$_POST["dataTot"],
		'totLetras'	=>$_POST["totLetras"],
		'det' 		=>$_POST["tblDet"]
	);
	return "";
}
?>