<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "fel1015";
$bitMod = "fac";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);
$tipoPol='010';

switch ($_POST['action']) {
	case 'consultarArtic':
		echo consultarArtic();
		break;

	case 'consultarExist':
		echo consultarExist();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarCorrtipov':
		echo consultarCorrtipov();
		break;

	case 'consultarCliencc':
		echo consultarCliencc();
		break;

	case 'consultarCiemes':
		echo consultarCiemes();
		break;

	case 'consultar':
		echo consultar();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'anular':
		echo anular();
		break;

	case 'borrar':
		echo borrar();
		break;

	case 'imprimir':
		echo imprimir();
		break;
}

function consultarArtic() {
	global $empCod;

	$func = new functions();

	$txtCodd=utf8_decode($_POST['txtCodd']);

	# QUERYS
	$sArtic = "SELECT a.*, 
				TRIM(a.art_cod) AS art_cod, 
				TRIM(a.art_desc) AS art_desc, 
				TRIM(a.art_desd) AS art_desd,
				TRIM(ctaCos.cta_nom) AS art_ctaCosnom,
				TRIM(ctaInv.cta_nom) AS art_ctaInvnom,
				TRIM(ctaVen.cta_nom) AS art_ctaVennom,
				TRIM(p.pro_nom) AS art_provnom,
				TRIM(um.um_nom) AS um_nom
				FROM artic a
				LEFT JOIN cuentas ctaCos ON a.art_emp = ctaCos.cta_emp AND a.art_ctaCos=ctaCos.cta
				LEFT JOIN cuentas ctaInv ON a.art_emp = ctaInv.cta_emp AND a.art_ctaInv=ctaInv.cta
				LEFT JOIN cuentas ctaVen ON a.art_emp = ctaVen.cta_emp AND a.art_ctaven=ctaVen.cta
				LEFT JOIN provcp p ON a.art_emp = p.pro_emp AND a.art_prov=p.pro_cod
				LEFT JOIN unimed um ON a.art_medi=um.um_cod
				WHERE a.art_emp='$empCod' AND a.art_cod='$txtCodd'";

	$sArticbarr = "SELECT a.*, 
				TRIM(a.art_cod) AS art_cod, 
				TRIM(a.art_desc) AS art_desc, 
				TRIM(a.art_desd) AS art_desd,
				TRIM(ctaCos.cta_nom) AS art_ctaCosnom,
				TRIM(ctaInv.cta_nom) AS art_ctaInvnom,
				TRIM(ctaVen.cta_nom) AS art_ctaVennom,
				TRIM(p.pro_nom) AS art_provnom,
				TRIM(um.um_nom) AS um_nom
				FROM artic a
				LEFT JOIN cuentas ctaCos ON a.art_emp = ctaCos.cta_emp AND a.art_ctaCos=ctaCos.cta
				LEFT JOIN cuentas ctaInv ON a.art_emp = ctaInv.cta_emp AND a.art_ctaInv=ctaInv.cta
				LEFT JOIN cuentas ctaVen ON a.art_emp = ctaVen.cta_emp AND a.art_ctaven=ctaVen.cta
				LEFT JOIN provcp p ON a.art_emp = p.pro_emp AND a.art_prov=p.pro_cod
				LEFT JOIN unimed um ON a.art_medi=um.um_cod
				WHERE a.art_emp='$empCod' AND a.art_codbarr='$txtCodd'";


	function sExiart($codigo) { 
		global $empCod;
		return "SELECT e.*, TRIM(b.bod_nom) AS bod_nom
				FROM exiart e 
				LEFT JOIN bodegas b ON e.ea_emp=b.bod_emp AND e.ea_bod=b.bod_cod
				WHERE e.ea_emp='$empCod' AND e.ea_cod='$codigo'";
	}

	$sCod_barr = "SELECT * FROM cod_barr WHERE cb_emp='$empCod' AND cb_cod='$txtCodd'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$codigo=$txtCodd;
	$resp = $db->sEx($sArtic, "artic");
	$select["artic"] = $db->query($sArtic);
	if ($db->numRows($select["artic"]) == 0) {
		$resp = $db->sEx($sArticbarr, "artic");
		$codigo=$resp["artic"]["art_cod"];
	}
	$resp["exiart"] = $db->sFetchAll(sExiart($codigo));
	$resp["imgArtic"] = "imgArticulos/$empCod"."_".$func->imgCharacters($codigo).".jpeg?".rand(1,9999);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "artic");
}

function consultarExist() {
	global $empCod;

	$func = new functions();

	$txtCod=utf8_decode($_POST['txtCod']);
	$selBod=utf8_decode($_POST['selBod']);

	# QUERYS
	$sExiart = "SELECT ea_exist, ea_exicon FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$txtCod' AND ea_bod='$selBod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sExiart, "exiart");
	$db->close();

	return json_encode($resp);
}

function consultarCorrtipov() {
	global $empCod;

	$func = new functions();

	$selTipoCod=utf8_decode($_POST['selTipoCod']);

	# QUERYS
	$sCorrtipov = "SELECT ctv_num FROM corrtipov WHERE ctv_emp='$empCod' AND ctv_tipo='$selTipoCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();

	$select["corrtipov"] = $db->query($sCorrtipov);
	if ($db->numRows($select["corrtipov"])>0) {
		$numFac = ($db->fetchAssoc($select["corrtipov"])["ctv_num"]);
	} else {
		$numFac = 1;
		$r["corrtipov"] = $db->query("INSERT INTO corrtipov (ctv_emp, ctv_tipo, ctv_num) VALUES('$empCod', '$selTipoCod', $numFac);");
	}

	$resp["corrtipov"]["ctv_num"] = $numFac;
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrtipov");
}

function consultarCta() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarCliencc() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$txtCliCod = $_POST["txtCliCod"];

	# QUERYS
	$sCliencc = "SELECT *, 
					TRIM(cli_cod) AS cli_cod, 
					TRIM(cli_nom) AS cli_nom,
					TRIM(cli_nomfac) AS cli_nomfac,
					TRIM(cli_nit) AS cli_nit,
					TRIM(cli_dir) AS cli_dir,
					TRIM(cli_ven) AS cli_ven,
					TRIM(cli_cta) AS cli_cta,
					TRIM(cli_tel) AS cli_tel
				FROM cliencc WHERE cli_emp='$empCod' AND cli_cod='$txtCliCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["cliencc"] = $db->sFetchAssoc($sCliencc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc");
}

function consultarCiemes() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();
	$numAno=$_POST["numAno"];
	$selMesCod=$_POST["selMesCod"];

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$selMesCod";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCiemes, "ciemes");
	$db->close();

	return json_encode($resp);
}

function consultar() {
	global $empCod, $usuNom, $tipoPol;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$selTipoCod=$_POST['selTipoCod'];
	$selTipoAbrev=$_POST['selTipoAbrev'];
	$numNum=$_POST['numNum'];

	# QUERYS
	$sFacturas = "SELECT
					f.*,
					c.ciem_stat,
					TRIM(cli.cli_nom) AS cli_nom,
					TRIM(cli.cli_cta) AS cli_cta
				  FROM facturas f 
				  LEFT JOIN ciemes c ON c.ciem_mes=MONTH(f.fact_fec) AND c.ciem_ano=YEAR(f.fact_fec) AND c.ciem_emp='$empCod'
				  LEFT JOIN cliencc cli ON cli.cli_emp='$empCod' AND cli.cli_cod=f.fact_codp
				  WHERE fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";

	function sFact_det($IDInterno) {
		return "SELECT * FROM fact_det WHERE factd_idinterno='$IDInterno'";
	}

	$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_tipoi='$selTipoAbrev' AND pold_num=$numNum";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sFacturas, "facturas");
	$resp["fact_det"] = ($resp["facturas"]!=null) ? $db->sFetchAll(sFact_det($resp["facturas"]["fact_idinterno"])) : array();
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "facturas");
}

function generarPartida() {
	global $empCod, $totales;

	$numTcam = $_POST["numTcam"];
	$crFpag = $_POST["crFpag"];
	$crExp = $_POST["crExp"];
	$crRet = $_POST["crRet"];
	$crReti = $_POST["crReti"];
	$selTipoImpues = $_POST["selTipoImpues"];
	$tot=$_POST["tot"];
	$cliCta=$_POST['cliCta'];
	$jsonDet=json_decode($_POST['tblDet'], true);

	$func = new functions();
	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}

	function sArtic($cod) {
		global $empCod;
		return "SELECT
					art_cosp,
					TRIM(art_ctacos) AS art_ctacos, 
					TRIM(art_ctainv) AS art_ctainv, 
					TRIM(art_ctaven) AS art_ctaven
				FROM artic WHERE art_cod='$cod' AND art_emp='$empCod'";
	}

	// !!!!! IMPORTANTE !!!!!
	// SE COPIA LA FUNCION iDetalle() QUE ESTA EN LA FUNCION guardar() Y SE QUITA LO QUE NO SE NECESITA, 
	// ESTO SE HACE PARA QUE LOS CALCULOS DE LA PARTIDA SEAN IGUALES A LOS QUE SE GUARDAN
	function iDetalle($tot, $expsn, $jsonDet) {
		global $totales;
		// VARIABLES PARA SEPARAR BIENES, SERVICIOS Y EXPORTACION
		$hayBienes=false;
		$totales["bienes"]["exentoS"]=0;
		$totales["bienes"]["exentoN"]=0;
		$totales["servicios"]["exentoS"]=0;
		$totales["servicios"]["exentoN"]=0;
		$totales["exportacion"]=0;

		foreach ($jsonDet as $obj) {
			// OPERACIONES PARA SERPARAR EL TOTAL DE BIENES Y SERVICIOS
			if ($obj->bienserd=='S') {
				$hayServicios = true;
				($obj->exensnd=='N') ? $totales["servicios"]["exentoN"]+=$obj->totd : $totales["servicios"]["exentoS"]+=$obj->totd;
			} else {
				$hayBienes = true;
				($obj->exensnd=='N') ? $totales["bienes"]["exentoN"]+=$obj->totd : $totales["bienes"]["exentoS"]+=$obj->totd;
			}
		}

		// SI ES EXPORTACIÓN, ENTONCES PONER CERO EN BIENES Y SERVICIOS - PONER EL TOTAL EN EXPORTACION PARA LOS CALCULOS
		if ($expsn=='S') {
			$totales["bienes"]["exentoS"]=0;
			$totales["bienes"]["exentoN"]=0;
			$totales["servicios"]["exentoS"]=0;
			$totales["servicios"]["exentoN"]=0;
			$totales["exportacion"]=$tot;
		}
	}
	
	// PARA HACER LOS CALCULOS
	iDetalle($tot, $crExp, json_decode($_POST['tblDet']));
	$val = calculos($tot, $crRet, $crReti, $crExp, $selTipoImpues, $numTcam, 1);

	$resp["tot"] = round($val["tot"],2);
	$resp["ret"] = round($val["ret"],2);
	$resp["reti"] = round($val["reti"],2);
	$resp["iva"] = round($val["iva"],2);
	$resp["sub"] = round($val["sub"],2);
	
	# EJECUCION DE QUERYS
	$db = new dbExec();

	$resp["ctaInv"]=array();
	$resp["ctaCos"]=array();
	$resp["ctaVen"]=array();
	$j=0;
	foreach ($jsonDet as $rec) {
		// COSTO Y CUENTAS DEL ARTICULO
		$fa["artic"] = $db->sFetchAssoc(sArtic($rec["codd"]));
		$totCosp = ($fa["artic"]["art_cosp"]*$rec["cantd"])*$numTcam;
		$ctaInv = $fa["artic"]["art_ctainv"];
		$ctaCos = $fa["artic"]["art_ctacos"];
		$ctaVen = $fa["artic"]["art_ctaven"];

		// PARA ACUMULAR LAS CUENTAS DE INVENTARIO
		$i = $func->multiSearch($resp["ctaInv"], array('cta' => (string)$ctaInv));
		if ($i >= 0) {
			$resp["ctaInv"][$i]["cta_valor"] += $totCosp;
		} else {
			$fa["ctaInv"] = $db->sFetchAssoc(sCuentas((string)$ctaInv));
			array_push($resp["ctaInv"], array("cta"=>$ctaInv,"cta_nom"=>$fa["ctaInv"]["cta_nom"],"cta_valor"=>$totCosp));
		}

		// PARA ACUMULAR LAS CUENTAS DE COSTOS
		$i = $func->multiSearch($resp["ctaCos"], array('cta' => (string)$ctaCos));
		if ($i >= 0) {
			$resp["ctaCos"][$i]["cta_valor"] += $totCosp;
		} else {
			$fa["ctaCos"] = $db->sFetchAssoc(sCuentas((string)$ctaCos));
		    array_push($resp["ctaCos"], array("cta"=>$ctaCos,"cta_nom"=>$fa["ctaCos"]["cta_nom"],"cta_valor"=>$totCosp));
		}

		// VENTAS=SUBTOTAL <O> VENTAS=TOTAL, DEPENDIENTO SI ES EXPORTACION O EXENTO
		$rec["totd"] = round($rec["totd"]*$numTcam, 2);
		if ($rec["exensnd"]=='N' && $crExp=='N') {
			$rec["totd"] /= (($_SESSION['pIva']/100)+1);
		}
		// PARA ACUMULAR LAS CUENTAS DE VENTAS
		$i = $func->multiSearch($resp["ctaVen"], array('cta' => (string)$ctaVen));
		if ($i >= 0) {
			$resp["ctaVen"][$i]["cta_valor"] += $rec["totd"];
		} else {
			$fa["ctaVen"] = $db->sFetchAssoc(sCuentas((string)$ctaVen));
		    array_push($resp["ctaVen"], array("cta"=>$ctaVen,"cta_nom"=>$fa["ctaVen"]["cta_nom"],"cta_valor"=>$rec["totd"], "cta_exensn"=>$rec["exensnd"]));
		}
		unset($jsonDet[$j]);
		$j++;
	}

	$resp["ctaRet"] = ($resp["ret"]==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtarisr"]));
	$resp["ctaReti"] = ($resp["reti"]==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtariva"]));
	$resp["ctaIva"] = ($resp["iva"]==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaiv"]));
	$resp["ctaCaja"] = ($resp["tot"]==0 && $crFpag!=1) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacaj"]));
	$resp["ctaCli"] = ($resp["tot"]==0 && $crFpag!=2) ? 0 : $db->sFetchAssoc(sCuentas((string)$cliCta));
	$db->close();

	return $func->jsonEncodeArray($resp, "ctaInv");
}

function guardar() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $numTcam, $dtFec, $selTipoCod, $selTipoAbrev, $tipoPol, $tipoInv, $db, $func, $totales, $dtGrabado, $numInv, $soloInv;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$DocumentGUID = '';
	$selTipoCod = $_POST["selTipoCod"];
	$selTipoAbrev = $_POST["selTipoAbrev"];
	$selTipoLibrosn = $_POST["selTipoLibrosn"];
	$selTipoImpues = $_POST["selTipoImpues"];
	$numNum = $_POST["numNum"];

	$dtFec = $_POST["dtFec"];
	$numAno=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));

	$selBodSalCod = $_POST["selBodSalCod"];
	$crAsigEnvio = "N";
	$selTipoEnvCod = "";
	$selTipoEnvAbrev = "";
	$selTipoEnvRelatd = "";
	$numNumEnv = 0;
	$numTcam = $_POST["numTcam"];
	$txtCliCod = utf8_decode($_POST["txtCliCod"]);
	$txtNomFac = utf8_decode($_POST["txtNomFac"]);
	$txtNit = utf8_decode($_POST["txtNit"]);
	$txtDir = utf8_decode($_POST["txtDir"]);
	$txtTel = utf8_decode($_POST["txtTel"]);
	$numDcre = $_POST["numDcre"];
	$selVendCod = $_POST["selVendCod"];
	$crFpag = $_POST["crFpag"];
	$crExp = $_POST["crExp"];
	$crRet = $_POST["crRet"];
	$crReti = $_POST["crReti"];
	$txtObs = utf8_decode($_POST["txtObs"]);
	$tot=$_POST["tot"];
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	$jsonDet=json_decode($_POST['tblDet']);
	$jsonPol=json_decode($_POST['tblPol']);

	$jsonDetAnt=json_decode($_POST['tblDetAnt']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoInv=$_POST["selTipoRelatd"];

	$arrayError = array();

	# QUERYS PARA UN REGISTRO
	$sTABLES = "SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_NAME='facturas' AND TABLE_SCHEMA='{$_SESSION['nombredb']}'";

	$sFacturas = "SELECT f.fact_idinterno, d.ds_num, f.fact_fec FROM facturas f
				  LEFT JOIN doctoss d ON d.ds_emp=f.fact_emp AND d.ds_ftipo=f.fact_tipo AND d.ds_fserie=f.fact_serie AND d.ds_fnum=f.fact_num
				  WHERE fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";

	$sTipov = "SELECT tv_soloinv FROM tipov WHERE tv_cod='$selTipoCod'";

	function sCliencc($cod){
		global $empCod;
		return "SELECT 
					*,
					TRIM(cli_tel) AS cli_tel,
					TRIM(cli_codpos) AS cli_codpos,
					TRIM(cli_muni) AS cli_muni,
					TRIM(cli_depto) AS cli_depto
				FROM cliencc WHERE cli_emp='$empCod' AND cli_cod='$cod'";
	}

	function iuFacturas($Batch, $Serial, $DocumentGUID, $transac, $tot, $codp, $nit, $nom, $dir, $tel, $dcre, $tcam, $fpag, $obs, $retsn, $retisn, $stat, $vencod, $lugare, $envio, $pedido, $orden, $bodsal, $pcomi, $contrato, $expsn, $asigEnvio, $tipoEnv, $serieEnv, $numEnv){
		global $empCod, $usuNom, $dtFec, $selTipoCod, $func;
		if ($func->stringToBool($_POST['nuevo'])) {
			return "INSERT INTO facturas(fact_documentguid,fact_emp,fact_tipo,fact_serie,fact_num,fact_transac,fact_fec,fact_tot,fact_codp,fact_nit,fact_nom,fact_dir,fact_tel,fact_dcre,fact_tcam,fact_fpag,fact_obs,fact_retsn,fact_retisn,fact_stat,fact_vend,fact_ulcam,fact_lugare,fact_envio,fact_pedido,fact_orden,fact_bodsal,fact_pcomi,fact_contrato,fact_fel,fact_expsn,fact_asigenvio,fact_tipoenv,fact_serieenv,fact_numenv) VALUES ('$DocumentGUID','$empCod','$selTipoCod','$Batch',$Serial,$transac,'$dtFec','$tot','$codp','$nit','$nom','$dir','$tel',$dcre,'$tcam','$fpag','$obs','$retsn','$retisn','$stat','$vencod','$usuNom','$lugare','$envio','$pedido','$orden','$bodsal','$pcomi','$contrato','','$expsn','$asigEnvio','$tipoEnv','$serieEnv','$numEnv')";
		} else {
			return "UPDATE facturas SET fact_fec='$dtFec',fact_tot='$tot',fact_codp='$codp',fact_nit='$nit',fact_nom='$nom',fact_dir='$dir',fact_tel='$tel',fact_dcre=$dcre,fact_tcam='$tcam',fact_fpag='$fpag',fact_obs='$obs',fact_retsn='$retsn',fact_retisn='$retisn',fact_stat='$stat',fact_vend='$vencod',fact_ulcam='$usuNom',fact_lugare='$lugare',fact_envio='$envio',fact_pedido='$pedido',fact_orden='$orden',fact_bodsal='$bodsal',fact_pcomi='$pcomi',fact_contrato='$contrato',fact_expsn='$expsn',fact_asigenvio='$asigEnvio',fact_tipoenv='$tipoEnv',fact_serieenv='$serieEnv',fact_numenv='$numEnv' WHERE fact_documentguid='$DocumentGUID' AND fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$Batch' AND fact_num=$Serial";
		}
	}

	function iCorrtipov($num) {
		global $empCod, $selTipoCod, $func;
		if ($func->stringToBool($_POST['nuevo'])) {
			return "UPDATE corrtipov SET ctv_num=$num+1 WHERE ctv_emp='$empCod' AND ctv_tipo='$selTipoCod';\n";
		}
		return "";
	}

	function sMeses($mes) {
		return "SELECT mes_nom FROM meses WHERE mes_cod=$mes";
	}
	
	function iuIva_ven($num, $Batch, $nit, $nom, $retsn, $retisn, $bien, $serv, $exen, $exp, $obs, $subb, $subs, $sube, $ret, $reti, $sub, $iva, $tot, $tcam) {
		global $empCod, $usuNom, $dtFec, $selTipoCod, $empConso, $bitMod, $func;
		if ($func->stringToBool($_POST['nuevo'])) {
			return "INSERT INTO iva_ven (ivav_emp, ivav_serie, ivav_num, ivav_nit, ivav_tipo, ivav_clin, ivav_fec, ivav_retsn, ivav_retisn, ivav_afe, ivav_bien, ivav_serv, ivav_exen, ivav_exp, ivav_expre, ivav_medi, ivav_noafe, ivav_vehi, ivav_vehia, ivav_tvehi, ivav_tfaco, ivav_galos, ivav_galor, ivav_galod, ivav_comb, ivav_con, ivav_subb, ivav_subs, ivav_subco, ivav_subve, ivav_sube, ivav_suber, ivav_subna, ivav_subme, ivav_ret, ivav_reti, ivav_sub, ivav_iva, ivav_tot, ivav_dedu, ivav_ulcam, ivav_conso, ivav_mod) VALUES ('$empCod', '$Batch', '$num', '$nit', '$selTipoCod', '$nom', '$dtFec', '$retsn', '$retisn', 'S', '$bien', '$serv', '$exen', '$exp', 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '$obs', '$subb', '$subs', 0, 0, '$sube', 0, 0, 0, $ret, $reti, '$sub', '$iva', '$tot', 0,'$usuNom', '$empConso', '$bitMod')";
		} else {
			return "UPDATE iva_ven SET ivav_nit='$nit', ivav_clin='$nom', ivav_fec='$dtFec', ivav_retsn='$retsn', ivav_retisn='$retisn', ivav_bien='$bien', ivav_serv='$serv', ivav_exen='$exen', ivav_exp='$exp', ivav_con='$obs', ivav_subb='$subb', ivav_subs='$subs', ivav_sube='$sube', ivav_ret='$ret', ivav_reti='$reti', ivav_sub='$sub', ivav_iva='$iva', ivav_tot='$tot', ivav_ulcam='$usuNom', ivav_conso='$empConso', ivav_mod='$bitMod' WHERE ivav_emp='$empCod' AND ivav_serie='$Batch' AND ivav_num=$num AND ivav_tipo='$selTipoCod'";
		}
	}

	function sDoctoscc($num, $Batch) {
		global $empCod, $selTipoCod;
		return "SELECT dc_num FROM doctoscc WHERE dc_emp='$empCod' AND dc_serie='$Batch' AND dc_num=$num AND dc_tipo='$selTipoCod'";
	}

	function iuDoctoscc($num, $Batch, $nit, $nom, $retsn, $retisn, $bien, $serv, $exen, $exp, $obs, $subb, $subs, $sube, $ret, $reti, $sub, $iva, $tot, $tcam, $cod) {
		global $empCod, $usuNom, $dtFec, $selTipoCod, $empConso, $bitMod, $func, $db;
		if ($db->numRows($db->query(sDoctoscc($num, $Batch)))==0) {
			return "INSERT INTO doctoscc (dc_emp, dc_serie, dc_num, dc_codp, dc_nit, dc_tipo, dc_clien, dc_fec, dc_fecp, dc_retsn, dc_retisn, dc_afe, dc_bien, dc_serv, dc_exen, dc_exp, dc_expre, dc_medi, dc_noafe, dc_tfaco, dc_galos, dc_galor, dc_galod, dc_comb, dc_con, dc_subb, dc_subs, dc_subco, dc_sube, dc_suber, dc_subna, dc_subme, dc_ret, dc_reti, dc_sub, dc_iva, dc_tot, dc_dedu, dc_tcam, dc_ulcam, dc_conso, dc_mod) VALUES ('$empCod', '$Batch', '$num','$cod', '$nit', '$selTipoCod', '$nom', '$dtFec', '$dtFec', '$retsn', '$retisn', 'S', '$bien', '$serv', '$exen', '$exp', 0, 0, 0, 0, 0, 0, 0, 0, '$obs', '$subb', '$subs', 0, '$sube', 0, 0, 0, $ret, $reti, '$sub', '$iva', '$tot', 0, '$tcam', '$usuNom', '$empConso','$bitMod')";
		} else {
			return "UPDATE doctoscc SET dc_codp='$cod', dc_nit='$nit', dc_clien='$nom', dc_fec='$dtFec', dc_fecp='$dtFec', dc_retsn='$retsn', dc_retisn='$retisn', dc_bien='$bien', dc_serv='$serv', dc_exen='$exen', dc_exp='$exp', dc_con='$obs', dc_subb='$subb', dc_subs='$subs', dc_sube='$sube', dc_ret='$ret', dc_reti='$reti', dc_sub='$sub', dc_iva='$iva', dc_tot='$tot', dc_tcam='$tcam', dc_ulcam='$usuNom', dc_conso='$empConso', dc_mod='$bitMod' WHERE dc_emp='$empCod' AND dc_serie='$Batch' AND dc_num=$num AND dc_tipo='$selTipoCod'";
		}
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function sExiart($cod, $bod) {
		global $empCod;
		return "SELECT ea_exist FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}

	function uExiart($cod, $cant, $bod, $signo) {
		global $empCod;
		return "UPDATE exiart SET ea_exist=ea_exist{$signo}{$cant} WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}

	function iuDoctoss($num, $bodsal, $tcam, $obs, $tot, $codp, $nit, $nom, $dir, $vend, $Batch, $Serial, $hora) { 
		global $empCod, $tipoInv, $dtFec, $usuNom, $selTipoCod, $func;
		if ($func->stringToBool($_POST['nuevo'])) {
			return "INSERT INTO doctoss(ds_emp,ds_tipo,ds_num,ds_fec,ds_fecapli,ds_bodsal,ds_tcam,ds_clicod,ds_clinit,ds_clinom,ds_clidir,ds_vencod,ds_ftipo,ds_fserie,ds_fnum,ds_hora,ds_obs,ds_total,ds_ulcam,ds_lentrega,ds_obsfac) VALUES ('$empCod','$tipoInv','$num','$dtFec','$dtFec','$bodsal','$tcam','$codp','$nit','$nom','$dir','$vend','$selTipoCod','$Batch',$Serial,'$hora','$obs','$tot','$usuNom','','')";
		} else {
			return "UPDATE doctoss SET ds_fec='$dtFec',ds_fecapli='$dtFec',ds_bodsal='$bodsal',ds_tcam='$tcam',ds_clicod='$codp',ds_clinit='$nit',ds_clinom='$nom',ds_clidir='$dir',ds_vencod='$vend',ds_ftipo='$selTipoCod',ds_fserie='$Batch',ds_fnum=$Serial,ds_hora='$hora',ds_obs='$obs',ds_total='$tot',ds_ulcam='$usuNom' WHERE ds_emp='$empCod' AND ds_tipo='$tipoInv' AND ds_num='$num'";
		}
	}

	function sArtic($cod) {
		global $empCod;
		return "SELECT art_cosp FROM artic WHERE art_cod='$cod' AND art_emp='$empCod'";
	}

	function iDetalle($IDInterno, $transac, $Batch, $Serial, $autoriza, $codp, $nit, $vend, $bodsal, $tcam, $obs, $nom, $dir, $expsn, $tot, $asigEnvio, $tipoEnvRelatd, $numEnv, $jsonDetAnt, $jsonDet) {
		global $empCod, $dtFec, $tipoInv, $db, $selTipoCod, $totales, $numInv, $soloInv;
		$func = new functions();

		// CORRELATIVO DE INVENTARIO
		/*$r["corrtdoci"] = "";
		if ($func->stringToBool($_POST['nuevo'])) {
			$select["corrtdoci"] = $db->query("SELECT ctdi_corr FROM corrtdoci WHERE ctdi_emp='$empCod' AND ctdi_tipo='$tipoInv'");
			if ($db->numRows($select["corrtdoci"])>0) {
				$numInv = ($db->fetchAssoc($select["corrtdoci"])["ctdi_corr"]);
				$r["corrtdoci"] = "UPDATE corrtdoci SET ctdi_corr=ctdi_corr+1 WHERE ctdi_emp='$empCod' AND ctdi_tipo='$tipoInv';\n";
			} else {
				$numInv = 1;
				$r["corrtdoci"] = "INSERT INTO corrtdoci (ctdi_emp, ctdi_tipo, ctdi_corr) VALUES('$empCod', '$tipoInv', 2);\n";
			}
		}*/

		// ELIMINAR ANTES DE INSERTAR
		$dFact_det = "DELETE FROM fact_det WHERE factd_emp='$empCod' AND factd_tipo='$selTipoCod' AND factd_serie='$Batch' AND factd_num=$Serial";

		$dDocs_det = "DELETE FROM docs_det WHERE dsd_emp='$empCod' AND dsd_tipo='$tipoInv' AND dsd_num=$numInv";

		$dMovii = "DELETE FROM movii WHERE mov_emp='$empCod' AND mov_tipo='$tipoInv' AND mov_num=$numInv";

		// VARIABLES DE ACUMULACION PARA LOS QUERYS
		$r["exiart"] = "";

		$r["fact_det"] = "{$dFact_det};\n"."INSERT INTO fact_det(factd_idinterno,factd_emp,factd_transac,factd_tipo,factd_serie,factd_num,factd_fec,factd_cod,factd_desc,factd_desci,factd_med,factd_unimed,factd_cant,factd_preu,factd_cosu,factd_sub,factd_descu,factd_descuv,factd_tot,factd_autoriza,factd_codp,factd_nit,factd_vend,factd_bodsal,factd_exensn,factd_bienser) VALUES \n";
		
		$r["docs_det"] = "{$dDocs_det};\n";

		$iDocs_det = "INSERT INTO docs_det(dsd_emp,dsd_tipo,dsd_num,dsd_fec,dsd_fecapli,dsd_linea,dsd_cod,dsd_cant,dsd_cantcon,dsd_desc,dsd_descfac,dsd_med,dsd_unimed,dsd_unit,dsd_descu,dsd_descuv,dsd_monto,dsd_cosu,dsd_exiant,dsd_exipos,dsd_consig,dsd_autoriza,dsd_exensn) VALUES";

		$r["movii"] = "{$dMovii};\n"."INSERT INTO movii(mov_emp,mov_tipo,mov_num,mov_ftipo,mov_fserie,mov_fnum,mov_fec,mov_fecapli,mov_linea,mov_cod,mov_bodent,mov_bodsal,mov_entra,mov_sale,mov_entracon,mov_salecon,mov_cosu,mov_preu) VALUES \n";

		// VARIABLES PARA SEPARAR BIENES, SERVICIOS Y EXPORTACION
		$hayBienes=false;
		$totales["bienes"]["exentoS"]=0;
		$totales["bienes"]["exentoN"]=0;
		$totales["servicios"]["exentoS"]=0;
		$totales["servicios"]["exentoN"]=0;
		$totales["exportacion"]=0;

		// PARA REVERTIR EXISTENCIAS
		foreach ($jsonDetAnt as $obj) {
			if ($obj->factd_bienser!='S') {
				$r["exiart"] .= uExiart($obj->factd_cod, $obj->factd_cant, $obj->factd_bodsal, "+").";\n";
			}
		}

		// RECORRER DETALLE PARA ACUMULAR QUERYS
		$i=0;
		$iUltimoBien=0;
		foreach ($jsonDet as $obj) {
			$i++;
			$obj->codd = utf8_decode($obj->codd);
			$obj->descd = utf8_decode($obj->descd);
			$obj->medid = utf8_decode($obj->medid);
			$obj->unimed = utf8_decode($obj->unimed);
			$cosp = $db->sFetchAssoc(sArtic($obj->codd))["art_cosp"];

			$r["fact_det"].="('$IDInterno','$empCod','$transac','$selTipoCod','$Batch','$Serial','$dtFec','$obj->codd','$obj->descd','$obj->descd','$obj->medid','$obj->unimed','$obj->cantd','$obj->preud','$cosp','$obj->subd','$obj->descud','$obj->descuvd','$obj->totd',0,'$codp','$nit','$vend','$bodsal','$obj->exensnd','$obj->bienserd')".$func->addValuesSemicolon($obj, $jsonDet);

			// OPERACIONES PARA SERPARAR EL TOTAL DE BIENES Y SERVICIOS
			if ($obj->bienserd=='S') {
				$hayServicios = true;
				($obj->exensnd=='N') ? $totales["servicios"]["exentoN"]+=$obj->totd : $totales["servicios"]["exentoS"]+=$obj->totd;
			} else {
				$hayBienes = true;
				$iUltimoBien = $i;
				($obj->exensnd=='N') ? $totales["bienes"]["exentoN"]+=$obj->totd : $totales["bienes"]["exentoS"]+=$obj->totd;

				$r["docs_det"] .= "SET @existAnt=(".sExiart($obj->codd, $bodsal).");\n";
				$r["docs_det"] .= "SET @existAct=@existAnt-".$obj->cantd.";\n";
				$r["docs_det"] .= uExiart($obj->codd, $obj->cantd, $bodsal, "-").";\n";

				$r["docs_det"] .= "{$iDocs_det} ('$empCod','$tipoInv','$numInv','$dtFec','$dtFec',$i,'$obj->codd','$obj->cantd',0,'$obj->descd','$obj->descd','$obj->medid','$obj->unimed','$obj->preud','$obj->descud','$obj->descuvd','$obj->totd','$cosp',@existAnt,@existAct,'',0,'$obj->exensnd');\n";

				$r["movii"] .= "('$empCod','$tipoInv','$numInv','$selTipoCod','$Batch','$Serial','$dtFec','$dtFec',$i,'$obj->codd','','$bodsal',0,'$obj->cantd',0,0,'$cosp','$obj->preud')".$func->addValuesSemicolon($obj, $jsonDet);
			}
		}
		
		$r["docs_det"] = ($iUltimoBien == $i) ? $r["docs_det"] : substr($r["docs_det"], 0, -2).";\n";
		$r["movii"] = ($iUltimoBien == $i) ? $r["movii"] : substr($r["movii"], 0, -2).";\n";

		// EVALUAR SI TAMBIEN SE GUARDA EN MODULO DE INVENTARIO O SOLO EN MODULO DE FACTURACION, SEGUN BIENES O SERVICIOS
		$bien = $totales["bienes"]["exentoS"]+$totales["bienes"]["exentoN"];

		$r["doctoss"] = iuDoctoss($numInv, $bodsal, $tcam, $obs, $bien, $codp, $nit, $nom, $dir, $vend, $Batch, $Serial, date("H:i:s", STRTOTIME(date('h:i:sa')))).";\n";

		$r["bienes"] = (!$hayBienes) ? "" : $r["doctoss"].$r["exiart"].$r["docs_det"].$r["movii"];
		//$r["bienes"] = ($asigEnvio=='S' && $soloInv=='N') ? "" : $r["bienes"];

		if ($asigEnvio=='S' && $soloInv=='N') {
			$r["bienes"] = "UPDATE movii SET mov_ftipo='$selTipoCod', mov_fserie='$Batch', mov_fnum=$Serial WHERE mov_emp='$empCod' AND mov_tipo='$tipoEnvRelatd' AND mov_num=$numEnv;\n";
		} else {
			if ($soloInv=='S') {
				$r["bienes"] .= "UPDATE movii SET mov_ftipo='', mov_fserie='', mov_fnum=0 WHERE mov_emp='$empCod' AND mov_tipo='$tipoInv' AND mov_num=$numInv;\n";
			}
		}

		$r = (sizeof($jsonDet)==0) ? "" : $r["fact_det"].$r["bienes"];

		// SI ES EXPORTACIÓN, ENTONCES PONER CERO EN BIENES Y SERVICIOS - PONER EL TOTAL EN EXPORTACION PARA LOS CALCULOS
		if ($expsn=='S') {
			$totales["bienes"]["exentoS"]=0;
			$totales["bienes"]["exentoN"]=0;
			$totales["servicios"]["exentoS"]=0;
			$totales["servicios"]["exentoN"]=0;
			$totales["exportacion"]=$tot;
		}

		return $r;
	}

	function sPolizas($num, $serie) {
		global $empCod, $tipoPol;
		return "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie'";
	}

	function iPolizas($num, $serie, $con, $nit) {
		global $empCod, $tipoPol, $usuNom, $dtFec, $dtGrabado;
		return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_stat, pol_tipoi, pol_nit, pol_ulcam, pol_grabado) VALUES('$empCod','$dtFec',0,'$tipoPol',$num,'$con','','$serie','$nit','$usuNom','$dtGrabado')";
	}

	function uPolizas($num, $serie, $con, $nit) {
		global $empCod, $tipoPol, $usuNom, $dtFec, $dtGrabado;
		return "UPDATE polizas SET pol_con='$con', pol_fec='$dtFec', pol_nit='$nit', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie'";
	}

	# QUERYS PARA VARIOS REGISTROS
	function iPoli_det($num, $serie, $nit, $jsonPol) {
		global $empCod, $dtFec, $tipoPol;
		$func = new functions();
		$r = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber, pold_stat) VALUES ";
		foreach ($jsonPol as $obj) {
			$obj->cta = utf8_decode($obj->cta);
			$obj->ctaNom = utf8_decode($obj->ctaNom);
			$r = $r."('$empCod','$dtFec',0,'$tipoPol','$num','$serie','$nit','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber','')".$func->addValues($obj, $jsonPol);
		}
		return $r;
	}

	function dPoli_det($num, $serie) {
		global $empCod, $tipoPol;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$soloInv = $db->sFetchAssoc($sTipov)['tv_soloinv'];
	$numInv = $numNum;
	if ($func->stringToBool($_POST['nuevo'])) {
		$IDInterno = $db->sFetchAssoc($sTABLES)['AUTO_INCREMENT'];
		$fecAnt = "0000-00-00";
	} else {
		$fa["facturas"] = $db->sFetchAssoc($sFacturas);
		$IDInterno = $fa["facturas"]["fact_idinterno"];
		$fecAnt = $fa["facturas"]["fact_fec"];
	}
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	$queryAcum = "";
	
	$queryAcum .= iuFacturas($selTipoAbrev, $numNum, $DocumentGUID, $IDInterno, $tot, $txtCliCod, $txtNit, $txtNomFac, $txtDir, $txtTel, $numDcre, $numTcam, $crFpag, $txtObs, $crRet, $crReti, '', $selVendCod, '', '', '', '', $selBodSalCod, "0.00", 0, $crExp, $crAsigEnvio, $selTipoEnvCod, $selTipoEnvAbrev, $numNumEnv).";\n";

	$queryAcum .= iCorrtipov($numNum);

	// APROVECHANDO EL RECORRIDO: SEPARA BIENES, SERVICIOS Y EXPORTACION - ACTUALIZA EXISTENCIAS - GUARDA EN EL MODULO DE INVENTARIO
	$queryAcum .= iDetalle($IDInterno, $IDInterno, $selTipoAbrev, $numNum, 0, $txtCliCod, $txtNit, $selVendCod, $selBodSalCod, $numTcam, $txtObs, $txtNomFac, $txtDir, $crExp, $tot, $crAsigEnvio, $selTipoEnvRelatd, $numNumEnv, $jsonDetAnt, $jsonDet);

	// SI TIENE ASIGNADO UN ENVIO O SE GUARDA EN TODOS LOS MODULOS
	if ($soloInv=='N') {
		// SI EL TIPO AFECTA EL LIBRO DE VENTAS, ENTONCES GUARDAR EN EL MODULO DE IVA
		if ($selTipoLibrosn=='S') {
			$val = calculos($tot, $crRet, $crReti, $crExp, $selTipoImpues, $numTcam, 1);
			$queryAcum .= iuIva_ven($numNum, $selTipoAbrev, $txtNit, $txtNomFac, $crRet, $crReti, $val["bien"], $val["serv"], $val["exen"], $val["exp"], $txtObs, $val["subb"], $val["subs"], $val["sube"], $val["ret"], $val["reti"], $val["sub"], $val["iva"], $val["tot"], 1).";\n";
		}
	}
	// SI LA FORMA DE PAGO ES AL CREDITO, ENTONCES GUARDAR EN EL MODULO DE CUENTAS POR COBRAR
	if ($crFpag==2) {
		$val = calculos($tot, $crRet, $crReti, $crExp, $selTipoImpues, 1, $numTcam);
		$queryAcum .= iuDoctoscc($numNum, $selTipoAbrev, $txtNit, $txtNomFac, $crRet, $crReti, $val["bien"], $val["serv"], $val["exen"], $val["exp"], $txtObs, $val["subb"], $val["subs"], $val["sube"], $val["ret"], $val["reti"], $val["sub"], $val["iva"], $val["tot"], $numTcam, $txtCliCod).";\n";
	}

	// SI EL DOCUMENTO ESTA EXENTO DE IMPUESTOS, ENTONCES GUARDAR POLIZA
	if ($selTipoImpues=='N') {
		$select["polizas"] = $db->query(sPolizas($numNum, $selTipoAbrev));
		$queryAcum .= ($db->numRows($select["polizas"]) > 0) ? uPolizas($numNum, $selTipoAbrev, $txtObs, $txtNit).";\n" : iPolizas($numNum, $selTipoAbrev, $txtObs, $txtNit).";\n";
		$queryAcum .= dPoli_det($numNum, $selTipoAbrev).";\n";
		$queryAcum .= iPoli_det($numNum, $selTipoAbrev, $txtNit, $jsonPol).";\n";
	}

	// PARA BITACORA
	if ($func->stringToBool($_POST['nuevo'])) {
		$queryAcum .= $func->iBitacora(utf8_decode("Se creó Documento IDInterno: {$IDInterno} DocumentGUID: {$DocumentGUID} No.: {$numNum} Serie: {$selTipoAbrev} NIT: {$txtNit} Usuario: ").$usuNom, $bitMod, $bitForm).";\n";
	} else {
		$queryAcum .= $func->iBitacora(utf8_decode("Se modificó Documento IDInterno: {$IDInterno} DocumentGUID: {$DocumentGUID} No.: {$numNum} Serie: {$selTipoAbrev} NIT: {$txtNit} Usuario: ").$usuNom, $bitMod, $bitForm).";\n";
	}

	//echo $queryAcum;
	$resp = $db->multiQueryExR($queryAcum);
	$db->close();

	$db = new dbExec();
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fa["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fa["cuentas"]["cta_acta"]);

			$fa["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fa["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fa["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}

	// PARA APLICAR LOS CIERRES
	foreach ($jsonPol as $obj) {
		$cta = $obj->cta;
		while (!empty($cta)) {
			$fa["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fa["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
			if ($db->numRows($select["cierres"]) > 0) {
				$fa["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fa["cierres"]["cie_mdebe"]+$obj->debe;
				$mhaber=$fa["cierres"]["cie_mhaber"]+$obj->haber;

				$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			} else {
				$mdebe=$obj->debe;
				$mhaber=$obj->haber;

				$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
	}
	$db->close();
	$resp["idinterno"]=$IDInterno;

	return json_encode($resp);
}

function anular() {
	global $empCod, $usuNom, $bitMod, $bitForm, $tipoPol, $db, $func, $dtGrabado, $numInv;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$DocumentGUID = '';
	$selTipoCod = $_POST["selTipoCod"];
	$selTipoAbrev = $_POST["selTipoAbrev"];
	$selTipoRelatd = $_POST["selTipoRelatd"];
	$numNum = $_POST["numNum"];
	$txtObs = $_POST["txtObs"];
	$asigEnvio = "N";

	$jsonDetAnt=json_decode($_POST['tblDetAnt']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$anulado='*** ANULADO ***';

	# QUERYS PARA UN REGISTRO
	$sTipov = "SELECT tv_soloinv FROM tipov WHERE tv_cod='$selTipoCod'";

	$sFacturas = "SELECT f.fact_idinterno, d.ds_tipo, d.ds_num, f.fact_fec, f.fact_nit FROM facturas f
				  LEFT JOIN doctoss d ON d.ds_emp=f.fact_emp AND d.ds_ftipo=f.fact_tipo AND d.ds_fserie=f.fact_serie AND d.ds_fnum=f.fact_num
				  WHERE fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";

	$uFacturas = "UPDATE facturas SET fact_tot=0,fact_nom='$anulado',fact_dir='$anulado',fact_obs='$txtObs',fact_ulcam='$usuNom' WHERE fact_documentguid='$DocumentGUID' AND fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";
	
	$uIva_ven =  "UPDATE iva_ven SET ivav_clin='$anulado', ivav_bien=0, ivav_serv=0, ivav_exen=0, ivav_exp=0, ivav_con='$txtObs', ivav_subb=0, ivav_subs=0, ivav_sube=0, ivav_ret=0, ivav_reti=0, ivav_sub=0, ivav_iva=0, ivav_tot=0, ivav_ulcam='$usuNom' WHERE ivav_emp='$empCod' AND ivav_serie='$selTipoAbrev' AND ivav_num=$numNum AND ivav_tipo='$selTipoCod'";

	$uDoctoscc = "UPDATE doctoscc SET dc_clien='$anulado', dc_bien=0, dc_serv=0, dc_exen=0, dc_exp=0, dc_con='$txtObs', dc_subb=0, dc_subs=0, dc_sube=0, dc_ret=0, dc_reti=0, dc_sub=0, dc_iva=0, dc_tot=0, dc_ulcam='$usuNom' WHERE dc_emp='$empCod' AND dc_serie='$selTipoAbrev' AND dc_num=$numNum AND dc_tipo='$selTipoCod'";

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$selTipoAbrev'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$selTipoAbrev'";

	function uFact_det($IDInterno) {
		return "UPDATE fact_det SET factd_cant=0,factd_preu=0,factd_cosu=0,factd_sub=0,factd_descu=0,factd_descuv=0,factd_tot=0 WHERE factd_idinterno=$IDInterno";
	}

	function uDoctoss($tipo, $num){
		global $empCod, $usuNom, $anulado;
		return "UPDATE doctoss SET ds_obs='$anulado',ds_total=0,ds_ulcam='$usuNom' WHERE ds_emp='$empCod' AND ds_tipo='$tipo' AND ds_num=$num";
	}

	function uDocs_det($tipo, $num) {
		global $empCod;
		return "UPDATE docs_det SET dsd_cant=0,dsd_cantcon=0,dsd_cosu=0,dsd_descu=0,dsd_descuv=0,dsd_monto=0 WHERE dsd_emp='$empCod' AND dsd_tipo='$tipo' AND dsd_num=$num";
	}

	function uMovii($tipo, $num) {
		global $empCod;
		return "UPDATE movii SET mov_entra=0,mov_sale=0,mov_entracon=0,mov_salecon=0,mov_cosu=0,mov_preu=0 WHERE mov_emp='$empCod' AND mov_tipo='$tipo' AND mov_num=$num";
	}

	function uExiart($cod, $cant, $bod, $signo) {
		global $empCod;
		return "UPDATE exiart SET ea_exist=ea_exist{$signo}{$cant} WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}

	function sMeses($mes) {
		return "SELECT mes_nom FROM meses WHERE mes_cod=$mes";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$soloInv = $db->sFetchAssoc($sTipov)['tv_soloinv'];
	$fa["facturas"] = $db->sFetchAssoc($sFacturas);
	$IDInterno = $fa["facturas"]["fact_idinterno"];
	$nit = $fa["facturas"]["fact_nit"];
	$tipoInv = $selTipoRelatd;
	$numInv = $numNum;
	$fecAnt = $fa["facturas"]["fact_fec"];
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	// PARA REVERTIR EXISTENCIAS
	$hayBienes = false;
	$r["exiart"] = "";
	foreach ($jsonDetAnt as $obj) {
		if ($obj->factd_bienser!='S') {
			$hayBienes = true;
			$r["exiart"] .= uExiart($obj->factd_cod, $obj->factd_cant, $obj->factd_bodsal, "+").";\n";
		}
	}

	$queryAcum = "";
	$queryAcum .= $uFacturas.";\n";
	$queryAcum .= uFact_det($IDInterno).";\n";
	$queryAcum .= $uIva_ven.";\n";
	$queryAcum .= $uDoctoscc.";\n";
	
	if ($asigEnvio=='S' && $soloInv=='N') {
		$queryAcum .= "";
	} else {
		if ($hayBienes) {
			$queryAcum .= $r["exiart"];
			$queryAcum .= uDoctoss($tipoInv, $numInv).";\n";
			$queryAcum .= uDocs_det($tipoInv, $numInv).";\n";
			$queryAcum .= uMovii($tipoInv, $numInv).";\n";
		}
	}

	$queryAcum .= $dPolizas.";\n";
	$queryAcum .= $dPoli_det.";\n";
	$queryAcum .= $func->iBitacora(utf8_decode("Se anuló documento IDInterno: {$IDInterno} DocumentGUID: {$DocumentGUID} No.: {$numNum} Serie: {$selTipoAbrev} NIT: {$nit} Usuario: ").$usuNom, $bitMod, $bitForm).";\n";

	//echo $queryAcum;
	$resp = $db->multiQueryAnEx($queryAcum);
	$db->close();

	$db = new dbExec();
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fa["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fa["cuentas"]["cta_acta"]);

			$fa["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fa["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fa["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}
	$db->close();

	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $tipoPol, $db, $func, $dtGrabado, $numInv;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$DocumentGUID = '';
	$selTipoCod = $_POST["selTipoCod"];
	$selTipoAbrev = $_POST["selTipoAbrev"];
	$selTipoRelatd = $_POST["selTipoRelatd"];
	$numNum = $_POST["numNum"];
	$txtObs = $_POST["txtObs"];
	$asigEnvio = "N";

	$jsonDetAnt=json_decode($_POST['tblDetAnt']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	# QUERYS PARA UN REGISTRO
	$sTipov = "SELECT tv_soloinv FROM tipov WHERE tv_cod='$selTipoCod'";

	$sFacturas = "SELECT f.fact_idinterno, d.ds_tipo, d.ds_num, f.fact_fec, f.fact_nit FROM facturas f
				  LEFT JOIN doctoss d ON d.ds_emp=f.fact_emp AND d.ds_ftipo=f.fact_tipo AND d.ds_fserie=f.fact_serie AND d.ds_fnum=f.fact_num
				  WHERE fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";

	$dFacturas = "DELETE FROM facturas WHERE fact_documentguid='$DocumentGUID' AND fact_emp='$empCod' AND fact_tipo='$selTipoCod' AND fact_serie='$selTipoAbrev' AND fact_num=$numNum";
	
	$dIva_ven =  "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$selTipoAbrev' AND ivav_num=$numNum AND ivav_tipo='$selTipoCod'";

	$dDoctoscc = "DELETE FROM doctoscc WHERE dc_emp='$empCod' AND dc_serie='$selTipoAbrev' AND dc_num=$numNum AND dc_tipo='$selTipoCod'";

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$selTipoAbrev'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$selTipoAbrev'";

	function dFact_det($IDInterno) {
		return "DELETE FROM fact_det WHERE factd_idinterno=$IDInterno";
	}

	function dDoctoss($tipo, $num){
		global $empCod;
		return "DELETE FROM doctoss WHERE ds_emp='$empCod' AND ds_tipo='$tipo' AND ds_num=$num";
	}

	function dDocs_det($tipo, $num) {
		global $empCod;
		return "DELETE FROM docs_det WHERE dsd_emp='$empCod' AND dsd_tipo='$tipo' AND dsd_num=$num";
	}

	function dMovii($tipo, $num) {
		global $empCod;
		return "DELETE FROM movii WHERE mov_emp='$empCod' AND mov_tipo='$tipo' AND mov_num=$num";
	}

	function uExiart($cod, $cant, $bod, $signo) {
		global $empCod;
		return "UPDATE exiart SET ea_exist=ea_exist{$signo}{$cant} WHERE ea_emp='$empCod' AND ea_cod='$cod' AND ea_bod='$bod'";
	}

	function sMeses($mes) {
		return "SELECT mes_nom FROM meses WHERE mes_cod=$mes";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$soloInv = $db->sFetchAssoc($sTipov)['tv_soloinv'];
	$fa["facturas"] = $db->sFetchAssoc($sFacturas);
	$IDInterno = $fa["facturas"]["fact_idinterno"];
	$nit = $fa["facturas"]["fact_nit"];
	$tipoInv = $selTipoRelatd;
	$numInv = $numNum;
	$fecAnt = $fa["facturas"]["fact_fec"];
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	// PARA REVERTIR EXISTENCIAS
	$hayBienes = false;
	$r["exiart"] = "";
	foreach ($jsonDetAnt as $obj) {
		if ($obj->factd_bienser!='S') {
			$hayBienes = true;
			$r["exiart"] .= uExiart($obj->factd_cod, $obj->factd_cant, $obj->factd_bodsal, "+").";\n";
		}
	}

	$queryAcum = "";
	$queryAcum .= $dFacturas.";\n";
	$queryAcum .= dFact_det($IDInterno).";\n";
	$queryAcum .= $dIva_ven.";\n";
	$queryAcum .= $dDoctoscc.";\n";

	if ($asigEnvio=='S' && $soloInv=='N') {
		$queryAcum .= "";
	} else {
		if ($hayBienes) {
			$queryAcum .= $r["exiart"];
			$queryAcum .= dDoctoss($tipoInv, $numInv).";\n";
			$queryAcum .= dDocs_det($tipoInv, $numInv).";\n";
			$queryAcum .= dMovii($tipoInv, $numInv).";\n";
		}
	}

	$queryAcum .= $dPolizas.";\n";
	$queryAcum .= $dPoli_det.";\n";
	$queryAcum .= $func->iBitacora(utf8_decode("Se borró documento IDInterno: {$IDInterno} DocumentGUID: {$DocumentGUID} No.: {$numNum} Serie: {$selTipoAbrev} NIT: {$nit} Usuario: ").$usuNom, $bitMod, $bitForm).";\n";

	//echo $queryAcum;
	$resp = $db->multiQueryDEx($queryAcum);
	$db->close();

	$db = new dbExec();
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fa["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fa["cuentas"]["cta_acta"]);

			$fa["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fa["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fa["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}
	$db->close();

	return json_encode($resp);
}

function imprimir() {
	global $empCod;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}
	
	# QUERYS
	$sTipov = "SELECT TRIM(tv_nom) AS tv_nom FROM tipov WHERE tv_cod='{$_POST["selTipoCod"]}'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$fa["tipov"] = $db->sFetchAssoc($sTipov);

	$_SESSION["printFacturas"] = array(
		'tipoNomFEL'=>$fa["tipov"]["tv_nom"],
		'tipoFEL'	=>$_POST["selTipoCod"],
		'nom'		=>$_POST["txtNomFac"],
		'nit'		=>$_POST["txtNit"],
		'dir'		=>$_POST["txtDir"],
		'fec'		=>$_POST["dtFec"],
		'tcam'		=>$_POST["tcam"],
		'tot'		=>$_POST["dataTot"],
		'totLetras'	=>$_POST["totLetras"],
		'det' 		=>$_POST["tblDet"]
	);
	return "";
}

function calculos($tot, $retsn, $retisn, $expsn, $impues, $tcam, $tcamRet) {
	global $totales;

	$val["ret"] = 0;
	$val["reti"] = 0;

	$val["bien"] = round($totales["bienes"]["exentoN"]*$tcam, 2);
	$val["serv"] = round($totales["servicios"]["exentoN"]*$tcam, 2);
	$val["exen"] = round(($totales["bienes"]["exentoS"]+$totales["servicios"]["exentoS"])*$tcam, 2);
	$val["exp"] = round($totales["exportacion"]*$tcam, 2);

	// SUBTOTALES
	$val["subb"] = $val["bien"];
	$val["subs"] = $val["serv"];
	$val["sube"] = $val["exp"];

    // IVA, SUBTOTAL Y TOTAL
	$val["tot"] = round($tot*$tcam, 2);
	$val["sub"] = $val["subb"]+$val["subs"]+$val["exen"]+$val["sube"];
	$val["iva"] = 0;
	if ($impues=="N") {
		$val["subb"] = ($val["bien"]/(($_SESSION['pIva']/100)+1));
		$val["subs"] = ($val["serv"]/(($_SESSION['pIva']/100)+1));
		$val["sube"] = $val["exp"];

		$val["sub"] = $val["subb"]+$val["subs"]+$val["exen"]+$val["sube"];
		$val["iva"] = $val["tot"]-$val["sub"];

		// RETENCION ISR
		$val["ret"]=0;
		$pBaseisrQ = $_SESSION["pBaseisr"]/$tcamRet;
		if ($retsn=='S' && $val["sub"]>=(2500/$tcamRet) && $expsn=='N') {
			if ($val["sub"] > $pBaseisrQ) {
				$sub1 = $pBaseisrQ;
				$sub2 = $val["sub"]-$pBaseisrQ;
			} else {
				$sub1 = $val["sub"];
				$sub2 = 0;
			}
			$ret1=($sub1*$_SESSION["pIsr"])/100;
			$ret2=($sub2*$_SESSION["pIsr2"])/100;
			$val["ret"]=round($ret1+$ret2, 2);
		}
		
		// RETENCION IVA
		$val["reti"] = ($retisn=='S' && $expsn=='N') ? round(($val["iva"]*$_SESSION["pRiva"])/100, 2) : 0;
	}

	return $val;
}
?>