<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=$_SESSION["empNom"];

$selTipoCod = $_GET["selTipoCod"];
$dtFecIni = $_GET["dtFecIni"];
$dtFecFin = $_GET["dtFecFin"];
$crAnu = $_GET["crAnu"];
$crFpag = $_GET["crFpag"];

$condiciones = "";
$condiciones .= ($crAnu!='T') ? "AND fact_tot=0" : "";
$condiciones .= ($crFpag!='T') ? " AND fact_fpag=$crFpag" : "";

# QUERYS
$where = "WHERE fact_emp='$empCod' AND fact_fec>='$dtFecIni' AND fact_fec<='$dtFecFin' AND fact_tipo='$selTipoCod' $condiciones ORDER BY fact_idinterno ASC";
$sFacturas = "SELECT * FROM facturas $where";
$sNotas = "SELECT * FROM notas $where";

# EJECUCION DE QUERYS
$db = new dbExec();

$cr["documentos"] = "";
$cr["formaPago"] = "";
switch ($selTipoCod[0]) {
    case 'F':
        $s = $sFacturas;
        $cr["documentos"] = utf8_decode("DOCUMENTOS: {$_GET["crAnuNom"]}");
        $cr["formaPago"] = utf8_decode("FORMA DE PAGO: {$_GET["crFpagNom"]}");
        break;
    case '5':
        $s = $sFacturas;
        $cr["documentos"] = utf8_decode("DOCUMENTOS: {$_GET["crAnuNom"]}");
        $cr["formaPago"] = utf8_decode("FORMA DE PAGO: {$_GET["crFpagNom"]}");
        break;
    
    default:
        $s = $sNotas;
        break;
}
$select["documentos"] = $db->query($s);

$lineWidth=17.5;
$lineHeight=0.35;
class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineWidth, $lineHeight, $cr;
        $dtFecIni = date('d/m/Y', strtotime($_GET["dtFecIni"]));
        $dtFecFin = date('d/m/Y', strtotime($_GET["dtFecFin"]));
        $this->SetMargins(2, 1, 2);
        $this->SetFont("Arial","",9);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");

        $this->MultiAlignCell($lineWidth/1.36, $lineHeight, "LISTADO DE DOCUMENTOS DEL $dtFecIni AL $dtFecFin",0,0,"L");
        $this->MultiAlignCell($lineWidth/3.75, $lineHeight, $cr["documentos"],0,1,"R");

        $this->MultiAlignCell($lineWidth/1.5, $lineHeight, utf8_decode("TIPO: {$_GET["selTipoCod"]}"),0,0,"L");
        $this->MultiAlignCell($lineWidth/3, $lineHeight, $cr["formaPago"],0,1,"R");

        // Derecha
        $this->SetY(.7);
        $this->Cell(0,1, utf8_decode("PÁGINA: ".((string)($this->PageNo()))),0,1,"R");
        $this->SetY(2.5);

        $header = array("ID","Serie",utf8_decode("Número"),"Fecha","NIT","Nombre en el Documento","Mon","Valor");
        $this->SetFont("","B",7);
        $this->SetWidths(array(1.3,1.75,2,1.5,1.75,6.3,.9,2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));
        $this->RowLHColor($header, $lineWidth, $lineHeight, array(192,192,192), array(0,0,0));

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","L","L","L","C","R"));
    }
    
    function Footer() {
        $this->SetY(-1.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"C");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P", "cm", "Letter");
//$pdf = new FPDF('P','mm',array(500,150));
$pdf->AddPage();

$totDocumentos=0;
while ($rec = $db->fetchAssoc($select["documentos"])) {
    $totDocumentos += round($rec["fact_tot"], 2);
    $body = array(
        trim($rec["fact_idinterno"]),
        trim($rec["fact_serie"]),
        $rec["fact_num"],
        date('d/m/Y', strtotime($rec["fact_fec"])),
        trim($rec["fact_nit"]),
        trim($rec["fact_nom"]),
        ($rec["fact_tcam"]>1) ? "$" : "Q",
        number_format($rec["fact_tot"], 2)
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->Cell($lineWidth/1.152, $lineHeight, "TOTAL", 0, 0, "R");
$pdf->Cell(2.3, $lineHeight, number_format($totDocumentos, 2), 0, 1, "R");

$pdf->Output(utf8_decode("Documentos (FEL-$selTipoCod)").".pdf","I");
?>