<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=$_SESSION["empNom"];

$selTipoCod = $_GET["selTipoCod"];
$dtFecIni = $_GET["dtFecIni"];
$dtFecFin = $_GET["dtFecFin"];
$crAnu = $_GET["crAnu"];
$crFpag = $_GET["crFpag"];

$condiciones = "";
$condiciones .= ($crAnu!='T') ? "AND fact_tot=0" : "";
$condiciones .= ($crFpag!='T') ? " AND fact_fpag=$crFpag" : "";

# QUERYS
$where = "WHERE fact_emp='$empCod' AND fact_fec>='$dtFecIni' AND fact_fec<='$dtFecFin' AND fact_tipo='$selTipoCod' $condiciones ORDER BY fact_idinterno ASC";
$sFacturas = "SELECT f.*, fd.*, TRIM(v.vend_nom) AS vend_nom FROM facturas f
              LEFT JOIN fact_det fd ON f.fact_idinterno=fd.factd_idinterno 
              LEFT JOIN vendedor v ON f.fact_vend=v.vend_cod
              $where";
$sNotas =  "SELECT f.*, fd.*, TRIM(v.vend_nom) AS vend_nom FROM notas f
            LEFT JOIN notas_det fd ON f.fact_idinterno=fd.factd_idinterno
            LEFT JOIN vendedor v ON f.fact_vend=v.vend_cod
            $where";

# EJECUCION DE QUERYS
$db = new dbExec();

$cr["documentos"] = "";
$cr["formaPago"] = "";
switch ($selTipoCod[0]) {
    case 'F':
        $s = $sFacturas;
        $cr["documentos"] = utf8_decode("DOCUMENTOS: {$_GET["crAnuNom"]}");
        $cr["formaPago"] = utf8_decode("FORMA DE PAGO: {$_GET["crFpagNom"]}");
        break;
    case '5':
        $s = $sFacturas;
        $cr["documentos"] = utf8_decode("DOCUMENTOS: {$_GET["crAnuNom"]}");
        $cr["formaPago"] = utf8_decode("FORMA DE PAGO: {$_GET["crFpagNom"]}");
        break;
    
    default:
        $s = $sNotas;
        break;
}
$select["documentos"] = $db->query($s);

$lineWidth=17.5;
$lineHeight=0.35;
class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineWidth, $lineHeight, $cr;
        $dtFecIni = date('d/m/Y', strtotime($_GET["dtFecIni"]));
        $dtFecFin = date('d/m/Y', strtotime($_GET["dtFecFin"]));
        $this->SetMargins(2, 1, 2);
        $this->SetFont("Arial","",9);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");

        $this->MultiAlignCell($lineWidth/1.36, $lineHeight, "LISTADO DE DOCUMENTOS DETALLADO DEL $dtFecIni AL $dtFecFin",0,0,"L");
        $this->MultiAlignCell($lineWidth/3.75, $lineHeight, $cr["documentos"],0,1,"R");

        $this->MultiAlignCell($lineWidth/1.5, $lineHeight, utf8_decode("TIPO: {$_GET["selTipoCod"]}"),0,0,"L");
        $this->MultiAlignCell($lineWidth/3, $lineHeight, $cr["formaPago"],0,1,"R");

        // Derecha
        $this->SetY(.7);
        $this->Cell(0,1, utf8_decode("PÁGINA: ".((string)($this->PageNo()))),0,1,"R");
        $this->SetY(2.5);
    }
    
    function Footer() {
        $this->SetY(-1.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"C");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P", "cm", "Letter");
//$pdf = new FPDF('P','mm',array(500,150));
$pdf->AddPage();
$pdf->SetFont("","",8);

$idInterno=0;
$totDocumentoAnt=0;
$totDocumentos=0;
while ($rec = $db->fetchAssoc($select["documentos"])) {
    if ($idInterno!=$rec["fact_idinterno"]) {
        $totDocumentos += round($rec["fact_tot"], 2);

        // TOTAL DEL DOCUMENTO
        if ($idInterno!=0) {
            $pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->Cell($lineWidth/1.207, $lineHeight, "TOTAL DEL DOCUMENTO", 0, 0, "R");
            $pdf->Cell(3, $lineHeight, number_format($totDocumentoAnt, 2), 0, 1, "R");
            $pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->Ln();
        }

        // ENCABEZADO DEL DOCUMENTO
        $pdf->Cell($lineWidth/15, $lineHeight, "Serie:",0,0);
        $pdf->Cell($lineWidth/5, $lineHeight, trim($rec["fact_serie"]),0,0);
        $pdf->Cell($lineWidth/12, $lineHeight, utf8_decode("Número:"),0,0);
        $pdf->Cell($lineWidth/5, $lineHeight, $rec["fact_num"],0,0);
        $pdf->Cell($lineWidth/15, $lineHeight, utf8_decode("NIT:"),0,0);
        $pdf->Cell($lineWidth/5, $lineHeight, trim($rec["fact_nit"]),0,0);
        $pdf->Cell($lineWidth/15, $lineHeight, utf8_decode("Fecha:"),0,0);
        $pdf->Cell($lineWidth/5, $lineHeight, date('d/m/Y', strtotime($rec["fact_fec"])),0,1);

        $pdf->Cell($lineWidth/7, $lineHeight, "Tasa de Cambio:",0,0);
        $pdf->Cell($lineWidth/9, $lineHeight, $rec["fact_tcam"],0,0);

        $pdf->Cell($lineWidth/12, $lineHeight, utf8_decode("Nombre:"),0,0);
        $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight, trim($rec["fact_nom"]),0,1);
        $pdf->Cell($lineWidth/12, $lineHeight, utf8_decode("Dirección:"),0,0);
        $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight, trim($rec["fact_dir"]),0,1);

        $header = array("Cantidad",utf8_decode("Código"),utf8_decode("Descripción"),"Precio Unit.","Total");
        $pdf->SetFont("","B");
        $pdf->SetWidths(array(1.65,2.5,8,2.35,3));
        $pdf->SetAligns(array("R","L","L","R","R"));
        $pdf->RowLH($header, $lineWidth, $lineHeight);
    }

    // DETALLE DEL DOCUMENTO
    $pdf->SetFont("");
    $pdf->SetAligns(array("R","L","L","R","R"));

    $body = array(
        number_format($rec["factd_cant"], 2),
        trim($rec["factd_cod"]),
        trim($rec["factd_desc"]),
        number_format($rec["factd_preu"], 2),
        number_format($rec["factd_tot"], 2)
    );
    $pdf->RowBorderHidden($body, $lineHeight);

    $idInterno=$rec["fact_idinterno"];
    $totDocumentoAnt=$rec["fact_tot"];
}

// TOTAL DEL DOCUMENTO
if ($idInterno!=0) {
    $pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
    $pdf->Cell($lineWidth/1.207, $lineHeight, "TOTAL DEL DOCUMENTO", 0, 0, "R");
    $pdf->Cell(3, $lineHeight, number_format($totDocumentoAnt, 2), 0, 1, "R");
    $pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
    $pdf->Ln();
}

// TOTAL GENERAL DE DOCUMENTOS
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->Cell($lineWidth/1.207, $lineHeight, "TOTAL GENERAL", 0, 0, "R");
$pdf->Cell(3, $lineHeight, number_format($totDocumentos, 2), 0, 1, "R");
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX(), $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

$pdf->Output(utf8_decode("Documentos Detallado (FEL-$selTipoCod)").".pdf","I");
?>