<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=$_SESSION["empNom"];

$dtFecIni = $_GET["dtFecIni"];
$dtFecFin = $_GET["dtFecFin"];
$txtCliCod = $_GET["txtCliCod"];

# QUERYS
$where = "WHERE fact_emp='$empCod' AND fact_fec>='$dtFecIni' AND fact_fec<='$dtFecFin' AND fact_codp='$txtCliCod' ORDER BY fact_idinterno ASC";
$sFacturas = "SELECT * FROM facturas $where";
$sNotas = "SELECT * FROM notas $where";

# EJECUCION DE QUERYS
$db = new dbExec();

$select["facturas"] = $db->query($sFacturas);
$select["notas"] = $db->query($sNotas);

$lineWidth=17.5;
$lineHeight=0.35;
class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineWidth, $lineHeight, $cr;
        $dtFecIni = date('d/m/Y', strtotime($_GET["dtFecIni"]));
        $dtFecFin = date('d/m/Y', strtotime($_GET["dtFecFin"]));
        $this->SetMargins(2, 1, 2);
        $this->SetFont("Arial","",9);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");

        $this->MultiAlignCell($lineWidth/1.36, $lineHeight, utf8_decode("LISTADO DE DOCUMENTOS SEGÚN CLIENTE DEL $dtFecIni AL $dtFecFin"),0,1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("CÓDIGO CLIENTE: {$_GET["txtCliCod"]}"),0,1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NOMBRE CLIENTE: {$_GET["txtCliNom"]}"),0,1);

        // Derecha
        $this->SetY(.7);
        $this->Cell(0,1, utf8_decode("PÁGINA: ".((string)($this->PageNo()))),0,1,"R");
        $this->SetY(2.7);

        $header = array("FEL","Serie",utf8_decode("Número"),"Fecha","NIT","Nombre en el Documento","M","Valor");
        $this->SetFont("","B",7);
        $this->SetWidths(array(1.05,1.75,2,1.5,1.75,7,.45,2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));
        $this->RowLHColor($header, $lineWidth, $lineHeight, array(192,192,192), array(0,0,0));

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","L","L","L","C","R"));
    }
    
    function Footer() {
        $this->SetY(-1.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"C");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P", "cm", "Letter");
//$pdf = new FPDF('P','mm',array(500,150));
$pdf->AddPage();

$totFacturas=0;
$totNotas=0;
while ($rec = $db->fetchAssoc($select["facturas"])) {
    $totFacturas += round($rec["fact_tot"], 2);
    $body = array(
        $rec["fact_tipo"],
        trim($rec["fact_serie"]),
        $rec["fact_num"],
        date('d/m/Y', strtotime($rec["fact_fec"])),
        trim($rec["fact_nit"]),
        trim($rec["fact_nom"]),
        ($rec["fact_tcam"]>1) ? "$" : "Q",
        number_format($rec["fact_tot"], 2)
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
while ($rec = $db->fetchAssoc($select["notas"])) {
    $totNotas += round($rec["fact_tot"], 2);
    $body = array(
        $rec["fact_tipo"],
        trim($rec["fact_serie"]),
        $rec["fact_num"],
        date('d/m/Y', strtotime($rec["fact_fec"])),
        trim($rec["fact_nit"]),
        trim($rec["fact_nom"]),
        ($rec["fact_tcam"]>1) ? "$" : "Q",
        number_format($rec["fact_tot"], 2)
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->Cell($lineWidth/1.152, $lineHeight, "TOTAL FACTURAS", 0, 0, "R");
$pdf->Cell(2.3, $lineHeight, number_format($totFacturas, 2), 0, 1, "R");
$pdf->Cell($lineWidth/1.152, $lineHeight, "TOTAL NOTAS", 0, 0, "R");
$pdf->Cell(2.3, $lineHeight, number_format($totNotas, 2), 0, 1, "R");

$pdf->Output(utf8_decode("Documentos Según Cliente (FEL)").".pdf","I");
?>