<?php 
include_once('../../../php/sessionStart.php'); 
include_once('../../../php/db/dbExec.php');
?>
<?php include_once('../includes/htmlOpen.php'); ?>
    <main class="main" style="">
      <?php 
        $li[0] = '<i class="fas fa-file-invoice"></i>';
        $li[1] = $_GET["opcNom"];
        include_once('../../../php/includes/ol.php');
        $modalImp = "modalImp";
        include_once('../../../php/includes/modalImp.php');
      ?>

      <div class="container-as">
        <div class="row">
          <div class="col">
            <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" id="pills-0-tab" data-toggle="pill" href="#pills-0" role="tab" aria-controls="pills-0" aria-selected="true">Mantenimiento</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" id="pills-1-tab" data-toggle="pill" href="#pills-1" role="tab" aria-controls="pills-1" aria-selected="true">Buscar Vendedores</a>
              </li>
              <li class="nav-item">
                <button class="nav-link btn btn-link" id="btnILista" type="button">Listado de Vendedores</button>
              </li>
            </ul>
            <div class="tab-content bg-transparent border-0" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-0" role="tabpanel" aria-labelledby="pills-0-tab">
                <form action="" name="thisform" autocomplete="off" enctype="multipart/form-data">
                  <div class="form-group">
                    <div class="form-row">
                      <div class="col-6 col-sm-3 col-md-2">
                        <label for="txtCod">Código</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtCod" maxlength="10">
                      </div>
                    </div>

                    <div class="form-row">
                      <div class="col-md-8">
                        <label for="txtNom">Nombre</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtNom" maxlength="80">
                      </div>
                      <div class="col-md-8">
                        <label for="txtDir">Dirección</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtDir" maxlength="120">
                      </div>
                    </div>

                    <div class="form-row">
                      <div class="col-6 col-sm-5 col-md-3">
                        <label for="txtTel">Teléfono</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtTel" maxlength="30">
                      </div>
                      <div class="col-6 col-sm-5 col-md-3">
                        <label for="txtCel">Celular</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtCel" maxlength="30">
                      </div>
                      <div class="col-4 col-sm-2 offset-4 offset-sm-0">
                        <label for="numPorc">Comisión</label>
                        <div class="input-group input-group-sm mb-2">
                          <input type="text" class="form-control form-control-sm form-control-as dec-0" id="numPorc" maxlength="30">
                          <div class="input-group-append">
                            <div class="input-group-text bg-secondary">%</div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="form-row">
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="form-row">
                      <div class="form-group col">
                        <button class="btn btn-success btn-lg btn-block" id="btnGuardar" type="button">Guardar</button>
                      </div>
                      <div class="form-group col">
                        <button class="btn btn-danger btn-lg btn-block" id="btnBorrar" type="button">Borrar</button>
                      </div>
                    </div>
                  </div>
                </form>

              </div>
              <div class="tab-pane fade" id="pills-1" role="tabpanel" aria-labelledby="pills-1-tab">
                <?php
                  $a='0';
                  $b='1';
                  include('../busVendedor/index.html')
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
<?php include_once('../../../php/includes/htmlClose.php'); ?>

<script>
  var pressEnter = false;
  var inputVendedor = "txtCod"
  var nuevo = true;

  const txtNom = document.thisform.txtNom;
  
  function restriccion(consultar = false){
    if (!consultar) {
      if (isNullPer(txtCod.value)) {
        txtCod.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el CÓDIGO"}});
        return true;
      }
      if (isNullPer(txtNom.value)) {
        txtNom.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NOMBRE"}});
        return true;
      }
    } else {
      if (isNullPer(txtCod.value)) {
        limpiar();
        return true;
      }
    }
    return false;
  }

  function limpiar(){
    txtNom.value = "";
    txtDir.value = "";
    txtTel.value = "";
    txtCel.value = "";
    numPorc.value = "";
  }

  $(document).ready(function() {
    $(this).find('input:visible:first').focus();

    // SUBMIT FORM
    $('form').submit(function() {
      return false;
    });
    
    $("form[name='thisform'] #txtCod")
    .focus(function() {
      inputVendedor = $(this).attr('id');
      $("#btnGuardar").off("focus");
      $("#btnBorrar").off("focus");
      txtCod.value = "";
      limpiar();
    })
    .keypress(function(e) {
      const keycode = e.keyCode || e.which;
      if (keycode == '13') {
        pressEnter = true;
        txtNom.focus();
      }
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-1-tab").click(); }
    })
    .change(function (){
      txtThis = this;
      txtGetValue = document.getElementById("txtNom");
      txtNext = document.getElementById("txtNom");

      $(txtThis).off("blur");

      const parametros = new FormData();
      parametros.append("action", "consultar");
      parametros.append("txtCod", txtCod.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
          alLoad("Consultando...")
        },
        success: function (jsonPhp) {
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (jsonJS.vendedor === null) {
              limpiar();
              nuevo = true;
            } else {
              txtNom.value = jsonJS.vendedor.vend_nom;
              txtDir.value = jsonJS.vendedor.vend_dir;
              txtTel.value = jsonJS.vendedor.vend_tel;
              txtCel.value = jsonJS.vendedor.vend_cel;
              numPorc.value = jsonJS.vendedor.vend_porc;
              nuevo = false;
            }
            alCloseFocus(txtNext);
            pressEnter = false;
            blurOn(txtThis, txtGetValue);
          }
        }
      });
    });

    // CLICK BORRAR
    $("#btnBorrar").click(function (){
      if (restriccion()) {return};
      const fnT = function(){
        const parametros = new FormData();
        parametros.append("action", "borrar");

        parametros.append("txtCod", txtCod.value);
        parametros.append("txtNom", txtNom.value);
        
        $.ajax({
          data:  parametros,
          url:   window.location.origin+window.location.pathname+"actions.php",
          type:  "post",
          contentType: false,
          processData: false,
          beforeSend: function () {
            alLoad("Cargando...")
          },
          success: function (jsonPhp) {
            const jsonJS = JSON.parse(jsonPhp);

            if(jsonJS.error==true){
              alError(jsonJS);
            } else {
              alSuccess(jsonJS);
              $("#btnBorrar").focus(function (){
                txtCod.focus();
              });
            }
          }
        });
      }
      const fnF = function(){
        return true;
      }

      usuClave(fnT, fnF);
    });

    // CLICK GUARDAR
    $("#btnGuardar").click(function (){
      if (restriccion()) {return};

      const parametros = new FormData();
      parametros.append("action", "guardar");

      parametros.append("nuevo", nuevo);
      parametros.append("txtCod", txtCod.value);
      parametros.append("txtNom", txtNom.value);
      parametros.append("txtDir", txtDir.value);
      parametros.append("txtTel", txtTel.value);
      parametros.append("txtCel", txtCel.value);
      parametros.append("numPorc", numPorc.value);
      
      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
          alLoad("Cargando...")
        },
        success: function (jsonPhp) {
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error==true){
            alError(jsonJS);
          } else {
            alSuccess(jsonJS);
            $("#btnGuardar").focus(function (){
              txtCod.focus();
            });
          }
        }
      });
    });
  });

   // CLICK IMPRIMIR
   $("#btnILista").click(function (){
     $('#modalImp').modal('show');
     var url = window.location.origin+window.location.pathname+"print.php";

     document.getElementById("objView").data = url;
     $('#ifrView').attr('src', url);
     $('#notSupportPDF').attr('href', url);
   });

  $('#modalImp').on('hidden.bs.modal', function (e) {
    txtCod.focus();
  });

  // FOCUS PILL
  $('a[data-toggle="pill"]').on('shown.bs.tab', function (e) {
    if (!isMobile()) {
      const target = e.target.attributes.href.value;
      const relatedTarget = e.relatedTarget.attributes.href.value;

      if ((target == "#pills-0" && isNullPer(txtCod.value)) || target != "#pills-0") {
        $(target+' input:visible:first').focus();
      } else {
        (relatedTarget == "#pills-1") ? txtNom.focus() : 0;
      }
    }
  });

</script>