<?php
$lineWidth=19.5;
$lineHeight=0.4;

if ($rec["fact_tcam"]>1) {
   $tcam="$";
} else {
   $tcam="Q";
}  

$pdf->AddPage();

// Para anular factura
if ($rec["fact_tot"] == 0) {
    $pdf->SetFont('Arial','B',100);
    $pdf->SetTextColor(255, 144, 144);
    $pdf->SetY(12);
    $pdf->Cell($lineWidth, 1, "ANULADO",0,0,"C");
}

$pdf->SetFont("Arial","B",7);
$pdf->SetTextColor(0,0,0);
$pdf->SetMargins(1, 1, 1);
$pdf->SetAutoPageBreak(true,.5);
$lineHeight7 = .3;
if ($empCod=='9') {
  $img = '../img/OBD_LOGO.jpg';
  $pdf->Image($img,1,.05,7,3);
  $pdf->SetY(2.4);
  $pdf->Cell(0, 0, "", 0, 1);
  $pdf->Cell($lineWidth/12.5, $lineHeight7, "");
  $pdf->SetFont("Times","BI",13);
  $pdf->Cell($lineWidth/3, $lineHeight7+.5, TRIM($empNom),0,1,"C");
  $pdf->SetFont("Arial","B",9);
  $pdf->Cell($lineWidth/12.5, $lineHeight7, "");
  $pdf->Cell($lineWidth/3, $lineHeight7, 'NIT: '.$empNit,0,1,"C");
  $pdf->Cell($lineWidth/12.5, $lineHeight7, "");
  $pdf->Cell($lineWidth/3, $lineHeight7, $empNomc,0,1,"C");
  $pdf->MultiAlignCell($lineWidth/2, .3, $empDir,0,1,"C");
} else {
  if ($empCod == '10') {
    $img = '../img/LOGO_CCT.jpg';
  }
  if ($empCod == '2') {
    $img = '../img/LOGO_CCAS.jpg';
  }
  if ($empCod == '4') {
    $img = '../img/LOGO_TRESMARIAS.jpg';
  }
  $pdf->Image($img,1,.85,3,3.5);
  $pdf->SetY(1.4);
  
  $pdf->Cell(0, 0, "", 0, 1);
  $pdf->Cell($lineWidth/4, $lineHeight7, "");
    $pdf->SetFont("Times","BI",12);
  $pdf->Cell($lineWidth/3, $lineHeight7+.5, TRIM($empNom),0,1,"C");
  $pdf->SetFont("Arial","B",9);
  $pdf->Cell($lineWidth/4, $lineHeight7, "");
  $pdf->Cell($lineWidth/3, $lineHeight7, 'NIT: '.$empNit,0,1,"C");
  $pdf->Cell($lineWidth/4, $lineHeight7, "");
  $pdf->SetFont("Arial","B",8);
  if ($empCod!="4") {
     $pdf->Cell($lineWidth/3, $lineHeight7, $empNomc,0,1,"C");
  } else {
     $pdf->Cell($lineWidth/3, $lineHeight7, "ACADEMIA DE CURSOS LIBRES KINGWOOD",0,1,"C");
  }
  $pdf->Cell($lineWidth/5.2, $lineHeight7, "",0,0,"L");
  $pdf->MultiAlignCell($lineWidth/2.3, .3, $empDir,0,1,"C");
}

$pdf->SetFont("Arial","B",9);
// Derecha
$y = 1.3;
$x = 14;
$pdf->SetY($y);
$pdf->SetX($x);
$pdf->Cell($lineWidth/2.9, 1, "DOCUMENTO TRIBUTARIO ELECTRONICO",0,1,"C");
$pdf->SetY($y+=$lineHeight+.07);
$pdf->SetX($x);
$pdf->Cell($lineWidth/2.9,1, utf8_decode("FACTURA"),0,1,"C");

if ($rec["fact_documentguid"]!="") {
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "NUMERO DE AUTORIZACION:",0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, $rec["fact_documentguid"],0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "SERIE: ".$rec["fact_serie"],0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "No. ".$rec["fact_num"],0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "Id Interno:  ".$rec["fact_idinterno"],0,1,"C");
} else {
    $pdf->SetY($y+=$lineHeight*2);
    $pdf->SetX($x);
    $pdf->SetFont("Arial","B",28);
    $pdf->MultiAlignCell($lineWidth/3,.8, "VISTA PREVIA",0,1,"C");
    $pdf->SetFont("Arial","B",9);
}
$pdf->SetY(4.5);

$pdf->line($pdf->GetX(), $pdf->GetY(), $lineWidth+1, $pdf->GetY());

$pdf->SetY($pdf->GetY()+.25);

$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/9.30, $lineHeight, utf8_decode("NOMBRE:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/1.5, $lineHeight, $rec["fact_nom"],0,0,"L");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("FECHA:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, date('d-m-Y', strtotime($rec["fact_fec"])),0,1,"L");

$pdf->MultiAlignCell($lineWidth/9.30, $lineHeight, utf8_decode("DIRECCIÓN:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/1.5, .3, $rec["fact_dir"],0,0,"L");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NIT:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode(str_replace('-','',$rec["fact_nit"])),0,1,"L");

$pdf->MultiAlignCell($lineWidth/9.30, $lineHeight, utf8_decode("ALUMNO:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/1.5, .3, $rec["fact_alumno"],0,0,"L");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("TELEFONO:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode($rec["fact_tel"]),0,1,"L");

$pdf->SetY($pdf->GetY()+.25);

$header = array(utf8_decode("DESCRIPCIÓN"),"IMPORTE ".$tcam);
$widths = array(16.76,2.74);
$pdf->SetWidths($widths);
$pdf->SetAligns(array("C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetAligns(array("L","R"));

// Lineas separadoras del detalle
$detX = 0;
$detY = $pdf->GetY()+17.2;
$pdf->line($pdf->GetX(), $pdf->GetY(), $pdf->GetX(), $detY);
foreach ($widths as $x) {
    $detX+=$x;
    $pdf->line($pdf->GetX()+$detX, $pdf->GetY(), $pdf->GetX()+$detX, $detY);
}
$descuv=0;
$sub=0;
while ($recDet = $db->fetchAssoc($select["fact_det"])) {
    $body = array(
//        $recDet["factd_cod"],
        $recDet["factd_desc"],
//        ($recDet["factd_cant"] > 0) ? $recDet["factd_cant"] : "",
//        ($recDet["factd_preu"] > 0) ? number_format($recDet["factd_preu"],2) : "",
        ($recDet["factd_tot"] > 0) ? $tcam.number_format($recDet["factd_sub"],2) : ""
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $sub+=$recDet["factd_sub"];
    $descuv+=$recDet["factd_descuv"];
}
$pdf->SetY(22.5);
$pdf->MultiAlignCell(7, $lineHeight, "",0,0,"L");
$pdf->MultiAlignCell(4, $lineHeight, "Impuestos en el DTE",0,1,"L");
$pdf->MultiAlignCell(7, $lineHeight, "",0,0,"L");
$pdf->MultiAlignCell(.9, $lineHeight, "IVA",0,0,"L");
$pdf->MultiAlignCell(2.5, $lineHeight, ($rec["ivav_iva"] > 0) ? number_format($rec["ivav_iva"],6) : "0.000000",0,1,"R");
$pdf->Cell($lineWidth-2, $lineHeight, "** SUJETO A PAGOS TRIMESTRALES **",0,1,"C");

$moneda = ($tcam=='Q') ? "QUETZALES" : utf8_decode("DÓLARES");
//$pdf->SetFont("","",6);
//$pdf->MultiAlignCell(15.7, $lineHeight, "",'TLB',0,"L");
//$pdf->SetFont("","",8);
//$pdf->Cell(1.05, $lineHeight, "SUBTOTAL:",'TBR',0,"R");
//$pdf->Cell(2.75, $lineHeight, $tcam.number_format($sub, 2),1,1,"R");
//$pdf->SetFont("","",6);
//$pdf->MultiAlignCell(15.7, $lineHeight, "",'TLB',0,"L");
//$pdf->SetFont("","",8);
//$pdf->Cell(1.05, $lineHeight, "(-) DESCUENTO:",'TBR',0,"R");
//$pdf->Cell(2.75, $lineHeight, $tcam.number_format($descuv, 2),1,1,"R");
$pdf->SetFont("","",6);
$pdf->MultiAlignCell(15.7, $lineHeight, "EN LETRAS: $totLetras $moneda",'TLB',0,"L");
$pdf->SetFont("","",8);
$pdf->Cell(1.05, $lineHeight, "TOTAL:",'TBR',0,"R");
$pdf->SetFont("","B",10);
$pdf->Cell(2.75, $lineHeight, $tcam.number_format($rec["fact_tot"], 2),1,1,"R");

$pdf->Ln();

//$pdf->MultiAlignCell($lineWidth/2, $lineHeight, "AUTORIZADO\n\n________________________\n".utf8_decode($empNomc),1,0,"C");
//$pdf->MultiAlignCell($lineWidth/2, $lineHeight, "CLIENTE\n\n________________________\nRECIBI CONFORME",1,0,"C");

//$pdf->Ln(.2);

$FechaHoraCertificacion = $rec["fact_guardado"];
$NombreCertificador = "COFIDI, SOCIEDAD ANONIMA - NIT:62469045";

$pdf->Cell($lineWidth, .1, "",1,1);
$pdf->Cell($lineWidth, $lineHeight, "DATOS FISCALES",1,1,"C");
$pdf->SetFont("Arial","B");
$pdf->Cell($lineWidth, $lineHeight, utf8_decode("Fecha de certificación: ").$FechaHoraCertificacion,1,1);
$pdf->Cell($lineWidth, $lineHeight, utf8_decode("CERTIFICADOR: ").$NombreCertificador,1,1);
?>