<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selTipodoci=$_GET["selTipodoci"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $selTipodoci;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE DOCUMENTOS DE ENTRADA DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");

        $this->Ln();
        $this->SetFont("","",8);
        $this->SetFont("","B");
        $this->SetWidths(array(1.7,2.3,1.8,2,6,7,1.6,2.2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","C","L","L","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selTipodoci=='000') {
    $sDoctose = "SELECT *, TRIM(de.de_obs) AS de_obs, TRIM(td.td_nom) AS td_nom
       FROM doce_det ded LEFT JOIN doctose de ON ded.ded_emp=de.de_emp and ded.ded_tipo=de.de_tipo and ded.ded_num=de.de_num 
       LEFT JOIN tipodoci td ON  ded.ded_tipo=td.td_cod 
       LEFT JOIN serieoc so ON  de.de_serieoc=so.so_cod 
       LEFT JOIN bodegas bod ON  de.de_bodent=bod.bod_cod 
       WHERE ded_emp='$empCod' and ded_fec>='$dtFeci' and ded_fec<='$dtFecf'  GROUP BY ded_emp,ded_tipo,ded_num,ded_cod ORDER BY ded_fec,ded_tipo,ded_num";
} else {
    $sDoctose = "SELECT *, TRIM(de.de_obs) AS de_obs, TRIM(td.td_nom) AS td_nom
       FROM doce_det ded LEFT JOIN doctose de ON ded.ded_emp=de.de_emp and ded.ded_tipo=de.de_tipo and ded.ded_num=de.de_num 
       LEFT JOIN tipodoci td ON  ded.ded_tipo=td.td_cod 
       LEFT JOIN serieoc so ON  de.de_serieoc=so.so_cod 
       LEFT JOIN bodegas bod ON  de.de_bodent=bod.bod_cod 
       WHERE ded_emp='$empCod' and ded_tipo='$selTipodoci' and ded_fec>='$dtFeci' and ded_fec<='$dtFecf' GROUP BY ded_emp,ded_tipo,ded_num,ded_cod ORDER BY ded_fec,ded_tipo,ded_num";
}           
# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["doce_det"] = $db->query($sDoctose);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "letter");
$pdf->AddPage();
$func = new functions();

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$subcant=0;
$totcant=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["doce_det"])) {
    if ($t_lini == 1) {
        //$pdf->SetFont("","B",8);        
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["ded_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["ded_fec"])),0,1,"L");
        if ($rec["td_afecos"]=='S' && $rec["td_inveini"]=='N') {
          $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("ORDEN DE COMPRA:   ".trim($rec["so_nom"])." - ".$rec["de_numoc"]),0,1,"L");
        }
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("BODEGA:  ".trim($rec["bod_nom"])."          ES PARA PRORRATEO:  ".$rec["de_prorsn"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("OBSERVACIONES: ".$rec["de_obs"]),0,1,"L");
        $pdf->SetFont("","",8);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","TOTAL","BONIFICA","EXENTO");
        $pdf->SetWidths(array(2.3,5.5,2,1.7,2,2,1.6,1.6));
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","C","R","R","R","R","C"));
    }
    if ($ti_tipo!=$rec["ded_tipo"]  || $ti_num!=$rec["ded_num"]) {
        if ($t_lini > 1) {
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
            $pdf->Cell(.04,.4,"          TOTAL ESTE DOCUMENTO",0,0,"L");
            $body = array(
                "",
                "",
                "",
                number_format($subcant, 2, '.', ','),
                "",
                number_format($subtot, 5, '.', ','),
            ); 
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
            $pdf->ln();
            $pdf->MultiAlignCell($lineWidth, $lineHeight, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["ded_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["ded_fec"])),0,1,"L");
            if ($rec["td_afecos"]=='S' && $rec["td_inveini"]=='N') {
              $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("ORDEN DE COMPRA:   ".trim($rec["so_nom"])." - ".$rec["de_numoc"]),0,1,"L");
            }
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("BODEGA:  ".trim($rec["bod_nom"])."          ES PARA PRORRATEO:  ".$rec["de_prorsn"]),0,1,"L");
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("OBSERVACIONES: ".$rec["de_obs"]),0,1,"L");
            $pdf->SetFont("","",8);   
            $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","TOTAL","BONIFICA","EXENTO");
            $pdf->SetWidths(array(2.3,5.5,2,1.7,2,2,1.6,1.6));
            $pdf->SetAligns(array("C","C","C","C","C","C","C","C"));
            $pdf->Row($header, $lineHeight);
            $pdf->SetAligns(array("L","L","C","R","R","R","R","C"));
        }             
        $subtot=0;
        $subcant=0;
        $ti_tipo=$rec["ded_tipo"];
        $ti_num=$rec["ded_num"];

        $t_lini=2;
    } 
    $subtot += $rec["ded_cost"];
    $tottot += $rec["ded_cost"];
    $subcant += $rec["ded_cant"];
    $totcant += $rec["ded_cant"];

    $body = array(
        $rec["ded_cod"],
        $rec["ded_desc"],
        $rec["ded_unimed"],
        ($rec["ded_cant"] > 0) ? number_format($rec["ded_cant"],2) : "",
        ($rec["ded_cosu"] > 0) ? number_format($rec["ded_cosu"],5) : "",
        ($rec["ded_cost"] > 0) ? number_format($rec["ded_cost"],5) : "",
        ($rec["ded_boni"] > 0) ? number_format($rec["ded_boni"],2) : "",
         $rec["ded_exesn"],
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
    if (($pdf->GetY()+$lineHeight) > 25) {
        $pdf->AddPage();
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["ded_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["ded_fec"])),0,1,"L");
        if ($rec["td_afecos"]=='S' && $rec["td_inveini"]=='N') {
          $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("ORDEN DE COMPRA:   ".trim($rec["so_nom"])." - ".$rec["de_numoc"]),0,1,"L");
        }
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("BODEGA:  ".trim($rec["bod_nom"])."          ES PARA PRORRATEO:  ".$rec["de_prorsn"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("OBSERVACIONES: ".$rec["de_obs"]),0,1,"L");
        $pdf->SetFont("","",8);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","TOTAL","BONIFICA","EXENTO");
        $pdf->SetWidths(array(2.3,5.5,2,1.7,2,2,1.6,1.6));
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","C","R","R","R","R","C"));
    }    
}

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL ESTE DOCUMENTO",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($subcant, 2, '.', ','),
    "",
    number_format($subtot, 5, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
$pdf->ln();

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL GENERAL",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($totcant, 2, '.', ','),
    "",
    number_format($tottot, 5, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());

$pdf->Output(utf8_decode("Lista Documentos Entrada" ).".pdf","I");

$db->close();

?>