<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selTipodoci=$_GET["selTipodoci"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $selTipodoci;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE DOCUMENTOS DE SALIDA DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");

        $this->Ln();
        $this->SetFont("","",8);
        $this->SetFont("","B");
        $this->SetWidths(array(1.7,2.3,1.8,2,6,7,1.6,2.2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","C","L","L","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selTipodoci=='000') {
    $sDoctoss = "SELECT *, TRIM(ds.ds_obs) AS ds_obs, TRIM(td.td_nom) AS td_nom
       FROM docs_det dsd LEFT JOIN doctoss ds ON dsd.dsd_emp=ds.ds_emp and dsd.dsd_tipo=ds.ds_tipo and dsd.dsd_num=ds.ds_num 
       LEFT JOIN tipodoci td ON  dsd.dsd_tipo=td.td_cod 
       LEFT JOIN bodegas bod ON  ds.ds_bodsal=bod.bod_cod 
       WHERE dsd_emp='$empCod' and dsd_fec>='$dtFeci' and dsd_fec<='$dtFecf' GROUP BY dsd_emp,dsd_tipo,dsd_num,dsd_cod ORDER BY dsd_fec,dsd_tipo,dsd_num";
} else {
    $sDoctoss = "SELECT *, TRIM(ds.ds_obs) AS ds_obs, TRIM(td.td_nom) AS td_nom
       FROM docs_det dsd LEFT JOIN doctoss ds ON dsd.dsd_emp=ds.ds_emp and dsd.dsd_tipo=ds.ds_tipo and dsd.dsd_num=ds.ds_num 
       LEFT JOIN tipodoci td ON  dsd.dsd_tipo=td.td_cod 
       LEFT JOIN bodegas bod ON  ds.ds_bodsal=bod.bod_cod 
       WHERE dsd_emp='$empCod' and dsd_tipo='$selTipodoci' and dsd_fec>='$dtFeci' and dsd_fec<='$dtFecf' GROUP BY dsd_emp,dsd_tipo,dsd_num,dsd_cod ORDER BY dsd_fec,dsd_tipo,dsd_num";
}           
# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["docs_det"] = $db->query($sDoctoss);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "letter");
$pdf->AddPage();
$func = new functions();

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$subcant=0;
$totcant=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["docs_det"])) {
    if ($t_lini == 1) {
        //$pdf->SetFont("","B",8);        
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["dsd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["dsd_fec"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("BODEGA QUE SALIO:  ".trim($rec["bod_nom"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("OBSERVACIONES: ".$rec["ds_obs"]),0,1,"L");
        $pdf->SetFont("","",8);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","TOTAL");
        $pdf->SetWidths(array(2.3,7.2,2,2,2.6,2.6));
        $pdf->SetAligns(array("C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","C","R","R","R"));
    }
    if ($ti_tipo!=$rec["dsd_tipo"]  || $ti_num!=$rec["dsd_num"]) {
        if ($t_lini > 1) {
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
            $pdf->Cell(.04,.4,"          TOTAL ESTE DOCUMENTO",0,0,"L");
            $body = array(
                "",
                "",
                "",
                number_format($subcant, 2, '.', ','),
                "",
                number_format($subtot, 5, '.', ','),
            ); 
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
            $pdf->ln();
            $pdf->MultiAlignCell($lineWidth, $lineHeight, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["dsd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["dsd_fec"])),0,1,"L");
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("BODEGA QUE SALIO:  ".trim($rec["bod_nom"])),0,1,"L");
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("OBSERVACIONES: ".$rec["ds_obs"]),0,1,"L");
            $pdf->SetFont("","",8);   
            $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","TOTAL");
            $pdf->SetWidths(array(2.3,7.2,2,2,2.6,2.6));
            $pdf->SetAligns(array("C","C","C","C","C","C"));
            $pdf->Row($header, $lineHeight);
            $pdf->SetAligns(array("L","L","C","R","R","R"));
        }             
        $subtot=0;
        $subcant=0;
        $ti_tipo=$rec["dsd_tipo"];
        $ti_num=$rec["dsd_num"];

        $t_lini=2;
    } 
    $subtot += $rec["dsd_monto"];
    $tottot += $rec["dsd_monto"];
    $subcant += $rec["dsd_cant"];
    $totcant += $rec["dsd_cant"];

    $body = array(
        $rec["dsd_cod"],
        $rec["dsd_desc"],
        $rec["dsd_unimed"],
        ($rec["dsd_cant"] > 0) ? number_format($rec["dsd_cant"],2) : "",
        ($rec["dsd_unit"] > 0) ? number_format($rec["dsd_unit"],5) : "",
        ($rec["dsd_monto"] > 0) ? number_format($rec["dsd_monto"],5) : "",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
    if (($pdf->GetY()+$lineHeight) > 25) {
        $pdf->AddPage();
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["dsd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["dsd_fec"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("BODEGA QUE SALIO:  ".trim($rec["bod_nom"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("OBSERVACIONES: ".$rec["ds_obs"]),0,1,"L");
        $pdf->SetFont("","",8);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","TOTAL");
        $pdf->SetWidths(array(2.3,7.2,2,2,2.6,2.6));
        $pdf->SetAligns(array("C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","C","R","R","R"));
    }    
}

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL ESTE DOCUMENTO",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($subcant, 2, '.', ','),
    "",
    number_format($subtot, 5, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
$pdf->ln();

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL GENERAL",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($totcant, 2, '.', ','),
    "",
    number_format($tottot, 5, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());

$pdf->Output(utf8_decode("Lista Documentos Salida" ).".pdf","I");

$db->close();

?>