<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selClasi=$_GET["selClasi"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

# QUERYS
if ($selClasi=='000') {
    $sEntsal = "SELECT art_emp, TRIM(art_cod) AS art_cod, TRIM(art_desc) AS art_desc, art_gru, art_clas, art_cosp, SUM(mov.mov_entra) AS mov_sentra, SUM(mov.mov_sale) AS mov_ssale, TRIM(gru_nom) AS gru_nom, TRIM(cla_nom) AS cla_nom 
       FROM artic art 
       LEFT JOIN movii mov ON mov.mov_emp=art.art_emp and mov.mov_cod=art.art_cod 
       LEFT JOIN gruposi gru ON gru.gru_emp=art.art_emp and gru.gru_cod=art.art_gru 
       LEFT JOIN clasii cla ON cla.cla_emp=art.art_emp and cla.cla_cod=art.art_clas 
       WHERE art_emp='$empCod' and mov.mov_fec>='$dtFeci' and mov.mov_fec<='$dtFecf'
       GROUP BY art_emp,art_cod ORDER BY art_clas,art_gru,art_cod";
} else {
    $sEntsal = "SELECT art_emp, TRIM(art_cod) AS art_cod, TRIM(art_desc) AS art_desc, art_gru, art_clas, art_cosp, SUM(mov.mov_entra) AS mov_sentra, SUM(mov.mov_sale) AS mov_ssale, TRIM(gru_nom) AS gru_nom, TRIM(cla_nom) AS cla_nom 
       FROM artic art 
       LEFT JOIN movii mov ON mov.mov_emp=art.art_emp and mov.mov_cod=art.art_cod 
       LEFT JOIN gruposi gru ON gru.gru_emp=art.art_emp and gru.gru_cod=art.art_gru 
       LEFT JOIN clasii cla ON cla.cla_emp=art.art_emp and cla.cla_cod=art.art_clas 
       WHERE art_emp='$empCod' and art_clas='$selClasi' and mov.mov_fec>='$dtFeci' and mov.mov_fec<='$dtFecf'
       GROUP BY art_emp,art_cod ORDER BY art_clas,art_gru,art_cod";
}           
# EJECUCION DE QUERYS
$db = new dbExec();
$select["entsal"] = $db->query($sEntsal);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['entradas']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['entradas'])
            ->setCellValueByColumnAndRow($i, 1, utf8_encode($empNom))
            ->setCellValueByColumnAndRow($i, 2, "REPORTE COSTEADO DE ENTRADAS Y SALIDAS DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf)));

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$i=$iIni;
$objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
            ->setCellValueByColumnAndRow($i++, $j, 'DESCRIPCION')
            ->setCellValueByColumnAndRow($i++, $j, 'ENTRADA')
            ->setCellValueByColumnAndRow($i++, $j, 'COSTO TOTAL QUETZALES')
            ->setCellValueByColumnAndRow($i++, $j, 'SALIDAS')
            ->setCellValueByColumnAndRow($i++, $j, 'COSTO TOTAL QUETZALES');
$objPHPExcel->getActiveSheet()->getStyle('A'.$j.':F'.$j)->applyFromArray($styEncabezado); 
$j+=1;

$objPHPExcel->getActiveSheet()->mergeCells('A1:F1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:F2')->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A3:F3')->getStyle('A3')->applyFromArray($styEmp);
//$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($styEncabezado);

$ti_clasi = 9999;
$ti_gru = 9999;
$subtot=0;
$tottot=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$j=6;
$inidoc=6;
$iniprov=6;
while ($rec = $db->fetchAssoc($select["entsal"])) {
    if ($ti_clasi.$ti_gru!=$rec["art_clas"].$rec["art_gru"]) {
        if ($t_lini > 1) {
            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE GRUPO")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidoc.':D'.($j-1).')')
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidoc.':F'.($j-1).')');
            $objPHPExcel->getActiveSheet()->getStyle('F'.$j.':F'.$j)->applyFromArray($styEncabezado); 
        }             
        $j+=2;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_encode($rec["cla_nom"]).", ".utf8_encode($rec["gru_nom"]));
        $j+=1;
        $inidoc=$j;
        $subtot=0;
        $ti_clasi=$rec["art_clas"];
        $ti_gru=$rec["art_gru"];
        $t_lini=2;
    } 
    $costoe=round(($rec["mov_sentra"]*$rec["art_cosp"]),2);
    $costos=round(($rec["mov_ssale"]*$rec["art_cosp"]),2);
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["art_cod"]))
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec["art_desc"])))
                ->setCellValueByColumnAndRow($i++, $j, $rec["mov_sentra"])
                ->setCellValueByColumnAndRow($i++, $j, $costoe)
                ->setCellValueByColumnAndRow($i++, $j, $rec["mov_ssale"])
                ->setCellValueByColumnAndRow($i++, $j, $costos);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':F'.$j)->applyFromArray($styLineas);
    $j+=1;
}
$i=$iIni;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE GRUPO")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidoc.':D'.($j-1).')')
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidoc.':F'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':D'.$j)->applyFromArray($styEncabezado); 
$objPHPExcel->getActiveSheet()->getStyle('F'.$j.':F'.$j)->applyFromArray($styEncabezado); 
$j+=2;
$i=$iIni;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL GENERAL") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    TOTAL ESTE GRUPO",D6:D'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    TOTAL ESTE GRUPO",F6:F'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':D'.$j)->applyFromArray($styEncabezado);
$objPHPExcel->getActiveSheet()->getStyle('F'.$j.':F'.$j)->applyFromArray($styEncabezado);


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(17);

$objPHPExcel->getActiveSheet()->getStyle('C6'.':F'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':B'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['entradas'])->setTitle('Entradas-Salidas');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ReporteEntSal.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>