<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selClasi=$_GET["selClasi"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $selTipodoci;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(23,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("REPORTE COSTEADO DE ENTRADAS Y SALIDAS DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        $this->Ln();
        $this->SetFont("","",8);
        $header = array("Codigo","Descripcion","Entradas","Costo Total Quetzales","Salidas","Costo Total Quetzales");
        $this->SetFont("","B");
        $this->SetWidths(array(3.3,7.8,3,3,3,3));
        $this->SetAligns(array("C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("");
        $this->SetAligns(array("L","L","R","R","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selClasi=='000') {
    $sEntsal = "SELECT art_emp, TRIM(art_cod) AS art_cod, TRIM(art_desc) AS art_desc, art_gru, art_clas, art_cosp, SUM(mov.mov_entra) AS mov_sentra, SUM(mov.mov_sale) AS mov_ssale, TRIM(gru_nom) AS gru_nom, TRIM(cla_nom) AS cla_nom 
       FROM artic art 
       LEFT JOIN movii mov ON mov.mov_emp=art.art_emp and mov.mov_cod=art.art_cod 
       LEFT JOIN gruposi gru ON gru.gru_emp=art.art_emp and gru.gru_cod=art.art_gru 
       LEFT JOIN clasii cla ON cla.cla_emp=art.art_emp and cla.cla_cod=art.art_clas 
       WHERE art_emp='$empCod' and mov.mov_fec>='$dtFeci' and mov.mov_fec<='$dtFecf'
       GROUP BY art_emp,art_cod ORDER BY art_clas,art_gru,art_cod";
} else {
    $sEntsal = "SELECT art_emp, TRIM(art_cod) AS art_cod, TRIM(art_desc) AS art_desc, art_gru, art_clas, art_cosp, SUM(mov.mov_entra) AS mov_sentra, SUM(mov.mov_sale) AS mov_ssale, TRIM(gru_nom) AS gru_nom, TRIM(cla_nom) AS cla_nom 
       FROM artic art 
       LEFT JOIN movii mov ON mov.mov_emp=art.art_emp and mov.mov_cod=art.art_cod 
       LEFT JOIN gruposi gru ON gru.gru_emp=art.art_emp and gru.gru_cod=art.art_gru 
       LEFT JOIN clasii cla ON cla.cla_emp=art.art_emp and cla.cla_cod=art.art_clas 
       WHERE art_emp='$empCod' and art_clas='$selClasi' and mov.mov_fec>='$dtFeci' and mov.mov_fec<='$dtFecf'
       GROUP BY art_emp,art_cod ORDER BY art_clas,art_gru,art_cod";
}           
//       LEFT JOIN docs_det dsd ON dsd.dsd_emp=art.art_emp and dsd.dsd_cod=art.art_cod 

# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["entsal"] = $db->query($sEntsal);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "letter");
$pdf->AddPage();
$func = new functions();

$ti_clasi = 9999;
$ti_gru = 9999;
$ti_num = 9999;
$subtote = 0;
$tottote = 0;
$subcante = 0;
$totcante = 0;
$subtots = 0;
$tottots = 0;
$subcants = 0;
$totcants = 0;

$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["entsal"])) {
    if ($ti_clasi.$ti_gru!=$rec["art_clas"].$rec["art_gru"]) {
        if ($t_lini > 1) {
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 24.7, $pdf->GetY());
            $pdf->Cell(.04,.4,"          TOTAL COSTOS ESTE GRUPO",0,0,"L");
            $body = array(
                "",
                "",
                "",
                number_format($subtote, 2, '.', ','),
                "",
                number_format($subtots, 2, '.', ','),
            ); 
            $pdf->RowBorderHidden($body, $lineHeight);
        }             
        $pdf->ln();
        $pdf->SetFont("","B");
        $pdf->Cell($lineWidth,.7,trim($rec["cla_nom"]).", ".rtrim($rec["gru_nom"]),0,1,"L");
        $pdf->SetFont("","");
        $subtote=0;
        $subtots=0;
        $ti_clasi=$rec["art_clas"];
        $ti_gru=$rec["art_gru"];
        $t_lini=2;
    }
    $costoe=round(($rec["mov_sentra"]*$rec["art_cosp"]),2);
    $costos=round(($rec["mov_ssale"]*$rec["art_cosp"]),2);
    $subtote += $costoe;
    $tottote += $costoe;
    $subtots += $costos;
    $tottots += $costos;

    $body = array(
        $rec["art_cod"],
        $rec["art_desc"],
        ($rec["mov_sentra"] > 0) ? number_format($rec["mov_sentra"],2) : "",
        ($costoe > 0) ? number_format($costoe,2) : "",
        ($rec["mov_ssale"] > 0) ? number_format($rec["mov_ssale"],2) : "",
        ($costos > 0) ? number_format($costos,2) : "",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 24.7, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL COSTOS ESTE GRUPO",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($subtote, 2, '.', ','),
    "",
    number_format($subtots, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 24.7, $pdf->GetY());
$pdf->ln();

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 24.7, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL GENERAL",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($tottote, 2, '.', ','),
    "",
    number_format($tottots, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 24.7, $pdf->GetY());

$pdf->Output(utf8_decode("Reporte Costeado Entras y Salidas" ).".pdf","I");

$db->close();

?>