<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selClasi=$_GET["selClasi"];
$selBodega=$_GET["selBodega"];
$BodegaNom=$_GET["BodegaNom"];
$crInclue=$_GET["crInclue"];
$dtFec=$_GET["dtFec"];
$crTse=$_GET["crTse"];
$txtGrupo=$_GET["txtGrupo"];
if ($crTse=="T") {
   $crTsenom="Todos los articulos";
} else {
   $crTsenom="Solo articulos con Existencia";
}   

$lineWidth=17;
$lineHeight=0.8;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec,$crInclue, $BodegaNom, $crTsenom;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, .4, utf8_decode("Listado de Articulos para toma fisica al ".strftime("%d/%m/%Y", strtotime($dtFec))),0,1,"L");
        //$this->Ln();
        $this->MultiAlignCell($lineWidth, .4, utf8_decode("Bodega ".$BodegaNom),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($crTsenom),0,1,"L");
        $this->SetFont("","",7);
        if ($crInclue=='S') {
            $header = array("Codigo","Descripcion","Medida","Sistema","Fisico");
            $this->SetFont("","B");
            $this->SetWidths(array(3,7.5,2.5,2.5,2.5));
            $this->SetAligns(array("C","C","C","C","C"));
            $this->Row($header, $lineHeight);
            $this->SetFont("");
            $this->SetAligns(array("L","L","C","R","C"));
        } else {
            $header = array("Codigo","Descripcion","Medida","Fisico");
            $this->SetFont("","B");
            $this->SetWidths(array(2.5,7.5,2.5,2.5));
            $this->SetAligns(array("C","C","C","C"));
            $this->Row($header, $lineHeight);
            $this->SetFont("");
            $this->SetAligns(array("L","L","C","C"));
        }
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if (empty($txtGrupo)) {
    if ($selClasi=='0000') {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr, 
                    TRIM(gru_nom) AS gru_nom, TRIM(cla_nom) AS cla_nom 
                    FROM artic art 
                    LEFT JOIN gruposi gru ON gru.gru_emp=art.art_emp and gru.gru_cod=art.art_gru 
                    LEFT JOIN clasii cla ON cla.cla_emp=art.art_emp and cla.cla_cod=art.art_clas 
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    WHERE art_emp='$empCod' AND art_bienser='B' ORDER BY art_emp,art_clas,art_gru,art_cod";
    } else {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr,
                    TRIM(gru_nom) AS gru_nom, TRIM(cla_nom) AS cla_nom 
                    FROM artic art 
                    LEFT JOIN gruposi gru ON gru.gru_emp=art.art_emp and gru.gru_cod=art.art_gru 
                    LEFT JOIN clasii cla ON cla.cla_emp=art.art_emp and cla.cla_cod=art.art_clas 
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    WHERE art_emp='$empCod' AND art_clas='$selClasi' AND art_bienser='B' ORDER BY art_emp,art_clas,art_gru,art_cod";
    }
} else {
    $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                TRIM(art_desc) AS art_desc,
                TRIM(art_desd) AS art_desd,
                TRIM(art_marca) AS art_marca,
                TRIM(art_prov) AS art_prov,
                TRIM(art_codf) AS art_codf,
                TRIM(art_codbarr) AS art_codbarr,
                TRIM(gru_nom) AS gru_nom, TRIM(cla_nom) AS cla_nom 
                FROM artic art 
                LEFT JOIN gruposi gru ON gru.gru_emp=art.art_emp and gru.gru_cod=art.art_gru 
                LEFT JOIN clasii cla ON cla.cla_emp=art.art_emp and cla.cla_cod=art.art_clas 
                LEFT JOIN unimed um ON art.art_medi=um.um_cod
                WHERE art_emp='$empCod' AND art_bienser='B' AND art_cod LIKE '%$txtGrupo%' ORDER BY art_emp,art_dep,art_subdep,art_desc";
}

function sExiart($codd) { 
    global $empCod, $usuNom, $selBodega;
    return "SELECT * FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$selBodega'";
}

function sMoviie0($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$selBodega' AND mov_fec>'$dtFec' GROUP BY '$empCod','$codd'";
}
function sMoviis0($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$selBodega' AND mov_fec>'$dtFec' GROUP BY '$empCod','$codd'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["artic"] = $db->query($sArtic);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$ti_clasi=99999;
$ti_gru=9999;
while ($rec = $db->fetchAssoc($select["artic"])) {
    if ($ti_clasi.$ti_gru!=$rec["art_clas"].$rec["art_gru"]) {
       $pdf->Cell($lineWidth,.7,trim($rec["cla_nom"]).", ".rtrim($rec["gru_nom"]),0,0,"L");
       $ti_clasi=$rec["art_clas"];
       $ti_gru=$rec["art_gru"];
       $pdf->ln();
    }
    $codd=$rec["art_cod"];

    $select["exiart"] = $db->query(sExiart($codd));
    $fetchAssoc["exiart"] = $db->fetchAssoc($select["exiart"]);
    $Exist = $fetchAssoc["exiart"]["ea_exist"];

    $select["movii"] = $db->query(sMoviie0($codd));
    $recme0 = $db->fetchAssoc($select['movii']);
    $sEntramov=$recme0["mov_sentra"];

    $select["movii"] = $db->query(sMoviis0($codd));
    $recms0 = $db->fetchAssoc($select['movii']);
    $sSalemov=$recms0["mov_ssale"];

    $Exipas=($Exist-$sEntramov)+$sSalemov;

    if ($crTse=='E' && $Exipas<=0) {
        continue;
    }        

    if ($crInclue=='S') {
        $body = array(
            $rec["art_cod"],
            trim($rec["art_desc"]),
            trim($rec["um_nom"]),
            number_format($Exipas, 2, '.', ','),
            trim("_____________"),
        );
    } else {
        $body = array(
            $rec["art_cod"],
            trim($rec["art_desc"]),
            trim($rec["um_nom"]),
            trim("_____________"),
        );
    }
    $pdf->RowBorderHidden($body, $lineHeight);
}
$db->close();
$pdf->Output(utf8_decode("TomaFisica").".pdf","I");
?>