<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf;
        $this->SetMargins(1.2, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("COMPARATIVO DE VENTAS DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");

        $this->Ln();
        $this->SetFont("","",8);
        $this->SetFont("","B");
        $this->SetWidths(array(1.7,2.3,1.8,2,6,7,1.6,2.2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","C","L","L","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sFact_det = "SELECT *, TRIM(fac.fact_nit) AS fact_nit, TRIM(fac.fact_nom) AS fact_nom, TRIM(fd.factd_desc) AS factd_desc
   FROM fact_det fd LEFT JOIN facturas fac ON fd.factd_emp=fac.fact_emp AND fd.factd_tipo=fac.fact_tipo AND fd.factd_serie=fac.fact_serie AND fd.factd_num=fac.fact_num LEFT JOIN tipov tv ON fd.factd_tipo=tv.tv_cod
   WHERE factd_emp='$empCod' and factd_fec>='$dtFeci' and factd_fec<='$dtFecf' and tv_librosn='S' AND fact_tot!=0 AND factd_bienser!='S' ORDER BY factd_fec,factd_tipo,factd_serie,factd_num";
# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["fact_det"] = $db->query($sFact_det);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "letter");
$pdf->AddPage();
$func = new functions();

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtotc=0;
$subtotp=0;
$subtotg=0;
$tottotc=0;
$tottotp=0;
$tottotg=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["fact_det"])) {
    if ($t_lini == 1) {
        //$pdf->SetFont("","B",8);        
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "SERIE: ".$rec["factd_serie"]."         NUMERO:  ".$rec["factd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["factd_fec"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NOMBRE:  ".trim($rec["fact_nom"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NIT: ".$rec["fact_nit"]),0,1,"L");
        $pdf->SetFont("","",8);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"CANTIDAD","COSTO TOTAL","PRECIO TOTAL","GANANCIA","%");
        $pdf->SetWidths(array(2.3,7.2,1.7,2.4,2.4,2.4,1));
        $pdf->SetAligns(array("C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","R","R","R","R","R"));
    }
    if ($ti_tipo!=$rec["factd_serie"]  || $ti_num!=$rec["factd_num"]) {
        if ($t_lini > 1) {
            if ($subtotg!=0 && $subtotp!=0) {
              $subporg = ($subtotg*100/$subtotp);
            } else {
              $subporg=0;
            }   
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
            $pdf->Cell(.04,.4,"          TOTAL ESTE DOCUMENTO",0,0,"L");
            $body = array(
                "",
                "",
                "",
                number_format($subtotc, 5, '.', ','),
                number_format($subtotp, 5, '.', ','),
                number_format($subtotg, 5, '.', ','),
                number_format($subporg, 2, '.', ','),
            ); 
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.2, $pdf->GetY());
            $pdf->ln();
            $pdf->MultiAlignCell($lineWidth, $lineHeight, "SERIE: ".$rec["factd_serie"]."         NUMERO:  ".$rec["factd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["factd_fec"])),0,1,"L");
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NOMBRE:  ".trim($rec["fact_nom"])),0,1,"L");
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NIT: ".$rec["fact_nit"]),0,1,"L");
            $pdf->SetFont("","",8);   
            $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"CANTIDAD","COSTO TOTAL","PRECIO TOTAL","GANANCIA","%");
            $pdf->SetWidths(array(2.3,7.2,1.7,2.4,2.4,2.4,1));
            $pdf->SetAligns(array("C","C","C","C","C","C","C"));
            $pdf->Row($header, $lineHeight);
            $pdf->SetAligns(array("L","L","R","R","R","R","R"));
        }             
        $subtotc=0;
        $subtotp=0;
        $subtotg=0;
        $ti_tipo=$rec["factd_serie"];
        $ti_num=$rec["factd_num"];

        $t_lini=2;
    }
    $costot = ($rec["factd_cosu"]*$rec["factd_cant"]);
    $ganancia = ($rec["factd_tot"]-$costot);
    if ($ganancia!=0 && $rec["factd_tot"]!=0) {
      $porgan = ($ganancia*100/$rec["factd_tot"]);
    } else {
      $porgan=0;
    }   
    $subtotc += $costot;
    $subtotp += $rec["factd_tot"];
    $subtotg += ($ganancia);
    $tottotc += $costot;
    $tottotp += $rec["factd_tot"];
    $tottotg += ($ganancia);


    $body = array(
        $rec["factd_cod"],
        $rec["factd_desc"],
        ($rec["factd_cant"] > 0) ? number_format($rec["factd_cant"],2) : "",
        ($costot > 0) ? number_format($costot,5) : "",
        ($rec["factd_tot"] > 0) ? number_format($rec["factd_tot"],5) : "",
        ($ganancia > 0) ? number_format($ganancia,5) : "",
        ($porgan > 0) ? number_format($porgan,2) : "",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
    if (($pdf->GetY()+$lineHeight) > 25) {
        $pdf->AddPage();
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "SERIE: ".$rec["factd_serie"]."         NUMERO:  ".$rec["factd_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["factd_fec"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NOMBRE:  ".trim($rec["fact_nom"])),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NIT: ".$rec["fact_nit"]),0,1,"L");
        $pdf->SetFont("","",8);   
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"CANTIDAD","COSTO TOTAL","PRECIO TOTAL","GANANCIA","%");
        $pdf->SetWidths(array(2.3,7.2,1.7,2.4,2.4,2.4,1));
        $pdf->SetAligns(array("C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","R","R","R","R","R"));
    }    
}
$subporg=($subtotg*100/$subtotp);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.6, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL ESTE DOCUMENTO",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($subtotc, 5, '.', ','),
    number_format($subtotp, 5, '.', ','),
    number_format($subtotg, 5, '.', ','),
    number_format($subporg, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.6, $pdf->GetY());
$pdf->ln();

if ($tottotg!=0 && $tottotp!=0) {
  $totporg = ($tottotg*100/$tottotp);
} else {
  $totporg=0;
}   

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.6, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL GENERAL",0,0,"L");
$body = array(
    "",
    "",
    "",
    number_format($tottotc, 5, '.', ','),
    number_format($tottotp, 5, '.', ','),
    number_format($tottotg, 5, '.', ','),
    number_format($totporg, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.6, $pdf->GetY());

$pdf->Output(utf8_decode("Comparativo Ventas" ).".pdf","I");

$db->close();

?>