<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$selDepto=$_GET["selDepto"];
$DeptoNom=$_GET["DeptoNom"];

# QUERYS
if ($selDepto=='000') {
    $sFact_det = "SELECT *, TRIM(fd.factd_desc) AS factd_desc, SUM(fd.factd_cant) AS factd_sumcant, SUM(fd.factd_tot) AS factd_sumpre, 
                  SUM(fd.factd_cant*fd.factd_cosu) AS factd_sumcos 
                  FROM fact_det fd 
                  LEFT JOIN artic art ON fd.factd_emp=art.art_emp AND fd.factd_cod=art.art_cod
                  WHERE factd_emp='$empCod' and factd_fec>='$dtFeci' and factd_fec<='$dtFecf' GROUP BY factd_emp,factd_cod 
                  ORDER BY factd_emp,art_desc";
} else {
    $sFact_det = "SELECT *, TRIM(fd.factd_desc) AS factd_desc, SUM(fd.factd_cant) AS factd_sumcant, SUM(fd.factd_tot) AS factd_sumpre, 
                  SUM(fd.factd_cant*fd.factd_cosu) AS factd_sumcos 
                  FROM fact_det fd 
                  LEFT JOIN artic art ON fd.factd_emp=art.art_emp AND fd.factd_cod=art.art_cod
                  WHERE factd_emp='$empCod' and factd_fec>='$dtFeci' and factd_fec<='$dtFecf' and art.art_dep='$selDepto' GROUP BY factd_emp,factd_cod 
                  ORDER BY factd_emp,art_desc";
}    
# EJECUCION DE QUERYS
$db = new dbExec();
$select["fact_det"] = $db->query($sFact_det);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['comparativoven']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['comparativoven'])
            ->setCellValueByColumnAndRow($i, 1, utf8_encode($empNom))
            ->setCellValueByColumnAndRow($i, 2, "LISTADO DE ANALISIS PRECIO VENTA vs. COSTO DEL  ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf)))
            ->setCellValueByColumnAndRow($i, 3, "FAMILIA  ".$DeptoNom)
            ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
            ->setCellValueByColumnAndRow($i++, $j, 'DESCRIPCION')
            ->setCellValueByColumnAndRow($i++, $j, 'UNIDADES')
            ->setCellValueByColumnAndRow($i++, $j, 'VTA. UNITARIO PROMEDIO')
            ->setCellValueByColumnAndRow($i++, $j, 'MONTO')
            ->setCellValueByColumnAndRow($i++, $j, 'COSTO VTA.UNITARIO')
            ->setCellValueByColumnAndRow($i++, $j, 'MONTO')
            ->setCellValueByColumnAndRow($i++, $j, '% RELACION COSTO/VTA.');


# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') ),

    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        'wrap' => true,
        )    
);

$styTotales = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->mergeCells('A1:H1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:H2')->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A3:H3')->getStyle('A3')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($styEncabezado);

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$j=6;
$inidoc=6;
$iniprov=6;
while ($rec = $db->fetchAssoc($select["fact_det"])) {
    if ($rec["factd_sumcant"]==0) {
        continue;
    }        
    if ($rec["factd_sumcant"]>0) {
        $prompre = ($rec["factd_sumpre"]/$rec["factd_sumcant"]);
    } else {
        $prompre = 0;
    }        
    if ($rec["factd_sumcant"]>0) {
        $promcos = ($rec["factd_sumcos"]/$rec["factd_sumcant"]);
    } else {
        $promcos = 0;        
    }
    if ($rec["factd_sumpre"]>0) {
        $porg = round(($rec["factd_sumcos"]/$rec["factd_sumpre"]),8);
    } else {
        $porg=0;
    }
 
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["factd_cod"]))
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["factd_desc"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["factd_sumcant"])
                ->setCellValueByColumnAndRow($i++, $j, $prompre)
                ->setCellValueByColumnAndRow($i++, $j, $rec["factd_sumpre"])
                ->setCellValueByColumnAndRow($i++, $j, $promcos)
                ->setCellValueByColumnAndRow($i++, $j, $rec["factd_sumcos"])
                ->setCellValueByColumnAndRow($i++, $j, $porg);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':H'.$j)->applyFromArray($styLineas);
    $j+=1;
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL GENERAL")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidoc.':E'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$inidoc.':G'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$j.'/E'.$j.')');
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':H'.$j)->applyFromArray($styTotales); 

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);

$objPHPExcel->getActiveSheet()->getStyle('C6'.':G'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('H6'.':H'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00000000');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':B'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['comparativoven'])->setTitle('ListadoAnalisis');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ListadoAnalisis.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>