<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$selDepto=$_GET["selDepto"];
$DeptoNom=$_GET["DeptoNom"];

//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf,$DeptoNom;
        $this->SetMargins(1.7, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE ANALISIS PRECIO VENTA vs. COSTO DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, "FAMILIA:  ".$DeptoNom,0,1,"L");
        $this->SetFont("","",8);
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"UNIDADES","VTA. UNITARIO PROMEDIO","MONTO","COSTO VTA.UNITARIO","MONTO","% RELACION COSTO/VTA.");
        $this->SetWidths(array(2.3,7.9,1.7,2.4,2.4,2.4,2.4,2.4));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetAligns(array("L","L","R","R","R","R","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $func = new functions();
        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# QUERYS
if ($selDepto=='000') {
    $sFact_det = "SELECT *, TRIM(fd.factd_desc) AS factd_desc, SUM(fd.factd_cant) AS factd_sumcant, SUM(fd.factd_tot) AS factd_sumpre, 
                  SUM(fd.factd_cant*fd.factd_cosu) AS factd_sumcos 
                  FROM fact_det fd 
                  LEFT JOIN artic art ON fd.factd_emp=art.art_emp AND fd.factd_cod=art.art_cod
                  WHERE factd_emp='$empCod' and factd_fec>='$dtFeci' and factd_fec<='$dtFecf' GROUP BY factd_emp,factd_cod 
                  ORDER BY factd_emp,art_desc";
} else {
    $sFact_det = "SELECT *, TRIM(fd.factd_desc) AS factd_desc, SUM(fd.factd_cant) AS factd_sumcant, SUM(fd.factd_tot) AS factd_sumpre, 
                  SUM(fd.factd_cant*fd.factd_cosu) AS factd_sumcos 
                  FROM fact_det fd 
                  LEFT JOIN artic art ON fd.factd_emp=art.art_emp AND fd.factd_cod=art.art_cod
                  WHERE factd_emp='$empCod' and factd_fec>='$dtFeci' and factd_fec<='$dtFecf' and art.art_dep='$selDepto' GROUP BY factd_emp,factd_cod 
                  ORDER BY factd_emp,art_desc";
}    
# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["fact_det"] = $db->query($sFact_det);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "letter");
$pdf->AddPage();
$func = new functions();

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$totpre=0;
$totcos=0;
$t_lini=1;

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["fact_det"])) {
    if ($rec["factd_sumcant"]==0) {
        continue;
    }        
    if ($rec["factd_sumcant"]>0) {
        $prompre = ($rec["factd_sumpre"]/$rec["factd_sumcant"]);
    } else {
        $prompre = 0;
    }        
    if ($rec["factd_sumcant"]>0) {
        $promcos = ($rec["factd_sumcos"]/$rec["factd_sumcant"]);
    } else {
        $promcos = 0;        
    }
    $totpre += $rec["factd_sumpre"];
    $totcos += $rec["factd_sumcos"];
    if ($rec["factd_sumpre"]>0) {
        $porg = round(($rec["factd_sumcos"]/$rec["factd_sumpre"]),8);
    } else {
        $porg=0;
    }
    $body = array(
        $rec["factd_cod"],
        $rec["factd_desc"],
        ($rec["factd_sumcant"] > 0) ? number_format($rec["factd_sumcant"],2) : "",
        ($prompre > 0) ? number_format($prompre,2) : "",
        ($rec["factd_sumpre"] > 0) ? number_format($rec["factd_sumpre"],2) : "",
        ($promcos > 0) ? number_format($promcos,2) : "",
        ($rec["factd_sumcos"] > 0) ? number_format($rec["factd_sumcos"],2) : "",
        ($porg > 0) ? number_format($porg,8) : "",
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
if ($totpre!=0 && $totcos!=0) {
  $totporg = round(($totcos/$totpre),8);
} else {
  $totporg=0;
}   
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 25.6, $pdf->GetY());
$body = array(
    "",
    "           TOTAL GENERAL",
    "",
    "",
    number_format($totpre, 2, '.', ','),
    "",
    number_format($totcos, 2, '.', ','),
    number_format($totporg, 8, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 25.6, $pdf->GetY());

$pdf->Output(utf8_decode("Lista Analisis" ).".pdf","I");

$db->close();

?>