<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt    LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod = $_SESSION['empCod'];
$empNom = $_SESSION['empNom'];

$selBodega=$_GET["selBodega"];
$BodegaNom=$_GET["BodegaNom"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

# QUERYS
$sMovii = "SELECT *, TRIM(art.art_cod) AS art_cod,
            TRIM(art.art_desc) AS art_desc,
            SUM(mov_entra) AS mov_sentra,
            SUM(mov_sale) AS mov_ssale
            FROM movii mi
            LEFT JOIN artic art ON art.art_emp=mi.mov_emp AND art.art_cod=mi.mov_cod
            LEFT JOIN exiart ea ON ea.ea_emp=mi.mov_emp AND ea.ea_cod=mi.mov_cod AND ea.ea_bod='$selBodega'
            LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
            LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
            LEFT JOIN unimed um ON art.art_medi=um.um_cod            
            WHERE (mov_emp='$empCod' AND mov_entra>0 AND mov_bodent='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf') or (mov_emp='$empCod' AND mov_sale>0 AND mov_bodsal='$selBodega' AND mov_fec>='$dtFeci' AND mov_fec<='$dtFecf') 
            GROUP BY mov_emp,mov_cod ORDER BY art.art_emp,CAST(art.art_cod AS UNSIGNED)";

function sMoviied($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$selBodega' AND mov_fec>'$dtFecf' GROUP BY '$empCod','$codd'";
}
function sMoviisd($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFeci, $dtFecf;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$selBodega' AND mov_fec>'$dtFecf' GROUP BY '$empCod','$codd'";
}

# EJECUCION DE QUERYS
$db = new dbExec();

$func = new functions();

$select["movii"] = $db->query($sMovii);

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['articulos']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=6;
$objPHPExcel->setActiveSheetIndex($sheet['articulos'])
            ->setCellValueByColumnAndRow($i, 1, utf8_encode($empNom))
            ->setCellValueByColumnAndRow($i, 2, "Resumen de entradas y salidas del ".strftime("%d/%m/%Y", strtotime($dtFeci))." al ".strftime("%d/%m/%Y", strtotime($dtFecf)))
            ->setCellValueByColumnAndRow($i, 3, "Bodega:  ".$BodegaNom)
            ->setCellValueByColumnAndRow($i++, $j, 'Codigo')
            ->setCellValueByColumnAndRow($i++, $j, 'Descripcion')
            ->setCellValueByColumnAndRow($i++, $j, 'Medida')
            ->setCellValueByColumnAndRow($i++, $j, 'Existencia Inicial')
            ->setCellValueByColumnAndRow($i++, $j, '  Entradas')
            ->setCellValueByColumnAndRow($i++, $j, '  Salidas')
            ->setCellValueByColumnAndRow($i++, $j, 'Existencia Final');
# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 17,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

$bordersThin = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

$borderBottomDouble = array(
    'borders' => array(
        'bottom' => array(
            'style' => PHPExcel_Style_Border::BORDER_DOUBLE
        )
    )
);

$borderTopThin = array(
    'borders' => array(
        'top' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);


foreach(range('A','T') as $colID) { 
    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
}

$objPHPExcel->getActiveSheet()->mergeCells('A1:G1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:G2')->getStyle('A2')->applyFromArray($styFec);
$objPHPExcel->getActiveSheet()->mergeCells('A3:G3')->getStyle('A3')->applyFromArray($styFec);
$objPHPExcel->getActiveSheet()->mergeCells('A4:G4')->getStyle('A4')->applyFromArray($styFec);
$objPHPExcel->getActiveSheet()->getStyle('A6:G6')->applyFromArray($styEncabezado);

# VALORES PRIMER HOJA
$i=$iIni;
for ($j=7; $rec = $db->fetchAssoc($select['movii']); $j++) {

    $codd=$rec["art_cod"];
    $cosp=$rec["art_cosp"];
    $exist=$rec["ea_exist"];
    $salidas=$rec["mov_ssale"];
    $entradas=$rec["mov_sentra"];

    // Para revisar lo posterior entradas
    $select["moviie"] = $db->query(sMoviied($codd));
    $recme0 = $db->fetchAssoc($select['moviie']);
    $sEntramov=$recme0["mov_sentra"];
    // Para revisar lo posterior salidas
    $select["moviis"] = $db->query(sMoviisd($codd));
    $recms0 = $db->fetchAssoc($select['moviis']);
    $sSalemov=$recms0["mov_ssale"];

    $exisact=($exist+$sSalemov)-$sEntramov;
    $exiini=($exisact+$salidas)-$entradas;

    if ($salidas==0 && $entradas==0) {
        continue;
    }
    $costot=round($exisact*$cosp,5);

    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['art_cod'])))
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['art_desc'])))
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['um_nom'])))
                ->setCellValueByColumnAndRow($i++, $j, $exiini)
                ->setCellValueByColumnAndRow($i++, $j, $entradas)
                ->setCellValueByColumnAndRow($i++, $j, $salidas)
                ->setCellValueByColumnAndRow($i++, $j, $exisact);
    $i=$iIni;
}

// TOTALES DEL MOVIMIENTO
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':G'.$j)->applyFromArray($borderTopThin);
$objPHPExcel->getActiveSheet()->getStyle('D'.$j.':G'.$j)->applyFromArray($borderBottomDouble);
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow(1, $j, '         Total')
    ->setCellValueByColumnAndRow(3, $j, '=SUM(D7:D'.($j-1).')')
    ->setCellValueByColumnAndRow(4, $j, '=SUM(E7:E'.($j-1).')') 
    ->setCellValueByColumnAndRow(5, $j, '=SUM(F7:F'.($j-1).')') 
    ->setCellValueByColumnAndRow(6, $j, '=SUM(G7:G'.($j-1).')'); 

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(45);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);

$objPHPExcel->getActiveSheet()->getStyle('D5'.':G'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A5'.':C'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['articulos'])->setTitle('articulos');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);

$db->close();

// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ResuMov.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;

?>
