<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selGrupo=$_GET["selGrupo"];

$lineWidth=17;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec;
        $this->SetMargins(2, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",15);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Articulos al ".strftime("%d/%m/%Y")),0,1,"L");

        $this->Ln();
        $this->SetFont("","",7);
        $header = array("Codigo","Descripcion","Medida","Marca","Clasificacion","Bloqueado");
        $this->SetFont("","B");
        $this->SetWidths(array(2.5,8.5,2.5,2.5,5.5,2));
        $this->SetAligns(array("C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","L","L","C"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selGrupo=='0000') {
    $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                TRIM(art_desc) AS art_desc,
                TRIM(art_desd) AS art_desd,
                TRIM(art_marca) AS art_marca,
                TRIM(art_codf) AS art_codf,
                TRIM(art_codbarr) AS art_codbarr
                FROM artic art LEFT JOIN gruposi gru ON art.art_emp=gru.gru_emp AND art.art_gru=gru.gru_cod 
                LEFT JOIN  clasii cla ON art.art_emp=cla.cla_emp AND art.art_clas=cla.cla_cod 
                LEFT JOIN unimed um ON art.art_medi=um.um_cod
                WHERE art_emp='$empCod' AND art_bienser='B' ORDER BY art_emp,art_gru,art_clas,art_desc";
} else {
    $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                TRIM(art_desc) AS art_desc,
                TRIM(art_desd) AS art_desd,
                TRIM(art_marca) AS art_marca,
                TRIM(art_codf) AS art_codf,
                TRIM(art_codbarr) AS art_codbarr
                FROM artic art LEFT JOIN gruposi gru ON art.art_emp=gru.gru_emp AND art.art_gru=gru.gru_cod 
                LEFT JOIN  clasii cla ON art.art_emp=cla.cla_emp AND art.art_clas=cla.cla_cod 
                LEFT JOIN unimed um ON art.art_medi=um.um_cod
                WHERE art_emp='$empCod' AND art_gru='$selGrupo' AND art_bienser='B' ORDER BY art_emp,art_gru,art_clas,art_desc";
}
# EJECUCION DE QUERYS
$db = new dbExec();
$select["artic"] = $db->query($sArtic);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Letter");
$pdf->AddPage();
$ti_Grupo="XXXX";
while ($rec = $db->fetchAssoc($select["artic"])) {
    if ($ti_Grupo!=$rec["art_gru"]) {
       $pdf->Cell($lineWidth,.7,trim($rec["gru_nom"]),0,0,"L");
       $ti_Grupo=$rec["art_gru"];
       $pdf->ln();
    }
    if ($rec["art_bloqueado"] == 1) {
       $txtblo='Si';
    } else {
       $txtblo='';
    }   
    $body = array(
        $rec["art_cod"],
        trim($rec["art_desc"]),
        trim($rec["um_nom"]),
        trim($rec["art_marca"]),
        trim($rec["cla_nom"]),
        trim($txtblo),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Articulos").".pdf","I");
?>