<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sBod = "SELECT *, TRIM(bod_nom) AS bod_nom FROM bodegas ORDER BY bod_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["bodegas"] = $db->query($sBod);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",12);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.5;

$pdf->SetFont("","",9);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Bodegas en Inventario"));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight*2);

$header = array("Codigo","Nombre de la Bodega");
$pdf->SetFont("","B");
$pdf->SetWidths(array(3,8));
$pdf->SetAligns(array("C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L"));

while ($rec = $db->fetchAssoc($select["bodegas"])) {
    $body = array(
        $rec["bod_cod"],
        trim($rec["bod_nom"]),        
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Listado de Bodegas Inventario").".pdf","I");
?>