<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$numNum=$_GET["numNum"];
$dtDel=$_GET["dtDel"];
$dtAl=$_GET["dtAl"];

$lineWidth=19;
$lineHeight=0.4;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $numNum, $dtDel, $dtAl;
        $this->SetMargins(3, 1, 2);
        $this->SetAutoPageBreak(true,.9);
        
//        $img = '../img/LogoOsher.png';
//        $this->Image($img,23,.5,2.9,2);
        $this->Cell(0, 0, "", 0, 1);
        $this->SetFont("Arial","B",10);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell($lineWidth/1,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight,  utf8_decode("Reporte de Planilla del ".strftime("%d/%m/%Y", strtotime($dtDel))." al ".strftime("%d/%m/%Y", strtotime($dtAl))),0,1,"L");
        //$this->Ln();
        $this->MultiAlignCell($lineWidth, $lineHeight, "Planilla No. ".$numNum,0,1,"L");
        $this->SetFont("","",6);
        $header = array("COD.","NOMBRE EMPLEADO","PUESTO","FECHA/ING.","D/TRAB","SUELDO ORDINARIO","SUELDO EXTRA","BONIFICA. DEC. 78-89 y 37-2001","OTROS INGRESOS","TOTAL DEVENGADO","IGSS","ISR","ANTICIPO","OTROS DECUEN","TOTAL DESCUEN","LIQUIDO A RECIBIR");
        $this->SetFont("","B");
        $this->SetWidths(array(1.3,5.6,3.6,1.7,1.2,1.7,1.5,2.3,1.6,1.8,1.6,1.6,1.6,1.6,1.6,1.6));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("");
        $this->SetAligns(array("L","L","L","C","C","R","R","R","R","R","R","R","R","R","R","R"));
    }
    
    function Footer() {
        $func = new functions();

        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# QUERYS
$sNomper = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom,
                mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                WHERE np_emp='$empCod' AND np_numpla='$numNum' ORDER BY np_emp,np_gru,np_dep,CAST(np_cod AS UNSIGNED)";

# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["nomper"] = $db->query($sNomper);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Legal");
$pdf->AddPage();
$ti_Depto="XXXX";
$subsord=0;
$subsext=0;
$subboni=0;
$subbonii=0;
$subotrp=0;
$subtotdev=0;
$subigss=0;
$subisr=0;
$subpreb=0;
$subpree=0;
$subdesj=0;
$subanti=0;
$subotrd=0;
$subtotdes=0;
$subliqrec=0;
$totsord=0;
$totsext=0;
$totboni=0;
$totbonii=0;
$tototrp=0;
$tottotdev=0;
$totigss=0;
$totisr=0;
$totpreb=0;
$totpree=0;
$totdesj=0;
$totanti=0;
$tototrd=0;
$tottotdes=0;
$totliqrec=0;

$t_lini=1;
$itemdep=0;
$items=0;
$grupop=99999;
$depp=99999;
while ($rec = $db->fetchAssoc($select["nomper"])) {
    if (($rec["mae_gru"].$rec["mae_dep"]) != ($grupop.$depp)) {
        if ($t_lini==1) {
            $pdf->SetFont("","B");
            $pdf->MultiAlignCell($lineWidth/1.2,.7, "GRUPO/PROYECTO: ".$rec["gru_nom"],0,1,"L");
            $pdf->SetFont("","");
        }
        if ($t_lini>1) {
            $pdf->line($pdf->GetX(), $pdf->GetY(), 34.8, $pdf->GetY());
            $pdf->MultiAlignCell($lineWidth/2,.4, "TOTAL ESTE DEPTO. EMPLEADOS: ".$itemdep,0,0,"L");
            $pdf->SetX(3);
            $body = array(
                "",
                "",
                "",
                "",
                "",
                number_format($subsord, 2, '.', ','),
                number_format($subsext, 2, '.', ','),
                number_format($subboni+$subbonii, 2, '.', ','),
                number_format($subotrp, 2, '.', ','),
                number_format($subtotdev, 2, '.', ','),
                number_format($subigss, 2, '.', ','),
                number_format($subisr, 2, '.', ','),
                number_format($subanti, 2, '.', ','),
                number_format($subotrd+$subpreb+$subpree+$subdesj, 2, '.', ','),
                number_format($subtotdes, 2, '.', ','),
                number_format($subliqrec, 2, '.', ','),
            );
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX(), $pdf->GetY(), 34.8, $pdf->GetY());
            $pdf->Ln(.5);            
        }
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/1.2,.7, "DEPARTAMENTO: ".$rec["dep_nom"],0,1,"L");
        $pdf->SetFont("","");
        $grupop=$rec["mae_gru"];
        $depp=$rec["mae_dep"];
        $t_lini=2;
        $itemdep=0;
        $subsord=0;
        $subsext=0;
        $subboni=0;
        $subbonii=0;
        $subotrp=0;
        $subtotdev=0;
        $subigss=0;
        $subisr=0;
        $subpreb=0;
        $subpree=0;
        $subdesj=0;
        $subanti=0;
        $subotrd=0;
        $subtotdes=0;
        $subliqrec=0;
    }

    $body = array(
        str_pad($rec["mae_cod"], 6, "0", STR_PAD_LEFT),
        $rec["mae_nom"]." ".$rec["mae_ape"],
        $rec["tpu_nom"],
        strftime("%d/%m/%Y", strtotime($rec["mae_fing"])),
        number_format($rec["np_dtra"], 1, '.', ','),
        number_format($rec["np_sord"], 2, '.', ','),
        number_format($rec["np_sext"], 2, '.', ','),
        number_format($rec["np_boni"]+$rec["np_bonii"]+$rec["np_bonoe"]+$rec["np_depre"]+$rec["np_viati"]+$rec["np_combus"], 2, '.', ','),
        number_format($rec["np_otrp"]+$rec["np_comi"], 2, '.', ','),
        number_format($rec["np_totdev"], 2, '.', ','),
        number_format($rec["np_igss"], 2, '.', ','),
        number_format($rec["np_isr"], 2, '.', ','),
        number_format($rec["np_anti"], 2, '.', ','),
        number_format($rec["np_otrd"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_unif"]+$rec["np_lent"], 2, '.', ','),
        number_format($rec["np_totdes"], 2, '.', ','),
        number_format($rec["np_liqrec"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);

    $subsord+=$rec["np_sord"];
    $subsext+=$rec["np_sext"];
    $subboni+=$rec["np_boni"];
    $subbonii+=($rec["np_bonii"]+$rec["np_bonoe"]+$rec["np_depre"]+$rec["np_viati"]+$rec["np_combus"]);
    $subotrp+=($rec["np_otrp"]+$rec["np_comi"]);
    $subtotdev+=$rec["np_totdev"];
    $subigss+=$rec["np_igss"];
    $subisr+=$rec["np_isr"];
    $subpreb+=$rec["np_preb"];
    $subpree+=$rec["np_pree"];
    $subdesj+=$rec["np_desj"];
    $subanti+=$rec["np_anti"];
    $subotrd+=($rec["np_otrd"]+$rec["np_comi"]);
    $subtotdes+=$rec["np_totdes"];
    $subliqrec+=$rec["np_liqrec"];
    $totsord+=$rec["np_sord"];
    $totsext+=$rec["np_sext"];
    $totboni+=$rec["np_boni"];
    $totbonii+=($rec["np_bonii"]+$rec["np_bonoe"]+$rec["np_depre"]+$rec["np_viati"]+$rec["np_combus"]);
    $tototrp+=($rec["np_otrp"]+$rec["np_comi"]);
    $tottotdev+=$rec["np_totdev"];
    $totigss+=$rec["np_igss"];
    $totisr+=$rec["np_isr"];
    $totpreb+=$rec["np_preb"];
    $totpree+=$rec["np_pree"];
    $totdesj+=$rec["np_desj"];
    $totanti+=$rec["np_anti"];
    $tototrd+=$rec["np_otrd"];
    $tottotdes+=$rec["np_totdes"];
    $totliqrec+=$rec["np_liqrec"];
    $itemdep+=1;
    $items+=1;
    if (($pdf->GetY()+$lineHeight) > 20) {
      $pdf->AddPage();
    }    
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 34.8, $pdf->GetY());
$pdf->MultiAlignCell($lineWidth/2,.4, "TOTAL ESTE DEPTO. EMPLEADOS: ".$itemdep,0,0,"L");
$pdf->SetX(3);
$body = array(
    "",
    "",
    "",
    "",
    "",
    number_format($subsord, 2, '.', ','),
    number_format($subsext, 2, '.', ','),
    number_format($subboni+$subbonii, 2, '.', ','),
    number_format($subotrp, 2, '.', ','),
    number_format($subtotdev, 2, '.', ','),
    number_format($subigss, 2, '.', ','),
    number_format($subisr, 2, '.', ','),
    number_format($subanti, 2, '.', ','),
    number_format($subotrd+$subpreb+$subpree+$subdesj, 2, '.', ','),
    number_format($subtotdes, 2, '.', ','),
    number_format($subliqrec, 2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 34.8, $pdf->GetY());
$pdf->Ln(.5);
$pdf->line($pdf->GetX(), $pdf->GetY(), 34.8, $pdf->GetY());
$pdf->MultiAlignCell($lineWidth/2,.4, "TOTAL GENERAL EMPLEADOS: ".$items,0,0,"L");
$pdf->SetX(3);
$body = array(
    "",
    "",
    "",
    "",
    "",
    number_format($totsord, 2, '.', ','),
    number_format($totsext, 2, '.', ','),
    number_format($totboni+$totbonii, 2, '.', ','),
    number_format($tototrp, 2, '.', ','),
    number_format($tottotdev, 2, '.', ','),
    number_format($totigss, 2, '.', ','),
    number_format($totisr, 2, '.', ','),
    number_format($totanti, 2, '.', ','),
    number_format($tototrd+$totpreb+$totpree+$totdesj, 2, '.', ','),
    number_format($tottotdes, 2, '.', ','),
    number_format($totliqrec, 2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY()+.075, 34.8, $pdf->GetY()+.075);
$pdf->Ln(2);
$pdf->SetFont("","",9);
$pdf->MultiAlignCell($lineWidth/12,.4, "",0,0,"L");
$pdf->MultiAlignCell($lineWidth/2,.4, "Hecho por: _______________________",0,0,"L");
$pdf->MultiAlignCell($lineWidth/12,.4, "",0,0,"L");
$pdf->MultiAlignCell($lineWidth/2,.4, "Revisado por: _______________________",0,0,"L");
$pdf->MultiAlignCell($lineWidth/12,.4, "",0,0,"L");
$pdf->MultiAlignCell($lineWidth/2,.4, "Autorizado por: _______________________",0,1,"L");
$pdf->MultiAlignCell($lineWidth/12,.4, "",0,0,"L");
$pdf->MultiAlignCell($lineWidth/2,.4, "                              Personal",0,0,"L");
$pdf->MultiAlignCell($lineWidth/12,.4, "",0,0,"L");
$pdf->MultiAlignCell($lineWidth/2,.4, "                              Contabilidad",0,1,"L");

$db->close();
$pdf->Output(utf8_decode("Planilla_".$numNum).".pdf","I");
?>